/*
	%W%
	%G%	%U%
*/

/*
** PARALLAX RAMPAGE device parameters
**
** Copyright Fluency International Software  4/24/84
*/

/* Rampage Device Register Structure */
struct pxdevice
{
	short csr;	/* control/status register */
	short cdr;	/* command/data register */
} ;

/* Control/Status Register */

# define CS_ER 		0x8000		/* General purpose error bit */
# define CS_RST		0x8000		/* Reset bit */
# define CS_USR		0x4000		/* User/Kernal mode bit */
# define CS_ERC		0x3F00		/* Error code mask */
# define CS_RDY		0x0080		/* Ready for PIO data bit */
# define CS_IE		0x0040		/* Interrupt Enable bit */
# define CS_WAC		0x0004		/* Waiting for bus addr/word cnt bit */
# define CS_WC		0x0002		/* Waiting for command bit */
# define CS_DAV		0x0001		/* Data Available bit */

/* Error Codes */

# define ERR_MEM	0x0000		/* Non-existent memory */
# define ERR_INST	0x0100		/* Illegal instruction */
# define ERR_POLY	0x0200		/* Polygon vertex overflow */
# define ERR_FILL	0x0300		/* Fill stack overflow */

# define PXGPRI		PZERO + 8	/* Rampage Write Priority */
# define PXTMASK	0x1c00
# define PX600		0
# define PX1000		0x400
# define PX1280		0x800

/* Boolean States */

# define TRUE		0x01		
# define FALSE		0x00	
# define PXWRKSTAT	0x20
# define PXREAD		0x40
# define PXOPEN		0x80

/* Rampage Buffer States */

# define PXGINIT	0x00		/* Rampage Init - trap interrupt */
# define PXGBLO		0x01		/* wait for low word of DMA bufr addr */
# define PXGBHI		0x02		/* wait for hi word of DMA bufr addr */
# define PXGWCNT	0x03		/* wait for DMA bufr word count */
# define PXGDONE	0x04		/* Rampage done sending DMA params */
# define PXGRDY		0x05		/* Rampage ready for next DMA command */

/* Command Codes */

# define RESET		0x002D
# define RJUMPB		0x0329
# define NOOP		0x0000
# define PXBSWAP	0x13c
# define PXSHOW		0x2c

/* misc */

#define LOWORD 0x0000FFFF	/* mask for low word of int */
#define WORDBITS  0x10		/* number of bits in a word */
