/*
	%W%
	%G%	%U%
*/

/*
 *	Parallax graphic device driver
 */

#include "px.h"
#if NPX > 0 || Npx > 0

#include "../machine/pte.h"
#include "types.h"
#include "param.h"
#include "systm.h"
#include "ioctl.h"
#include "buf.h"
#include "conf.h"
#include "dir.h"
#include "user.h"
#include "tty.h"
#include "map.h"
#include "vm.h"
#include "cmap.h"
#include "uio.h"
#include "kernel.h"
#include "file.h"

#include "../is68kdev/qbvar.h"
#include "../machine/board.h"
#include "../is68kdev/pxreg.h"

#define	PX_TIMEOUT	hz*5

# define min(a,b) ((a) < (b) ? (a) : (b))

/*
 * Driver information for auto-configuration stuff.
 */
int	pxprobe(), pxslave(), pxattach(), pxrint(), pxdgo();

struct	qb_ctlr *pxcinfo[NPX];
struct	qb_device *pxdinfo[NPX];
struct	buf pxutab[NPX];


extern u_short *PXstd[];

unsigned pxstdmap[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0
};

char pxstdvec[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0
};

struct	qb_driver PXdriver =
	{ pxprobe, pxslave, pxattach, pxdgo, PXstd, "px", pxdinfo, "PX", pxcinfo };

/* Parallax buffer queue */
struct buf pxrq[NPX];
struct buf pxwq[NPX];

/* Rampage i/o buffer structure */
struct pxbuf
{
	char		state;		/* Rampage DMA buffer state */
	char		flags;		/* Miscellaneous flag bits */
	struct buf	*cbp;		/* Current buffer pointer */
	unsigned	bcount;		/* Transfer byte count */
	short		*cp;		/* Current address pointer */
	short		count;		/* Timeout counter */
	short		pxtype;		/* Configuration parameters */
} pxbuf[NPX];

#define PXCLEAR		1		/* Clear screen flag for pxreset() */
#define PXINIT		2		/* Initialize interrupt flag for pxreset() */

int pxstrategy();
extern unsigned minphys();
int pxwdog = 0;

pxprobe(pxaddr)		 /* make controller at reg interrupt */
register struct pxdevice *pxaddr;
{
	register char *mp = (char *)pxbuf;
	register unsigned *confp = (unsigned *)&pxstdmap[((int)pxaddr&0x3f)>>2];
	register int i;

	DELAY(1000);
	for( i = 0; i < sizeof pxbuf; i++ )
		*mp++ = 0;
	if( *confp == 0 ) {
		pxaddr->csr = CS_RST;		/* reset */
		while( badaddr((caddr_t)pxaddr,2) )
			;
		while( ((i = pxaddr->csr)&CS_WC) == 0 )
		{
			DELAY(1);
		}
		DELAY(5000);
		pxaddr->cdr = PXSHOW;
		DELAY(5000);	/******/
		while( ((i = pxaddr->csr)&CS_DAV) != CS_DAV )
		{
			DELAY(1);
		}
		DELAY(2000);
		*confp = pxaddr->cdr & PXTMASK;
		i = *confp;
		if( *confp == PX1280 ) {
			*++confp = i;
			*++confp = i;
			*++confp = i;
			pxstdvec[((int)pxaddr&0x3f)>>2] = i = freevec();
			DELAY(2000);	/***********/
			pxaddr->cdr = (i<<8)|0x3f;
			DELAY( 2000 ); /**** 200 ****/
			while( ((i = pxaddr->csr)&(CS_RDY | CS_WC)) !=
				(CS_RDY | CS_WC ) )
			{
				DELAY( 10 );
			}
			DELAY( 3500 );
			pxaddr->csr = CS_IE;		/* enable interrupts (and interrupt) */
			DELAY(2000);	/***********/
			while( ((i = pxaddr->csr)&(CS_RDY | CS_WC)) !=
				(CS_RDY | CS_WC ) )
			{
				DELAY( 10 );
			}
			DELAY( 35000 );
		}
		else {
			pxaddr->csr = CS_RST;		/* reset */
			pxaddr->csr = CS_IE;		/* enable interrupts (and interrupt) */
		}
	}
	else
		return(0);
	return (sizeof (struct pxdevice));
}

pxslave(qi, pxaddr)
struct qb_device *qi;
struct pxdevice *pxaddr;
{
	return (1);
}

pxattach(qi)		 /* Record attachment of the unit to the controller. */
struct qb_device *qi;
{
	register int pxaddr = (int)pxcinfo[qi->qi_unit]->qm_addr;
	register int type = pxstdmap[(pxaddr&0x3f)>>2];

	if( type == PX1280 )
		printf("	Parallax PX1280");
	else
		printf("	Parallax PX600");
	printf(" Graphics Processor ");
	return (1);
}

pxreset(unit,flag)
int unit, flag;
{
	register struct pxbuf *buf = &pxbuf[unit];
	register struct pxdevice *pxaddr;
	register int ivector;

	pxaddr = (struct pxdevice *)pxcinfo[unit]->qm_addr; 
	ivector = pxstdvec[((int)pxaddr&0x3f)>>2];
	buf->pxtype = pxstdmap[((int)pxaddr&0x3f)>>2];
	buf->cbp = NULL;
	if( flag & PXCLEAR ) {
		waitaddr(pxaddr,buf);
		pxaddr->csr = CS_RST;		/* reset rampage */
		DELAY(120);
		waitaddr(pxaddr,buf);
		pxaddr->cdr = RESET;
		DELAY(320);
	}
	waitaddr(pxaddr,buf);
	pxaddr->csr = CS_RST;		/* reset rampage */
	DELAY(120);
	if( buf->pxtype == PX1280 ) {
		waitaddr(pxaddr,buf);
		pxaddr->cdr = PXBSWAP;		/* Turn on byte swapping */
	}
	buf->state = PXGINIT;		/* set state to initialize DMA */
	if( flag & PXINIT ) {
		waitaddr(pxaddr,buf);
		if( buf->pxtype == PX1280 ) {
			pxaddr->cdr = (ivector<<8)|0x3f;
			waitaddr(pxaddr,buf);
		}
		pxaddr->csr = CS_IE;		/* enable interrupts (and interrupt) */
	}
	buf->flags = PXOPEN;
}

pxopen(dev, flag)
dev_t dev;
{
	register struct pxbuf *buf;
	register struct pxdevice *pxaddr;
	register short unit;
	int pxwatch();

	if( pxcinfo[unit = minor(dev)]->qm_alive == 0 ) {
		return(ENXIO);
	}
	pxaddr = (struct pxdevice *)pxcinfo[unit]->qm_addr; 
	buf = &(pxbuf[unit]);

	if ( unit >= NPX ) {		/* check for valid minor */
		return ENXIO;
	}
	if( (buf->flags&PXOPEN) == 0 )
		pxreset(unit,(PXCLEAR|PXINIT));
	if( pxwdog == 0 ) {
		timeout(pxwatch,0,PX_TIMEOUT);			/* Start watchdog timer */
		pxwdog++;
	}
	return(0);
}

pxclose(dev,flag)
dev_t dev;
{
	register struct pxbuf *buf;
	register int s, unit;
	register struct pxdevice *pxaddr;

	unit = minor(dev);
	pxaddr = (struct pxdevice *)pxcinfo[unit]->qm_addr; 
	buf = &(pxbuf[unit]);

	s = splx(pxdinfo[unit]->qi_mi->qm_psl);
	while( buf->state != PXGRDY )
		sleep(buf,PRIBIO);
	pxreset(unit,0);
	buf->flags = 0;
	buf->cbp = NULL;
	splx(s);
	return 0;
}

pxioctl(dev, request, arg, mode)
dev_t dev;
int request, *arg;
{
	register struct pxbuf *buf;
	register struct pxdevice *pxaddr;
	register int unit, error = 0;

	unit = minor(dev);
	buf = &(pxbuf[unit]);
	pxaddr = (struct pxdevice *)pxcinfo[unit]->qm_addr;

	switch ( request ) {
	case PXIOCTYPE:			/* Return config word */
		*arg = buf->pxtype;
		break;
	case PXWSOPEN:			/* Make sure px stays open */
		buf->flags |= PXWRKSTAT;
		break;
	case PXWSCLOSE:			/* Ok to close the workstation */
		buf->flags &= ~PXWRKSTAT;
		pxclose(dev,0);
		break;
	default:
		uprintf("px: ioctl error: invalid request\n");
		error = EINVAL;
	}
	return(error);
}

pxread(dev,uio)
dev_t dev;
struct uio *uio;
{
	register struct buf *bp;
	
	if( minor(dev) > NPX )
		return(ENXIO);
	bp = &pxrq[minor(dev)];
	return(physio(pxstrategy,bp,dev,B_READ,minphys,uio));
}
	
pxwrite(dev,uio)
dev_t dev;
struct uio *uio;
{
	register struct buf *bp;

	if( minor(dev) > NPX )
		return(ENXIO);
	bp = &pxwq[minor(dev)];
	return(physio(pxstrategy,bp,dev,B_WRITE,minphys,uio));
}

pxstrategy(bp)
register struct buf *bp;
{
	register int i, s, dev, *cp;
	register struct pxbuf *buf;
	register struct qb_device *qi;
	register struct qb_ctlr *qm;
	register struct buf *dp;
	register int unit = minor(dev);

	dp = &pxutab[unit];
	qi = pxdinfo[unit];
	qm = qi->qi_mi;
	s = splx(qm->qm_psl);
	dev = bp->b_dev;
	buf = &pxbuf[unit];
	if( (buf->flags&PXOPEN) == 0 ) {
		bp->b_flags |= B_ERROR;
		bp->b_error = EFAULT;
		biodone(bp);
	}
	while( buf->state != PXGRDY )
		sleep(buf,PRIBIO);
	buf->state = PXGBLO;
	buf->cbp = bp;
	bp->av_forw = NULL;
	dp->b_forw = NULL;
	dp->b_actf = bp;
	qm->qm_tab.b_actf = dp;
	qbgo(qi);
	splx(s);
}

pxdgo(qm)
register struct qb_ctlr *qm;
{
	register struct buf *bp;
	
	bp = qm->qm_tab.b_actf->b_actf;
	if(pxstart(minor(bp->b_dev),VDMA_STD(qm->qm_qbinfo,vbnum), bp->b_bcount)) {
		bp->b_flags |= B_ERROR;
		biodone(bp);
		qbdone(qm);
	}
}

pxerror(error,unit,bp)
int error, unit;
register struct buf *bp;
{
	register struct pxbuf *buf = &pxbuf[unit];

	if( bp != NULL ) {
		bp->b_error |= error;
		bp->b_flags |= B_ERROR;
		qbdone(pxcinfo[unit]);
		biodone(bp);
	}
	pxreset(unit,PXINIT);
	buf->count = 0;
	buf->cbp = NULL;
	wakeup(buf);
}

pxrint(unit)			/* Rampage interrupt handler */
unsigned short unit;
{
	register struct qb_ctlr *qm;
	register struct pxbuf *buf;
	register struct pxdevice *pxaddr; 
	register unsigned short csr;
	register struct buf *bp;
	register int s;
	int *abp;

	s = splx(pxdinfo[unit]->qi_mi->qm_psl);
	qm = pxcinfo[unit];
	pxaddr = (struct pxdevice *)qm->qm_addr; 
	buf = &(pxbuf[unit]);
	bp = buf->cbp;
	if( buf->pxtype != PX1280 )
		waitaddr(pxaddr,buf);
	csr = pxaddr->csr; 

	buf->count = 0;
	if ( csr & CS_ER ) {	/* check if interrupt is due to Rampage error */
		printf("px: error CSR=%x\n",csr);
		pxerror(EIO,unit,bp);
		splx(s);
		return;
	}
	pxstart(unit,buf->cp,buf->bcount);	/* Continue/acknowledge  */
	splx(s);
}

pxstart(unit,addr,count)			/* transmit interrupt state machine */
register unsigned short	unit;
register int addr, count;
{
	register struct pxbuf *buf;
	register struct pxdevice *pxaddr = 
				(struct pxdevice *)pxcinfo[unit]->qm_addr; 
	register struct buf *bp;

	buf = &(pxbuf[unit]);
	bp = buf->cbp;
	buf->count = 0;
	switch(buf->state) {
	case PXGINIT:
		buf->state = PXGDONE;
		buf->cbp = NULL;
		if( buf->pxtype != PX1280 )
			waitaddr(pxaddr,buf);
		pxaddr->cdr = RJUMPB;
		break;

	case PXGBLO:
		buf->cp = (short *)addr;
		buf->bcount = count;
		buf->state = PXGBHI;
		if( buf->pxtype != PX1280 )
			waitaddr(pxaddr,buf);
		pxaddr->cdr = addr & LOWORD;
		break;

	case PXGBHI:
		buf->state = PXGWCNT;
		if( buf->pxtype != PX1280 )
			waitaddr(pxaddr,buf);
		pxaddr->cdr = addr >> WORDBITS;
		break;

	case PXGWCNT:
		buf->state = PXGDONE;
		if( buf->pxtype != PX1280 )
			waitaddr(pxaddr,buf);
		pxaddr->cdr = count >> 1;
		break;

	case PXGDONE:
		if( bp != NULL ) {
			biodone(bp);
			qbdone(pxcinfo[unit]);
			buf->cbp = NULL;
		}
		buf->state = PXGRDY;
		wakeup(buf);
		break;

	default:
		return(-1);
	}
	return(0);
}

waitaddr(pxaddr,buf)
register struct pxdevice *pxaddr;
register struct pxbuf *buf;
{
	register int csr;

	if( buf->pxtype == PX1280 ) {
		while( ((csr |= pxaddr->csr) & (CS_RDY|CS_WC)) != (CS_RDY|CS_WC) ) {
			DELAY(5);
		}
	}
	else
		while( badaddr((caddr_t)pxaddr, 2) )
			;
	while( (pxaddr->csr&(CS_ER|CS_ERC|CS_RDY|CS_IE|CS_WC|CS_WAC|CS_DAV)) == 0 )
		;
	return(csr |= pxaddr->csr);
}

wait1280(pxaddr, bits)
register struct pxdevice *pxaddr;
int bits;
{
	register int csr;

	while( (csr |= pxaddr->csr) & bits != bits)
		DELAY(5);
}

pxwatch(n)
int n;
{
	register int unit;

	timeout(pxwatch,0,PX_TIMEOUT);
	for( unit = 0; unit < n; unit++ ) {
		if( pxbuf[unit].flags & PXOPEN ) {
			if( pxbuf[unit].state != PXGRDY ) {
/*				if( pxbuf[unit].count++ == 20 ) { */
				if( pxbuf[unit].count++ == 4 ) {
					pxbuf[unit].count = 0;
					printf("PX%d lost interrupt!\n",unit);
printf("csr: %x\n", ((struct pxdevice *)(pxcinfo[unit]->qm_addr))->csr);
					pxerror(EIO,unit,pxbuf[unit].cbp);
				}
			}
		}
	}
}
#endif
