/*
 * This file performs the setting up of the OpenChip scratch area which must
 * be done before anything else is done with the OpenChip. The OpenChip should
 * be in the reset state before The kernel is run but do not depend on this.
 * The scratch area must start on a 256 byte boundary.
 */

static char SCCSid[] = {"@(#)opnchpinit.c	1.3 7/11/88"};

#include "../h/types.h"

#include "../machine/board.h"

#include "../is68kdev/openchip.h"


/*
 * Since the scratch area must start on a 256 byte boundary extra room must be
 * allocated.
 * Actually, the scratch area is not used, but it can't hurt to init it for now.
 */
char opcbbuf[255 + sizeof(struct oc_scratch)];
/*
 * openscratch may be used by other code to determine where the scratch area is.
 */
struct oc_scratch *openscratch;
char *memboundary;
char opcpvector = 120;

opcpinit() {
	static char flag;

	if (flag == 0) {
		OPENCHIP->op_reset = 0;	/* reset the OpenChip */
		openscratch = (struct oc_scratch *)(((long)opcbbuf + 255) & ~0xff);
		OPENCHIP->op_scratch = (struct oc_scratch *)svtop(openscratch);
		OPENCHIP->op_bustimeout = 120;	/* value found emperically */
		OPENCHIP->op_genvec =  VEC_GENBASE;
		/*
		 * now check to see where the boundary with VME memory is situated i.e.
		 * whether there is 4 Mbytes or 16 Mbytes.
		 */
		if (OPENCHIP->op_system & OP_SYS_MSIZE) {
			memboundary = (char *)0x5000000;
		} else {
			memboundary = (char *)0x4400000;
		}
		flag = 1;
	}
}

int OCverbose = 0;
int OCsanitycheck = 1;
/* do a sanity check on the OPENCHIP interrupt enable bits	*/
/* called with printable name of caller				*/
OCsanity(s)
char *s;	/* name of caller for printf			*/
{
	extern int sio1init, sio0init;
	if(!OCsanitycheck) {
		return;
	}
	if(! (OPENCHIP->op_sccntrl & OP_SC_INEA)) {
	    if(OCverbose)
		printf("%s: scsi INEA lost\n", s);
	    OPENCHIP->op_sccntrl |= OP_SC_INEA;
	}
	if(! (OPENCHIP->op_clkstat & OP_CLK_INEA)) {
	    if(OCverbose)
		printf("%s: clock INEA lost\n", s);
	    OPENCHIP->op_clkstat |= OP_CLK_INEA;
	}
	if(sio0init && (! (OPENCHIP->op_duchan[0].du_txstat & OP_DU_INEA))) {
	    if(OCverbose)
		printf("%s: sio chan 0 INEA lost\n", s);
	    OPENCHIP->op_duchan[0].du_txstat |= OP_DU_INEA;
	}
	if(sio1init && (! (OPENCHIP->op_duchan[1].du_txstat & OP_DU_INEA))) {
	    if(OCverbose)
		printf("%s: sio chan 1 INEA lost\n", s);
	    OPENCHIP->op_duchan[1].du_txstat |= OP_DU_INEA;
	}
}

OCwaitloc()	/* called from waitloc, add arg and call OCsanity()	*/
{
	extern char *sioifaddr;
	OCsanity("waitloc");
	if(*sioifaddr != 1) {
		printf("OCwaitloc found sioinitflg %x at %x\n", *sioifaddr,
			sioifaddr);
	}
}
setbustmo(howlong)
int howlong;
{
	OPENCHIP->op_bustimeout = howlong;
}
