/*
 * VMEBUS: Integrated Solutions VME-GP-SCSI controller interface defines
 */

#define Ngs_targ_cont	8	/* max number of target devs per gs cont */

/* ===================================================================== 
 * 		BEGIN SCSI/U DEVICE
 * ===================================================================== */
struct	gs_scsiu_device	{	/* HOST ADAPTOR CONTROL REGISTERS */
	u_short	gs_loc;
#define		GS_LOC_ID	0x7200	/*   read value of gs_loc */
#define		GS_LOC_ID_MASK	0xFF00	/*   host adaptor id mask */
#define		GS_LOC_HID_MASK	0x0007	/*   host adaptor scsi id mask */
#define		GS_LOC_INIT	0xF100	/*   start initialize sequence */
#define		GS_LOC_INIT_FLG	0x00	/*   special init parameters */
#define		GS_LOC_INIT_OK	(~GS_LOC_INIT & 0xFFFF) /*   done init seq */
#define		GS_LOC_GO	0x0000	/*   tell controller to look at hacb */
};

/* ===================================================================== 
 * 		BEGIN INTERPHASE V/SCSI 4210 JAGUAR DEVICE
 * ===================================================================== */

#define NCQE			0x1C


struct	inter_mcsb	{
	u_short				mcsb_msr;
#define GS_I_MSR_CNA	0x0001
#define GS_I_MSR_BOK	0x0002
#define GS_I_MSR_QFC	0x0004
	u_short				mcsb_mcr;
#define GS_I_MCR_SQM	0x0001
#define GS_I_MCR_FLQR	0x0004
#define GS_I_MCR_FLQ	0x0800
#define GS_I_MCR_RES	0x1000
#define GS_I_MCR_SFEN	0x2000
	u_char				mcsb_iqar_il;
#define GS_I_IQAR_IQHE	0x40
#define GS_I_IQAR_IQEA	0x80
	u_char				mcsb_iqar_iv;
	u_short				mcsb_qhp;
	u_char				mcsb_tqwn;
	u_char						: 7;
	u_char				mcsb_tqw	: 1;
	u_short				mcsb_rsvd[3];
};

struct	inter_iopb	{
	u_short				iopb_cmd;
#define GS_I_IOPB_CMD_PASS	0x0020
#define GS_I_IOPB_CMD_XPASS	0x0021
#define GS_I_IOPB_CMD_RESET	0x0022
#define GS_I_IOPB_CMD_DIAG	0x0040
#define GS_I_IOPB_CMD_INIT_CTL	0x0041
#define GS_I_IOPB_CMD_INIT_WQ	0x0042
#define GS_I_IOPB_CMD_DUMP_IP	0x0043
#define GS_I_IOPB_CMD_DUMP_WQ	0x0044
#define GS_I_IOPB_CMD_FLUSH_WQ	0x0049
	u_short				iopb_options;
#define GS_I_IOPB_OPT_IE	0x0001
#define GS_I_IOPB_OPT_SG	0x0002
#define GS_I_IOPB_OPT_DIR	0x0100
	u_char				iopb_scsi_status;
	u_char				iopb_cerr;
	u_short				iopb_rsvd;
	u_char				iopb_intvec_norm;
	u_char				iopb_intvec_err;
	u_short				iopb_intlev;
	u_short				iopb_rsvd2;
	u_short				iopb_mem_type;
#define GS_I_IOPB_MT_16		0x0100
#define GS_I_IOPB_MT_32		0x0200
#define GS_I_IOPB_MT_DP		0x0300
#define GS_I_IOPB_TT_BLK	0x0400
#define GS_I_IOPB_TT_NOINC	0x0800
	u_short				iopb_address_h;
	u_short				iopb_address_l;
	u_short				iopb_maxlen_h;
	u_short				iopb_maxlen_l;
	u_short				iopb_rsvd3[2];
	u_short				iopb_busid;
	u_short				iopb_unitadd;
	union scsi_cdb			iopb_cdb;
};

struct	inter_cqe	{
	u_short				cqe_qecr;
#define GS_I_CQE_QECR_GO	0x0001
#define GS_I_CQE_QECR_AA	0x0002
#define GS_I_CQE_QECR_HPC	0x0004
	u_short 			cqe_iopbadd;
	u_short				cqe_tag_h;
	u_short				cqe_tag_l;
	u_char				cqe_iopblen;
#define IOPB_HEAD	(sizeof(struct inter_iopb) - sizeof(union scsi_cdb))
	u_char				cqe_wqn;
	u_short				cqe_rsvd;
};

struct	inter_crb	{
	u_short				crb_crsw;
#define GS_I_CRB_CRSW_CRBV	0x0001
#define GS_I_CRB_CRSW_CC	0x0002
#define GS_I_CRB_CRSW_ERR	0x0004
#define GS_I_CRB_CRSW_EXC	0x0008
#define GS_I_CRB_CRSW_AQ	0x0010
#define GS_I_CRB_CRSW_QMS	0x0020
#define GS_I_CRB_CRSW_CQA	0x0040
	u_short				crb_rsvd;
	u_short				crb_tag_h;
	u_short				crb_tag_l;
	u_char				crb_iopblen;
	u_char				crb_wqn;
	u_short				crb_rsvd2;
	struct	inter_iopb		crb_iopb;
};

struct	inter_css	{
	u_char	css_xxx[120];
};

struct	inter_sgl	{
	u_short				is_el1_cnt;
	u_short				is_el1_add_h;
	u_short				is_el1_add_l;
	u_short				is_el1_mem;
	u_short				is_el2_cnt;
	u_short				is_el2_add_h;
	u_short				is_el2_add_l;
	u_short				is_el2_mem;
};

struct	inter_cib	{
	u_short				ic_ncqe;
	u_short				ic_dma_burst;
	u_char				ic_norm_intlev;
	u_char				ic_norm_intvec;
	u_char				ic_err_intlev;
	u_char				ic_err_intvec;
	u_short				ic_pri_busid;
	u_short				ic_sec_busid;
#define GS_I_CIB_ID_DFT		0x0008
	u_short				ic_crb_off;
	u_short				ic_sel_timo_h;
	u_short				ic_sel_timo_l;
	u_short				ic_resel_timo_h;
	u_short				ic_resel_timo_l;
	u_short				ic_vme_timo_h;
	u_short				ic_vme_timo_l;
	u_short				ic_rsvd[3];
};

#define HUS_EXCESS	(0x800 - sizeof(struct inter_mcsb) - \
				(sizeof(struct inter_cqe) * (NCQE + 1)) - \
				(sizeof(struct inter_iopb) * (NCQE)) - \
				 sizeof(struct inter_crb) - \
				 sizeof(struct inter_css) )
struct	inter_hus	{
	union	{
		u_char				un_pad[HUS_EXCESS];
		struct	inter_sgl		un_sgl[Ngs_targ_cont];
		struct	inter_cib		un_cib;
	} ih_un;
#define	ih_sgl	ih_un.un_sgl
#define	ih_cib	ih_un.un_cib
	struct inter_iopb		ih_iopb[NCQE];
};

struct	gs_inter_device	{	/* INTERPHASE I/O SPACE */
	struct	inter_mcsb		gs_mcsb;
	struct	inter_cqe		gs_mce;
	struct	inter_cqe		gs_cq[NCQE];
	struct	inter_hus		gs_hus;
	struct	inter_crb		gs_crb;
	struct	inter_css		gs_css;
};

/* ===================================================================== 
 * 		BEGIN CIPRICO RIMFIRE-3500 DEVICE
 * ===================================================================== */

struct	gs_cipr_device	{	/* CIPRICO CONTROL REGISTERS */
	u_short	gs_addbuf[4];
#define	GS_CIPR_MEMT_16BIT	0x8000	/* 16 bit wide transfers, no swapping */
#define	GS_CIPR_MEMT_32BIT	0x8400	/* 32 bit wide transfers, no swapping */
	u_short	gs_chatt[4];
#define	CIPR_CHATT_T0	0
#define	CIPR_CHATT_CL	1
	u_short	gs_status[4];
#define	GS_CIPR_RDY	0x0002	/* ready bit of status register */
	u_short	gs_reset[4];
	u_short gs_pad[240];
};

struct	cipr_pb {		/* ciprico parameter block */
	u_int	pb_ident;	/* command identifier */
	u_char	pb_rsvd;
#define	CIPR_PB_OPT_BMT	0x04	/* use block mode transfers */
#define	CIPR_PB_OPT_PAR	0x02	/* use scsi bus parity */
#define	CIPR_PB_OPT_DIS	0x01	/* allow disconnect/reconnect */
	u_char	pb_flags;
#define	CIPR_PB_FL_DBV	0x80	/* data bits valid */
#define	CIPR_PB_FL_IRS	0x08	/* inhibit sense request */
#define	CIPR_PB_FL_DAT	0x04	/* data in/data out in this operation */
#define	CIPR_PB_FL_DIR	0x02	/* data direction is out */
#define	CIPR_PB_FL_SGO	0x01	/* scatter/gather operation */
#define	CIPR_PB_FL_STD	0x88	/* standard setup; or in DIR & DAT flags */
#define	CIPR_THR_TRANS	0x80	/* throttle is transfer count */
#define	CIPR_THR_BYTE	0x00	/* throttle is byte count */
	u_char	pb_addmod;	/* address modifier */
#define	ADRM_STD_N_D	0x39		/*   Standard Non-Supervisory Data */
#define	ADRM_EXT_N_D	0x09		/*   Extended Non-Supervisory Data */
	u_char	pb_targ;	/* scsi target id */
	u_int	pb_datadr;	/* vme data memory address */
	u_int	pb_datlen;	/* transfer count */
	u_char	pb_cdb[12];	/* 12 byte cdb */
};

struct	cipr_sb {		/* ciprico status block */
	u_int	sb_ident;	/* command identifier */
	u_char	sb_rsvd;
	u_char	sb_scsi_status;
	u_char	sb_cerr;
	u_char	sb_flags;
#define	CIPR_SB_FL_CC	0x80	/* command complete */
#define	CIPR_SB_FL_ERR	0x40	/* command had an error */
#define	CIPR_SB_FL_RTY	0x20	/* command required one or more retries */
#define	CIPR_SB_FL_DTT	0x10	/* data transfer truncated */
	u_char	sb_info[8];	/* additional info bytes (sense request data) */
};

struct	gs_type0 {		/* CIPRICO TYPE-0 PARAMETER BLOCK */
	struct cipr_pb	t0_pb;
	u_short		t0_rsvd;
	u_short		t0_int;	/* interrupt specifier */
	u_int		t0_rsvd2;
	struct cipr_sb	t0_sb;
};

struct	gs_clds {		/* CIPRICO COMMAND LIST DATA STRUCTURE */
	u_int	cl_pbi;		/* parameter block in index */
	u_int	cl_pbo;		/* parameter block out index */
	u_int	cl_sbi;		/* status block in index */
	u_int	cl_sbo;		/* status block out index */
	u_int	cl_pbs;		/* parameter block area size */
	u_int	cl_sbs;		/* status block area size */
	u_int	cl_rsvd[2];	/* reserved */
#define NCPB	8	/* number of ciprico parameter blocks */
	struct cipr_pb cl_pb[NCPB];
#define NCSB	8	/* number of ciprico status blocks */
	struct cipr_sb cl_sb[NCSB];
};

struct	cipr_sgl {
	u_int	cs_next;	/* address of next sg descripter in list */

	u_char	cs_el1_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el1_mod   :7;/* address modifier of element 1 */
	u_char	cs_el1_len_hi:8;/* bits 16-23 of data length of element 1 */
	u_short	cs_el1_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el1_add;	/* address of element 1 */

	u_char	cs_el2_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el2_mod   :7;/* address modifier of element 2 */
	u_char	cs_el2_len_hi;	/* bits 16-23 of data length of element 2 */
	u_short	cs_el2_len;	/* bits 0-15 of data length of element 2 */
	u_long	cs_el2_add;	/* address of element 2 */

	u_char	cs_el3_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el3_mod   :7;/* address modifier of element 1 */
	u_char	cs_el3_len_hi;	/* bits 16-23 of data length of element 1 */
	u_short	cs_el3_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el3_add;	/* address of element 1 */

	u_char	cs_el4_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el4_mod   :7;/* address modifier of element 1 */
	u_char	cs_el4_len_hi;	/* bits 16-23 of data length of element 1 */
	u_short	cs_el4_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el4_add;	/* address of element 1 */

	u_char	cs_el5_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el5_mod   :7;/* address modifier of element 1 */
	u_char	cs_el5_len_hi;	/* bits 16-23 of data length of element 1 */
	u_short	cs_el5_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el5_add;	/* address of element 1 */

	u_char	cs_el6_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el6_mod   :7;/* address modifier of element 1 */
	u_char	cs_el6_len_hi;	/* bits 16-23 of data length of element 1 */
	u_short	cs_el6_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el6_add;	/* address of element 1 */

	u_char	cs_el7_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el7_mod   :7;/* address modifier of element 1 */
	u_char	cs_el7_len_hi;	/* bits 16-23 of data length of element 1 */
	u_short	cs_el7_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el7_add;	/* address of element 1 */

	u_char	cs_el8_ninc  :1;/* use non-incrementing if set */
	u_char	cs_el8_mod   :7;/* address modifier of element 1 */
	u_char	cs_el8_len_hi;	/* bits 16-23 of data length of element 1 */
	u_short	cs_el8_len;	/* bits 0-15 of data length of element 1 */
	u_long	cs_el8_add;	/* address of element 1 */
};

#ifdef	VQX
/* ===================================================================== 
 * 		BEGIN LIBERATOR ON_BOARD SCSI CONTROLLER INFO
 * ===================================================================== */
/* 
 * taken from qsvar.h - ISI Liberator structs common to lower level SCSI qs and 
 * upper level drivers (disk, tape, etc.).
 */


/* OpenChip lun struct */

struct lunelem {
	struct scsi_cmd *l_cmndptr; /* ptr to command struct */

	u_char l_state;		/* state of lun */
#define	L_ST_NULL	0
#define	L_ST_PENDING	1	/* discon cmd pending reconnection for lun */

	u_char l_flags;		/* bits 0-3 indicate target ID */
#define	L_FL_DESTMASK	0x07
#define	L_FL_SEL_ATN	0x08
#define	L_FL_CHK_PARITY	0x10
#define	L_FL_MANUAL	0x20

	u_char l_sync_trans;	/* value loaded into sync/trans register */
	u_char l_identify;	/* byte passed to targ for msg out */
};

#define LEN_STATUS	2

/* OpenChip command struct - these are queued up in the scratch area */

struct scsi_cmnd {
	struct qs_link qs_datlnk;	/* saved data pointer */
	struct qs_link qs_dat3lnk;	/* after each data transfer phase the
					 * current data pointer gets copied here
					 */
	char *qs_pcmnd;	/* pointer to command bytes */
	char *qs_pstat;	/* pointer to status bytes */
	char qs_ncmnd;	/* number of command bytes */
	char qs_nstat;	/* number of status bytes */
	char qs_finstat;	/* end status */
	char qs_pad;
	struct scsi_cmnd *qs_chain;
	struct lunelem *qs_ptrlun;
		/*
		 * All fields before this point are used by the Openchip.
		 * When the command is passed to scissue(), qs_dat2lnk should
		 * have been set up. scissue() will copy it into qs_datlnk and
		 * qs_dat3lnk each time the command has to be sent (multiple
		 * issuings are the result of a received BUSY response).
		 */
	char qs_status[LEN_STATUS];
	struct qs_link qs_dat2lnk;
	struct scsiproto *qs_proto;
	long qs_cmndlngth;	/* length of data transfer for the command */
	long qs_rqsnslngth;	/* length of data transfer for request sense */
	short qs_flags;
	char qs_retries;	/* maximum number of times to issue command */
	u_char qs_lun;
	char dbgmsg[80];
};

#define	SET_CMD(cmd,chain,cdb,ncmnd,pstat,finstat,nstat,datptr,datcnt,flags,stat){ \
		bzero(cmd, sizeof (struct scsi_cmnd));			\
		(cmd)->qs_chain = (struct scsi_cmnd *) chain;		\
		(cmd)->qs_pcmnd = (char *) cdb;				\
		(cmd)->qs_ncmnd = ncmnd;				\
		(cmd)->qs_pstat = (char *) pstat;			\
		(cmd)->qs_finstat = finstat;				\
		(cmd)->qs_nstat = nstat;				\
		(cmd)->qs_datlnk.sl_ptr = (char *) datptr;		\
		(cmd)->qs_datlnk.sl_cnt = datcnt;			\
		(cmd)->qs_flags = flags;				\
		(*(cmd)->qs_pstat) = stat;				}
/*
 * Note that the values taken by the qs_finstat and qs_flags fields are the
 * same values used by the sp_finstat and sp_flags fields of a scsiproto
 * structure.
 */

/*
 * values of sp_finstat. The Openchip can generate the first four. Others
 * explain why the software decided to try and abort the commands.
 */
#define	SFN_NOT_FINISHED	0
#define	SFN_NORMAL_END		1
#define	SFN_NO_CMND_CMPLT	2
#define	SFN_SLCT_TIMEOUT	3

#define	SFN_ABRT_REJ_MSG	4	/* a message rejection that the software couldn't recover from */
#define	SFN_ABRT_MSG_PRTY	5	/* there was a message parity error for  which the target didn't perform a message out phase */
#define	SFN_ABRT_MDFY_PTRS	6	/* a modify data pointer message moved the pointer back past the start */
#define	SFN_ABRT_BERR	7	/* a bus error occurred during DMA */

#define	SFN_INACTIVE	8	/* command block is inactive */
#define	SFN_STILL_BUSY	9	/* ran out of retries on receiving BUSY status */
#define	SFN_FUNNY_STATUS	10	/* any status other than good, check or busy */
#define	SFN_RQS_SNS_CHK	11	/* request sense command returned check status */
#define SFN_NOINTRFACE	12	/* no attached interface for this command */
#define SFN_TOO_MANY_BUFFERS 13	/* the attached interface didn't have the necessary buffers or other structures to handle this command */
#define SFN_ILL_PHASE	14	/* one of the two illegal phases occured */
#define SFN_STATOVFL	15	/* too many status bytes were sent */
#define	SFN_UNSPEC	16	/* unspecified error */

/*
 * bit positions in sp_flags.
 */
#define	SCF_RQS_SNS	0x0001		/* request sense issued */
#define	SCF_DATA_PRTY	0x0002		/* data transfer parity error */
#define SCF_DATA_OVFL	0x0004		/* data transfer exceeded allowed space */
#define SCF_COMM_OVFL	0x0008		/* command transfer exceeded allowed space */
#define SCF_STATUS_OVFL	0x0010		/* status transfer exceeded allowed space */
#define	SCF_UNSPEC_PHASE	0x0020		/* unspecified phase occurred */

#define SCF_FATAL_COMB	(SCF_DATA_PRTY | SCF_DATA_OVFL | SCF_COMM_OVFL | SCF_STATUS_OVFL | SCF_UNSPEC_PHASE)	/* the fatal flags */

#define	SCSTAT_RSRVCONF	0x18
#endif	VQX

/* ===================================================================== 
 * 		BEGIN GENERIC DEVICE DEFINITIONS
 * ===================================================================== */
struct	gs_hacb	{		/* HOST ADAPTOR CONTROL BLOCK */
    u_short	hacb_dcr;		/* device control register */
#define		DCR_GO		0x0100	/*	shift by target */
#define		DCR_BUSY	0x0001	/*	shift by target */
    u_short	hacb_semhost;		/* Semaphore registers */
    u_short	hacb_semhadpt;
    u_short	hacb_pad;		/* reserved ... */
    struct	hacb_dcb {		/* DEVICE CONTROL BLOCK */
      union {
/*0,1*/	u_short		un_word;	/* composite error */
       struct {
/* 0*/	u_char		ub_cerr;	/* controller error code */
#define		DCB_CERR_OK	0x00		/*   no errors */
#define		DCB_CERR_SCSI	0x80		/*   non-zero scsi status */
#define		DCB_CERR_CMDERR	0x81		/*   host sent a bad command */
#define		DCB_CERR_SELERR	0x82		/*   error selecting target */
#define		DCB_CERR_STIMER	0x83		/*   select timeout error */
#define		DCB_CERR_IERR	0x84		/*   wrong interrupt occured */
#define		DCB_CERR_TMOERR	0x85		/*   host adaptor timeout */
#define		DCB_CERR_PCERR	0x86		/*   SPC in wrong phase */
#define		DCB_CERR_VMERR	0x87		/*   vme address casued berr */
#define		DCB_CERR_NOSTAT	0x88		/*   no status received error */
#define		DCB_CERR_RECERR	0x89		/*   unexpected reconnect */
#define		DCB_CERR_DIRERR	0x8A		/*   direction error */
#define		DCB_CERR_TRGDSC	0x8B		/*   unexpected disconnect */
#define		DCB_CERR_RESET	0x8C		/*   sent bus reset */
#define		DCB_CERR_RESABO	0x8D		/*   aborted via bus reset */
#define		DCB_CERR_UNDEF1	0x8E		/*   undefined */
#define		DCB_CERR_UNDEF2	0x8F		/*   undefined */
#define		DCB_CERR_UNDEF3	0x90		/*   undefined */
/* 1*/	u_char		ub_scsi_status;	/* scsi completion status */
       } un_bytes;
      } dcb_un;
#define dcb_err			dcb_un.un_word
#define dcb_cerr		dcb_un.un_bytes.ub_cerr		
#define dcb_scsi_status		dcb_un.un_bytes.ub_scsi_status	
/* 2*/	u_char		dcb_ie		: 1;	/* interrupt enable */
#define		DCB_NOIE	0		/*   disable interrupts */
#define		DCB_IE		1		/*   enable interrupts */
	u_char		dcb_dir		: 1;	/* data direction ? */
#define		DCB_DIR_IN	0		/*   data dir is to host */
#define		DCB_DIR_OUT	1		/*   data dir is to target */
#define		DCB_DIR_NO	0		/*   no data to transfer */
	u_char		dcb_sw		: 1;	/* swap bytes ? */
#define		DCB_NOSW	0		/*   don't byte swap on data */
#define		DCB_SW		1		/*   byte swap on data */
	u_char		dcb_nodisc	: 1;	/* disconnect/reconnect ? */
#define		DCB_DISC	0		/*   disconnect/reconnect */
#define		DCB_NODISC	1		/*   no disconnect/reconnect */
	u_char				: 4;
/* 3*/	u_char		dcb_cdblen;		/* scsi_cdb length */
/* 4*/	u_char		dcb_bw		: 2;	/* HOSTBUS data width */
#define		DCB_BW_8	0
#define		DCB_BW_16	1
#define		DCB_BW_32	2
	u_char		dcb_am		: 6;	/* HOSTBUS address modifier */
#define		DCB_AM_STD_S_D	0x3D		/*   Std Supervisior Data */
/* 5*/	u_char		dcb_iv;			/* interrupt vector */
/* 6*/	u_char		*dcb_dadr;		/* data start address */
/*10*/	u_int		dcb_dlen;		/* amount of data */
/*14*/	u_short		dcb_dbsz;		/* data block size */
/*16*/	union scsi_cdb	dcb_cdb;		/* command descriptor block */
    }	hacb_dcb[8];
#define	SET_DCB(dcb, ie, dir, sw, disc, cdblen, bw, am, iv, dadr, dlen, dbsz) {\
		(dcb)->dcb_err = 0;					\
		(dcb)->dcb_cerr = 0;					\
		(dcb)->dcb_scsi_status = 0;				\
									\
		(dcb)->dcb_ie = ie;					\
		(dcb)->dcb_dir = dir;					\
		(dcb)->dcb_sw = sw;					\
		(dcb)->dcb_nodisc = disc;				\
		(dcb)->dcb_cdblen = cdblen;				\
		(dcb)->dcb_bw = bw;					\
		(dcb)->dcb_am = am;					\
		(dcb)->dcb_iv = iv;					\
		(dcb)->dcb_dadr = (u_char *) dadr;			\
		(dcb)->dcb_dlen = dlen;					\
		(dcb)->dcb_dbsz = dbsz;					}
};

#ifdef	KERNEL
struct hacb_dcb	*gsgetdcb();
#endif	KERNEL

/*
#ifdef	ASCII_DCB_CERR
char	*ascii_dcb_cerr[] = {
	" ", "HOST COMMAND ERROR", "ERROR SELECTING TARGET",
	"SELECT TIMEOUT", "WRONG INTERRUPT", "HOST ADAPTOR TIMEOUT",
	"SPC IN WRONG PHASE", "VME BUS ERROR", "STATUS NOT RECVD",
	"UNEXPECTED RECONNECT", "DIRECTION ERROR", "UNEXPECTED DISCONNECT",
	"HUNG: BUS RESET", "KILLED BY RESET", 
	"0xE", "0xF", "0x10",
};
#else	ASCII_DCB_CERR
extern char	*ascii_dcb_cerr[];
#endif	ASCII_DCB_CERR
*/
