
/*
 * VMEBUS: Integrated Solutions SCSI/U subdriver subroutines
 */

char		gs_scsiu_version[8];
int		gs_scsiu_vers();
int		gs_scsiu_cmdwait(), gs_scsiu_run(), gs_scsiu_intr();

gs_scsiu_intr(cont)
{
	register struct gs_hacb	*hacb 
	    = (struct gs_hacb *)CACHE_INHIBIT(&gs_hacb[cont]);
	int			targ;
	u_short			rdcr;
	struct hacb_dcb		*dcb;

	/*
	 * Figure out which target(s) interrupted by shifting through dcr to
	 * find a target with GO bit cleared and DB bit set.
	 */
	rdcr = hacb->hacb_dcr;
	for (targ = 0; targ < Ngs_targ_cont; targ++, rdcr = (rdcr>>1)&0x7FFF) {
		if (!(rdcr & DCR_BUSY) || (rdcr & DCR_GO))
			continue;
		dcb = &hacb->hacb_dcb[targ];
		gsrunning[cont]--;
		/* reset DB bit in dcr of interrupting device */
		do {
			hacb->hacb_semhost = 0;
			hacb->hacb_semhost = 1;
		} while (hacb->hacb_semhadpt);
		hacb->hacb_dcr &= ~(DCR_BUSY << targ);
		hacb->hacb_semhost = 0;
		gs_intr_common(cont, targ, dcb);
	}
	return (0);
}

gs_scsiu_run(cont, targ)
{
	register struct gs_hacb	*hacb 
	    = (struct gs_hacb *)CACHE_INHIBIT(&gs_hacb[cont]);

	if (hacb->hacb_dcr & ((DCR_GO | DCR_BUSY) << targ))
		panic("gs: target busy but not active");
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
	} while (hacb->hacb_semhadpt);
	hacb->hacb_dcr |= (DCR_GO << targ);
	hacb->hacb_semhost = 0;
	gsrunning[cont]++;
	((struct gs_scsiu_device *)GSaddr[cont])->gs_loc = GS_LOC_GO;
}

gs_scsiu_init(gsaddr, cont)
	register struct gs_scsiu_device	*gsaddr;
{
	register struct gs_hacb	*hacb 
	    = (struct gs_hacb *)CACHE_INHIBIT(&gs_hacb[cont]);
	register struct hacb_dcb	*dcb;
	int				hatarg, vdma, iopb;
	long 				l = 0;

	while (gsaddr->gs_loc == 0xFFFF && ++l < 800000)
		;
	if ((gsaddr->gs_loc & GS_LOC_ID_MASK) != GS_LOC_ID)
		return(-1);
	bzero(hacb, sizeof(struct gs_hacb));
	/* give the init cmd */
	do {
	        gsaddr->gs_loc = GS_LOC_INIT | GS_LOC_INIT_FLG;
	} while (gsaddr->gs_loc != GS_LOC_INIT_OK);
	vdma = IOPB_STD(iopballoc(&gs_hacb[cont], sizeof(struct gs_hacb)),vbnum);
	gsaddr->gs_loc = 0;
	gsaddr->gs_loc = vdma >> 16;
	gsaddr->gs_loc = vdma;
	while (gsaddr->gs_loc == 0xFFFF && ++l < 800000)
		;
	if (((gsident[cont] = gsaddr->gs_loc) & GS_LOC_ID_MASK) != GS_LOC_ID)
		return (-1);
	gs_run[cont] = gs_scsiu_run;
	gs_intr[cont] = gs_scsiu_intr;
	gs_cmdwait[cont] = gs_scsiu_cmdwait;
	gs_vers[cont] = gs_scsiu_vers;
	GSaddr[cont] = (int) gsaddr;

	/* issue version command to cause interrupt */
	hatarg = gsident[cont] & GS_LOC_HID_MASK;
	bzero(gs_scsiu_version, 8);
	dcb = &hacb->hacb_dcb[hatarg];
	iopb = iopballoc(gs_scsiu_version, 8);
	vdma = IOPB_STD(iopb,vbnum);
	SET_CDB_0(&dcb->dcb_cdb, CMD_VERSION, 0, 0, 0, 0, 0);
	SET_DCB(dcb, DCB_IE, DCB_DIR_IN, 0, 0, sizeof(struct cdb_0),
		DCB_BW_16, DCB_AM_STD_S_D, 0, vdma, 8, 1);
	gsrun(cont, hatarg);
	gsrunning[cont]--;
	if (gs_scsiu_cmdwait(cont, hatarg, 800000))
		return (-1);
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
	} while (hacb->hacb_semhadpt);
	hacb->hacb_dcr = 0;
	hacb->hacb_semhost = 0;
	iopbfree(iopb);
	if (dcb->dcb_err)			/* make sure no errors */
		return (-1);
	return (0);
}

gs_scsiu_cmdwait(cont, targ, timeout)
{
	register struct gs_hacb	*hacb 
	    = (struct gs_hacb *)CACHE_INHIBIT(&gs_hacb[cont]);
	int			targo = DCR_GO << targ;
	long			l = 0;

	/* wait for GO to be cleared */
	while (hacb->hacb_dcr & (targo)) {
	    if (l++ > timeout) {
		do {
		    hacb->hacb_semhost = 0;
		    hacb->hacb_semhost = 1;
		} while (hacb->hacb_semhadpt);
		hacb->hacb_dcr = 0;
		hacb->hacb_semhost = 0;
		return (-1);
	    }
	    DELAY(400);
	} 
	return (0);
}

gs_scsiu_cmdabort(cont, targ)
{
	register struct gs_hacb	*hacb 
	    = (struct gs_hacb *)CACHE_INHIBIT(&gs_hacb[cont]);
	struct hacb_dcb		*dcb = &hacb->hacb_dcb[targ];
	int			rdcr;

	bzero(dcb, sizeof(struct hacb_dcb));
	dcb->dcb_ie = DCB_IE;
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
	} while (hacb->hacb_semhadpt);
	rdcr = hacb->hacb_dcr;
	hacb->hacb_dcr = (rdcr & ~(DCR_BUSY << targ)) | (DCR_GO << targ);
	hacb->hacb_semhost = 0;
}

gs_scsiu_vers()
{
	printf("        ISI SCSI/U: HW %8s", gs_scsiu_version);
}
