/*
 * VMEBUS: Integrated Solutions INTERPHASE SCSI subdriver subroutines
 */

#define BZERO_INTER		bzero_inter
#define BCOPY_INTER		bcopy_inter
#define	GS_MAGIC_INTER		0x9700
#define	GS_DMA_BURST		32
#define	GS_INTER_SEL_TIMO	400
#define	GS_INTER_DISC_TIMO	0
#define	GS_VME_TIMO		0
#define	GS_INTER_OWN_ID		-1
#define	GS_INTR_LEVEL		6

int		gs_inter_cmdwait(), gs_inter_run(), gs_inter_intr();
u_short		gs_inter_intvec[NGS];
int		gs_inter_memt;
int		gs_inter_vers();
char		*gs_inter_vers_css;

#ifndef SGL_IN_SHORTIO
struct inter_sgl	gs_inter_sgl[NGS][Ngs_targ_cont];
u_long			gs_inter_sgl_vdma[NGS][Ngs_targ_cont];
#endif SGL_IN_SHORTIO
u_long			gs_inter_null;
int			gs_inter_null_vdma;

#define INTER_OFFSET(add)	(char *)((u_long )(add) - (u_long)(gsaddr))

gs_inter_intr(cont)
{
	struct gs_inter_device *gsaddr = (struct gs_inter_device *)GSaddr[cont];
	struct inter_crb	*crb = &gsaddr->gs_crb;
	struct inter_iopb	*iopb = &crb->crb_iopb;
	struct hacb_dcb		*dcb;
	int			targ;

	if (!(crb->crb_crsw & GS_I_CRB_CRSW_CRBV)) {
		printf("spurious interrupt: ignored\n");
		return(0);
	}
	if (!(crb->crb_crsw & GS_I_CRB_CRSW_CC))
		panic("command not complete");
	targ = crb->crb_tag_l;
	dcb = &gs_hacb[cont].hacb_dcb[targ];
	gsrunning[cont]--;
	gs_hacb[cont].hacb_dcr &= ~((DCR_BUSY | DCR_GO) << targ);
	if (crb->crb_crsw & (GS_I_CRB_CRSW_ERR | GS_I_CRB_CRSW_EXC))
		if (iopb->iopb_cerr != 0x34) {
			dcb->dcb_scsi_status = iopb->iopb_scsi_status;
			dcb->dcb_cerr = iopb->iopb_cerr;
		}
	crb->crb_crsw = 0;
	gs_intr_common(cont, targ, dcb);
	return (0);
}

gs_inter_run(cont, targ)
{
	struct gs_hacb	*hacb = &gs_hacb[cont];
	struct hacb_dcb	*dcb = &hacb->hacb_dcb[targ];
	struct gs_inter_device *gsaddr = (struct gs_inter_device *)GSaddr[cont];
	struct inter_iopb	*iopb;
	struct inter_cqe	*cqe;
	int			ix, res_len, s;

	s = splx(PSL_CURMOD + (GS_INTR_LEVEL << PSL_IPL_SHIFT));
	ix = gsaddr->gs_mcsb.mcsb_qhp;
	cqe = &gsaddr->gs_cq[ix];
	if (cqe->cqe_qecr & GS_I_CQE_QECR_GO)
		panic("gs: out of cqe's");
	gsaddr->gs_mcsb.mcsb_qhp = (ix + 1) % (NCQE);
	iopb = &gsaddr->gs_hus.ih_iopb[ix];
	BZERO_INTER(iopb, sizeof(struct inter_iopb));
	iopb->iopb_cmd = GS_I_IOPB_CMD_PASS;
	if (dcb->dcb_ie == DCB_IE) {
		iopb->iopb_options |= GS_I_IOPB_OPT_IE;
		iopb->iopb_intvec_norm = gs_inter_intvec[cont];
		iopb->iopb_intvec_err = gs_inter_intvec[cont];
		iopb->iopb_intlev = GS_INTR_LEVEL;
	}
	if (dcb->dcb_dir == DCB_DIR_OUT)
		iopb->iopb_options |= GS_I_IOPB_OPT_DIR;
	if (dcb->dcb_dbsz && (res_len = (dcb->dcb_dlen % dcb->dcb_dbsz))) {
#ifdef SGL_IN_SHORTIO
		struct inter_sgl	*sgl = &gsaddr->gs_hus.ih_sgl[targ];

		iopb->iopb_mem_type = GS_I_IOPB_MT_DP;
		iopb->iopb_address_l = (u_long )INTER_OFFSET(sgl);
#else SGL_IN_SHORTIO
		struct inter_sgl    *sgl = &gs_inter_sgl[cont][targ];
		u_long		    sgl_vdma = gs_inter_sgl_vdma[cont][targ];

		iopb->iopb_mem_type = gs_inter_memt | GS_ADDRMOD;
		iopb->iopb_address_h = sgl_vdma >> 16;
		iopb->iopb_address_l = sgl_vdma & 0xFFFF;
#endif SGL_IN_SHORTIO
		iopb->iopb_options |= GS_I_IOPB_OPT_SG;
		iopb->iopb_maxlen_l = 2;
		sgl->is_el1_cnt = dcb->dcb_dlen;
		sgl->is_el1_add_h = (u_long )dcb->dcb_dadr >> 16;
		sgl->is_el1_add_l = (u_long )dcb->dcb_dadr & 0xFFFF;
		sgl->is_el1_mem = gs_inter_memt | GS_ADDRMOD;
		sgl->is_el2_cnt = dcb->dcb_dbsz - res_len;
		sgl->is_el2_add_h = (u_long )gs_inter_null_vdma >> 16;
		sgl->is_el2_add_l = (u_long )gs_inter_null_vdma & 0xFFFF;
		sgl->is_el2_mem = 
		    GS_I_IOPB_TT_NOINC | gs_inter_memt | GS_ADDRMOD;
	} else {
		iopb->iopb_mem_type = gs_inter_memt | GS_ADDRMOD;
		iopb->iopb_address_h = (u_long )dcb->dcb_dadr >> 16;
		iopb->iopb_address_l = (u_long )dcb->dcb_dadr & 0xFFFF;
		iopb->iopb_maxlen_h = dcb->dcb_dlen >> 16;
		iopb->iopb_maxlen_l = dcb->dcb_dlen & 0xFFFF;
	}
	iopb->iopb_unitadd = targ | (dcb->dcb_cdb.cdb_0.cdb_0_lun << 3);
	BCOPY_INTER(&dcb->dcb_cdb, &iopb->iopb_cdb, dcb->dcb_cdblen);
	BZERO_INTER(cqe, sizeof(struct inter_cqe));
	cqe->cqe_wqn = targ + 1;
	cqe->cqe_tag_h = ix;
	cqe->cqe_tag_l = targ;
	cqe->cqe_iopblen = IOPB_HEAD + dcb->dcb_cdblen;
	cqe->cqe_iopbadd = (u_short )INTER_OFFSET(iopb);
	cqe->cqe_qecr = GS_I_CQE_QECR_GO;
	gsrunning[cont]++;
	hacb->hacb_dcr |= ((DCR_GO | DCR_BUSY) << targ); /* for gswatch */
	splx(s);
}

gs_inter_init(gsaddr, cont)
	register struct gs_inter_device	*gsaddr;
{
	struct inter_cib		*cibp = &gsaddr->gs_hus.ih_cib;
	struct inter_crb		*crbp = &gsaddr->gs_crb;
	struct inter_iopb		*iopb = &gsaddr->gs_hus.ih_iopb[0];
	struct inter_cqe		*mcep = &gsaddr->gs_mce;
	long				l = 0;
	u_char				v;

	gsaddr->gs_mcsb.mcsb_mcr = GS_I_MCR_RES; 	/* reset board */
	DELAY(100);
	gsaddr->gs_mcsb.mcsb_mcr = 0; 			/* release reset */
	do { 
	    	if (l++ > 0x80000)
			return (-1);
	    	DELAY(400);
	} while (gsaddr->gs_mcsb.mcsb_msr != GS_I_MSR_BOK);
	BZERO_INTER(&gs_hacb[cont], sizeof(struct gs_hacb));

	if (!gs_inter_memt)
#ifdef	M68020
#ifndef VQX
		if (GS_CPUMEMW == BSR_16BITMEM)
			gs_inter_memt = GS_I_IOPB_MT_16;
		else
#endif VQX
#endif	M68020
			gs_inter_memt = GS_I_IOPB_MT_32;

	/* initialize controller */
	gs_inter_intvec[cont] = freevec();
	BZERO_INTER(cibp, sizeof(struct inter_cib));
	cibp->ic_ncqe = NCQE;
	cibp->ic_dma_burst = GS_DMA_BURST;
	cibp->ic_norm_intlev = GS_INTR_LEVEL;
	cibp->ic_norm_intvec = gs_inter_intvec[cont];
	cibp->ic_err_intlev = GS_INTR_LEVEL;
	cibp->ic_err_intvec = gs_inter_intvec[cont];
	if (GS_INTER_OWN_ID < 0) {
		cibp->ic_pri_busid = GS_I_CIB_ID_DFT;
		cibp->ic_sec_busid = GS_I_CIB_ID_DFT;
	} else {
		cibp->ic_pri_busid = GS_INTER_OWN_ID;
		cibp->ic_sec_busid = GS_INTER_OWN_ID;
	}
	cibp->ic_crb_off = (u_short )INTER_OFFSET(crbp);
	cibp->ic_sel_timo_h = GS_INTER_SEL_TIMO >> 16;
	cibp->ic_sel_timo_l = GS_INTER_SEL_TIMO & 0xFFFF;
	cibp->ic_resel_timo_h = GS_INTER_DISC_TIMO >> 16;
	cibp->ic_resel_timo_l = GS_INTER_DISC_TIMO & 0xFFFF;
	cibp->ic_vme_timo_h = GS_VME_TIMO >> 16;
	cibp->ic_vme_timo_l = GS_VME_TIMO & 0xFFFF;
	BZERO_INTER(iopb, sizeof(struct inter_iopb));
	iopb->iopb_cmd = GS_I_IOPB_CMD_INIT_CTL;
	iopb->iopb_options = GS_I_IOPB_OPT_IE;
	iopb->iopb_intvec_norm = gs_inter_intvec[cont];
	iopb->iopb_intvec_err = gs_inter_intvec[cont];
	iopb->iopb_intlev = GS_INTR_LEVEL;
	iopb->iopb_mem_type = GS_I_IOPB_MT_DP;
	iopb->iopb_address_l = (u_short )INTER_OFFSET(cibp);
	iopb->iopb_maxlen_l = sizeof(struct inter_cib);
	BZERO_INTER(mcep, sizeof(struct inter_cqe));
	mcep->cqe_iopblen = IOPB_HEAD - 2;
	mcep->cqe_tag_h = (u_long )cibp >> 16;
	mcep->cqe_tag_l = (u_long )cibp & 0xFFFF;
	mcep->cqe_iopbadd = (u_short )INTER_OFFSET(iopb);
	mcep->cqe_qecr = GS_I_CQE_QECR_GO;
	l = 0;
	while (!(crbp->crb_crsw & GS_I_CRB_CRSW_CRBV)) {
	    	if (l++ > 0x80000)
			return (-1);
	    	DELAY(400);
	} 
	if (crbp->crb_crsw != (GS_I_CRB_CRSW_CC | GS_I_CRB_CRSW_CRBV))
		return(-1);
	if (((crbp->crb_tag_h << 16) | crbp->crb_tag_l) != (u_long )cibp)
		return(-1);
	if (crbp->crb_iopb.iopb_cerr)
		return(-1);
	crbp->crb_crsw = 0;

	/* initialize work queues */
	BZERO_INTER(iopb, sizeof(struct inter_iopb));
	iopb->iopb_cmd = GS_I_IOPB_CMD_INIT_WQ;
	iopb->iopb_unitadd = 0x8000;	/* force initialization */
	iopb->iopb_cdb.cdb_raw[1] = 3;	/* allow 3 cmds per device */
	iopb->iopb_cdb.cdb_raw[3] = 7;	/* use an average priority */
	for (iopb->iopb_busid = 1; iopb->iopb_busid <= 14; iopb->iopb_busid++){
		BZERO_INTER(mcep, sizeof(struct inter_cqe));
		mcep->cqe_iopblen = IOPB_HEAD + 2;
		mcep->cqe_tag_l = iopb->iopb_busid;
		mcep->cqe_iopbadd = (u_short )INTER_OFFSET(iopb);
		mcep->cqe_qecr = GS_I_CQE_QECR_GO;
		l = 0;
		while (!(crbp->crb_crsw & GS_I_CRB_CRSW_CRBV)) {
	    		if (l++ > 0x80000)
				return (-1);
	    		DELAY(400);
		} 
		if (crbp->crb_crsw != (GS_I_CRB_CRSW_CC | GS_I_CRB_CRSW_CRBV))
			return(-1);
		if (crbp->crb_tag_l != iopb->iopb_busid)
			return(-1);
		if (crbp->crb_iopb.iopb_cerr)
			return(-1);
		crbp->crb_crsw = 0;
	}
	gsaddr->gs_mcsb.mcsb_mcr = GS_I_MCR_SQM;	/* start work queues */
	l = 0;
	while (!(crbp->crb_crsw & GS_I_CRB_CRSW_CRBV)) {
	    	if (l++ > 0x80000)
			return (-1);
	    	DELAY(400);
	} 
	if (!(crbp->crb_crsw & GS_I_CRB_CRSW_QMS))
		return(-1);
	DELAY(400);
	crbp->crb_crsw = 0;
	gs_inter_null_vdma 
	    = IOPB_STD(iopballoc(&gs_inter_null, sizeof(gs_inter_null)),vbnum);
#ifndef SGL_IN_SHORTIO
	for (l = 0; l < Ngs_targ_cont; l++)
		gs_inter_sgl_vdma[cont][l] = IOPB_STD(
		    iopballoc(&gs_inter_sgl[cont][l],sizeof(struct inter_sgl)),vbnum);
#endif SGL_IN_SHORTIO
	gs_run[cont] = gs_inter_run;
	gs_intr[cont] = gs_inter_intr;
	gs_cmdwait[cont] = gs_inter_cmdwait;
	gs_vers[cont] = gs_inter_vers;
	gs_inter_vers_css = gsaddr->gs_css.css_xxx;
	gsident[cont] = GS_MAGIC_INTER | gs_inter_vers_css[34];
	return (0);
}

gs_inter_cmdwait(cont, targ, timeout)
{
	register u_short	*crsw;
	long			l = 0;

	crsw = &((struct gs_inter_device *)GSaddr[cont])->gs_crb.crb_crsw;
	while (!(*crsw & GS_I_CRB_CRSW_CRBV)) {
	    	if (l++ > timeout) {
			return (-1);
	    	}
	    	DELAY(400);
	} 
	return(0);
}

bcopy_inter(sp, dp, len)
	register char *sp;
	register char *dp;
	register u_int len;
{
	while (len--)
		*dp++ = *sp++;
}

bzero_inter(ap, len)
	register char *ap;
	register u_int len;
{
	while (len--)
		*ap++ = 0;
}

gs_inter_vers()
{
	printf("        INTERPHASE SCSI: FW %3s (%2s/%2s/%2s)",
		gs_inter_vers_css + 13,
		gs_inter_vers_css + 18,
		gs_inter_vers_css + 20,
		gs_inter_vers_css + 24);
}
