#define CIPR_NONINC	/**/
/*
 * VMEBUS: Integrated Solutions CIPRICO subdriver subroutines
 */
int		gs_cipr_cmdwait(), gs_cipr_run(), gs_cipr_intr();
struct gs_type0	gs_t0pb;
int		t0_vdma;
int		gs_cipr_memt;
struct gs_clds	gs_clds[NGS];
u_char		gs_cipr_noint[NGS];

int             gs_cipr_vers();
struct cipr_sb  gs_cipr_vers_sb;

struct cipr_sgl		gs_cipr_sgl[NGS][Ngs_targ_cont];
u_long			gs_cipr_sgl_vdma[NGS][Ngs_targ_cont];
#ifdef CIPR_NONINC
u_int			gs_cipr_null;
#else CIPR_NONINC
#define MAXDEVBKSZ      0x200
char			gs_cipr_null[MAXDEVBKSZ];
#endif CIPR_NONINC
u_long			gs_cipr_null_vdma;

#define	GS_MAGIC_CIPR		0x9800
#define	GS_GEN_OPT		(CIPR_PB_OPT_PAR | CIPR_PB_OPT_DIS)
#define	GS_THROTTLE_TYPE	(CIPR_THR_TRANS)
#define	GS_THROTTLE_CNT		32
#define	GS_CIPR_OWN_ID		7
#define GS_DISC_TIMO		0x0000
#define GS_SEL_TIMO		0x80 << 16
#define CIPR_RETRY_CTL_RBE	0x10
#define GS_RETRY_CTL		(CIPR_RETRY_CTL_RBE) << 8
#define GS_RETRY_LIM		0x02
#define CIPR_UNIT_FLAGS_SYN	0x02
#define GS_UNIT_FLAGS		(CIPR_UNIT_FLAGS_SYN)
#define	GS_INTR_LEVEL		6

gs_cipr_intr(cont)
{
	if (gs_cipr_noint[cont])
		gs_cipr_fakeintr(cont);
	else
		gs_cipr_realintr(cont);
}

gs_cipr_fakeintr(cont)
{
	struct gs_type0	*t0 = (struct gs_type0 *)CACHE_INHIBIT(&gs_t0pb);
	struct cipr_sb	*sb = &t0->t0_sb;
	struct gs_hacb	*hacb = &gs_hacb[cont];
	struct hacb_dcb	*dcb;
	int		targ;

	gs_cipr_noint[cont] = 0;
	if (!(sb->sb_flags & CIPR_SB_FL_CC))
		panic("command not complete");
	targ = sb->sb_ident;
	dcb = &hacb->hacb_dcb[targ];
	gsrunning[cont]--;
	hacb->hacb_dcr &= ~((DCR_BUSY | DCR_GO) << targ);
	if (sb->sb_flags & CIPR_SB_FL_ERR) {
		dcb->dcb_scsi_status = sb->sb_scsi_status;
		dcb->dcb_cerr = sb->sb_cerr;
	}
	gs_intr_common(cont, targ, dcb);
	return (0);
}

gs_cipr_realintr(cont)
{
	struct gs_clds	*clds = (struct gs_clds *)CACHE_INHIBIT(&gs_clds[cont]);
	struct cipr_sb	*sb;
	struct hacb_dcb	*dcb;
	int		targ;

	while (clds->cl_sbo != clds->cl_sbi) {
		sb = &clds->cl_sb[clds->cl_sbo];
		if (!(sb->sb_flags & CIPR_SB_FL_CC))
			panic("command not complete");
		targ = sb->sb_ident;
		dcb = &gs_hacb[cont].hacb_dcb[targ];
		gsrunning[cont]--;
		gs_hacb[cont].hacb_dcr &= ~((DCR_BUSY | DCR_GO) << targ);
		if (sb->sb_flags & CIPR_SB_FL_ERR) {
			dcb->dcb_scsi_status = sb->sb_scsi_status;
			dcb->dcb_cerr = sb->sb_cerr;
		}
		clds->cl_sbo = (clds->cl_sbo + 1) % NCSB;
		gs_intr_common(cont, targ, dcb);
	}
	return (0);
}

gs_cipr_run(cont, targ)
{
	struct gs_hacb	*hacb = &gs_hacb[cont];
	struct hacb_dcb	*dcb = &hacb->hacb_dcb[targ];

	if (dcb->dcb_ie == DCB_IE)
		gs_cipr_run_int(cont, targ, hacb, dcb);
	else
		gs_cipr_run_noint(cont, targ, hacb, dcb);
}

gs_cipr_run_noint(cont, targ, hacb, dcb)
	struct gs_hacb	*hacb;
	struct hacb_dcb	*dcb;
{
	
	struct gs_type0	*t0 = (struct gs_type0 *)CACHE_INHIBIT(&gs_t0pb);
	struct cipr_pb	*pbp = &t0->t0_pb;

	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_ident = targ;
	pbp->pb_flags = CIPR_PB_FL_STD |
		(dcb->dcb_dlen ? CIPR_PB_FL_DAT : 0) |
		((dcb->dcb_dir == DCB_DIR_OUT) ? CIPR_PB_FL_DIR : 0);
	pbp->pb_addmod = GS_ADDRMOD;
	pbp->pb_targ = targ;
	pbp->pb_datlen = dcb->dcb_dlen;
	pbp->pb_datadr = (u_int )dcb->dcb_dadr;
	pbp->pb_targ = targ;	/* command to controller */
	bcopy(&dcb->dcb_cdb, pbp->pb_cdb, dcb->dcb_cdblen);
	gsrunning[cont]++;
	gs_cipr_noint[cont] = 1;
	hacb->hacb_dcr |= ((DCR_GO | DCR_BUSY) << targ); /* for gswatch */
	gs_issue_t0_cmd(GSaddr[cont]);
}

gs_cipr_run_int(cont, targ, hacb, dcb)
	struct gs_hacb	*hacb;
	struct hacb_dcb	*dcb;
{
	struct gs_clds	*clds = (struct gs_clds *)CACHE_INHIBIT(&gs_clds[cont]);
	struct gs_cipr_device *gsaddr = (struct gs_cipr_device *)GSaddr[cont];
	struct cipr_pb	*pbp;
	int res_len, s;

	s = splx(PSL_CURMOD + (GS_INTR_LEVEL << PSL_IPL_SHIFT));
	if ((clds->cl_pbi + 1) % NCPB == clds->cl_pbo)
		panic("gs: command list full");
	pbp = &clds->cl_pb[clds->cl_pbi];
	pbp->pb_ident = targ;
	pbp->pb_flags = CIPR_PB_FL_STD |
		(dcb->dcb_dlen ? CIPR_PB_FL_DAT : 0) |
		((dcb->dcb_dir == DCB_DIR_OUT) ? CIPR_PB_FL_DIR : 0);
	pbp->pb_addmod = GS_ADDRMOD;
	pbp->pb_targ = targ;
	if (dcb->dcb_dbsz && (res_len = (dcb->dcb_dlen % dcb->dcb_dbsz))) {
		struct cipr_sgl *sgl = &gs_cipr_sgl[cont][targ];

#ifndef CIPR_NONINC
		if (dcb->dcb_dbsz - res_len > MAXDEVBKSZ)
			panic("gs: leftover too large");
#endif CIPR_NONINC

		bzero(sgl, sizeof(*sgl));/**/
		sgl->cs_next    = -1;
		sgl->cs_el1_mod = GS_ADDRMOD;
		sgl->cs_el1_len = dcb->dcb_dlen;
		sgl->cs_el1_add = (u_long )dcb->dcb_dadr;
#ifdef CIPR_NONINC
		sgl->cs_el2_ninc = 1;
#endif CIPR_NONINC
		sgl->cs_el2_mod = GS_ADDRMOD;
		sgl->cs_el2_len = dcb->dcb_dbsz - res_len;
		sgl->cs_el2_add = gs_cipr_null_vdma;
		/*sgl->cs_el3_len = 0;/**/
		pbp->pb_flags |= CIPR_PB_FL_SGO;
		pbp->pb_datlen = sgl->cs_el1_len + sgl->cs_el2_len;
		pbp->pb_datadr = gs_cipr_sgl_vdma[cont][targ];
	} else {
		pbp->pb_datlen = dcb->dcb_dlen;
		pbp->pb_datadr = (u_int )dcb->dcb_dadr;
	}


	bcopy(&dcb->dcb_cdb, pbp->pb_cdb, dcb->dcb_cdblen);
	clds->cl_pbi = (clds->cl_pbi + 1) % NCPB;
	gsrunning[cont]++;
	hacb->hacb_dcr |= ((DCR_GO | DCR_BUSY) << targ); /* for gswatch */
	gsaddr->gs_chatt[0] = CIPR_CHATT_CL;
	splx(s);
}

gs_cipr_init(gsaddr, cont)
	register struct gs_cipr_device	*gsaddr;
{
	struct gs_clds	*clds = (struct gs_clds *)CACHE_INHIBIT(&gs_clds[cont]);
	struct gs_type0	*t0 = (struct gs_type0 *)CACHE_INHIBIT(&gs_t0pb);
	register struct cipr_pb		*pbp = (struct cipr_pb *)&t0->t0_pb;
	long				l = 0;


	gsaddr->gs_reset[0] = 0; /* reset board */
	while (!(gsaddr->gs_status[0] & GS_CIPR_RDY) && ++l < 800000)
		;
	if (!(gsaddr->gs_status[0] & GS_CIPR_RDY))
		return(-1);
	bzero(&gs_hacb[cont], sizeof(struct gs_hacb));
	if (!gs_cipr_null_vdma) {
#ifdef CIPR_NONINC
		gs_cipr_null_vdma=IOPB_STD(iopballoc(&gs_cipr_null,
						sizeof(gs_cipr_null)),vbnum);
#else CIPR_NONINC
		gs_cipr_null_vdma=IOPB_STD(iopballoc(gs_cipr_null, MAXDEVBKSZ),vbnum);
#endif CIPR_NONINC
#ifdef	M68020
#ifndef VQX
		if (GS_CPUMEMW == BSR_16BITMEM)
			gs_cipr_memt = GS_CIPR_MEMT_16BIT | GS_ADDRMOD;
		else
#endif VQX
#endif	M68020
			gs_cipr_memt = GS_CIPR_MEMT_32BIT | GS_ADDRMOD;
	}
	if (!t0_vdma) {
		t0_vdma =
		  IOPB_STD(iopballoc(&gs_t0pb, sizeof(struct gs_type0)),vbnum);
		for (l = 0; l < Ngs_targ_cont; l++)
		    gs_cipr_sgl_vdma[cont][l] = 
			IOPB_STD(iopballoc(&gs_cipr_sgl[cont][l],
			    sizeof(struct cipr_sgl)), vbnum);
	}

	/* give general options command; set options */
	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_cdb[0] = 0x07;	/* general options command */
	pbp->pb_rsvd = GS_GEN_OPT;
	pbp->pb_flags = GS_THROTTLE_TYPE | GS_THROTTLE_CNT;
	pbp->pb_addmod = GS_CIPR_OWN_ID;
	pbp->pb_targ = 0xFF;	/* command to controller */
	if (gs_cipr_dot0cmd(gsaddr, cont))
		return(-1);

	/* do unit options command on all 8 targets */
	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_cdb[0] = 0x08;	/* unit options command */
	pbp->pb_rsvd = GS_DISC_TIMO >> 8;
	pbp->pb_flags = GS_DISC_TIMO;
	pbp->pb_datadr = GS_SEL_TIMO | GS_RETRY_CTL | GS_RETRY_LIM;
	pbp->pb_datlen = GS_UNIT_FLAGS;
	pbp->pb_targ = 0xFF;	/* command to controller */
	while (pbp->pb_addmod < 8) {
		if (gs_cipr_dot0cmd(gsaddr, cont))
			return(-1);
		pbp->pb_addmod++;
	}

	/* give the start command list command */
	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_cdb[0] = 0x01;	/* unit options command */
	pbp->pb_addmod = GS_ADDRMOD;
	pbp->pb_datadr = IOPB_STD(iopballoc(&gs_clds[cont], sizeof(struct gs_clds)),vbnum);
	pbp->pb_datlen = (GS_INTR_LEVEL << 8) | freevec();
	pbp->pb_targ = 0xFF;	/* command to controller */
	bzero(clds, sizeof(struct gs_clds));
	clds->cl_pbs = NCPB;
	clds->cl_sbs = NCSB;
	if (gs_cipr_dot0cmd(gsaddr, cont))
		return(-1);

	/* give the identify command to cause interrupt */
	pbp = clds->cl_pb;
	pbp->pb_ident = 0xFF;
	pbp->pb_targ = 0xFF;	/* command to controller */
	pbp->pb_cdb[0] = 0x05;	/* identify command */
	clds->cl_pbi++;
	gsaddr->gs_chatt[0] = CIPR_CHATT_CL;
	do {
	    	DELAY(1000);
	    	if (l++ > 0x2000) {
			return (-1);
	    	}
	} while (clds->cl_sbi == clds->cl_sbo);
	if (!(clds->cl_sb->sb_flags & CIPR_SB_FL_CC) ||
	    (clds->cl_sb->sb_flags & CIPR_SB_FL_ERR))
		return (-1);
	gs_cipr_vers_sb = *clds->cl_sb;
	clds->cl_sbo++;
	gsident[cont] = GS_MAGIC_CIPR | GS_CIPR_OWN_ID;
	gs_run[cont] = gs_cipr_run;
	gs_intr[cont] = gs_cipr_intr;
	gs_cmdwait[cont] = gs_cipr_cmdwait;
	gs_vers[cont] = gs_cipr_vers;

	return (0);
}

gs_cipr_dot0cmd(gsaddr, cont)
	register struct gs_cipr_device	*gsaddr;
{
	register u_char	*flags 
	    = (u_char *)CACHE_INHIBIT(&gs_t0pb.t0_sb.sb_flags);

	gs_issue_t0_cmd(gsaddr);
	if (gs_cipr_cmdwait(cont, 0xFF, 0x2000))
		return(-1);
	if (gsaddr->gs_status[0] & 0x0010)
		panic("memory transfer error");
	if (!(*flags & CIPR_SB_FL_CC) || (*flags & CIPR_SB_FL_ERR))
		return (-1);
	return(0);
}

gs_issue_t0_cmd(gsaddr)
	register struct gs_cipr_device	*gsaddr;
{
	DELAY(1000);	/* give time to settle */
	gsaddr->gs_addbuf[0] = gs_cipr_memt;
	gsaddr->gs_addbuf[0] = t0_vdma >> 16;
	gsaddr->gs_addbuf[0] = t0_vdma;
	gsaddr->gs_chatt[0] = CIPR_CHATT_T0;
}

gs_cipr_cmdwait(cont, targ, timeout)
{
	register u_char	*flags 
	    = (u_char *)CACHE_INHIBIT(&gs_t0pb.t0_sb.sb_flags);
	long		l = 0;

	do {
	    	DELAY(1000);
	    	if (l++ > timeout) {
			return (-1);
	    	}
	} while (!(*flags & CIPR_SB_FL_CC));
	return(0);
}

gs_cipr_vers()
{
	printf("        CIPRICO SCSI: FW %d (%d/%d/%d): ENG %d",
		gs_cipr_vers_sb.sb_rsvd,
		gs_cipr_vers_sb.sb_info[2],
		gs_cipr_vers_sb.sb_info[1],
		gs_cipr_vers_sb.sb_info[3],
		gs_cipr_vers_sb.sb_scsi_status);
}
