/*
 * VMEBUS: Integrated Solutions SCSI driver subroutines
 */
#include "gs.h"

#if NGS > 0 || Ngs > 0
#undef	NGS
#undef	Ngs
#define NGS		4	/* max number of gp-scsi controllers per cpu */
#define ASCII_SNS_7_KEY
#define ASCII_PDTYPE

/* #define INTERPHASE	/**/
#define	CIPRICO

#define DEBUG		0	/* use 0-3 */
#ifdef	DEBUG
int		gsdebug = DEBUG;
int		gsdebugcont = 0;
int		gsdebugtarg = 2;
#endif	DEBUG

#include "../machine/pte.h"
#include "../machine/board.h"
#include "../machine/psl.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#ifdef  VQX
#include "../is68kdev/openchip.h"
#endif  VQX
#include "../is68kdev/qbvar.h"
#include "../is68kdev/scsi.h"
#include "../is68kdev/gsreg.h"
#include "../is68kdev/gsvar.h"

/*        _________________________________
 * ctlr:  | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *        ---------------------------------
 *                 \_cont____/ \___targ__/
 */
#define	GS_CTLR(cont, targ)	(((cont) << 3) | (targ))
/* see /sys/conf/devaddr.c */ 
extern u_short *GSstd[];

int		GSaddr[NGS];
int		gs_iosize[NGS];
u_short		gsident[NGS];
int		(*gs_vers[NGS])();
int		(*gs_cmdwait[NGS])(), (*gs_run[NGS])(), (*gs_intr[NGS])();
struct qb_ctlr	*gscinfo[NGS];
struct gs_hacb	gs_hacb[NGS];
struct gs_queue	*gsqh[NGS * Ngs_targ_cont];
u_char		gsrunning[NGS];
int		gswstart, gswatch();	/* watchdog guardian */
u_char		gswticks[3][NGS][Ngs_targ_cont];
#define GS_WTIME  hz*5

#ifdef	M68020
#define	GS_CPUMEMW	((*BSR) & BSR_MEMWIDTH)
#ifdef	M68025
#define	GS_ADDRMOD	(ADRM_EXT_N_D)
#else	M68025
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68025
#else	M68020
#define	GS_CPUMEMW	(BSR_16BITMEM)
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68020

#ifdef	M68030
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68030


/* Check that controller exists */
gsprobe(gsaddr, cont)
	register u_int	gsaddr;
{
	int	*ap;

	if (GSaddr[cont]) {		/* already assigned and inited */
		cvec = 0;		/* vector already caught */
		goto ret;
	}
	if (gsaddr == -1)
		/* wait for unassigned slot */
		return (0);

	if ((gsaddr == (u_int)&vme_stdio[0xFFFFC0])
	    || (gsaddr == (u_int)&vme_stdio[0xFFFFD0])
	    || (gsaddr == (u_int)&vme_stdio[0xFFFFE0])
	    || (gsaddr == (u_int)&vme_stdio[0xFFFFF0])) {
		if (gs_scsiu_init(gsaddr, cont))
			return (0);
		gs_iosize[cont] = 0x10;
	}
#ifdef CIPRICO
	 else if ((gsaddr == (u_int)&vme_short[0x2000])
	          || (gsaddr == (u_int)&vme_short[0x2200])
	          || (gsaddr == (u_int)&vme_short[0x2400])
	          || (gsaddr == (u_int)&vme_short[0x2600])) {
		if (gs_cipr_init(gsaddr, cont))
			return (0);
		gs_iosize[cont] = 0x200;
	}
#endif CIPRICO
#ifdef INTERPHASE
	 else if ((gsaddr == (u_int)&vme_short[0x3000])
	          || (gsaddr == (u_int)&vme_short[0x3800])
	          || (gsaddr == (u_int)&vme_short[0x4000])
	          || (gsaddr == (u_int)&vme_short[0x4800])) {
		if (gs_inter_init(gsaddr, cont))
			return (0);
		gs_iosize[cont] = 0x800;
	}
#endif INTERPHASE
#ifdef  VQX
         else if (gsaddr == (u_int)&(OPENCHIP->op_scsistatus)) {
                if (gs_vqx_init(gsaddr, cont))
                        return (0);
                gs_iosize[cont] = 1;
        }
#endif  VQX
	else
		return(0);

	/* need to save the real addr, mark slot assigned */
	GSaddr[cont] = gsaddr;
	for (ap = (int *)GSstd; *ap; ap++)
		if (*ap == gsaddr)
			*ap = -1;

#ifdef  NOTDEF
        /* actually, we never use GSaddr for this controller    */
        /* gsaddr for the vqx is chosen to be unique to the scsi but harmless,
         * but therefore the controller does not find it useful
         * If we gave them OPENCHIP they might end up setting op_scratch.
         */
        if (gsaddr == (u_int)&(OPENCHIP->op_scsistatus)) {
                GSaddr[cont] = (int)OPENCHIP;
        }
#endif  NOTDEF

	if (gswstart == 0) {		/* start watchdog timer */
		timeout(gswatch, (caddr_t)0, GS_WTIME);
		gswstart++;
	}
ret:	clevmax = clev_biomax;
	clev_bio = MAX(clev, clev_bio);
	return (gs_iosize[cont]);
}

/* Handle a disk interrupt. */
gsintr(cont)
{
	(*gs_intr[cont])(cont);
}

gs_intr_common(cont, targ, dcb)
	struct hacb_dcb		*dcb;
{
	struct gs_queue		*qp = gsqh[GS_CTLR(cont, targ)];

	gswticks[0][cont][targ] = 0;
	gswticks[1][cont][targ] = 0;
	gswticks[2][cont][targ] = 0;
#ifdef	DEBUG
	if ((gsdebug > 1) &&
	  (gsdebugcont == cont) && (gsdebugtarg == targ))
	    printf("cont %d targ %d lun %d: cerr %x: scsi_status %b\n",
		cont, targ, dcb->dcb_cdb.cdb_0.cdb_0_lun,
		dcb->dcb_cerr, dcb->dcb_scsi_status, SCSI_STATUS_BITS);
#endif	DEBUG
	/*
	 * Check for and process errors.  If doerr returns non-zero,
	 * then a new command is needed on this target immediately,
	 * and we should not move on to the next driver
	 */
	if ((*qp->gsq_doerr)(cont, targ, dcb)) {
		gsrun(cont, targ);
		return;
	}
	/* if driver not deqd, give another driver a chance */
	if (gsqh[GS_CTLR(cont, targ)] == qp)
		gsqh[GS_CTLR(cont, targ)] = qp->gsq_forw;
	gsstart(cont, targ);
}

/* fill in command and run */
gsstart(cont, targ)
{
	struct hacb_dcb *dcb = &gs_hacb[cont].hacb_dcb[targ];
	struct gs_queue	*qp;
	int rc;

	while (qp = gsqh[GS_CTLR(cont, targ)]) {
                /* (*qp->gsq_getcmd) returns:                           */
                /* 0 if no command to do for this unit                  */
                /* 1 if a direct command loaded into dcb                */
                /* 2 if qbgo was called to get a buf struct to find out */
                /*      what to do (and gdgo was called to start it)    */

                if (rc = (*qp->gsq_getcmd)(cont, targ, dcb)) {
                        if (rc == 1) {  /* command is loaded, start it  */
                                gsrun(cont, targ);
                                return;
                        }
                        if (rc == 2) {  /* command is started by gdgo   */
                                return;
                        }
		} else
			gsqh[GS_CTLR(cont, targ)] = qp->gsq_forw;
	}
}

gsrun(cont, targ)
{
#ifdef	DEBUG
	if (gsdebug && (gsdebugcont == cont) && (gsdebugtarg == targ))
		gsprintdcb(cont, targ);
#endif	DEBUG
	(*gs_run[cont])(cont, targ);
}

/* initialize queue entry */
gsqinit(gsq, getcmd, doerr)
	register struct gs_queue	*gsq;
	int				(*getcmd)(), (*doerr)();
{
	gsq->gsq_forw = (struct gs_queue *)0;
	gsq->gsq_back = (struct gs_queue *)0;
	gsq->gsq_getcmd = getcmd;
	gsq->gsq_doerr = doerr;
}

/* add entry to end of queue */
gsenq(cont, targ, gsq)
	register struct gs_queue	*gsq;
{
	register struct gs_queue	*qp = gsqh[GS_CTLR(cont, targ)];

	if (qp == 0) {
		gsq->gsq_forw = gsq;
		gsq->gsq_back = gsq;
		gsqh[GS_CTLR(cont, targ)] = gsq;
		gsstart(cont, targ);
	} else {
		gsq->gsq_forw = qp;
		gsq->gsq_back = qp->gsq_back;
		qp->gsq_back = gsq;
		gsq->gsq_back->gsq_forw = gsq;
	}
	return (0);
}

/* remove an entry from front of queue */
gsdeq(cont, targ, gsq)
	register struct gs_queue	*gsq;
{
	register struct gs_queue	*qp = gsqh[GS_CTLR(cont, targ)];

	if (gsq->gsq_forw == gsq)	/* q is empty */
		gsqh[GS_CTLR(cont, targ)] = 0;
	else {
		if (qp == gsq)		/* move head up */
			gsqh[GS_CTLR(cont, targ)] = gsq->gsq_forw;
		gsq->gsq_forw->gsq_back = gsq->gsq_back;
		gsq->gsq_back->gsq_forw = gsq->gsq_forw;
	}

	/* zero out pointers indicating driver is done */
	gsq->gsq_back = gsq->gsq_forw = 0;
	return (0);
}

/* wait for polled mode command to complete */
gsfakeint(cont, targ, gsq, timeout)
	struct gs_queue *gsq;
{
	gsenq(cont, targ, gsq);		/* start up target pseudocontroller */
	do {
		if ((*gs_cmdwait[cont])(cont, targ, timeout)) {
			printf("gs%d: controller timed out\n",
				GS_CTLR(cont, targ));
			return (-1);
		}
		gsintr(cont);		/* fake interrupt */
	} while (gsrunning[cont]);
	return (0);
}

/* has a dual function: look for lost interrupts, and for missed commands */
gswatch()
{
	u_char  cont, targ;
	u_short r, c;
	register struct gs_hacb *hacb;

	timeout(gswatch, (caddr_t)0, GS_WTIME);
	for (cont = 0; cont < NGS; cont++) {
	    hacb = (struct gs_hacb *)CACHE_INHIBIT(&gs_hacb[cont]);
	    if ((r = hacb->hacb_dcr) == 0)
		continue;
	    for (targ = 0; targ < Ngs_targ_cont; targ++, r >>= 1) {
		c = r & (DCR_GO | DCR_BUSY);
		switch (c) {
		    case DCR_GO:	/* command not accepted yet */
			if (gswticks[0][cont][targ]++ >= 20) {
				gswticks[0][cont][targ] = 0;
				printf("GS%d: possible missed cmd\n",
				    GS_CTLR(cont, targ));
				((struct gs_scsiu_device *)GSaddr[cont])
				    ->gs_loc = GS_LOC_GO;
				continue;
			}
		    case DCR_BUSY:	/* command done, not cleaned */
			if (gswticks[1][cont][targ]++ >= 20) {
				gswticks[1][cont][targ] = 0;
				printf("GS%d: lost interrupt\n",
				    GS_CTLR(cont, targ));
				gsintr(cont);
				continue;
			}
		    case (DCR_GO|DCR_BUSY): /* command in process */
			if (gswticks[2][cont][targ]++ >= 1000) {
				gswticks[2][cont][targ] = 0;
				printf("GS%d: hung dcr=%x: cmd aborted\n",
				    GS_CTLR(cont,targ), gs_hacb[cont].hacb_dcr);
/*				gscmdabort(cont, targ);/**/
				continue;
			}
		    case 0: /* device not in use */
				;
		}
	    }
	}
}


gsvers(cont)
{
	(*gs_vers[cont])();
}


#ifdef	DEBUG
gsprintdcb(cont, targ)
{
	register u_char *c
	    = (u_char *)CACHE_INHIBIT(&gs_hacb[cont].hacb_dcb[targ]); 
	register int i, s;

	s = spltty();
	printf("\nDCB: cont %d targ %d lun %d:", cont, targ,
	    gs_hacb[cont].hacb_dcb[targ].dcb_cdb.cdb_0.cdb_0_lun);
	for (i = 0 ; i < sizeof(struct hacb_dcb); i++) {
		if ((i % 16) == 0)
			printf("\n  %2d:", i);
		printf(" %2x", *c++);
	}
	if (gsdebug > 2) {
		printf("\nSpace to execute, 'q' to disable: ");
		while ((i = cngetc()) == -1)
			;
		if (i == 'q')
			gsdebug--;
	} else
		printf("\n");
	splx(s);
}
#endif	DEBUG

#ifdef CIPRICO
#include	"../is68kdev/gs_cipr.c"
#endif CIPRICO
#include	"../is68kdev/gs_scsiu.c"
#ifdef INTERPHASE
#include	"../is68kdev/gs_inter.c"
#endif INTERPHASE
#ifdef  VQX
#include        "../is68kdev/gs_vqx.c"
#endif  VQX

#endif
