/*
 * VMEBUS: Integrated Solutions GIP graphics controler, and
 * 	   Integrated Solutions Monochrome WorkStation (MWS) card
 */
#ifndef	ASSEMBLY
struct	gpdevice {
    union {
	struct gip {				/* microcoded GIP */
	    unsigned short	gip_fifo,
				gip_snake,
				gip_shift,
				gip_reset;
#define				gp_fifo		gip_mws.gip.gip_fifo
#define				gp_snake	gip_mws.gip.gip_snake
#define				gp_shift	gip_mws.gip.gip_shift
#define				gp_reset	gip_mws.gip.gip_reset
	} gip;

	struct mws {				/* monochrome work station */
	    unsigned short	mws_csr;
#define				gp_csr		gip_mws.mws.mws_csr
	} mws;
    }	gip_mws;
};
extern struct gpdevice	*gpaddr;	/* pointer to registers */
extern unsigned short	*gpwcs;		/* GIP writable control store */
extern unsigned char	gptype;		/* attributes of graphics subsystem */
#endif	ASSEMBLY
#define		GPEXISTS_B	0	/* 	we have a graphics subsystem */
#define		GPEXISTS	(1<<GPEXISTS_B)
#define		GPHASGIP_B	1	/* 	GIP subsystem */
#define		GPHASGIP	(1<<GPHASGIP_B)
#define		GPCOLOR_B	2	/* 	COLOR subsystem */
#define		GPCOLOR		(1<<GPCOLOR_B)
#define		GPCANINT_B	3	/* 	supports interrupting GIP */
#define		GPCANINT	(1<<GPCANINT_B)
#define		GPUSEINT_B	4	/* 	use interrupting GIP */
#define		GPUSEINT	(1<<GPUSEINT_B)
#define		GPEXCLUSIVE_B	5	/* 	GIP is exclusively owned */
#define		GPEXCLUSIVE	(1<<GPEXCLUSIVE_B)

/* ------------------------- DEFINES FOR GIP ----------------------------- */
/* offsets from gpaddr to registers */
#	define GPFIFO	 	0
#	define GPSNAKE		2
#	define GPSHIFT		4
#	define GPRESET		6

/* offset from display memory to writable control store */
#	define GPWCS		0x1000

#define GPFIFOMAX	64		/* depth of fifo */
#define GPLUTSIZE	16		/* size of color lookup table */
#define GPFIFOEMPTY	7		/* fifo read busy bit */
#define GPILEVEL	3		/* interrupt level */

/* GIP micro code general/specific enables: comment to disable */
#define UCODE /**/
#ifdef UCODE
#	define UCODE_ALU	/**/
#	define UCODE_PITCH	/**/
#	define UCODE_BOX	/**/
#	define UCODE_BOXC	/**/
/*#	define UCODE_BOXP	/**/
#	define UCODE_PAINT	/**/
#	define UCODE_VECT	/**/
#	define UCODE_CLIP	/**/
#endif UCODE

/* GIP micro-code opcode definitions */
#define GP_ALUC		0x8001          /* alu_clear */
#define GP_ALUS		0x8002          /* alu_set */
#define GP_ALUT		0x8003          /* alu_toggle */
#define GP_BOX		0x8004          /* box */
#define GP_BOXC		0x8005          /* box_copy */
#define GP_BOXP		0x8006          /* box_pattern */
#define GP_CLIP		0x8007          /* clip */
#define GP_CLIPON	0x8008          /* clip_on */
#define GP_CLIPOF	0x8009          /* clip_off */
#define GP_INIT		0x800A          /* init */
#define GP_INTON	0x800B          /* interrupt_on */
#define GP_INTOF	0x800C          /* interrupt_off */
#define GP_PAINT	0x800D          /* paint */
#define GP_PGSEL	0x800E          /* page_select */
#define GP_PGSF		0x800F          /* page_select_fill */
#define GP_SPTCH	0x8010          /* source_pitch */
#define GP_DPTCH	0x8011          /* destination_pitch */
#define GP_TEXT		0x8012          /* text */
#define GP_VECT		0x8013          /* vector */
#define GP_SLUT		0x8020		/* COLOR set_lookup */
#define GP_SCOLOR	0x8021		/* COLOR set_color */

/* ------------------------- DEFINES FOR MWS ----------------------------- */
#define	GPCSR_256_OFF		0x3FFC0
#define	GPCSR_512_OFF		0x7FFC0
#define	GPCSR_W_IVMASK		0x00FF
#define	GPCSR_W_RETINT		0x0100
#define	GPCSR_W_BLANK		0x0200
#define	GPCSR_W_PLANE		0x0400
#define	GPCSR_R_W39		0x0001
#define	GPCSR_R_W40		0x0002
#define	GPCSR_R_W38		0x0004
#define	GPCSR_R_W18		0x0008
#define	GPCSR_R_MASK		0x000F
#define	GPCSR_R_1280x1024	(GPCSR_R_W18|GPCSR_R_W38|GPCSR_R_W40)
#define	GPCSR_R_1024x1440	(GPCSR_R_W18|GPCSR_R_W38|GPCSR_R_W39)
#define	GPCSR_R_1024x1024	(GPCSR_R_W18|GPCSR_R_W38)

/* ------------------------- MISC DEFINES -------------------------------- */

					/* BOGUS: */
#define BXMAX           1280 		/* all refrences should be patched */
#define BYMAX           1024		/* by windows/general.c InitializeVT */

/* time out values */
#define	GP_FIFOBSYWAIT	50			/* ~ 100 usec */
#define	GP_FIFOTIMEO	100			/* ~ 1.6 sec */
#define	GP_TIMEO	100			/* ~ 1.6 sec */

/* sleep priorities */
#define	GP_FIFOPRI	/*PZERO*/25-9		/* KLUDGE: fifo sleep */
#define	GP_FLUSHVTPRI	PZERO-1			/* gpdaemon sleep priority */
#define	GP_WANTPRI	PZERO+1			/* user sleep priority */

/* who has access to GIP display memory */
#define	GP_CPUDISP	0			/* cpu last access */
#define	GP_GIPDISP	1			/* gip last access */
