/*
 * VMEBUS: Integrated Solutions GIP graphics controler, and
 * 	   Integrated Solutions Monochrome WorkStation (MWS) card
 */
#ifndef	ASSEMBLY
struct	fbdevice {
    union {
	struct gip {				/* microcoded GIP */
	    unsigned short	gip_fifo,
				gip_snake,
				gip_shift,
				gip_reset;
#define				fb_fifo		gip_mws.gip.gip_fifo
#define				fb_snake	gip_mws.gip.gip_snake
#define				fb_shift	gip_mws.gip.gip_shift
#define				fb_reset	gip_mws.gip.gip_reset
	} gip;

	struct mws {				/* monochrome work station */
	    unsigned short	mws_csr;
#define				fb_csr		gip_mws.mws.mws_csr
	} mws;
    }	gip_mws;
};
extern struct fbdevice	*gpaddr;	/* pointer to registers */
unsigned short	*fbwcs;		/* GIP writable control store */
extern unsigned char	fbtype;		/* attributes of graphics subsystem */
#endif	ASSEMBLY
#define		FBEXISTS_B	0	/* 	we have a graphics subsystem */
#define		FBEXISTS	(1<<FBEXISTS_B)
#define		FBHASGIP_B	1	/* 	GIP subsystem */
#define		FBHASGIP	(1<<FBHASGIP_B)
#define		FBCOLOR_B	2	/* 	COLOR subsystem */
#define		FBCOLOR		(1<<FBCOLOR_B)
#define		FBCANINT_B	3	/* 	supports interrupting GIP */
#define		FBCANINT	(1<<FBCANINT_B)
#define		FBUSEINT_B	4	/* 	use interrupting GIP */
#define		FBUSEINT	(1<<FBUSEINT_B)
#define		FBEXCLUSIVE_B	5	/* 	GIP is exclusively owned */
#define		FBEXCLUSIVE	(1<<FBEXCLUSIVE_B)

#define FB_SIZE (160*1024)
#define FBSIZE ((FB_SIZE + (NBPG-1)) & ~(NBPG-1))

/* ------------------------- DEFINES FOR GIP ----------------------------- */
/* offsets from gpaddr to registers */
#	define FBFIFO	 	0
#	define FBSNAKE		2
#	define FBSHIFT		4
#	define FBRESET		6

/* offset from display memory to writable control store */
#	define FBWCS		0x1000

#define FBFIFOMAX	64		/* depth of fifo */
#define FBLUTSIZE	16		/* size of color lookup table */
#define FBFIFOEMPTY	7		/* fifo read busy bit */
#define FBILEVEL	3		/* interrupt level */

/* GIP micro code general/specific enables: comment to disable */
#define UCODE /**/
#ifdef UCODE
#	define UCODE_ALU	/**/
#	define UCODE_PITCH	/**/
#	define UCODE_BOX	/**/
#	define UCODE_BOXC	/**/
/*#	define UCODE_BOXP	/**/
#	define UCODE_PAINT	/**/
#	define UCODE_VECT	/**/
#	define UCODE_CLIP	/**/
#endif UCODE

/* GIP micro-code opcode definitions */
#define FB_ALUC		0x8001          /* alu_clear */
#define FB_ALUS		0x8002          /* alu_set */
#define FB_ALUT		0x8003          /* alu_toggle */
#define FB_BOX		0x8004          /* box */
#define FB_BOXC		0x8005          /* box_copy */
#define FB_BOXP		0x8006          /* box_pattern */
#define FB_CLIP		0x8007          /* clip */
#define FB_CLIPON	0x8008          /* clip_on */
#define FB_CLIPOF	0x8009          /* clip_off */
#define FB_INIT		0x800A          /* init */
#define FB_INTON	0x800B          /* interrupt_on */
#define FB_INTOF	0x800C          /* interrupt_off */
#define FB_PAINT	0x800D          /* paint */
#define FB_PGSEL	0x800E          /* page_select */
#define FB_PGSF		0x800F          /* page_select_fill */
#define FB_SPTCH	0x8010          /* source_pitch */
#define FB_DPTCH	0x8011          /* destination_pitch */
#define FB_TEXT		0x8012          /* text */
#define FB_VECT		0x8013          /* vector */
#define FB_SLUT		0x8020		/* COLOR set_lookup */
#define FB_SCOLOR	0x8021		/* COLOR set_color */

/* ------------------------- DEFINES FOR MWS ----------------------------- */
#define	FBCSR_256_OFF		0x3FFC0
#define	FBCSR_512_OFF		0x7FFC0
#define	FBCSR_W_IVMASK		0x00FF
#define	FBCSR_W_RETINT		0x0100
#define	FBCSR_W_BLANK		0x0200
#define	FBCSR_W_PLANE		0x0400
#define	FBCSR_R_W39		0x0001
#define	FBCSR_R_W40		0x0002
#define	FBCSR_R_W38		0x0004
#define	FBCSR_R_W18		0x0008
#define	FBCSR_R_MASK		0x000F
#define	FBCSR_R_1280x1024	(FBCSR_R_W18|FBCSR_R_W38|FBCSR_R_W40)
#define	FBCSR_R_1024x1440	(FBCSR_R_W18|FBCSR_R_W38|FBCSR_R_W39)

/* ------------------------- MISC DEFINES -------------------------------- */

					/* BOGUS: */
#define BXMAX           1280 		/* all refrences should be patched */
#define BYMAX           1024		/* by windows/general.c InitializeVT */

/* time out values */
#define	FB_FIFOBSYWAIT	50			/* ~ 100 usec */
#define	FB_FIFOTIMEO	100			/* ~ 1.6 sec */
#define	FB_TIMEO	100			/* ~ 1.6 sec */

/* sleep priorities */
#define	FB_FIFOPRI	/*PZERO*/25-9		/* KLUDGE: fifo sleep */
#define	FB_FLUSHVTPRI	PZERO-1			/* fbdaemon sleep priority */
#define	FB_WANTPRI	PZERO+1			/* user sleep priority */

/* who has access to GIP display memory */
#define	FB_CPUDISP	0			/* cpu last access */
#define	FB_GIPDISP	1			/* gip last access */

#ifndef VTSIZE
#define VTSIZE ((1024*24)+(17*4096))
#endif VTSIZE
