/* QXSSE Header file - cut down mmi.h for console driver */
/* SCCS identification "@(#) console.h 1.1@(#)" */

#define M_ZEROS        0		/* BitBlT combination modes */
#define M_SANDD	       1
#define M_SANDND       2
#define M_COPY         3
#define M_NSANDD       4
#define M_DST          5
#define M_XOR          6
#define M_OR           7
#define M_NSANDND      8
#define M_NSXORD       9
#define M_NDST        10
#define M_SORND       11
#define M_NOT         12
#define M_NSORD       13
#define M_NSORND      14
#define M_ONES        15

#define FNAMESIZE   12

#define PHEIGHT      1 			/* Pen size */
#define PWIDTH       2

#ifndef	word
#define	word	unsigned short
#define	byte	unsigned char
#endif	!word

#define Dword		unsigned long
#define addrptr		word *

/*                                                                *************
                                                                  *           *
                                                                  *   POINT   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Complex types, point                                                        |
-------------------------------------------------------------------------------
*/

typedef struct       /* co-ordinate point */
{
   short x, y;
}
point;

/*                                                                *************
                                                                  *           *
                                                                  * PATTERN   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Halftone                                                                    |
-------------------------------------------------------------------------------
*/

typedef word pattern[16];

/*                                                                *************
                                                                  *           *
                                                                  *  CTRANS   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Foreground & Background colours                                             |
-------------------------------------------------------------------------------
*/

typedef struct      /* ctrans */
{
   byte   foreground, background;
}
ctrans;

/*                                                                *************
                                                                  *           *
                                                                  *   SIZE    *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
|                                                                             |
-------------------------------------------------------------------------------
*/

typedef struct
{
   short width, height;
}
rectsize;

/*                                                                *************
                                                                  *           *
                                                                  * RECTANGLE *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
|                                                                             |
-------------------------------------------------------------------------------
*/

typedef struct       /* rectangle */
{
   short x, y, width, height;       /* Top left origin and size in pixels */
}
rectangle;

/*                                                                *************
                                                                  *           *
                                                                  *   FORM    *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Bitmap description.                                                         |
-------------------------------------------------------------------------------
*/

typedef struct Ffudge      /* bitmap */
{
   addrptr     *bits;               /* Pointer to bitmap (form.bits) */
   short       x, y;                /* This is really a rectangle!   */
   short       width, height;       /* Pixel width and height        */
   short       rowwords;            /* Word width of one plane       */
   short       format;              /* Internal representation type  */
   short       planes;              /* No. of colour planes          */
   int	       *formlist;	    /* MUST BE NULL */
}
form;

/*                                                                *************
                                                                  *           *
                                                                  *CopyStruct *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
|                                                                             |
-------------------------------------------------------------------------------
*/

typedef struct
{
   form        *sourceform;
   form        *destform;
   addrptr     htoneform;
   rectangle   *srcrect;
   rectangle   *destrect;
   rectangle   *cliprect;
   byte        mode;
   byte        rubbish;
   ctrans      *cindex;
}
CopyStruct;

/*                                                                *************
                                                                  *           *
                                                                  *   FONT    *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
|                                                                             |
-------------------------------------------------------------------------------
*/

typedef struct       /* font */
{
   word         fonttype;          /* Fixed, proportional etc. */
   short        firstchar;         /* Ascii code of first char */
   short        lastchar;          /* Ascii code of last  char */
   short        ascent;            /* Extent above base line   */
   short        descent;           /* Extent below base line   */
   short        maxwidth;          /* Maximum character width  */
   short        leading;           /* Distance to next line    */
   form         glyphs;            /* Form structure           */
   addrptr      *strike;           /* Handle to position in glyphs     */
   addrptr      *ow;               /* Offset/width table (-1 = no char) */
}
font;

   /* font types */

#define FIXED       00
#define PROP        01

   /* Output codes */

#define HIDEC       04
#define SHOWC       05
#define BELL        07
#define CURLEFT     08
#define CURRIGHT    0x1d
#define CURDOWN     0x1f
#define CURUP       11
#define CLRSCR      12
#define CR          13
#define LF          10
#define TOGINV      18      /* Toggle inverse mode   */
#define HOMEC       30
#define BCKSPACE   127

/* escape sequences */

#define CM          ' '      /* Cursor movement escape sequence */

/* Keyboard defines */

#define CTRLK        0x100 		/* key modification masks */
#define ACTK         0x200
#define DK           0x200
#define SHFTK        0x400
#define CAPSDOWN     0x800
#define CAPSUP       0xf7ff
#define CAPSLK       0x800

   /* 16 bit keyboard code masks */

#define FNMASK       0x4000

   /* Some constants */

#define F1           FNMASK
#define F2           (FNMASK | 1)
#define F3           (FNMASK | 2)
#define F4           (FNMASK | 3)
#define F5           (FNMASK | 4)
#define F6           (FNMASK | 5)
#define F7           (FNMASK | 6)
#define F8           (FNMASK | 7)
#define F9           (FNMASK | 8)
#define F10          (FNMASK | 9)
#define HELPK        (FNMASK | 10)


#define ESCSEQ       0x1000 		/* Some more constants */
#define PTRUK        0x100b   /* Top half will be ignored on output */
#define PTRDK        0x101f
#define PTRLK        0x1008
#define PTRRK        0x101d

#define DELK         0x7f
#define TABK         9
#define CULK         8
#define CURK         29
#define CUDK         31
#define CUPK         11
#define CRK          13
#define NULLK        0

/* Mouse defines */

#define MMASK      0x3000      /* the mouse bits in kstat */
#define MLMASK     0x1000      /* the left mouse bit      */
#define MRMASK     0x2000      /* the right mouse bit     */

#define DEFPLANES	2	/* Default # bit planes for QXROM */
