/*
 * code to initialise the clock on a Torch QX.
 */
static char SCCSid[] = {"@(#) clockio.c 1.1@(#)"};

#include "../h/types.h"
#include "../machine/pte.h"
#include "param.h"
#include "conf.h"
#include "user.h"
#include "proc.h"
#include "ioctl.h"
#include "tty.h"
#include "map.h"
#include "buf.h"
#include "vm.h"

#include "../machine/board.h"
#include "../is68kdev/qbvar.h"
#include "../is68kdev/cpreg.h"

#include "bk.h"
#include "clist.h"
#include "file.h"
#include "uio.h"
/* all of the above include in hope of satisfying kernel.h's appetite	*/
#include "kernel.h"
#include "../is68kdev/openchip.h"

clkinit() {
	register struct openchip *optr = OPENCHIP;

	optr->op_clkpreset = (32 * optr->op_sysclk)/(hz * optr->op_sysperiod);
	optr->op_clkstat = OP_CLK_INEA;
}
