/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)vmparam.h	6.7 (Berkeley) 10/23/85
 */

/*
 * Machine dependent constants for IS68K
 */
/*
 * USRTEXT is the start of the user text/data space, while USRSTACK
 * is the top (end) of the user stack.  LOWPAGES and HIGHPAGES are
 * the number of pages from the beginning of the P0 region to the
 * beginning of the text and from the beginning of the P1 region to the
 * beginning of the stack respectively.
 *
 * On the IS68K, the P0 & P1 regions overlap.
 * On the IS68K 68010 boards, the uarea is NOT at the top of the user stack
 */
#define	USRTEXT		0

#if defined(M68030) || defined(VQX)
#define	P0PAGES		(0x40000000 / NBPG)	/* pages in P0 region */
#define	HIGHPAGES	UPAGES
#else   M68030 || VQX
#if defined(M68020) && !defined(VQX)
#define	P0PAGES		(0x10000000 / NBPG)	/* pages in P0 region */
#define	HIGHPAGES	UPAGES
#else   M68020 && !VQX
#ifdef	QBUS
#define	P0PAGES		(0x400000 / NBPG)	/* pages in P0 region */
#else	QBUS
#define	P0PAGES		(0x800000 / NBPG)	/* pages in P0 region */
#endif	QBUS
#define	HIGHPAGES	0
#endif  M68020 && !VQX
#endif  M68030 || VQX
#define	BTOPUSRSTACK	(P0PAGES - HIGHPAGES)	/* btop(USRSTACK) */
#define	USRSTACK	(BTOPUSRSTACK * NBPG) /* Start of user stack */
#define	LOWPAGES	0
#define	P1PAGES		P0PAGES		/* number of pages in P1 region */

/*
 * Virtual memory related constants, all in bytes
 */
#define	SLOP		8
#ifndef	MAXTSIZ
#define	MAXTSIZ		((P0PAGES-SLOP)*NBPG)	/* max text size */
#endif	MAXTSIZ

#ifndef MAXDSIZ
#define	MAXDSIZ		((P0PAGES-8-SLOP)*NBPG)	/* max data size */
#endif	MAXDSIZ

#ifndef	MAXSSIZ
#define	MAXSSIZ		MAXDSIZ			/* max stack size */
#endif	MAXSSIZ

#ifndef DFLDSIZ
#define	DFLDSIZ		MAXDSIZ  		/* initial data size limit */
/* WAS (6 * 1024 * 1024) in original VAX code: MCR 2/19/88 */
#endif	DFLDSIZ

#ifndef	DFLSSIZ
#define	DFLSSIZ		(512*1024)		/* initial stack size limit */
#endif	DFLSSIZ

/*
 * Default sizes of swap allocation chunks (see dmap.h).
 * The actual values may be changed in vminit() based on MAXDSIZ.
 * With MAXDSIZ of 16Mb and NDMAP of 38, dmmax will be 1024.
 * ISI: DMMIN=8, DMMAX=1024 NDMAP==128 immage can be 60.5Meg.
 */
#define	DMMIN	(NBPG/512)		/* smallest swap allocation */
#define	DMMAX	1024			/* largest potential swap allocation */
#define	DMTEXT	DMMAX			/* swap allocation for text */

/*
 * Sizes of the system and user portions of the system page table.
#define	SYSPTSIZE	((20+MAXUSERS)*NPTEPG)	VAX 4.3
#define	USRPTSIZE 	(32*NPTEPG)		VAX 4.3
 */
#if defined(M68030) || defined(VQX)
			/* SYSPTSIZE*NBPG must be multiple of 16 meg */
			/* so that the system can use tt0 to map itself */
                        /* This isn't true for the VQX but is the same for */
                        /* simplicity. */
#define	SYSPTSIZE	((1<<24)/NBPG)
#define	USRPTSIZE 	0x400
#else M68030 || VQX
#if defined(M68020) && !defined(VQX)
#define	SYSPTSIZE	0x800
#define	USRPTSIZE 	0x400
#else	M68020 && !VQX
#ifdef	QBUS
#define	SYSPTSIZE	0x200
#define	USRPTSIZE	0x40
#else	QBUS
#define	SYSPTSIZE	0x200
#define	USRPTSIZE	0x80
#endif	QBUS
#endif	M68020 && !VQX
#endif	M68030 || VQX

/*
 * The size of the clock loop.
 */
#define	LOOPPAGES	(maxfree - firstfree)

/*
 * The time for a process to be blocked before being very swappable.
 * This is a number of seconds which the system takes as being a non-trivial
 * amount of real time.  You probably shouldn't change this;
 * it is used in subtle ways (fractions and multiples of it are, that is, like
 * half of a ``long time'', almost a long time, etc.)
 * It is related to human patience and other factors which don't really
 * change over time.
 */
#define	MAXSLP 		20

/*
 * A swapped in process is given a small amount of core without being bothered
 * by the page replacement algorithm.  Basically this says that if you are
 * swapped in you deserve some resources.  We protect the last SAFERSS
 * pages against paging and will just swap you out rather than paging you.
 * Note that each process has at least UPAGES+CLSIZE pages which are not
 * paged anyways (this is currently 8+2=10 pages or 5k bytes), so this
 * number just means a swapped in process is given around 25k bytes.
 * Just for fun: current memory prices are 4600$ a megabyte on VAX (4/22/81),
 * so we loan each swapped in process memory worth 100$, or just admit
 * that we don't consider it worthwhile and swap it out to disk which costs
 * $30/mb or about $0.75.
 */
#define	SAFERSS		(20*1024)/NBPG	/* nominal ``small'' resident set size
					   protected against replacement */

/*
 * DISKRPM is used to estimate the number of paging i/o operations
 * which one can expect from a single disk controller.
 */
#define	DISKRPM		60

/*
 * Klustering constants.  Klustering is the gathering
 * of pages together for pagein/pageout, while clustering
 * is the treatment of hardware page size as though it were
 * larger than it really is.
 *
 * KLMAX gives maximum cluster size in CLSIZE page (cluster-page)
 * units.  Note that KLMAX*CLSIZE must be <= DMMIN in dmap.h.
 */

#define	KLMAX	(1/CLSIZE)
#define	KLSEQL	(1/CLSIZE)		/* in klust if vadvise(VA_SEQL) */
#define	KLIN	(1/CLSIZE)		/* default data/stack in klust */
#define	KLTXT	(1/CLSIZE)		/* default text in klust */
#define	KLOUT	(1/CLSIZE)

/*
 * KLSDIST is the advance or retard of the fifo reclaim for sequential
 * processes data space.
 */
#define	KLSDIST	3		/* klusters advance/retard for seq. fifo */

/*
 * Paging thresholds (see vm_sched.c).
 * Strategy of 1/19/85:
 *	lotsfree is 512k bytes, but at most 1/4 of memory
 *	desfree is 200k bytes, but at most 1/8 of memory
 *	minfree is 64k bytes, but at most 1/2 of desfree
 */
#define	LOTSFREE	(512 * 1024)
#define	LOTSFREEFRACT	4
#define	DESFREE		(200 * 1024)
#define	DESFREEFRACT	8
#define	MINFREE		(64 * 1024)
#define	MINFREEFRACT	2

/*
 * Paged text files that are less than PGTHRESH bytes may be swapped
 * in instead of paged in.
 */
#define PGTHRESH        (64 * 1024)

/*
 * There are two clock hands, initially separated by HANDSPREAD bytes
 * (but at most all of user memory).  The amount of time to reclaim
 * a page once the pageout process examines it increases with this
 * distance and decreases as the scan rate rises.
 */
#define	HANDSPREAD	(2 * 1024 * 1024)

/*
 * The number of times per second to recompute the desired paging rate
 * and poke the pagedaemon.
 */
#define	RATETOSCHEDPAGING	4

/*
 * Believed threshold (in megabytes) for which interleaved
 * swapping area is desirable.
 */
#define	LOTSOFMEM	2
