/*
 * Unique portion of vm_machdep.c for VQX board
 */

struct tdlong pta_pad[4*((1<<30)/PPTASPACE) + 2]; 
					/* 2 is for quad alignment */
struct pte zpte = {0, 0, 0, 0, 0, 0, 0, 0, 0 };
struct tdlong *pta, *ptap0, *ptap1;
struct tdlong ztdlong = {0, 0, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0};
struct rpd rpd = {0, 4*((1<<30)/PPTASPACE), 1, DTLONG, 0};
struct tcr tcr = {1, 0, 0, PS4K, 0, TIA, TIB, 0, 0};

extern struct pte Umap[];
extern struct pte CMAP1;
extern char CADDR1;
struct pte zpte;
struct pte *bptopte();

startinit()
{
	register u_long	addr, i, j, k;
	register struct pte pte, *p1, *p2;
	register struct tdlong *td;
	int (*vec[])();
	extern char Syssize, end, etext;

	/*
	 * Initialize Sysmap for kernel text and data
	 */
	p1 = Sysmap;
	while (p1 < eSysmap)
		*p1++ = zpte;
	
	p1 = Sysmap;
	/*
	 * In the VQX system physical memory starts at 64Mb
	 */
	j = (SVTOP((u_long)&end + NBPG - 1)) / NBPG;
	k = (SVTOP((u_long)&etext + NBPG - 1)) / NBPG - 1;
	for (i = btop(PHYSMEMBASE) ; i < j ; i++, p1++) {
		*p1 = zpte;		/* structure assignment to zero pte */
		p1->pg_v = 1;
		p1->pg_pfnum = i; 
		if (i < k && i > btop(SVTOP(eSysmap + NBPG - 1)))
			p1->pg_prot = 1; 
	}

	/* 
 	 * quadword align pta.
	 */
	pta = (struct tdlong *)(((u_long)pta_pad + 15) & ~15);

	rpd.rp_addr = svtop(pta);

	/* 
	 * Initialize user virtual portion of pta.
	 */
	i = MAXU_ADDR / PPTASPACE;
	td = pta;
	while (i--)
		*td++ = ztdlong;
	ptap0 = pta;
	ptap1 = &pta[MAXU_ADDR / PPTASPACE];

	/* 
	 * Initialize kernel virtual portion of pta.
	 */
	addr = svtop(Sysmap);
	i = (int)&Syssize;
	td = &pta[SYSV_BASE / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_dt = DTSHORT;
		td->td_addr = addr;
		td->td_ral = 7;
		td->td_wal = 7;
		td->td_sg = 1;
		td->td_s = 1;
		td->td_limit = (i < NPTEPG) ? i : NPTEPG;
		i -= td->td_limit;
		addr += td->td_limit * 4;
		td++;
	}

	/*
 	 * Initialize kernel V EQ R portion of the pta.
	 * Note that memory doesn't start at zero
	 */
	addr = 0;
	i = btop(MAXPHYSMEM + PHYSMEMBASE);
	td = &pta[VEQR_ADDR / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_dt = DTPAGE;
		td->td_addr = addr;
		td->td_ral = 7;
		td->td_wal = 7;
		td->td_sg = 1;
		td->td_s = 1;
		td->td_limit = btop(PPTASPACE);
		i -= td->td_limit;
		addr += PPTASPACE;
		td++;
	}

	/*
	 * Initialize openchip register space,  The virtual address space
	 * OBIO_BASE to OBIO_BASE+OBIO_SIZE is mapped to physical 0.
	 * This makes the EPROM, reserved address, and open chip registers
	 * accessable.
	 */
	addr = 0;
	td = &pta[OBIO_BASE/PPTASPACE];
	i = OBIO_SIZE;
	while (i > 0){
		*td = ztdlong;
		td->td_dt = DTPAGE;
		td->td_addr = addr;
		td->td_ral = 7;
		td->td_wal = 7;
		td->td_sg = 1;
		td->td_s = 1;
		td->td_lu = 1;		/* lower limit of 0	*/
		td->td_limit = 0;
		addr += PPTASPACE;
		i -= PPTASPACE;	
		td++;
	}


	/*
	 * Initialize VME portion of the pta for short, standard, and 
	 * extended VME memory space.  VME space is set (arbitrarily)
	 * starting at 0x80000000(2Gb), virtual.  The hardware supports
	 * more than 2Gb of VME space but we won't use it all.  The
	 * hardware supports 4Mb of short (A16) memory space, and 16Mb 
	 * standard (A24) memory space.  Since the three memory spaces
	 * abut and there is no advantage to have some weird mapping, we
	 * will map them linearly, using early termination page table
	 * descriptors.  We will then select the correct VME type by
	 * selecting the correct virtual base address. 
	 */
        addr = VME_BASE;
	td = &pta[VME_BASE / PPTASPACE];
	i = VME_LEN;

	while (i > 0){
		*td = ztdlong;
		td->td_dt = DTPAGE;
		td->td_addr = addr;
		td->td_ral = 7;
		td->td_wal = 7;
		td->td_sg = 1;
		td->td_s = 1;
		td->td_lu = 1;		/* lower limit of 0	*/
		td->td_limit = 0;
		addr += PPTASPACE;
		i -= PPTASPACE;
		td++;
	}

	/*
	 * initialize root pointer
	 */
	rpd.rp_addr = svtop(pta);
	loadmmu(MMUCRP, &rpd);

#ifdef notdef
	/*
	 * Initialize translation control register
	 */
	loadmmu(MMUTC, &tcr);

	printf("root pointer set\n");
	printf("physmem %x, maxmem %x, freemem %x\n", physmem, maxmem, freemem);


        addr = VME_BASE;
	td = &pta[VME_BASE / PPTASPACE];
	i = VME_LEN;
	printf("pta: %a\n", pta);
	while (i > 0){
		printf("i:%X, addr:%X, td:%a\n", i, addr, td);
		addr += PPTASPACE;
		i -= PPTASPACE;
		td++;
	}

#endif notdef
	/*
	 * inititalize the Openchip.  This must be done before any
	 * printing.
	 */
	opcpinit();
	
	/*
	 * Allocate and setup page table and _u area for proc[0]. 
	 * First free page is allocated for proc 0 page table.
	 */
	addr = btop(SVTOP((u_long)&end + NBPG - 1));
	pte = zpte;
	pte.pg_pfnum = addr++;
	pte.pg_prot = 0;
	pte.pg_v = 1;
	Usrptmap[0] = pte;

	p1 = &usrpt[NPTEPG - UPAGES];
	p2 = Umap;
	for (i = 0 ; i < UPAGES ; i++) {
		pte.pg_pfnum = addr++;
		*p2++ = pte;
		*p1 = pte;
		p1++->pg_prot = 1;		/* write protect user u */
	}

	/* 
	 * Initialize (slightly) the pcb
	 */
	u.u_pcb.pcb_sp = (u_long)&u + UPAGES * NBPG;
	u.u_pcb.pcb_psl = 0x2700;
	u.u_pcb.pcb_szpt = 1;
	u.u_pcb.pcb_p0br = usrpt;
	u.u_pcb.pcb_p0lr = AST_NONE;
	u.u_pcb.pcb_p1br = initp1br(&usrpt[NPTEPG - UPAGES]);
	u.u_pcb.pcb_p1lr = P1PAGES - UPAGES;
	u.u_stack[0] = U_REDZONE_MAGIC;
	setctx();
	return(addr);
}

newptes(pte, v, size)
register struct pte *pte;
u_int v;
register int size;
{
	register caddr_t a = ptob(v) + SYSV_BASE;

#ifdef notdef
	if (size > 8)
		tbia();
	else {
		while (size-- > 0) {
			tbis(a);
			a += NBPG;
		}
	}
#else notdef
	tbia();
#endif notdef
	cacheclear();
}

svtop(addr) 
register u_long	addr;
{
	register struct pte *pte;
	extern char esysmap;

	if (addr >= SYSV_BASE && addr < (u_long)&esysmap) {
		pte = &Sysmap[btop(addr - SYSV_BASE)];
		if (pte->pg_v)
			return((pte->pg_pfnum << PGSHIFT) | (addr&PGOFSET));
		else
		    printf("invalid pte: %X,&pte: %X ,pfnum: %X, addr: %X\n",
				*pte, pte, pte->pg_pfnum, addr);
	} else {
		/*
		 * This is used ( at least ) when mapping in the GIP 
		 * by libgip into user space.  It is the case in this
		 * system that VME memory of all types is mapped 1-1
		 * between virtual and physical memory in the upper 2Gb.
		 */
		if (addr >= VME_BASE && addr <= VME_BASE + VME_LEN - 1){
			return(addr);
		}
	}
	printf("address out of range: %X\n", addr);
	panic("svtop");
}

ctx_free(p) { }

refbits() { }

setctx()
{
	register i, j;
	register struct pte *pte;
	register struct tdlong *p0, *p1, *tmpp;
	
	i = u.u_pcb.pcb_p0lr & ~AST_CLR;
	pte = &Usrptmap[btokmx(u.u_pcb.pcb_p0br)];
	p0 = &pta[USRTEXT / PPTASPACE];
	while (i > 0) {
		*p0 = ztdlong;
		p0->td_dt = DTSHORT;
		p0->td_limit = (i < NPTEPG) ? i : NPTEPG;
		i -= p0->td_limit;
		p0->td_addr = (u_int)ptob(pte->pg_pfnum);
		p0++;
		pte++;
	}
	tmpp = p0;
	while (ptap0 > p0)
		*p0++ = ztdlong;
	ptap0 = tmpp;

	j = P1PAGES - (u.u_pcb.pcb_p1lr & ~PME_CLR);
	pte = &Usrptmap[btokmx(u.u_pcb.pcb_p0br) + u.u_pcb.pcb_szpt - 1];
	p1 = &pta[MAXU_ADDR / PPTASPACE - 1];
	while (j > 0) {
		*p1 = ztdlong;
		p1->td_dt = DTSHORT;
		p1->td_addr = (u_int)ptob(pte->pg_pfnum);
		if (j < NPTEPG) {
			p1->td_limit = NPTEPG - j;
			p1->td_lu = 1;
			j = 0;
		} else {
			p1->td_limit = NPTEPG;
			j -= p1->td_limit;
		}
		p1--;
	}
	tmpp = p1;
	while (ptap1 < p1)
		*p1-- = ztdlong;
	ptap1 = tmpp;
	tbia();
}

cache_inhibit() {}

flush_cache_entry() {}

bpcopyin(k, bp)
	register char *k;
	register struct buf *bp;
{
	register struct pte *pte;
	register unsigned paddr, o;
	register int bcount, count;

	bcount = bp->b_bcount;
	pte = bptopte(bp);
	o = (int)bp->b_un.b_addr & (NBPG - 1); 
	pte_flush_cache(pte, bp->b_un.b_addr, bcount);
	while (bcount) {
		paddr = (pte->pg_pfnum << PGSHIFT) | o;
		count = MIN(bcount, (NBPG - o));
		bcopy(paddr + VEQR_ADDR, k, count);
		bcount -= count;
		k += count;
		pte++;
		o = 0;
	}
}

bpcopyout(k, bp)
	register char *k;
	register struct buf *bp;
{
	register struct pte *pte;
	register unsigned paddr, o;
	register int bcount, count;

	bcount = bp->b_bcount;
	pte = bptopte(bp);
	o = (int)bp->b_un.b_addr & (NBPG - 1); 
	while (bcount) {
		paddr = (pte->pg_pfnum << PGSHIFT) | o;
		count = MIN(bcount, (NBPG - o));
		bcopy(k, paddr + VEQR_ADDR, count);
		bcount -= count;
		k += count;
		pte++;
		o = 0;
	}
}
