/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)vm_machdep.c	6.8 (Berkeley) 10/23/85
 */
/*#define PRPTES	/* Print out pte's */
/*#define PRCMAP	/* Print out cmap structure */

#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "user.h"
#include "proc.h"
#include "cmap.h"
#include "vfs.h"
#include "vm.h"
#include "text.h"
#include "buf.h"
#include "../ufs/mount.h"

#include "../machine/board.h"
#include "../machine/m68k.h"
#include "../machine/scb.h"

#ifdef	SYSV
#include "../sysv/sys/region.h"
#endif	SYSV

/*
 * Unique IS-68K{123}0 portion of vm_machdep.c
 */
#ifdef	M68030
#	include "../machine/vm_machdep.30.c"
#else	M68030
#ifdef VQX
#       include "../machine/vm_machdep.vqx.c"
#else VQX
#       include "../machine/vm_machdep.20.c"
#endif VQX
#endif	M68030

/*
 * Common code 
 */

/*
 * Set a red zone in the kernel stack after the u. area.
 */
setredzone(pte, vaddr)
	register struct pte *pte;
	struct user *vaddr;
{
#ifdef vax
	pte += (sizeof (struct user) + NBPG - 1) / NBPG;
	*(int *)pte &= ~PG_PROT;
	*(int *)pte |= PG_URKR;
	if (vaddr)
		mtpr(TBIS, vaddr + sizeof (struct user));
#endif vax
}

/* KLUDGE NOTE: 4.3 made this a macro with count == 1 */
mapin(pte, v, pfnum, count, prot)
	struct pte *pte;
	u_int v;
	register u_int pfnum;
	int count;
	register int prot;
{
	register struct pte *rpte = pte;
	register int rcount = count;

	while (--rcount >= 0) {
		*(int *)rpte = prot;
		rpte++->pg_pfnum = pfnum++;
	}
	newptes(pte, v, count);
}

#ifdef notdef
/*ARGSUSED*/
mapout(pte, size)
	register struct pte *pte;
	int size;
{

	panic("mapout");
}
#endif

/*
 * Check for valid program size
 * NB - Check data and data growth separately as they may overflow 
 * when summed together.
 */
chksize(ts, ids, uds, ss)
	unsigned ts, ids, uds, ss;
{
	extern int maxtsize;

	if (ctob(ts) > maxtsize ||
	    ctob(ids) > u.u_rlimit[RLIMIT_DATA].rlim_cur ||
	    ctob(uds) > u.u_rlimit[RLIMIT_DATA].rlim_cur ||
	    ctob(ids + uds) > u.u_rlimit[RLIMIT_DATA].rlim_cur ||
	    ctob(ss) > u.u_rlimit[RLIMIT_STACK].rlim_cur) {
		u.u_error = ENOMEM;
		return (1);
	}
	return (0);
}

/*
 * Change protection codes of text segment.
 * Have to flush translation buffer since this could
 * affect virtual memory mapping of current process.
 */
chgprot(addr, tprot)
caddr_t addr;
long tprot;
{
	unsigned v;
	int tp;
	register struct pte *pte;
	register struct cmap *c;

	v = clbase(btop(addr));
	if (!isatsv(u.u_procp, v)) {
		u.u_error = EFAULT;
		return (0);
	}
	tp = vtotp(u.u_procp, v);
	pte = tptopte(u.u_procp, tp);
	if (pte->pg_fod == 0 && pte->pg_pfnum) {
		c = &cmap[pgtocm(pte->pg_pfnum)];
		if (c->c_blkno && c->c_vp != swapdev_vp)
			munhash(c->c_vp, (daddr_t)(u_long)c->c_blkno);
	}
	*(int *)pte &= ~PG_PROT;
	*(int *)pte |= tprot;
	distcl(pte);
#ifdef vax
	tbiscl(v);
#endif vax
#ifdef is68k
	refbits();
	newptes(pte, v, CLSIZE);
#endif is68k
	return (1);
}

settprot(tprot)
long tprot;
{
	register int *ptaddr, i;
	register struct pte *pte = tptopte(u.u_procp, 0);

	for (i = 0; i < u.u_tsize; i++) {
		*(int *)pte &= ~PG_PROT;
		*(int *)pte |= tprot;
		pte++;
	}
#ifdef vax
	mtpr(TBIA, 0);
#endif vax
#ifdef is68k
	newptes(tptopte(u.u_procp,0), (u_int)0, u.u_tsize);
#endif is68k
}

/* NOTE: 4.3 defines getmemc, and putmemc */

/*
 * Move pages from one kernel virtual address to another.
 * Both addresses are assumed to reside in the Sysmap,
 * and size must be a multiple of CLSIZE.
 */
pagemove(from, to, size)
register caddr_t from, to;
int size;
{
	register caddr_t rfrom = from, rto = to;
	register rsize = size;
	register struct pte *fpte, *tpte;
	register struct pte *rfpte, *rtpte;

	if (size % CLBYTES)
		panic("pagemove");
	fpte = rfpte = &Sysmap[btop(from - SYSV_BASE)];
	tpte = rtpte = &Sysmap[btop(to - SYSV_BASE)];
	while (rsize > 0) {
		*rtpte++ = *rfpte;
		*(int *)rfpte++ = 0;
		rfrom += NBPG;
		rto += NBPG;
		rsize -= NBPG;
	}
	newptes(fpte, from, size);
	newptes(tpte, to, size);
}

prcmap()
{
#ifdef	PRCMAP
	register struct cmap *c;
	int s;

	s = spl7();
	cprintf("typ trn wnt lck fre gon dev ndx blk hlnk pag prv nxt\n");
	for (c = &cmap[0]; c < ecmap ; c++) {
	cprintf("  %x   %x   %x   %x   %x   %x   %x   %x   %x    %x   %x   %x   %x\n",
		c->c_type, c->c_intrans, c->c_want, c->c_lock, c->c_free,
		c->c_gone, c->c_vp, c->c_ndx, c->c_blkno, c->c_hlink,
		c->c_page, c->c_prev, c->c_next);
	}
	splx(s);
#endif	PRCMAP
}

prptes(p, n)
	int *p;
{
#ifdef	PRPTES
	register int i, last = *p, nrun = 0;

	cprintf("PTES @0x%x %d :",p,n);
	for (i = 0 ; i < n ; i++, p++, nrun++) {
		if (*p != last) {
			if (nrun > 1)
				cprintf("%d-%x, ", nrun, last);
			else
				cprintf("%x, ", last);
			nrun = 0;
			last = *p;
		}
	}
	if (nrun > 1)
		cprintf("%dx%x\n", nrun, last);
	else
		cprintf("%x\n", last);
#endif	PRPTES
}
