/*
 * Unique portion of vm_machdep.c for 68030's
 */

#define CACHE_FLUSH_THRESH 128

struct tdlong pta_pad[4*((1<<30)/PPTASPACE) + 2]; 
					/* 2 is for quad alignment */
struct tdlong *pta, *ptap0, *ptap1;
struct tdlong ztdlong = {0, 0, 0x7e, 0, 0, 0, 0, 0, 0, 0};
struct rpd rpd = {0, 4*((1<<30)/PPTASPACE), DTLONG, 0};
struct tcr tcr = {1, 0, 0, PS4K, 0, TIA, TIB, 0, 0};
struct tcr tcoff = {0, 0, 0, PS4K, 0, TIA, TIB, 0, 0};
struct ttr systt = {		/* system transparent */
	SYSV_BASE >> 24, 
	(SYSPTSIZE * NBPG)/(1<<24)-1,	/* multiple of 16 meg */
	1, 0, 
	0, 1, 			/* both r/w */
	4, 3,			/* fc = 1xx */
};

struct ttr ttoff = {		/* system transparent off*/
	SYSV_BASE >> 24, 
	(SYSPTSIZE * NBPG)/(1<<24)-1,	/* multiple of 16 meg */
	0, 0, 
	0, 1, 			/* both r/w */
	4, 3,			/* fc = 1xx */
};

struct ttr fc3tt = {		/* FC3 transparent */
	0, 
	0xff,
	1, 1,			/* enable, cache inhibit */ 
	0, 1, 			/* both r/w */
	3, 0,			/* fc = 3 */
};

extern struct pte Umap[];
extern struct pte CMAP1;
extern char CADDR1;
struct pte zpte;
struct pte *bptopte();

startinit()
{
	register u_long	addr, i, j, k;
	register struct pte pte, *p1, *p2;
	register struct tdlong *td;
	int (*vec[])();
	extern char Syssize, end, etext;

	/* 
 	 * quadword align pta.
	 */
	pta = (struct tdlong *)(((u_long)pta_pad + 15) & ~15);

	/*
	 * Since Sysmap is in the cache inhibit V EQ R region,
 	 * Initialize kernel V EQ R portion of the pta.
	 */
	addr = 0;
	i = btop(MAXPHYSMEM);
	td = &pta[VEQR_CI_ADDR / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = addr;
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_ci = 1;
		td->td_limit = btop(PPTASPACE);
		i -= td->td_limit;
		addr += PPTASPACE;
		td++;
	}

	/*
	 * initialize root pointer
	 */
	rpd.rp_addr = (int)pta - SYSV_BASE;
	loadmmu(MMUCRP, &rpd);

	/*
	 * Initialize translation control register
	 */
	loadmmu(MMUTC, &tcr);

	/*
	 * Sysmap is now addressable.
	 * Initialize Sysmap for kernel text and data
	 */

	p1 = Sysmap;
	j = ((u_long)&end + NBPG - 1 - SYSV_BASE)/NBPG;
	k = ((u_long)&etext + NBPG - 1 - SYSV_BASE)/NBPG - 1;
	for (i = 0 ; i < j ; i++, p1++) {
		p1->pg_v = 1;
		p1->pg_pfnum = i; 
		if (i < k)
			p1->pg_prot = 1; 
	}

	/* 
	 * Initialize user virtual portion of pta.
	 */
	i = MAXU_ADDR / PPTASPACE;
	td = pta;
	while (i--)
		*td++ = ztdlong;
	ptap0 = pta;
	ptap1 = &pta[MAXU_ADDR / PPTASPACE];

	/* 
	 * Initialize kernel virtual portion of pta.
	 */
	addr = (int)Sysmap - VEQR_ADDR;
	i = (int)&Syssize;
	td = &pta[SYSV_BASE / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = addr;
		td->td_dt = DTSHORT;
		td->td_s = 1;
		td->td_limit = (i < NPTEPG) ? i : NPTEPG;
		i -= td->td_limit;
		addr += td->td_limit * 4;
		td++;
	}

	/*
	 * Cache inhibit page table pages 
	 */
	cache_inhibit(Sysmap, (int)&Syssize * (sizeof (struct pte)));

	/*
 	 * Initialize kernel V EQ R portion of the pta.
	 */
	addr = 0;
	i = btop(MAXPHYSMEM);
	td = &pta[VEQR_ADDR / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = addr;
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_limit = btop(PPTASPACE);
		i -= td->td_limit;
		addr += PPTASPACE;
		td++;
	}

	/*
 	 * Initialize VME portion of the pta.
	 */
	addr = VME_BASE;
	i = btop(VMESPACE);
	td = &pta[VME_BASE / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = addr;
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_ci = 1;
		td->td_limit = btop(PPTASPACE);
		i -= td->td_limit;
		addr += PPTASPACE;
		td++;
	}

	/*
	 * Allocate and setup page table and _u area for proc[0]. 
	 * First free page is allocated for proc 0 page table.
	 */
	addr = btop((u_long)&end + NBPG - 1) - btop(SYSV_BASE);
	pte = zpte;
	pte.pg_pfnum = addr++;
	pte.pg_prot = 0;
	pte.pg_v = 1;
	Usrptmap[0] = pte;
	Usrptmap[0].pg_ci = 1;

	p1 = &usrpt[NPTEPG - UPAGES];
	p2 = Umap;
	for (i = 0 ; i < UPAGES ; i++) {
		pte.pg_pfnum = addr++;
		*p2++ = pte;
		*p1 = pte;
		p1++->pg_prot = 1;		/* write protect user u */
	}

	/* 
	 * Initialize (slightly) the pcb
	 */
	u.u_pcb.pcb_sp = (u_long)&u + UPAGES * NBPG;
	u.u_pcb.pcb_psl = 0x2700;
	u.u_pcb.pcb_szpt = 1;
	u.u_pcb.pcb_p0br = usrpt;
	u.u_pcb.pcb_p0lr = AST_NONE;
	u.u_pcb.pcb_p1br = initp1br(&usrpt[NPTEPG - UPAGES]);
	u.u_pcb.pcb_p1lr = P1PAGES - UPAGES;
	u.u_stack[0] = U_REDZONE_MAGIC;
	setctx();
	return(addr);
}

newptes(pte, v, size)
register struct pte *pte;
u_int v;
register int size;
{
	register caddr_t a = ptob(v);

	if (size > 8)
		tbia();
	else {
		while (size-- > 0) {
			tbis(a);
			a += NBPG;
		}
	}
	flush_dcache();
}

svtop(addr) 
register u_long	addr;
{
	register struct pte *pte;

	if (addr >= SYSV_BASE && addr < (u_long)&Syssize*NBPG+SYSV_BASE) {
		pte = &Sysmap[btop(addr - SYSV_BASE)];
		if (pte->pg_v)
			return((pte->pg_pfnum << PGSHIFT) | (addr&PGOFSET));
	} else if (addr >= VEQR_ADDR && addr < (VEQR_ADDR + MAXPHYSMEM)) {
			return(addr - VEQR_ADDR);
	} else if (addr >= (u_long)Sysmap && addr < (u_long)eSysmap) {
			return(addr - VEQR_CI_ADDR);
	} else if (addr >= VME_BASE)
			return(addr);
	panic("svtop");
}

setctx()
{
	register i, j;
	register struct pte *pte;
	register struct tdlong *p0, *p1, *tmpp;
	
	i = u.u_pcb.pcb_p0lr & ~AST_CLR;
	pte = &Usrptmap[btokmx(u.u_pcb.pcb_p0br)];
	p0 = &pta[USRTEXT / PPTASPACE];
	while (i > 0) {
		*p0 = ztdlong;
		p0->td_dt = DTSHORT;
		p0->td_limit = (i < NPTEPG) ? i : NPTEPG;
		i -= p0->td_limit;
		p0->td_addr = (u_int)ptob(pte->pg_pfnum);
		p0++;
		pte++;
	}
	tmpp = p0;
	while (ptap0 > p0)
		*p0++ = ztdlong;
	ptap0 = tmpp;

	j = P1PAGES - (u.u_pcb.pcb_p1lr & ~PME_CLR);
	pte = &Usrptmap[btokmx(u.u_pcb.pcb_p0br) + u.u_pcb.pcb_szpt - 1];
	p1 = &pta[MAXU_ADDR / PPTASPACE - 1];
	while (j > 0) {
		*p1 = ztdlong;
		p1->td_dt = DTSHORT;
		p1->td_addr = (u_int)ptob(pte->pg_pfnum);
		if (j < NPTEPG) {
			p1->td_limit = NPTEPG - j;
			p1->td_lu = 1;
			j = 0;
		} else {
			p1->td_limit = NPTEPG;
			j -= p1->td_limit;
		}
		p1--;
	}
	tmpp = p1;
	while (ptap1 < p1)
		*p1-- = ztdlong;
	ptap1 = tmpp;
	tbia();
}

cache_inhibit(vaddr, len)
register unsigned vaddr;
register len;
{
	register i, last;

	i = btop(svtop(vaddr));
	last = btop(svtop(vaddr + len - 1));
	while (i <=  last)
		Sysmap[i++].pg_ci = 1;
}

flush_cache_entry(vaddr, len)
register unsigned vaddr;
register len;
{

	register unsigned paddr;
	register count;
	
	if (len)
	    pte_flush_cache(&Sysmap[btop(vaddr-SYSV_BASE)], vaddr, len);
}


pte_flush_cache(pte, vaddr, len)
register struct pte *pte;
register unsigned vaddr;
register len;
{

	register unsigned paddr, o;
	register count;

	if (len && len > CACHE_FLUSH_THRESH) {
		flush_all_caches();
	} else if (len) {
		flush_dcache();
		len = (((vaddr + len) & 0xFFFFFFF0) + 16)-(vaddr & 0xFFFFFFF0);
		o = (vaddr & 0xFFFFFFF0) & PGOFSET;
		while (len) {
			paddr = (pte->pg_pfnum << PGSHIFT) | o;
			count = MIN(len, (NBPG - o));
			flush_ext_cache_entry(paddr, count);
			len -= count;
			pte++;
			o = 0;
		}
	}
}

bpcopyin(k, bp)
	register char *k;
	register struct buf *bp;
{
	register struct pte *pte;
	register unsigned paddr, o;
	register int bcount, count;

	bcount = bp->b_bcount;
	pte = bptopte(bp);
	o = (int)bp->b_un.b_addr & (NBPG - 1); 
	pte_flush_cache(pte, bp->b_un.b_addr, bcount);
	while (bcount) {
		paddr = (pte->pg_pfnum << PGSHIFT) | o;
		count = MIN(bcount, (NBPG - o));
		bcopy(paddr + VEQR_ADDR, k, count);
		bcount -= count;
		k += count;
		pte++;
		o = 0;
	}
}

bpcopyout(k, bp)
	register char *k;
	register struct buf *bp;
{
	register struct pte *pte;
	register unsigned paddr, o;
	register int bcount, count;

	bcount = bp->b_bcount;
	pte = bptopte(bp);
	o = (int)bp->b_un.b_addr & (NBPG - 1); 
	while (bcount) {
		paddr = (pte->pg_pfnum << PGSHIFT) | o;
		count = MIN(bcount, (NBPG - o));
		bcopy(k, paddr + VEQR_ADDR, count);
		bcount -= count;
		k += count;
		pte++;
		o = 0;
	}
}

pcopyin(ps, kd, count)
{
	bcopy(ps+VEQR_ADDR, kd, count);
}

pcopyout(ks, pd, count)
{
	bcopy(ks, pd+VEQR_ADDR, count);
}
