/*
 * Unique portion of vm_machdep.c for 68020's
 */

struct vc_context {
	int		vc_lastaccess;
	struct proc	*vc_occupant;
};
struct vc_context vc_context[NCTX];
int vc_tick;		

/*
 * Allocate a context for the current process. This routine is called from
 * trap after a context fault.  We scan the context table first looking for 
 * an empty context and secondly for the least recently used context.
 * We then setup the context and point the context register at it.
 * If it was stolen from another process, we have to update the status bits in 
 * the old process' page table, and set its p->p_context to unallocated.
 */
ctx_alloc()
{
	register u_short i, lru, oldest;
	register struct vc_context *vc;
	register struct proc *p = u.u_procp;

	if (p->p_flag & SSYS)
		panic("context fault on system process");
	oldest = vc_tick++;
	for (i = lru = 1; i < (NCTX-1); i++) {
		vc = &vc_context[i];
		if (vc->vc_occupant == 0) {
			lru = i;
			break;
		} else if (vc->vc_lastaccess < oldest) {
			lru = i;
			oldest = vc->vc_lastaccess;
		}
	}
	vc = &vc_context[lru];
	if (vc->vc_occupant)
		ctx_free(vc->vc_occupant);
	vc->vc_occupant = p;
	vc->vc_lastaccess = vc_tick;
	setctx(lru);
	setptp(p);
	p->p_context = lru;
	invutbuf();
}

ctx_free(p)
	register struct proc *p;
{
	register struct vc_context *vc;

	if (p->p_context == CTX_INVALID || p->p_context == CTX_SYS)
		return;
	if (u.u_procp == p || p->p_context == ctx)
		invutbuf();
	vc = &vc_context[p->p_context];
	if (vc->vc_occupant != p)
		panic("ctx_free");
	p->p_context = CTX_INVALID;
	vc->vc_occupant = 0;
	vc->vc_lastaccess = 0;
}

#define btoptp(x)	(PTP_VALID|btop(x)|(((int)x&PTP_LSBMASK)<<PTP_LSBSHIFT))

setptp(p)
	register struct proc *p;
{
	register int *ptp = (int *)PTP_BASE;
	register struct pte *ptep;
	register int ptpincr = PTP_INCR/sizeof (int);
	register int i, k, n;

	for (i = 0 ; i < NPTPS ; i++, ptp += ptpincr)
		*ptp = PTP_INVALID;
	ptp = (int *)PTP_BASE;
	ptep = &Usrptmap[btokmx(tptopte(p,0))];
	if (p->p_szpt == 1) {
		if (ptep->pg_pfnum >= PTP_PG) {
		    printf("pg_pgnum = %x, max = %x\n",ptep->pg_pfnum,PTP_PG);
		    panic("page of pte's too high");
		}
		*ptp = btoptp(ptob(ptep->pg_pfnum));
		ptp = (int *)(PTP_BASE + (PTP_INCR * (NPTPS-1)) );
		*ptp = btoptp(((int)(ptob(ptep->pg_pfnum))|PTP_LSBMASK));
	} else {
	    n = u.u_pcb.pcb_p0lr&~AST_CLR;
	    for (i=0, k=0 ; i <= n ; i+=(NPTEPG/2), ptp+=ptpincr){
		if (ptep->pg_pfnum >= PTP_PG) {
		    printf("pg_pgnum = %x, max = %x\n",ptep->pg_pfnum,PTP_PG);
		    panic("page of pte's too high");
		}
		*ptp = btoptp(((int)(ptob(ptep->pg_pfnum))|k));
		if (k)
		    ptep++;
		k ^= PTP_LSBMASK;
	    }
	    ptp = (int *)(PTP_BASE + (PTP_INCR * (NPTPS-1)) );
	    ptep = &Usrptmap[btokmx(sptopte(p,0))];
	    for (i=p->p_ssize,k=PTP_LSBMASK; i>0; i-=(NPTEPG/2), ptp-=ptpincr){
		if (ptep->pg_pfnum >= PTP_PG) {
		    printf("pg_pgnum = %x, max = %x\n",ptep->pg_pfnum,PTP_PG);
		    panic("page of pte's too high");
		}
		*ptp = btoptp(((int)(ptob(ptep->pg_pfnum))|k));
		k ^= PTP_LSBMASK;
		if (k)
		    ptep--;
	    }
	}
}

setctx(i)
{
	register int s = spl7();

	ctx = i;
	ctx_bits &= ~CTX_LED;		/* turn LED DS3 on */
	*CTX = ctx_bits | i;
	ctx_bits |= CTX_LED;		/* and off at next context switch */
	splx(s);
}

#ifdef	C_invutbuf
invutbuf() { 
	register int *tbuf = (int *)TBUF_BASE_USR;
	register int tbufincr = TBUF_INCR/sizeof (int);
	register int i;

	for (i = 0 ; i < NTBUFS ; i++, tbuf += tbufincr)
		*tbuf = TBUF_INVALID;
}
#endif	C_invutbuf

#ifdef	C_newptes
newptes(pte, v, size)
	register struct pte *pte;
	u_int v;
	register int size;
{
	register int *tbuf;
	register int tbufincr = TBUF_INCR/sizeof (int);
	register int i;

	if (size <= 0)
		return;
	if (pte >= Sysmap && pte <= eSysmap)
		tbuf = (int *)TBUF_BASE_SYS;
	else
		tbuf = (int *)TBUF_BASE_USR;

	if ( size > 20 )
		for (i = 0 ; i < NTBUFS ; i++, tbuf += tbufincr)
			*tbuf = TBUF_INVALID;
	else {
		v &= PG_PFNUM;
		tbuf = (int *)((int)tbuf | ((v<<PGSHIFT)&TBUF_INDEX_MASK));
		while (size > 0) {
			*tbuf = TBUF_INVALID;
			tbuf += tbufincr;
			size--;
		}
	}
}
#endif	C_newptes

svtop(addr) 
{
	register struct pte *pte;

	switch (addr & MEMR_MASK) {
	    case NONT_BASE:
		return(addr);

	    case SYSV_BASE:
		pte = &Sysmap[btop(addr - SYSV_BASE)];
		if (pte->pg_v)
			return((pte->pg_pfnum << PGSHIFT) | (addr&PGOFSET));

	    default:
/*		panic("svtop"); /**/
		return 0;
	}
}

bpcopyin(k, bp)
	register char *k;
	register struct buf *bp;
{
	pcopyin(bptop(bp), k, bp->b_bcount);
}

bpcopyout(k, bp)
	register char *k;
	register struct buf *bp;
{
	pcopyout(k, bptop(bp), bp->b_bcount);
}

#ifdef	C_useracc
/*
 * test the accessability of a portion of user address space.  This is
 * better than the locore version because it does not fault in pages until they
 * are needed.
 */
useracc(v, len, acc)
	register int len, acc;
{
	register struct pte *pte;

#ifdef	TRFS
	if (u.u_tclient)
		return(Tuseracc());
#endif	TRFS

	pte = vtopte(u.u_procp, btop(v));
	while (len > 0) {
		if ((acc == B_WRITE) && (pte->pg_prot == PG_URKR))
			return (0);
		len -= NBPG;
		pte++;
	}
	return(1);
}
#endif	C_useracc
