/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)trap.h	6.2 (Berkeley) 6/8/85
 */

/*
 * ISI: IS68K {VQ}BUS 680{12}0 trap type values
 */

/* The first constant values are known to the real world <signal.h> */
#define	T_RESADFLT	0x00	/* reserved addressing fault */
#define	T_PRIVINFLT	0x01	/* privileged instruction fault */
#define	T_RESOPFLT	0x02	/* reserved operand fault */
/* End of known constants */

#define	T_BUSERR	0x03	/* bus error */
#define	T_ADDERR	0x04	/* address error */
#define	T_ZERODIV	0x05	/* divide by zero */
#define	T_CHK		0x06	/* CHK instruction */
#define	T_TRAPV		0x07	/* TRAPV instruction */
#define	T_SEGFLT	0x08	/* segment fault */
#define	T_PROTFLT	0x09	/* protection fault */
#define	T_TRCTRAP	0x0A	/* trace trap */
#define	T_NMI		0x0B	/* nonmaskable interrupt */
#define	T_PAGEFLT	0x0C	/* page fault */
#define	T_L1010EM	0x0D	/* line 1010 emulation */
#define	T_L1111EM	0x0E	/* line 1111 emulation */
#define	T_FMTERR	0x0F	/* stack format error */
#define	T_TRAP		0x10	/* trap instruction */
#define	T_SYSCALL	0x11	/* system call instruction */
#define	T_ASTFLT	0x12	/* asynchronous trap */
#define	T_STRAY		0x13	/* stray trap or interrupt */
#define	T_BPTFLT	0x14	/* breakpoint fault trap */
#define T_SEGVIO	0x15	/* segment violation */
#define T_CNTXFLT	0x16	/* context fault (68020) */
#define	T_COPROC	0x17	/* coprocessor protocol violation (68020) */
#define	T_FPE		0x18	/* floating point exception (68881) */
#define	T_PARITY	0x19	/* parity error */
#define	T_MMU		0x1a	/* mmu configuration exception */

#define	USER		0x20	/* user-mode flag added to type */

#ifdef	TRAP_TYPE
/*
 * The following array must match above indexes.
 */
char	*trap_type[] = {
	"Reserved addressing mode",	/* 0x00 */
	"Privileged instruction",	/* 0x01 */
	"Reserved operand",		/* 0x02 */
	"Bus error",			/* 0x03 */
	"Address error",		/* 0x04 */
	"Divide by zero",		/* 0x05 */
	"CHK trap",			/* 0x06 */
	"TRAPV trap",			/* 0x07 */
	"Segment fault",		/* 0x08 */
	"Protection violation",		/* 0x09 */
	"Trace trap",			/* 0x0A */
	"Nonmaskable interrupt",	/* 0x0B */
	"Page fault",			/* 0x0C */
	"A-Line emulation trap",	/* 0x0D */
	"F-Line emulation trap",	/* 0x0E */
	"Stack format trap",		/* 0x0F */
	"Trap trap",			/* 0x10 */
	"System call trap",		/* 0x11 */
	"Asynchronous trap",		/* 0x12 */
	"Stray interrupt",		/* 0x13 */
	"Breakpoint trap",		/* 0x14 */
	"Segment violation",		/* 0x15 */
	"Context fault",		/* 0x16 */
	"Coprocessor violation",	/* 0x17 */
	"Floating point exception",	/* 0x18 */
	"Parity error",			/* 0x19 */
	"MMU configuration exception",  /* 0x1a */
};
#define	NTRAP_TYPES	(sizeof trap_type / sizeof trap_type[0])
#endif	TRAP_TYPE
