/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)scb.h	6.2 (Berkeley) 6/8/85
 */

/* 
 * ISI: IS68K vector table
 */

#define	STRAY	.long	_Xstray
#define	STRAY8	STRAY;STRAY;STRAY;STRAY;STRAY;STRAY;STRAY;STRAY
#define	STRAY16	STRAY8;STRAY8
#define	KS(a)	.long	_X/**/a

	.data
	.align	1
	.globl	_scb
/* System control block: */
_scb:
#ifdef	M68010
/*   0 */	STRAY;		STRAY;		KS(buserr);	KS(adderr);
#else	M68020
/*   0 */	.long 0;	.long 0;	KS(buserr);	KS(adderr);
#endif	M68010
/*   4 */	KS(illins);	KS(zerodiv);	KS(chk);	KS(trapv);
/*   8 */	KS(privvio);	KS(trace);	KS(l1010em);	KS(l1111em);
#ifdef	M68010
/*  12 */	STRAY;		STRAY;		KS(fmterr);	STRAY;
#else	M68020
/*  12 */	STRAY;		KS(coproc);	KS(fmterr);	STRAY;
#endif	M68010
/*  16 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  20 */	STRAY;		STRAY;		STRAY;		STRAY;
#ifdef	M68030
/*  24 */	STRAY;		KS(softtrap);	STRAY;		STRAY;
/*  28 */	KS(sio);	STRAY;		KS(clock);	KS(nmi);
#else	M68030
/*  24 */	STRAY;		STRAY;		STRAY;		STRAY;
#ifdef	M68010
/*  28 */	STRAY;		KS(lclock);	STRAY;		KS(nmi);
#else	M68020
#ifdef	VQX
								/* nmi? */
/*  28 */	STRAY;		STRAY;		STRAY;		STRAY;
#else	VQX
/*  28 */	STRAY;		KS(sio);	KS(clock);	KS(nmi);
#endif	VQX
#endif	M68020
#endif	M68030
/*  32 */	KS(trap0);	KS(trap1);	KS(trap2);	KS(trap3);
/*  36 */	KS(trap4);	KS(trap5);	KS(trap6);	KS(trap7);
/*  40 */	KS(trap8);	KS(trap9);	KS(trap10);	KS(trap11);
/*  44 */	KS(trap12);	KS(trap13);	KS(trap14);	KS(trap15);
#ifdef	M68010
/*  48 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  52 */	STRAY;		STRAY;		STRAY;		STRAY;
#else	M68020
/*  48 */	KS(fpe);	KS(fpe);	KS(fpe);	KS(fpe);
/*  52 */	KS(fpe);	KS(fpe);	KS(fpe);	STRAY;
#endif	M68010
#ifdef	M68030
/*  56 */	KS(mmu);	STRAY;		STRAY;		STRAY;
#else	M68030
/*  56 */	STRAY;		STRAY;		STRAY;		STRAY;
#endif	M68030
/*  60 */	STRAY;		STRAY;		STRAY;		STRAY;
#ifdef	M68010
/*  64 */	KS(sioxint1);	STRAY;		KS(sioeint1);	STRAY;
/*  68 */	KS(siorint1);	STRAY;		KS(siosint1);	STRAY;
/*  72 */	KS(sioxint0);	STRAY;		KS(sioeint0);	STRAY;
/*  76 */	KS(siorint0);	STRAY;		KS(siosint0);	STRAY;
/*  80 */	KS(ctcint0);	STRAY;		KS(ctcint1);	STRAY;
/*  84 */	KS(ctcint2);	STRAY;		KS(ctcint3);	STRAY;
/*  88 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  92 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  96 */	STRAY8;		STRAY8;		STRAY8;		STRAY8;
#else	M68020
#ifdef VQX
/*  64	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  68	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  72	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  76	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  80	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  84	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  88	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  92	*/	STRAY;		STRAY;		STRAY;		STRAY;
/*  96	*/	STRAY8;		STRAY8;		STRAY8;		STRAY8;
#else	M68020
/*  64 */	STRAY16;	STRAY16;	STRAY16;	STRAY16;
#endif VQX
#endif	M68010
#ifdef	VQX
		/*vidframe*/	/*clock*/	/*audio*/	/*keybd*/
/* 128 */	STRAY;		KS(clock);	STRAY;		KS(kbintr);
		/*scsi*/	/*ethernet*/	/*acfail*/	/*sysfail*/
/* 132 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 136 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 140 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 144 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 148 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 152 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 156 */	STRAY;		STRAY;		STRAY;		STRAY;
		/*siosccrx0*/	/*sioscctx0*/	/*siosccsp*/	/*siosccex*/
/* 160 */	KS(siorint0);	KS(sioxint0);	KS(siostchg0);	KS(sioex0);
		/*siosccrdma0*/	/*siosccxdma0*/
/* 164 */	KS(siordma0);	KS(sioxdma0);	STRAY;		STRAY;
		/*siosccrx1*/	/*sioscctx1*/	/*siosccsp*/	/*siosccex*/
/* 168 */	KS(siorint1);	KS(sioxint1);	KS(siostchg1);	KS(sioex1);
		/*siosccrdma1*/	/*siosccxdma1*/
/* 172 */	KS(siordma1);	KS(sioxdma1);	STRAY;		STRAY;
/* 180 */	STRAY;		STRAY;		STRAY;		STRAY;
/* 188 */	STRAY;		STRAY;		STRAY;		STRAY;
#else	VQX
/* 128 */	STRAY16;	STRAY16;	STRAY16;	STRAY16;
#endif	VQX
/* 192 */	STRAY16;	STRAY16;	STRAY16;	STRAY16;
/* 256 */
	.text
