/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)pcb.h	6.4 (Berkeley) 6/8/85
 */

/*
 * ISI: IS68K process control block
 */

#ifndef	LOCORE
struct pcb {
	int	pcb_d2; 
	int	pcb_d3; 
	int	pcb_d4; 
	int	pcb_d5; 
	int	pcb_d6; 
	int	pcb_d7; 
	int	pcb_a2; 
	int	pcb_a3; 
	int	pcb_a4; 
	int	pcb_a5; 
	int	pcb_a6; 
#define	pcb_fp pcb_a6
	int	pcb_a7; 
#define	pcb_sp pcb_a7
	int	pcb_psl;	 	/* program status longword */
	int	pcb_pc; 		/* program counter */
	struct  pte *pcb_p0br;	 	/* seg 0 base register */
	int	pcb_p0lr; 		/* seg 0 length register and astlevel */
	struct  pte *pcb_p1br;	 	/* seg 1 base register */
	int	pcb_p1lr;	 	/* seg 1 length register and pme */
/* Software pcb (extension) */
	int	pcb_szpt; 		/* number of pages of user page table */
	int	pcb_cmap2;
	int	*pcb_sswap;
};

extern char ast;			/* pending ast's: see bits below */

#define	aston()	{u.u_pcb.pcb_p0lr = (u.u_pcb.pcb_p0lr &~ AST_CLR) | AST_USER; \
		ast |= (1 << AST_USR); }
#define	astoff(){u.u_pcb.pcb_p0lr = (u.u_pcb.pcb_p0lr &~ AST_CLR) | AST_NONE; \
		ast &= ~(1 << AST_USR); }
#endif
	/* pcb ast bits on vax */
#define	AST_NONE	0x04000000	/* ast level */
#define	AST_USER	0x03000000	/* ast for user mode */
#define	AST_CLR		0x07000000
#define	PME_CLR		0x80000000

	/* pending "ast" bits */
#define	AST_USR		0		/* user ast pending */
#define	AST_TIC		1		/* softclock ast pending */
#define	AST_SOFT	2		/* software ast pending */
