/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)machparam.h	6.4 (Berkeley) 9/17/85
 */

/*
 * Machine dependent constants for is68k.
 */
#define	NBPG	(4*1024)	/* 4K bytes/page */
#define	PGSHIFT	12		/* LOG2(NBPG) */
#define	PGOFSET	(NBPG-1)	/* byte offset into page */

#define	NBSEG	(128*1024)	/* 128K bytes/segment (V10) */
#define	SGSHIFT	17		/* segment shift */

#define	CLSIZE		1
#define	CLSIZELOG2	0

#define	SSIZE	((8*1024)/NBPG)	/* initial stack size/NBPG */
#define	SINCR	((32*1024)/NBPG)/* increment of stack/NBPG */

#if defined(M68030) || defined(VQX)
#define	KERNELBASE 0x40000000	/* NFS: start of kernel mapping */
#else	M68030
#ifdef	M68020
#define	KERNELBASE 0x10000000	/* NFS: start of kernel mapping */
#else	M68020
#define	KERNELBASE 0		/* NFS: start of kernel mapping */
#endif	M68020
#endif  M68030 || VQX
#define	UPAGES	2		/* pages of u-area */

#if !defined(M68020) && !defined(M68030)
#ifdef	QBUS
#define IOPAGES	2		/* number of io pages at top of kernel space */
#define NBUF18	8		/* number of MAXBSIZE buffers in 18 bit land */
#else	QBUS
#define IOPAGES	32		/* number of io pages at top of kernel space */
#endif	QBUS
#endif	M68020

/*
 * Some macros for units conversion
 */
/* Core clicks (NBPG bytes) to segments and vice versa */
#define	ctos(x)		(((x)+(1<<(SGSHIFT-PGSHIFT))-1)>>(SGSHIFT-PGSHIFT))
#define	stoc(x)		((x)<<(SGSHIFT-PGSHIFT))

/* Core clicks (NBPG bytes) to page table pointer and vice versa */
#if defined(M68020) || !defined(VQX)
#define	ctop(x)	(((x)+((1<<(PGSHIFT-1))>>2)-1)>>(PGSHIFT-1-2))
#define	ptoc(x)	((x)<<(PGSHIFT-1-2))
#else	M68020 && !VQX
#define	ctop(x)	(x)
#define	ptoc(x)	(x)
#endif  M68020 && !VQX

/* Core clicks (NBPG bytes) to disk blocks (512 bytes) */
#define	ctod(x)	((x)<<(PGSHIFT-9))
#define	dtoc(x)	((((unsigned)(x))+(1<<(PGSHIFT-9))-1)>>(PGSHIFT-9))
#define	dtob(x)	((x)<<9)

/* clicks to bytes */
#define	ctob(x)	((x)<<PGSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((unsigned)(x)+(NBPG-1))>>PGSHIFT)

/*
 * Macros to decode processor status word.
 */
#define	USERMODE(ps)	(((ps) & PSL_CURMOD) == 0)
#define	BASEPRI(ps)	(((ps) & PSL_IPL) == 0)

#ifdef	KERNEL
#ifndef	LOCORE
int	cpuspeed;	/* relative cpu speed, 8MHz 68000 == 1 */
/* DELAY(n) is in locore.s */
#endif	LOCORE
#else	KERNEL
#define	DELAY(n)	{ register int N = (n); while (N--); }
#endif	KERNEL

/* macros for referencing longs as two shorts */
#define	lobyte(X)	(((unsigned char *)&X)[1])
#define	hibyte(X)	(((unsigned char *)&X)[0])
#define	loword(X)	(((u_short *)&(X))[1])
#define	hiword(X)	(((u_short *)&(X))[0])

/* macros for making byte refs to word regs on the Qbus (note byte reversal) */
#define	Qlobyte(X)	(((uchar_t *)&X)[1])
#define	Qhibyte(X)	(((uchar_t *)&X)[0])

#ifndef	is68k_kobj
#ifdef	SYSV				/* ISI: SYSV: */
#ifndef	HZ
#define HZ	60
#endif
#endif	SYSV
#endif	is68k_kobj

/*
 * A mini-root gets copied into the front of the swap and we run over top of 
 * the swap area just long enough for us to do a mkfs and restor of the real
 * root (sure beats rewriting standalone restor).
 */
#define	MINIROOTSIZE	8192
