/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)machdep.c	6.26 (Berkeley) 2/23/86
 */

#define STACKTRACE /* */
#define SLEEPTRACE /* */
#define BUFFERTRACE /* */

#include "reg.h"
#include "pte.h"
#include "psl.h"
#include "cpu.h"

#include "param.h"
#include "systm.h"
#include "dir.h"
#include "user.h"
#include "kernel.h"
#include "dnlc.h"
#include "map.h"
#include "vm.h"
#include "proc.h"
#include "buf.h"
#include "reboot.h"
#include "conf.h"
#include "vnode.h"
#include "../ufs/inode.h"
#include "file.h"
#include "text.h"
#include "clist.h"
#include "callout.h"
#include "cmap.h"
#include "mbuf.h"
#include "msgbuf.h"
#include <syslog.h>
#ifdef	QUOTA
#include "../ufs/quota.h"
#endif	QUOTA

#include "frame.h"
#include "m68k.h"
#include "trap.h"
#include "board.h"
#include "../is68kdev/qbvar.h"

#ifdef	SYSV
#include "../sysv/sys/stream.h"
#include "../sysv/sys/ipc.h"
#include "../sysv/sys/msg.h"
#include "../sysv/sys/region.h"
#include "../sysv/sys/shm.h"
#include "../sysv/sys/sysmacros.h"
#endif	SYSV


#ifndef VQX
#define motopf(x)       x
#define mpotopf(x)      x
#define pftondx(x)      x
#endif VQX

/*
 * DEVICE SPECIFIC
 */
#include "vb.h"				/* VMEBUS: */
#include "nw.h"				/* VMEBUS: */
#ifdef	VQX
#include "qp.h"				/* Liberator: */
#endif 	VQX

int		msgbuf_setup = 0;	/* log buffer initialized */
#ifdef	M68030
#define	DIVIDER	198000
#else	M68030
#define	DIVIDER	184000
#endif	M68030
int		cpuspeed = 2;
int		have_68881;
int		skybase;		/* not used in the VQX	*/	
int		bufpages;		/* now initialized in param.o */
int		bufpcnt;		/* now initialized in param.o */
int		detachedmem;
int		stacktrace_depth = 0/*16*/;
int		stacktrace_args = 5;
char 		*strarg();
#ifdef	TRFS
u_int	*Client, *ClientNPROC;
#endif	TRFS

/*
 * Declare these as initialized data so we can patch them.
 */
#ifdef	NBUF
int	nbuf = NBUF;
#else
int	nbuf = 0;
#endif
int	nswbuf 	= 0;
int	howto;			/* d7 == how to boot */
int	devtype;		/* d6 == major of root dev */
char	*initi;			/* filename in /etc/ to "init" */
char	*initflg;		/* pointer to init's single/multi/GWS flag */
char	*gpaddr;		/* ISI: GWS: graphics ? */
int	rdswapsize;		/* size in blocks of diskless/cluster swap */

#ifdef  VQX
static  struct pte zpte = {0, 0, 0, 0, 0, 0, 0, 0, 0 };
#endif  VQX

/*
 * Machine-dependent startup code
 */
startup(firstaddr)
	int firstaddr;
{
	register int unixsize;
	register u_int i;
	register struct pte *pte;
	register caddr_t v;
	int maxbufs;
	extern char etext;
	int fa = firstaddr;

	vbminit();
	newptes(Usrptmap, btop(usrpt), 1);

	/* Initialize error message buffer (at end of core). */
	maxmem -= btoc(sizeof (struct msgbuf));
	mapin(msgbufmap, btop(&msgbuf), mpotopf(maxmem), 
		btoc(sizeof (struct msgbuf)), PG_V|PG_KW);
	msgbuf_setup = 1;

	vbnum = atoi(strarg("VBNUM"));
#ifdef	M68030
	if (vbnum)
		vme_int_disable();
	else
		vme_int_enable();
#endif	M68030

	/* Map in graphics memory */
	fa = (firstaddr += 
                GP_initialize(ctob(mpotopf(maxmem+btoc(sizeof (struct msgbuf)))), fa));

#ifdef VQX
        if (strarg("console")) {
                if (!strncmp(strarg("console"), "ascii", 8)){
                        printf("Using ascii console\n");
                }
#if	(NQP > 0)
		else if (!strncmp(strarg("console"), "obg", 8)){
                        fa = (firstaddr += obginit(fa));
                        printf("Using On-Board graphics console\n");
                }
        } else {
                fa = (firstaddr += obginit(fa));
#endif	QP
        }
#endif	VQX

	/* Map in cluster communications memory */
	maxmem -= btoc(VB_initialize(ctob(mpotopf(maxmem))));

	/* Map in NW ethernet node processor memory */
	if (vbnum == 0)
		NW_initialize(
			ctob(mpotopf(maxmem+btoc(sizeof (struct msgbuf)))));


	if (strarg("INIT"))
		strcpy(initi, strarg("INIT"));
	/*
	 * This alows one to do a autoboot on a different kernel.  Try
	 * the following.
	 *  ex(0,0)nemesis:/great_kernel(root=sm0a) howto=0
	 * You get the idea.			Rick McNeal, Nov 23, 1987
	 */
	if (strarg("howto"))
	  atob (strarg("howto"), &howto);
	if (howto & RB_SINGLE)
		*initflg = gpaddr ? 'S' : 's';
	else
		*initflg = gpaddr ? 'M' : 'm';

#ifdef	TRFS
	if (strarg("HOST")) {
		strcpy(hostname, strarg("HOST"));
		hostnamelen = strlen(hostname);
	} else {
		hostname[0] = 0;
	}
	if (strarg("SERVER")) {
		strcpy(servername, strarg("SERVER"));
		servernamelen = strlen(servername);
	} else {
		servername[0] = 0;
	}
	if (strarg("GATEWAY")) {
		strcpy(gatewayname, strarg("GATEWAY"));
		gatewaynamelen = strlen(gatewayname);
	} else {
		gatewayname[0] = 0;
	}
	diskless = (*servername != 0);

	if (diskless) {
		extern int trfs_no;

		if (hostname == 0)
			panic("host not specified at boottime");
		swdevt[0].sw_dev = makedev(trfs_no, 1);
		swdevt[0].sw_nblks = rdswapsize;
	}
#endif	TRFS

	/*
	 * Good {morning,afternoon,evening,night}.
	 */
	printf("%sreal      memory = %mM\n", version, 
		ctob(physmem + detachedmem));
	if (detachedmem)
		printf("detached  memory = %mM at0x%8x\n", ctob(detachedmem),
			ctob(physmem));

	/*
	 * Allocate space for system data structures. The first available real 
	 * memory address is in "firstaddr". The first available kernel virtual
	 * address is in "v". As pages of kernel virtual memory are allocated,
	 * "v" is incremented. As pages of memory are allocated and cleared,
	 * "firstaddr" is incremented.  
	 */
#define	valloc(name, type, num) 					\
	    dbg_addkvsymbol(":name", v);				\
	    (name) = (type *)(v); 					\
	    (v) = (caddr_t)(((long)((name)+(num)) + 3) & ~3)
#define	valloclim(name, type, num, lim) 				\
	    dbg_addkvsymbol(":name", v);				\
	    (name) = (type *)(v); 					\
	    (lim) = ((name)+(num));					\
	    (v) = (caddr_t)(((long)(lim) + 3) & ~3)

#ifdef	SYSV
	reg_varinit();
#endif	SYSV
	v = (caddr_t)(SYSV_BASE | ctob(pftondx(firstaddr)));
	valloclim(inode, struct inode, ninode, inodeNINODE);
	valloclim(file, struct file, nfile, fileNFILE);
	valloclim(proc, struct proc, nproc, procNPROC);
	valloclim(text, struct text, ntext, textNTEXT);
	valloc(cfree, struct cblock, nclist);
	valloc(callout, struct callout, ncallout);
	nswapmap = nproc * 2;
	valloc(swapmap, struct map, nswapmap);
	valloc(argmap, struct map, ARGMAPSIZE);
	valloc(kernelmap, struct map, USRPTSIZE);
	valloc(mbmap, struct map, nmbclusters/4);
	valloc(ncache, struct ncache, ncsize);
#ifdef	QUOTA
#ifndef	is68k
	valloclim(quota, struct quota, nquota, quotaNQUOTA);
#endif	is68k
	valloclim(dquot, struct dquot, ndquot, dquotNDQUOT);
#endif	QUOTA
#ifdef	TRFS
	valloclim(Client, u_long, nproc, ClientNPROC);
#endif	TRFS
	
#ifdef	SYSV
	valloclim(queue, queue_t, nqueue, queueNQUEUE);
	valloclim(streams, struct stdata, nstream, streamsNSTREAM);
	valloc(mblock, mblk_t, nmblock);
	valloc(dblock, dblk_t, ndblock);
	valloc(strevent, struct strevent, nstrevent);
	msg = (paddr_t)(v);
	(v) = (caddr_t)((msg)+(msginfo.msgseg * msginfo.msgssz));
	valloc(region, reg_t, nregion);
	valloc(pregion, preg_t, npregion);
	valloc(shmem, struct shmid_ds, shmmni);
#endif	SYSV

	/*
	 * Determine how many buffers to allocate.
	 * Use 10% of memory for the first 2 Meg, bufpcnt% [5,50] of the 
	 * remaining memory. Insure a minimum of 16 buffers.  We allocate half 
	 * as many swap buffer headers as file i/o buffers.
	 */
	if (bufpages == 0) {
		if (bufpcnt < 5)
			bufpcnt = 5;
		if (bufpcnt > 50)
			bufpcnt = 50;
#ifdef	TRFS
		/* If diskless, use 2% of 2 Meg or what we have. */
		if (diskless) {
			if (physmem >= btoc(2*1024*1024))
				bufpages = btoc(2*1024*1024)/(100/2)/CLSIZE;
			else
				bufpages = physmem/(100/2)/CLSIZE;
		} else
#endif	TRFS
		if (physmem < btoc(2*1024*1024))
			bufpages = physmem/(100/10)/CLSIZE;
		else {
			bufpages = btoc(2*1024*1024)/(100/10)/CLSIZE;
			bufpages += (MIN(physmem,0x800)-btoc(2*1024*1024))/(100/bufpcnt)/CLSIZE;
		}
	}
	if (bufpages >= 800) {
		bufpages = 800;
		printf("Warning: reduce bufpages to maximum of 800.\n");
	}

	if (nbuf == 0) {
		nbuf = (bufpages * CLBYTES) / AVGBSIZE;
		if (nbuf < 20)
			nbuf = 20;
	}
	if (nswbuf == 0) {
		nswbuf = (nbuf / 2) &~ 1;	/* force even */
		if (nswbuf > 256)
			nswbuf = 256;		/* sanity */
	}
	if (nswbuf > 32)
		nswbuf = 32;		/* temporary KLUDGE -- see swap() */

	valloc(swbuf, struct buf, nswbuf);

	/*
	 * Now the amount of virtual memory remaining for buffers can be 
	 * calculated, estimating needs for the cmap.
	 */
	ncmap = (maxmem*NBPG - ((int)v &~ SYSV_BASE)) /
		(CLBYTES + sizeof(struct cmap)) + 2;
	maxbufs = ((SYSPTSIZE * NBPG) -
	    ((int)(v + ncmap * sizeof(struct cmap)) - SYSV_BASE)) /
		(MAXBSIZE + sizeof(struct buf));
	if (maxbufs < 16)
		panic("sys pt too small");
	if (nbuf > maxbufs) {
	    printf("***  WARNING:  SYSPTSIZE limits buffers: %d to %d ***\n",
		nbuf, maxbufs);
	    nbuf = maxbufs;
	}
	if (bufpages > nbuf * (MAXBSIZE / CLBYTES)) {
	    printf("***  WARNING:  SYSPTSIZE limits bufpages: %d to %d ***\n",
		bufpages, nbuf * (MAXBSIZE / CLBYTES));
	    bufpages = nbuf * (MAXBSIZE / CLBYTES);
	}
	valloc(buffermap, struct map, nbuf+1);
	valloc(buf, struct buf, nbuf);
	valloc(buffers, char, bufpages * CLBYTES);

	/*
	 * Allocate space for core map.
	 * Allow space for all of phsical memory minus the amount 
	 * dedicated to the system. The amount of physical memory
	 * dedicated to the system is the total virtual memory of
	 * the system thus far, plus core map, buffer pages,
	 * and buffer headers not yet allocated.
	 * Add 2: 1 because the 0th entry is unused, 1 for rounding.
	 */
	ncmap = (maxmem*NBPG - ((int)v &~ SYSV_BASE)) /
		(CLBYTES + sizeof(struct cmap)) + 2;
	valloclim(cmap, struct cmap, ncmap, ecmap);
	if (((int)v & ~SYSV_BASE) > SYSPTSIZE*NBPG) {
		printf("v %x, max %x\n", (int)v & ~SYSV_BASE, SYSPTSIZE*NBPG);
		panic("SYSPTSIZE too small");
	}

	/*
	 * Clear space allocated thus far, and make r/w entries for the space 
	 * in the kernel map.
	 */
	unixsize = btoc((int)v &~ SYSV_BASE);
	while (pftondx(firstaddr) < unixsize) {
		Sysmap[pftondx(firstaddr)].pg_v = 1;
		Sysmap[pftondx(firstaddr)].pg_prot = 0;
		Sysmap[pftondx(firstaddr)].pg_pfnum = firstaddr;
		clearseg((u_int)firstaddr);
		firstaddr++;
	}

	if (pftondx(firstaddr) >= physmem - 8*UPAGES)
		panic("no memory");
	newptes(&Sysmap[pftondx(fa)], fa, firstaddr - fa);

	/* Initialize callouts */
	callfree = callout;
	for (i = 1; i < ncallout; i++)
		callout[i-1].c_next = &callout[i];

	/* Initialize memory allocator and swap and user page table maps.  */
	meminit(firstaddr, mpotopf(maxmem));
	maxmem = freemem;
	printf("available memory = %mM\n", ctob(maxmem));
	/*
	 * Allow upto 75 % of memory to be locked. This number should be tuned;
	 * it is user settable in param.c.
	 */
	if (lockablemem == 0) {
		lockablemem = (maxmem * 75) / 100;
		printf("max lockable mem = %mM\n", ctob(lockablemem));
	} else 
		printf("usr lockable mem = %mM\n", ctob(lockablemem));
	if (maxmem < 128)
		printf("***  WARNING:  Insufficient memory for this configuration  ***\n\n");
	printf("using %d buffers containing %mM of memory\n", nbuf,
		(bufpages * CLBYTES));
	rminit(buffermap, bufpages * CLBYTES, (long)buffers,
	    "buffers", nbuf+1);
	rminit(kernelmap, (long)USRPTSIZE-1, (long)1,
	    "usrpt", USRPTSIZE);
	rminit(mbmap, (long)((nmbclusters - 1) * CLSIZE), (long)CLSIZE,
	    "mbclusters", nmbclusters/4);

	kmem_init();		/* initialize kernel memory allocator */
	configure();		/* Configure the system.  */
}

#ifdef	PGINPROF
/*
 * Return the difference (in microseconds)
 * between the  current time and a previous
 * time as represented  by the arguments.
 */
vmtime(otime, olbolt, oicr)
	int otime, olbolt, oicr;
{
	return(((time.tv_sec-otime)*60 + lbolt-olbolt)*16667 + (0-oicr));
}
#endif	PGINPROF

chkaout(machtype)
{
	return(0);		/* KLUDGE FOR NOW */
}

intsvc()
{
	return(int_svc);
}

/*
 * Clear registers on exec
 */
setregs(entry)
	u_long entry;
{
	register int i;
	register struct proc *p = u.u_procp;
#ifdef vax
#define	NIREG 12
	static int ireg[NIREG] =
	{R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11};
#endif vax
#ifdef is68k
#define	NIREG 15
	static int ireg[NIREG] =
	{R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11,R12,R13,R14};
#endif is68k
	/* should pass args to init on the stack */
	for (i = 0 ; i < NIREG ; i++)
		u.u_ar0[ireg[i]] = 0;
#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		u.u_ar0[PC] = entry;
	else
#endif	SYSV
		u.u_ar0[PC] = entry + 2;

	fpu_reset();
	bzero(&u.U_FLOAT, sizeof (u.U_FLOAT));
	u.u_68881_inuse = 0;
}

/*
 * Simulate vax sigcontext in <signal.h>, but with 680[12]0 stack frame format. 
 * Note that pc and psl are exchanged (they are in vax order).
 */
struct sigctx {
	int		sc_onstack;		/* sigstack state to restore */
	int		sc_mask;		/* signal mask to restore */
	int		sc_sp;			/* user sp to restore */
	union xsf	sc_xsf;			/* extended exception frame */
};						/* with pc and psl exchanged */
#define	sc_pc	sc_xsf.xf0.xsf_psl		/* vax pc position */
#define	sc_psl	sc_xsf.xf0.xsf_pc		/* vax psl position */

/*
 * Args to sigcode, plus eventual arg to sigcleanup, pushed on interrupt stack.
 * sigcode copies the first 3 items to make args to user's handler.
 */
struct sigframe {
	int		sf_sig;			/* signal # */
	int		sf_code;		/* extra hdware code */
	struct sigctx	*sf_sctxp;		/* ptr to sigcontext */
	int		(*sf_handler)();	/* user's handler */
	struct sigctx	*sf_copy_sctxp;		/* arg for sigcleanup */
};

/*
 * Sendsig - Send an interrupt to a process: First sigcode (see locore.s) gets 
 * pushed on the current user stack, for lack of any better place to put it.  
 * Then a max size sigctx structure (an extended sigcontext structure from 
 * <signal.h>) gets pushed on the user stack, to be used by sigcleanup (below)
 * to return to the user state before the interrupt occurred.  After pushing
 * the sigctx structure, we potentially switch to the user's interrupt stack.  
 * We push a sigframe structure, providing the arguments to the signal handler.
 * When we return from here to the user, we will return to the stacked sigcode.
 * After the user's signal handler returns to the sigcode, it will trap to 
 * sigcleanup (below) to finish the job. There is a unique trap #code for each 
 * 680[12]0 stack format to clean up.
 */
sendsig(handler, sig, mask)
int		(*handler)();			/* user's signal handler */
register int	sig;				/* signal number */
int		mask;				/* mask restore */
{
	register caddr_t	sigp;		/* where sigcode goes */
	struct sigctx		sctx;		/* sigctx is built here */
	register struct sigctx	*sctxp;		/* where sigctx goes */
	struct sigframe		sframe;		/* sigframe is built here */
	register struct sigframe *sframep;	/* where sigframe goes */
	register int		*regs;		/* ptr to user's regs */
	u_short			*vec;		/* stack format vector ptr */
	register int		xsfsize;	/* size of xsf stack frame */
	register int		oonstack;	/* old onstack status */
	extern caddr_t		sigcode;	/* sigcode, in locore.s */
	extern int		szsigcode;	/* sizeof sigcode */

#ifdef	SYSV
	/*
	 * If this signal is being delivered to a process which is currently
	 * in UNIVERSE_SYSV, signal stack should not be used.
	 * As the setuniverse and execve system calls remove any trace of
	 * signal stacks when switching to UNIVERSE_SYSV, this routine
	 * need not bother.
	 */
#endif	SYSV

	regs = u.u_ar0;
	oonstack = u.u_onstack;
	if (regs[SP] >= USRSTACK)	/* out of range */
		goto bad;

	if (!u.u_onstack && (u.u_sigonstack & sigmask(sig))) {
		sigp = (char *)(u.u_sigsp - szsigcode);
		u.u_onstack = 1;
	} else
		sigp = (char *)(regs[SP] - szsigcode);
	sctxp = (struct sigctx *)sigp - 1; /* claim space for sigctx */
	sframep = (struct sigframe *)sctxp - 1;

	/*
	 * Must build signal handler context on stack to be returned to so that
	 * sigcleanup (trapped to from sigcode) will pop ps and pc off correct 
	 * stack.  The remainder of the signal state used in calling the handler
	 * must be placed on the stack on which the handler is to operate so 
	 * that the procedure entry code in sigcode will save the registers and
	 * such correctly.
	 */
	if (!oonstack && (u_int)sframep <= USRSTACK - ctob(u.u_ssize)) 
		(void) grow((u_int)sframep);
	if (!useracc((caddr_t)sframep, sizeof (struct sigframe), B_WRITE))
		goto bad;
	if (!u.u_onstack && (u_int)sctxp <= USRSTACK - ctob(u.u_ssize))
		(void) grow((u_int)sctxp);
	if (!useracc((caddr_t)sctxp, sizeof (struct sigctx), B_WRITE))
		goto bad;
	if (copyout(sigcode, sigp, (u_int)szsigcode))
		goto bad;
	sframe.sf_sig = sig;
	if (sig == SIGILL || sig == SIGFPE) {
		sframe.sf_code = u.u_code;
		u.u_code = 0;
	} else
		sframe.sf_code = 0;
	sframe.sf_sctxp = sctxp;
	sframe.sf_handler = handler;

	/*
	 * Duplicate the pointer to the sigctx structure. This one doesn't get 
	 * popped by the rtd, and is used by sigcleanup to reset the signal 
	 * state on inward return.
	 */
	sframe.sf_copy_sctxp = sctxp;

	/* put sigframe structure on user's interrupt stack */
	if (copyout((caddr_t)&sframe, (char *)sframep, (u_int)sizeof(sframe)))
		goto bad;

	/* 
	 * Compute extended exception stack frame size and its sigcode entry
	 */
	sctx.sc_onstack = oonstack;	/* sigctx goes on previous stack */
	sctx.sc_mask = mask;
	sctx.sc_sp = regs[SP];
	vec = (short *)(&((struct esf0 *)(&regs[PC + 1]))->esf_vec);
	switch (*vec & (ESF_FMTMSK & ~ESF_SOFT)) {
	  case ESF_FMT0:		/* sigcode returns via trap #8 */
		xsfsize = XSF_ISIZE0; sigp += 0; break;
	  case ESF_FMT2:		/* sigcode returns via trap #6 */
		xsfsize = XSF_ISIZE2; sigp += 2; break;
	  case ESF_FMT8:		/* sigcode returns via trap #5 */
		xsfsize = XSF_ISIZE8; sigp += 4; break;
	  case ESF_FMT9:		/* sigcode returns via trap #4 */
		xsfsize = XSF_ISIZE9; sigp += 6; break;
	  case ESF_FMTA:		/* sigcode returns via trap #3 */
		xsfsize = XSF_ISIZEA; sigp += 8; break;
	  case ESF_FMTB:		/* sigcode returns via trap #2 */
		xsfsize = XSF_ISIZEB; sigp += 10; break;
	  default:
		panic("Sendsig: bad stack format");
	}

	/* copy appropriate amount of kernel exception stack to local buffer */
	bcopy((caddr_t)&regs[PS], (caddr_t)&sctx.sc_pc, xsfsize);
	sctx.sc_psl = regs[PS];		/* make VAX order pc/psl */
	sctx.sc_pc = regs[PC];		/* make VAX order pc/psl */

	/* copy local sigctx to previous user stack */
	if (copyout((char *)&sctx, (char *)sctxp, (u_int)sizeof(sctx)))
		goto bad;

	/* 
	 * If we have a long frame, mark it so locore will collapse it to a 
	 * short 4-word frame to enter user sigcode.
	 */
	if (xsfsize != XSF_ISIZE0)	/* tell locore to collapse stack */
		*vec |= ESF_SOFT;	/* use illegal stack format bit */
	regs[SP] = (int)sframep;
	regs[PC] = (int)sigp;
	return;

bad:	sendill();
}

sigreturn(){}				/* KLUDGE 4.3 */

/*
 * Routine to cleanup state after a longjmp or signal has been taken. This is 
 * entered via trap #{8,7,6,5,4,3,2} which generates a negative syscall 
 * {-2,-1,-3,-4,-5,-6,-7}, one code per 680[12]0 exception stack format. User 
 * stack top is ptr to sigctx placed by Sendsig. Reset signal mask and stack 
 * state from sigctx, then fake a vax rei.
 */
sigcleanup(code)
int	code;		/* negative syscall code */
{
	struct sigctx		sctx;		/* local sigcontext buffer */
	register struct sigctx	*sctxp;		/* addr of user sigcontext */
	register struct proc	*p = u.u_procp;	/* current process */
	register u_int		sp;
	register u_int		ulen;		/* sizeof sigcontext struct */
	register u_short	fmt;		/* xsf stack format */
	register int		xsfsize;	/* size of xsf stack frame */

	if (code == -1)			/* longjmp cleanup */
		ulen = 5*4;		/* sizeof vax sigcontext cleanup */
	else
		ulen = sizeof(sctx);	/* sizeof 680[12]0 max sigcontext */

	sctxp = (struct sigctx *)fuword((caddr_t)u.u_ar0[SP]);
	if ((int)sctxp == -1)
		goto bad;
	if (!useracc((caddr_t)sctxp, ulen, B_WRITE))
		goto bad;
	/* get user's sigctx structure */
	if (copyin((caddr_t)sctxp, (caddr_t)&sctx, ulen))
		goto bad;
	u.u_onstack = sctx.sc_onstack & 01;
	p->p_sigmask = 
		sctx.sc_mask &~ (sigmask(SIGKILL)|sigmask(SIGCONT)|sigmask(SIGSTOP));
	sp = sctx.sc_sp;

	/* compute size of xsf stack frame */
	fmt = sctx.sc_xsf.xf0.xsf_esf.esf_vec & (ESF_FMTMSK & ~ESF_SOFT);
	xsfsize = -1;
	switch(code) {
	  case -1:		/* trap #7 longjmp cleanup */
		sp += 8;	/* pop pc and psl in fake sigcontext */
		xsfsize = 0;	/* don't copy user sigcontext */
		break;
	  case -2:		/* trap #8 xsf format 0 signal cleanup */
		if (fmt == ESF_FMT0)
			xsfsize = XSF_ISIZE0;
		break;
	  case -3:		/* trap #6 xsf format 2 signal cleanup */
		if (fmt == ESF_FMT2)
			xsfsize = XSF_ISIZE2;
		break;
	  case -4:		/* trap #5 xsf format 8 signal cleanup */
		if (fmt == ESF_FMT8)
			xsfsize = XSF_ISIZE8;
		break;
	  case -5:		/* trap #4 xsf format 9 signal cleanup */
		if (fmt == ESF_FMT9)
			xsfsize = XSF_ISIZE9;
		break;
	  case -6:		/* trap #3 xsf format A signal cleanup */
		if (fmt == ESF_FMTA)
			xsfsize = XSF_ISIZEA;
		break;
	  case -7:		/* trap #2 xsf format B signal cleanup */
		if (fmt == ESF_FMTB)
			xsfsize = XSF_ISIZEB;
		break;
	  default:
		goto bad;
	}
	if (xsfsize == -1)	/* user changed the stack format */
		goto bad;
	if (xsfsize > 0)	/* user's sigcontext is in vax order */
		bcopy((char *)&sctx.sc_pc, (char *)&u.u_ar0[PS], xsfsize);

	/* 
	 * now fake a vax rei, then pop the sigcode off user stack.
	 */
	u.u_ar0[PC] = sctx.sc_pc;	/* get pc from VAX order sigcontext */
	u.u_ar0[PS] = sctx.sc_psl;	/* get psl from VAX order sigcontext */
	u.u_ar0[PS] |= PSL_USERSET;	/* ensure return to user mode */
	u.u_ar0[PS] &= ~PSL_USERCLR;
	u.u_ar0[SP] = sp;
	return;

bad:	sendill();
}

/* proc trashed its stack, zap it */
sendill()
{
	register int sig;

	u.u_signal[SIGILL] = SIG_DFL;
	sig = sigmask(SIGILL);
	u.u_procp->p_sigignore &= ~sig;
	u.u_procp->p_sigcatch &= ~sig;
	u.u_procp->p_sigmask &= ~sig;
	psignal(u.u_procp, SIGILL);
}

int tout_cpu;
static int cpu_tout()
{
	tout_cpu = 1;
}

prcpuspeed()
{
	register u_int i, j, k;

	timeout(cpu_tout, (caddr_t)0, 4*hz);
	spl0();
	i = SELFTIME();
	spl7();
	j = i/DIVIDER;
	if ((i % DIVIDER) >= (DIVIDER/2))
		j++;
	cpuspeed = i / 4000000;
	if ((i % 4000000) >= 1000000)
		cpuspeed++;
	if (j < 16) {
		printf(" <16");
	} else if (j < 18) {
		printf("16.67");
	} else if (j < 21) {
		printf("20.0");
	} else if (j < 26) {
		printf("25.0");
	} else {
		printf(" >25.0");
	}
#ifdef M68020
	printf("MHz MC68020 CPU");
#else  M68020
	printf("MHz MC68030 CPU");
#endif M68020

	if (have68881())
		printf(" with MC68881 Floating-Point Coprocessor");
	printf("\n");
}

int want_parity = 1;
memenable()
{

#ifdef	M68030
	memconfig();
#endif	M68030

#ifndef VQX
	if (want_parity) {
		printf("Parity Enabled\n");
		parityon();
	} else {
		printf("Parity NOT Enabled\n");
		parityoff();
	}
#endif VQX
}

int	waittime = -1;

boot(paniced, arghowto)
	int paniced, arghowto;
{
	register struct buf *bp;
	int iter, nbusy0, nbusy1;

#if	DEBUGGER
	if (paniced != RB_BOOT)
		trap15();
#endif	DEBUGGER
/*	bufertrace();	/* */
/*	sleeptrace();	/* */
/*	stacktrace();	/* */
	(void) spl0();
	howto = arghowto;
	devtype = rootdev;
	if ((howto&RB_NOSYNC)==0 && waittime < 0 && bfreelist[0].b_forw) {
		waittime = 0;
		/*
		 * Release vnodes held by texts before update.
		 */
		xumount(NODEV);
		update();
		if (diskless)
			printf("syncing server... ");
		else 
			printf("syncing disks... ");
		nbusy0 = 100000;
		for (iter = 0; iter < 20; iter++) {
			nbusy1 = 0;
			for (bp = &buf[nbuf]; --bp >= buf; )
				if ((bp->b_flags & (B_BUSY|B_INVAL)) == B_BUSY)
					nbusy1++;
			if (nbusy1 == 0)
				break;
			if (nbusy1 < nbusy0) {
				printf("%d ", nbusy1);
				nbusy0 = nbusy1;
				iter = 0;
			}
			DELAY(4000 * iter);
		}
		DELAY(4000);
		printf("...done\n");
		/*
		 * If we've been adjusting the clock, the todr
		 * will be out of synch; adjust it now.
		 */
		resettodr();
		DELAY(4000);
	}
#ifdef	TRFS
	/* Tell others we are gone... */
	TrfsShutdown();
#endif	TRFS
	ifqbreset(0);			/* reset network interfaces */
	DELAY(8000);
	spl7();
	if (howto&RB_HALT) {
		printf("halting (in tight loop); hit RESET\n\n");
		for (;;)
			;
	} else if (paniced == RB_PANIC)
		doadump();
	DELAY(800000);		/* let graphics screen finish scroll! */
	_reboot();
	/*NOTREACHED*/
}

/*
 * Return the best possible estimate of the time in the timeval
 * to which tvp points.  We do this by reading the interval count
 * register to determine the time remaining to the next clock tick.
 * We must compensate for wraparound which is not yet reflected in the time
 * (which happens when the ICR hits 0 and wraps after the splhigh(),
 * but before the mfpr(ICR)).  Also check that this time is no less than
 * any previously-reported time, which could happen around the time
 * of a clock adjustment.  Just for fun, we guarantee that the time
 * will be greater than the value obtained by a previous call.
 */
microtime(tvp)
	register struct timeval *tvp;
{
#ifdef	vax
	int s = splhigh();
	static struct timeval lasttime;
	register long t;

	*tvp = time;
	t =  mfpr(ICR);
	if (t < -tick / 2 && (mfpr(ICCS) & ICCS_INT))
		t += tick;
	tvp->tv_usec += tick + t;
	if (tvp->tv_usec > 1000000) {
		tvp->tv_sec++;
		tvp->tv_usec -= 1000000;
	}
	if (tvp->tv_sec == lasttime.tv_sec &&
	    tvp->tv_usec <= lasttime.tv_usec &&
	    (tvp->tv_usec = lasttime.tv_usec + 1) > 1000000) {
		tvp->tv_sec++;
		tvp->tv_usec -= 1000000;
	}
	lasttime = *tvp;
	splx(s);
#else	vax
	uniqtime(tvp);
#endif	vax
}

uniqtime(tv)					/* NFS: */
	register struct timeval *tv;
{
	static struct timeval lasttime;
	static int uniq;

	while (lasttime.tv_usec != time.tv_usec || 
	    lasttime.tv_sec != time.tv_sec) {
		lasttime = time;
		uniq = 0;
	}
	*tv = lasttime;
	tv->tv_usec += uniq++;
}

physstrat(bp, strat, prio, locked, rawio)
	register struct buf *bp;
	int (*strat)(), prio;
{
	register struct buf *bbp;

	/* pageout daemon doesn't wait for pushed pages */
	if (bp->b_flags & B_DIRTY)
		(*strat)(bp);
	else {
	    if (
#ifdef	TRFS
	        u.u_tclient  ||
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
		server() ||
#endif	defined(SYSV) && defined(RFS)
		(qbaddrcontig(bp, rawio) != bp->b_bcount)) {
		if (locked) {
		    vsunlock(bp->b_un.b_addr, bp->b_bcount, bp->b_flags&B_READ);
		    locked = 0;
		}
		bbp = (struct buf *)getqeblk(bp->b_bcount, BQUALIFY(bp->b_dev));
		bbp->b_dev = bp->b_dev;
		bbp->b_blkno = bp->b_blkno;
		bbp->b_flags |= (bp->b_flags & (B_READ|B_WRITE));
		if ((bp->b_flags & B_READ) == B_WRITE)
			copyin(bp->b_un.b_addr, bbp->b_un.b_addr, bp->b_bcount);
		(*strat)(bbp);
		biowait(bbp);
		if ((bp->b_flags & B_READ) && (bp->b_bcount - bbp->b_resid) > 0)
			copyout(bbp->b_un.b_addr, bp->b_un.b_addr, 
				bp->b_bcount-bbp->b_resid);
		bp->b_resid = bbp->b_resid;
		bp->b_flags |= (bbp->b_flags & B_ERROR)|B_DONE;
		bp->b_error = bbp->b_error;
		bbp->b_dev = NODEV;
		bfree(bbp);
		brelse(bbp);
	    } else {
		(*strat)(bp);
		biowait(bp);
	    }
	}
	return locked;
}

stacktrace (arg0, arg1)
	int arg0, arg1;
{
#ifdef STACKTRACE
	register struct frame *fp = ((struct frame *)&arg1) - 1;
	register struct frame *nextfp;
	register i = 0, j;
	int s;

	s = spl6();
	if ((caddr_t)fp < (caddr_t)&u  ||  
	    ((caddr_t)fp + sizeof(struct frame)) > (caddr_t)&u + UPAGES*NBPG) {
		printf("stacktrace: illegal initial fp %x\n", fp);
		splx(s);
		return;
	}
	printf("Stacktrace:	PC		FP       ARGS\n");
	for (nextfp = (struct frame *)fp->fr_savfp;  ((int)nextfp & 1) == 0  &&
	     nextfp > fp  &&  (caddr_t)nextfp > (caddr_t)&u && 
	     ((caddr_t)nextfp + sizeof(struct frame)) < (caddr_t)&u + UPAGES*NBPG;
	     nextfp = (struct frame *)fp->fr_savfp) {
		fp = nextfp;
		printf("%a 	%8x ", fp->fr_savpc, fp->fr_savfp);
		for (j = 0 ; j < stacktrace_args ; j++)
			printf("%c%x", j?',':'(', fp->fr_arg[j]);
		printf(")\n");
		if (stacktrace_depth && ++i > stacktrace_depth) {
			printf("    ...\n");
			break;
		}
	}
	splx(s);
#endif STACKTRACE
}

bufertrace()
{
#ifdef BUFFERTRACE
	register struct buf *dp, *bp;
	char *bqname[BQUEUES];
	int i, j;
	int s;

	s = spl6();
	bqname[BQ_LOCKED] = "LOCKED";
	bqname[BQ_LRU] = "LRU";
	bqname[BQ_AGE] = "AGE";
	bqname[BQ_EMPTY] = "EMPTY";
	for (i=0,j=0 ; i < BQUEUES ; i++) {
		dp = &bfreelist[i];
		printf("FREE QUEUE %s %x :\n	",bqname[i],dp);
		for (bp = dp->av_forw ; bp != dp ; bp = bp->av_forw) {
			printf("(%x %b %x) ",bp, bp->b_flags, B_FLAGS_BITS, bp->b_bufsize);
			if ((++j)%2 == 0)
				printf("\n	");
		}
		printf("\n");
	}
	for (i=0 ; i < BUFHSZ ; i++) {
		dp = (struct buf*) &bufhash[i];
		if (dp->b_forw == dp || dp->b_forw == 0)
			continue;
		j = 0;
		printf("CACHE HASH %d %x :\n	",i,dp);
		for (bp = dp->b_forw ; bp != dp ; bp = bp->b_forw) {
			printf("(%x %b %x) ",bp, bp->b_flags, B_FLAGS_BITS, bp->b_bufsize);
			if ((++j)%2 == 0)
				printf("\n	");
		}
		printf("\n");
	}
	splx(s);
#endif BUFFERTRACE
}

#define	ARGBUF		((char *)0x700+SYSV_BASE)
#define	ARGBUFSIZE	(0x100 - 0x10)
char *
strarg(p)
	register char *p;
{
	register char *q = ARGBUF;
	register int len = strlen(p);
	register int nleft = ARGBUFSIZE - len - 2;

	q[-1] = 0;
	while (--nleft >= 0) {
		switch (q[-1]) {
		  case '\0': case ' ': case '\t': case '\n': case '\r':
			break;
		  default:
			q++;
			continue;
		}
		if (strncmp(p, q, len) == 0  &&  q[len] == '=') {
			q = p = &q[len + 1];
			while (--nleft >= 0)
				switch (*p++) {
				  case '\0': case ' ': case '\t': case '\n':
				  case '\r':
					*--p = '\0';
					return q;
				}
			*--p = '\0';
			return q;
		}
		q++;
	}
	return (char *)0;
}

/*
 * Given a string atob() will return a number in *iptr.  This routine
 * is different from atoi() in the following ways.
 * 1) It will return 1 if there was some sort of conversion error.
 * 2) If the string starts with 0x the base is set to 16.  If the string
 *    starts with just 0 it will be base 8 else base 10.
 */
atob (buf, iptr)
	char *buf;
	int *iptr;
{
	int c, base, num;

	*iptr = 0;
	num = 0;
	if (buf == NULL)
	  return (1);
	if (*buf == '0') {
		if (*(buf + 1) == 'x') {
			base = 16;
			buf++;
		}
		else
		  base = 8;
		buf++;
	}
	else
	  base = 10;

	while (*buf != '\0') {
		c = *buf;
		if (c >= 'A' && c <= 'F')
		  c = c - 'A' + 'a'; /* convert to lower */
		if (c >= 'a' && c <= 'f')
		  num = num * base + c - 'a' + 10;
		else if (c >= '0' && c <= '9')
		  num = num * base + c - '0';
		else
		  return (1);
		buf++;
	}

	*iptr = num;
	return (0);
}
