/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)locore.s	6.36 (Berkeley) 3/12/86
 */
#define	STK_XPAGE_BUG
#define FP_68881	/* comment to disable 68881 save/restore on switch */
/*#define KPROF	0x10000	/* enable kernel profiling */

#include "errno.h"
#include "param.h"
#include "psl.h"
#include "pte.h"
#include "pcb.h"
#include "m68k.h"
#include "trap.h"
#include "scb.h"
#include "board.h"
#include "../is68kdev/sioreg.h"
#include "../is68kdev/qbvar.h"
#include <syscall.h>
#ifdef	SYSV
#include "../sysv/sys/filehdr.h"
#endif	SYSV

/* DEVICE SPECIFIC */
#include "gp.h"				/* VMEBUS */
#include "vb.h"				/* VMEBUS */
#include "nw.h"				/* VMEBUS */

/*
 *	Debug trace skeleton and flags:
 *		TRACE(<ea>)
 *		Printn(reg, scratch_D_reg, scratch_D_reg, scratch_A_reg)
 */
#define	TXW		movl d0,msp; 9: movsb SR_A+OCTART_ADDR,d0; \
			btst #2,d0; jeq 9b; movl msp,d0
#define	TRACE(x)	TXW; movl d0,msp; movb x,d0; \
			movsb d0,THR_A+OCTART_ADDR;movl msp,d0
#define	PN(X,Y,Z)	roll #4,X; movb X,Y; andw #0xF,Y; TRACE(Z@(0,Y:w))
#define	Printn(W,X,Y,Z) movl #N2C,X;andl #0xFFFFFFF,X;movl X,Z;movl W,X; \
			TRACE(#0x7b);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z); \
			PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);TRACE(#0x7d)

	.globl	_vme_short
	.globl	_vme_std
	.globl	_vme_stdio
	.globl	_vme_ext
	.globl	_vbmatm_reg
	.set	_vme_short,VME_SHORTIO
	.set	_vme_std,VME_STANDARD
	.set	_vme_stdio,VME_STANDARD
	.set	_vme_ext,VME_EXTENDED
	.set	_vbmatm_reg,VBMATM_REG

/*
 * System page table, must begin on a 16 byte boundary
 * The 0x1000000 forces all page tables to be not in
 * the system transparent translation region.  
 * The page tables must be cache inhibited.
 * So mapped it through V_EQ_R region.
 * If cache is of no consideration, then the constant
 * VEQR_ADDR can be removed.  Also refer to vm_machdep.30.c.
 */
#define	vaddr(x)	(((((x)-_Sysmap)/4)*NBPG)+SYSV_BASE)
	.set	pteindx,	(VEQR_CI_ADDR + NBPG)

	.align	2
#define	SYSMAP(mname, vname, npte)					\
	.globl	_/**/mname;						\
	.globl	_/**/vname;						\
	.set	_/**/mname,	pteindx;				\
	.set	_/**/vname,	vaddr(_/**/mname);			\
	.set    pteindx,        pteindx + ((npte) * 4);

	SYSMAP(Sysmap		,Sysbase	,SYSPTSIZE )
	SYSMAP(Usrptmap		,usrpt		,USRPTSIZE )
	SYSMAP(Umap		,u		,UPAGES )
	SYSMAP(Forkmap		,forkutl	,UPAGES )
	SYSMAP(Xswapmap		,xswaputl	,UPAGES )
	SYSMAP(Xswap2map	,xswap2utl	,UPAGES )
	SYSMAP(Swapmap		,swaputl	,UPAGES )
	SYSMAP(Pushmap		,pushutl	,UPAGES )
	SYSMAP(Vfmap		,vfutl		,UPAGES )
	SYSMAP(CMAP1		,CADDR1		,1 )
	SYSMAP(CMAP2		,CADDR2		,1 )
	SYSMAP(mcrmap		,mcr		,1 )
	SYSMAP(mmap		,vmmap		,1 )
	SYSMAP(msgbufmap	,msgbuf		,MSGBUFPTECNT )
	SYSMAP(camap		,cabase		,16*CLSIZE )
	SYSMAP(ecamap		,calimit	,0 )
	SYSMAP(Mbmap		,mbutl		,NMBCLUSTERS*CLSIZE+CLSIZE )
#ifndef	is68k_kobj
#if	NGP > 0
	SYSMAP(vidbufmap	,vidbuf    	,NGP*((1024*1024)/NBPG))
#endif	NGP > 0
#if	NVB > 0
	SYSMAP(vbmap		,vb		,(256*1024)/NBPG)
#endif	NVB > 0
#if	NNW > 0
	SYSMAP(nwmap0		,nw0		,(256*1024)/NBPG)
	SYSMAP(nwmap1		,nw1		,(256*1024)/NBPG)
#endif	NNW > 0
#endif	is68k_kobj
	SYSMAP(usrdevmap	,usrdev		,(1024*1024)/NBPG)
	SYSMAP(eSysmap		,esysmap	,0 )

	.globl	_Syssize
	.set	_Syssize,(_eSysmap - _Sysmap) / 4

#define	PSL_IPLN	PSL_IPL2	/* must be higher than PSL_IPLC */
#define	PSL_IPLS	PSL_IPL2	/* must be higher than PSL_IPLC */
#define	PSL_IPLC	PSL_IPL1

/*
#define	CACHE_ON (ICACHE_CLEAR|ICACHE_ENABLE|DCACHE_CLEAR|DCACHE_ENABLE|DCACHE_WA|ICACHE_BURST|DCACHE_BURST)
*/
#define	CACHE_ON (ICACHE_CLEAR|ICACHE_ENABLE|DCACHE_CLEAR|DCACHE_ENABLE|DCACHE_WA)
#define	CACHE_OFF ICACHE_CLEAR|DCACHE_CLEAR

#define INITSCR (SCR_INTR_ENAB|SCR_LED_OFF|SCR_PROM_DISAB|SCR_VME_SYSFAIL|SCR_CACHE_ENAB)

#define	SCRATCH_STACK	NBPG		/* before pte's */

	.text
	.globl	start 

/*
 * Initialization.
 * The code between here and startinit assumes:
 *	.  kernel is mapped virtual equal to real
 *	.  the upper nibble of the address is ignored
 *	   by the CPU, i.e. 0x40000000 == 0x00000000
 */
start:	movw	#PSL_IPL7,sr		/* make sure interrupts are disabled */
	movl	#SCRATCH_STACK+SYSV_BASE,sp	/* temporary stack */

	 /*
         * Set up scb so if we trap out we end up in the PROM, for DEBUG.
         */
        lea     SYSV_BASE,a0
        movl    a0,vb                   /* set vector base register to 0 */
        clrl    a0@+
        clrl    a0@+
        movw    #NSCBVEC-1-2,d0
        lea     __reboot,a1
    1:  movl    a1,a0@+
        dbra    d0,1b

	movl    #FC_ALT,d0
	movl	d0,sfc			/* set source/destination function */
	movl	d0,dfc			/* code to alternate space */

	movw	#SCR_CACHE_CLEAR|SCR_PROM_DISAB|SCR_VME_SYSFAIL,d0
	movsw	d0,SCR_ADDR
	movw	#SCR_PROM_DISAB|SCR_VME_SYSFAIL,d0
	movsw	d0,SCR_ADDR
	movl	#ICACHE_CLEAR|ICACHE_ENABLE,d0
	movl	d0,cac			/* clear and enable cache */

	/*
	 * Size and zero memory, starting at _edata.
	 * This is assuming the system is loaded at SYSV_EQ_R.
	 * This will clear kernel BSS.
	 */
	movl	vb,a1
	movl	a1@(SCB_BUSERR),d1		/* save buserr vec */
	movl	#2f,d0
	movl	d0,a1@(8)
	movl	#_edata,a0
	subl	#SYSV_BASE,a0
    1:	cmpl	#MAXPHYSMEM,a0
	jge	2f
	clrl	a0@
	tstl	a0@+
	jeq	1b			/* clear until bus error */

    2:	movl	d1,a1@(SCB_BUSERR)	/* restore buserr vec */
	movl	a0,d1
	movl	#PGSHIFT,d0
	lsrl	d0,d1			/* save the size of memory in d1 */

	/*
	 * Initialize the kernel virtual equal to real region
	 * by programming tt0.  This region includes kernel code,
	 * data, and bss.
 	 */
	movl	_cacr,d0
	movl	d0,cac			/* clear and enable cache */
	lea	_systt,a1
	pmove	a1@,mmutt0
	lea	_fc3tt,a1			/* turn off tt1 */
	pmove	a1@,mmutt1

	/*******************************************************************
	 * Now able to reference kernel link space (system virtual) memory *
	 *******************************************************************/
	subl	_detachedmem,d1
	movl	d1,_maxmem
	movl	d1,_physmem
	movl	d1,_freemem
	movl	d7,_howto		/* PROM arguments: how to boot */
	movl	d6,_devtype		/* major number of boot device */

	/*
         * copy the template scb to vector base region (location 0).
         */
        movl    vb,a1
        clrl    a1@+
        movl    #0x4e4f4e4f,a1@+        /* trap #15, trap #15 catch jump 0 */
        lea     _scb+(2*4),a0
        movw    #NSCBVEC-2-1,d0
    1:  movl    a0@+,a1@+
        dbra    d0,1b

#ifdef	STK_XPAGE_BUG
	movl	vb,a0
	movl	a0,_rupt_table
	movl	#_xbug_disp_pad,d0
	addl	#3,d0			/* long align dispatch code */
	andl	#0xfffffffc,d0
	movl	#_xbug_scb,d1		/* long	align xbug_scb */
	addl	#3,d1
	andl	#0xfffffffc,d1
	movl	d1,a0
	movl	a0,vb			/* point vb to intermediate dispatch */
	movw	#NSCBVEC-1,d1		/* stuff dispatch table */
     1: movl	d0,a0@+
	dbra	d1,1b
	movl	xbug_codesize,sp@-
	movl	d0,sp@-
	movl	#_xbug_code,sp@-
	jsr	_bcopy			/* bcopy(bugcode, bug_disp, codesize) */
	addl	#12,sp
#endif	STK_XPAGE_BUG

	movw	_scr,d0
	movsw	d0,SCR_ADDR
	jsr	_startinit
	lea	_u+(UPAGES*NBPG),sp	/* set stack pointer to top of _u */
	movl	d0,sp@-

	TRACE(#0xA); TRACE(#0xD);	/* Output "\n" */

	.globl	_START
_START:	jsr	_main
	addl	#4,sp

	lea	NBPG,a0
	movl	a0,usp
	movw	#0,sp@-
	pea	0			/* user pc */
	movw	#PSL_USERSET,sp@-
	rte				/* go run icode */

/*
	.globl	_DELAY
_DELAY:	movl	_cpuspeed,d1
    1:	movl	sp@(4),d0
    2:	dbf	d0,2b
	addw	#1,d0
	subl	#1,d0
	jge	2b
	dbf	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	rts
*/


	.globl	_DELAY
_DELAY:	
	movl	sp@(4),d1
	tstl	d1
	jeq	4f
    1:	movl	_cpuspeed,d0
    2:	tstl	_tout_cpu
	bra	3f
	nop
    3:	subl	#1,d0
	jne	2b
	subl	#1,d1
	jne	1b
    4:	rts

	.globl	_SELFTIME
_SELFTIME:
	clrl	d0
    1:	tstl	_tout_cpu
	beq	2f
	bra	3f
    2:	addl	#1,d0
	bra	1b
    3:	rts

	.globl	_trigger
_trigger:
	movl	sp@(4),a0
	addl	#NVRAM_ADDR,a0
	movl	sp@(8),d0
	movsl	d0,a0@
	rts

	.globl	_flush_dcache_entry
_flush_dcache_entry:
	movl	sp@(4),a0		/* get address */
	movl	sp@(8),d0		/* get count */
    	jle	3f
	cmpl	#100,d0
	jle	1f
	movl	cac,d0
	orl	#DCACHE_CLEAR,d0
	movl	d0,cac
	jra	3f
	
    1:  movl	a0,caa
	movl	cac,d1
	orl	#DCACHE_CE,d1
	movl	d1,cac
	addl	#4,a0
	subl	#4,d0
	jgt	1b
    3:  rts

	.globl	_flush_ext_cache_entry
_flush_ext_cache_entry:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	andl	#SCR_CACHE_ENAB,d0
	movw	d1,sr
	tstl	d0
	jeq	3f
	movl	sp@(4),a0		/* get address */
	movl	sp@(8),d1		/* get count */
	jle	3f
    1:  movsw	d0,a0@
	addl	#16,a0
	subl	#16,d1
	jgt	1b
    3:	rts

	.globl	_tbia
_tbia:
	pflusha
	rts

	.globl	_tbis
_tbis:
	movl	sp@(4),a0
	pflush	#0,#0,a0@
	rts

	.globl	_getvbr
_getvbr:
	movl	vb,d0
	rts

	.globl	_getcacr
_getcacr:
	movl	cac,d0
	rts

	.globl	_loadmmu
_loadmmu:
	movl	sp@(4),d0
	movl	sp@(8),a0
	cmpl	#MMUCRP,d0
	jne	1f
	pmove	a0@,mmucrp
	rts
1:	cmpl	#MMUSRP,d0
	jne	1f
	pmove	a0@,mmusrp
	rts
1:	cmpl	#MMUTC,d0
	jne	1f
	pmove	a0@,mmutc
	rts
1:	cmpl	#MMUSR,d0
	jne	1f
	pmove	a0@,mmusr
	rts
1:	cmpl	#MMUTT0,d0
	jne	1f
	pmove	a0@,mmutt0
	rts
1:	cmpl	#MMUTT1,d0
	jne	2f
	pmove	a0@,mmutt1
2:
	rts
	
	.globl	_getmmu
_getmmu:
	movl	sp@(4),d0
	movl	sp@(8),a0
	cmpl	#MMUCRP,d0
	jne	1f
	pmove	mmucrp,a0@
	rts
1:	cmpl	#MMUSRP,d0
	jne	1f
	pmove	mmusrp,a0@
	rts
1:	cmpl	#MMUTC,d0
	jne	1f
	pmove	mmutc,a0@
	rts
1:	cmpl	#MMUSR,d0
	jne	1f
	pmove	mmusr,a0@
	rts
1:	cmpl	#MMUTT0,d0
	jne	1f
	pmove	mmutt0,a0@
	rts
1:	cmpl	#MMUTT1,d0
	jne	2f
	pmove	mmutt1,a0@
2:	rts
	
	.globl	_blink_led
_blink_led:			/* blink the error led */
	movw	sr,d1
	movw	d1,a0
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	movw	d0,d1
	andl	#~SCR_LED_OFF,d1
	andw	#SCR_LED_OFF,d0
	eorw	#SCR_LED_OFF,d0
	orw	d0,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	movw	a0,d1
	movw	d1,sr
	rts
/*
 * read/write byte/word/long to alternate function code space
 */
	.globl	_afcrb,_afcwb,_afcrw,_afcww,_afcrl,_afcwl
_afcrb:
	movl	sp@(4),a0
	clrl	d0
	movsb	a0@,d0
	rts

_afcrw:
	movl	sp@(4),a0
	clrl	d0
	movsw	a0@,d0
	rts

_afcrl:
	movl	sp@(4),a0
	movsl	a0@,d0
	rts

_afcwb:
	movl	sp@(4),a0
	movl	sp@(8),d0
	movsb	d0,a0@
	rts

_afcww:
	movl	sp@(4),a0
	movl	sp@(8),d0
	movsw	d0,a0@
	rts

_afcwl:
	movl	sp@(4),a0
	movl	sp@(8),d0
	movsl	d0,a0@
	rts

	.globl	_ext_cache_on
_ext_cache_on:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	andl	#~SCR_CACHE_ENAB,d0
	orw	#SCR_CACHE_CLEAR,d0
	movsw	d0,SCR_ADDR
	andl	#~SCR_CACHE_CLEAR,d0
	orw	#SCR_CACHE_ENAB,d0
	movsw	d0,SCR_ADDR
	movw	d0,_scr
	movw	d1,sr
	rts

	.globl	_ext_cache_off
_ext_cache_off:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	andl	#~SCR_CACHE_ENAB,d0
	movsw	d0,SCR_ADDR
	movw	d0,_scr
	movw	d1,sr
	rts

/*
 * Flush external and internal data cache
 */
	.globl	_flush_all_caches
_flush_all_caches:
	movw	sr,d1
	movw	d1,a0
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	movl	d0,d1
	andl	#~SCR_CACHE_ENAB,d0
	orw	#SCR_CACHE_CLEAR,d0
	movsw	d0,SCR_ADDR
	movsw	d1,SCR_ADDR
	movw	a0,d1
	movw	d1,sr
/*
 * Flush internal data cache
 */
	.globl	_flush_dcache
_flush_dcache:
	movl	cac,d0
	orl	#DCACHE_CLEAR,d0
	movl	d0,cac
	rts

	.globl	_vme_int_enable,_vme_int_disable
_vme_int_enable:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	orw	#SCR_VME_INT_ENAB,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	movw	d1,sr
	rts

_vme_int_disable:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	andw	#~SCR_VME_INT_ENAB,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	movw	d1,sr
	rts

	.globl	_fpu_enable,_fpu_reset
_fpu_enable:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	orw	#SCR_FPU_USE,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	movw	d1,sr
	rts

_fpu_reset:
	tstb	_u+U_68881_INUSE	/* is 68881/2 being used */
	jeq	1f
	lea	_u+U_68881_STATE,a0
	fsave	a0@			/* save state frame */
	tstb	a0@			/* if null, dont save registers */
	beq	1f
	lea	_u+U_68881_REGS,a0
	fmovemx	#<f0-f7>,a0@		/* save programmers model */
	addl	#8*12,a0
	fmoveml	#<fpcr,fpsr,fpiar>,a0@
	clrb	_u+U_68881_INUSE	/* is 68881/2 being used */
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	andw	#~SCR_FPU_USE,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	movw	d1,sr
    1:
	rts

/*
 * Initialize software copy of VSB memory configuration registers
 */
	.globl	_memconfig
_memconfig:
	movml	#<d2,d3,d4,d5,d6,a2>,sp@-
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#vsbmembase,a0
    2:	movw	#0xffff,a0@+
	dbra	d0,2b
	movl	vb,a2
	movl	a2@(SCB_BUSERR),d6
	movl	sp,d5

	clrl	d1			/* initialize base address */
/*
 * configure all 16 meg boards.
 */
	movl	#vsbmembase,a0
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#8f,a2@(SCB_BUSERR)
    1:	clrl	d2
	movsw	a1@,d2			/* read ISVSBM status register */
	cmpw	#0xffff,d2
	jeq	2f
	jra	9f			/* the board responds */
    8:	movl	d5,sp			/* buserror, reset stack */
	jra	2f
    9:	movl	d2,d3			/* see if memory board */
	andl	#VSB_ID_MASK,d3		/* get board id */	
	movl	#VSB_ID_SHFT,d4
	lsrl	d4,d3
	cmpl	#VSB_ID_MEM,d3
	jne	2f
	andl	#VSB_MEM_SIZE_MASK,d2	/* get memory size */
	movl	#VSB_MEM_SIZE_SHFT,d3
	lsrl	d3,d2
	cmpl	#VSB_MEM_SIZE_16MEG,d2
	jne	2f
	addl	#1,d2			/* adjust for size start at 0 */
    	movl	d1,d3			/* set up base address */
	andl	#VSB_MEM_BASE_MASK,d3	
	movw	d3,a0@
	addl	d2,d1			/* calc base address for next board */
    2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0
	dbra	d0,1b

/*
 * configure all 8 meg boards.
 */
	movl	#vsbmembase,a0
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#8f,a2@(SCB_BUSERR)
    1:	clrl	d2
	movsw	a1@,d2			/* read ISVSBM status register */
	cmpw	#0xffff,d2
	jeq	2f
	jra	9f			/* the board responds */
    8:	movl	d5,sp			/* buserror, reset stack */
	jra	2f
    9:	movl	d2,d3			/* see if memory board */
	andl	#VSB_ID_MASK,d3		/* get board id */	
	movl	#VSB_ID_SHFT,d4
	lsrl	d4,d3
	cmpl	#VSB_ID_MEM,d3
	jne	2f
	andl	#VSB_MEM_SIZE_MASK,d2	/* get memory size */
	movl	#VSB_MEM_SIZE_SHFT,d3
	lsrl	d3,d2
	cmpl	#VSB_MEM_SIZE_8MEG,d2
	jne	2f
	addl	#1,d2			/* adjust for size start at 0 */
    	movl	d1,d3			/* set up base address */
	andl	#VSB_MEM_BASE_MASK,d3	
	movw	d3,a0@
	addl	d2,d1			/* calc base address for next board */
    2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0
	dbra	d0,1b

/*
 * configure all 4 meg boards.
 */
	movl	#vsbmembase,a0
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#8f,a2@(SCB_BUSERR)
    1:	clrl	d2
	movsw	a1@,d2			/* read ISVSBM status register */
	cmpw	#0xffff,d2
	jeq	2f
	jra	9f			/* the board responds */
    8:	movl	d5,sp			/* buserror, reset stack */
	jra	2f
    9:	movl	d2,d3			/* see if memory board */
	andl	#VSB_ID_MASK,d3		/* get board id */	
	movl	#VSB_ID_SHFT,d4
	lsrl	d4,d3
	cmpl	#VSB_ID_MEM,d3
	jne	2f
	andl	#VSB_MEM_SIZE_MASK,d2	/* get memory size */
	movl	#VSB_MEM_SIZE_SHFT,d3
	lsrl	d3,d2
	cmpl	#VSB_MEM_SIZE_4MEG,d2
	jne	2f
	addl	#1,d2			/* adjust for size start at 0 */
    	movl	d1,d3			/* set up base address */
	andl	#VSB_MEM_BASE_MASK,d3	
	movw	d3,a0@
	addl	d2,d1			/* calc base address for next board */
    2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0
	dbra	d0,1b
	movl	d6,a2@(SCB_BUSERR)		/* restore buserror vector */
	movml	sp@+,#<d2,d3,d4,d5,d6,a2>
	rts
/*
 * Configure all memory boards with parity on
 */
	.globl	_parityon
_parityon:
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#vsbmembase,a0
    1:	movw	a0@,d1			/* get sw copy of config register */
	cmpw	#0xffff,d1		/* non-configed board read 0xffff */
	jeq	2f
	orw	#VSB_PAR_ENAB,d1	/* enable parity */
	movsw	d1,a1@			/* program base address */
	movw	d1,a0@
    2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0
	dbra	d0,1b
	rts

/*
 * Configure all memory boards with parity off
 */
	.globl	_parityoff
_parityoff:
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#vsbmembase,a0
    1:	movw	a0@,d1			/* get sw copy of config register */
	cmpw	#0xffff,d1		/* non-config board read 0xffff */
	jeq	2f
	andl	#~VSB_PAR_ENAB,d1	/* disable parity */
	movsw	d1,a1@			/* program base address */
	movw	d1,a0@
    2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0
	dbra	d0,1b
	rts

/*
 * Check and service parity errors on all memory boards
 */
	.globl	_reset_parity
_reset_parity:
	movl	#VSB_MAX_SLOTS,d0
	subl	#1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#vsbmembase,a0
    1:	movw	a0@,d1			/* get sw copy of config register */
	cmpw	#0xffff,d1		/* non-config board read 0xffff */
	jeq	2f
	movsw	a1@,d1			/* read ISVSBM status register */
	andw	#VSB_PAR_ENAB,d1	/* disable parity */
	jeq	2f
    	movw	a0@,d1			/* get sw copy of config register */
	andl	#~VSB_PAR_ENAB,d1	/* disable parity */
	movsw	d1,a1@			/* program base address */
	orw	#VSB_PAR_ENAB,d1	/* enable parity */
	movsw	d1,a1@			/* program base address */
    2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0
	dbra	d0,1b
	rts

/*
 * Interrupt vector routines. Following globals are for convienience in namelist
 */
	.globl	_waittime
	.globl	traps
	.globl	iret
	.globl	dorte


/*
 * The following deals with the 030 stack crossing page 
 * boundary problem.  Also refer to autoconf.c
 */
#ifdef	STK_XPAGE_BUG
	.globl	_xbug_disp_pad
	.globl	_xbug_code
	.globl	_xbug_scb
	.globl	_rupt_table
	.align	1
_xbug_disp_pad:	.space	8
	.align	1
_xbug_code:
    	movml	#<d0,a0>,sp@-		/* save [da][0] */
     	movw	sp@(14),d0		/* get vector and format */
	andw	#ESF_VECMSK,d0		/* isolate vector */
	movl	_rupt_table,a0		/* get dispatch table */
	movl	a0@(0,d0:w*1),a0	/* get dispatch address */
	jmp	a0@
	.align	1
xbug_codesize: .long	xbug_codesize-_xbug_code
_rupt_table:	.long	0
_xbug_scb:	.space	4*(NSCBVEC+2)

#define	SCBVEC(name)	.align 1;  .globl _X/**/name;  _X/**/name: \
			movml	sp@+,#<d0,a0>;9
#else	STK_XPAGE_BUG
#define	SCBVEC(name)	.align 1;  .globl _X/**/name;  _X/**/name
#endif	STK_XPAGE_BUG

#define	TRAP(x)		PEEXT(x); jra traps
#define	PEEXT(x)	movl sp@(2),sp@-; movw sp@(4),sp@-; \
			clrw sp@-; pea x	/* push exception extention */
#define	PUSHR		movml #<d0-d1,a0-a1>,sp@-
#define	POPR		movml sp@+,#<d0-d1,a0-a1>
#define	PUSHED		(4*4)			/* offset around saved regs */
#define	TCODE		PUSHED			/* offset to trap code */
#define	TTYPE		(PUSHED+2)		/* offset to trap type */
#define	EEXT		12			/* size exception extension */
#define	ESF		(EEXT+PUSHED)		/* offset to exception frame */
#define	INC(counter)	addl #1,_cnt+counter	/* increment event counter */
#define	IBEG		IINC; PEEXT(0); PUSHR;  /* start of interrupt */
#define	RTE(n)		IDEC; INC(n); jra iret	/* end of interrupt */
#define	IINC		addl #1,_int_svc	/* increment interrupt depth */
#define	IDEC		subl #1,_int_svc	/* decrement interrupt depth */

/*
 * collapse various stack formats to 4-word format 0 if ESF_SOFT bit is on in 
 * the stack format/vector offset word. Used to send signals to process, and 
 * for nofault recovery.
 */
#define	COLLAPSE(x)	\
    5:	cmpw	#ESF_FMT/**/x,sp@(ESF_VEC); jne 5f; /* stack format x to */    \
	movw	#ESF_FMT0,sp@(ESF_VEC+ESF_ISIZE/**/x-ESF_ISIZE0); /* fmt0 */   \
	movl	sp@(ESF_PC),sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy pc */\
	movw	sp@(ESF_SW),sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy sr */\
	lea	sp@(ESF_ISIZE/**/x-ESF_ISIZE0),sp; jra 2b /* collapse size */

	.globl	_get_rupt_table
_get_rupt_table:
	movl	#SYSV_BASE,d0
	rts

SCBVEC(stray):		TRAP(T_STRAY)
SCBVEC(adderr):		TRAP(T_ADDERR)
SCBVEC(illins):		TRAP(T_RESOPFLT)
SCBVEC(zerodiv):	TRAP(T_ZERODIV)
SCBVEC(chk):		TRAP(T_CHK)
SCBVEC(trapv):		TRAP(T_TRAPV)
SCBVEC(privvio):	TRAP(T_PRIVINFLT)
SCBVEC(l1010em):	TRAP(T_L1010EM)
SCBVEC(l1111em):	TRAP(T_L1111EM)
SCBVEC(fmterr):		TRAP(T_FMTERR)
SCBVEC(coproc):		TRAP(T_COPROC)
SCBVEC(fpe):		TRAP(T_FPE)
#ifdef M68030
SCBVEC(mmu):		TRAP(T_MMU)
#endif M68030
#ifndef	SYSV
SCBVEC(trap0):		TRAP(T_TRAP+(0<<16))
#endif	SYSV
SCBVEC(trap9):		TRAP(T_TRAP+(9<<16))
SCBVEC(trap10):		TRAP(T_TRAP+(10<<16))
SCBVEC(trap11):		TRAP(T_TRAP+(11<<16))
SCBVEC(trap12):		TRAP(T_TRAP+(12<<16))
SCBVEC(trap13):		TRAP(T_TRAP+(13<<16))
SCBVEC(trap14):		TRAP(T_TRAP+(14<<16))
SCBVEC(trap15):
#ifdef	DEBUGGER
			btst	#5,sp@; jne	dbg_excpt
#endif
			TRAP(T_BPTFLT)
SCBVEC(trace):
			/* ignore trace traps if trace bit is not set! */
			btst	#7,sp@; jne	1f; rte
#ifdef	DEBUGGER
    1:			btst	#5,sp@; jne	dbg_excpt
#endif
    1:			TRAP(T_TRCTRAP)

traps:	PUSHR				/* save [da][01] temporary registers */
traps0:	movl	usp,a0			/* save user sp */
	pea	a0@
	movml	#<d2-d7,a2-a6>,sp@-
	jsr	_trap			/* call generic trap handler */
	movml	sp@+,#<d2-d7,a2-a6>
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_TRAP)		/* keep count */

iret: 	
	btst	#AST_USR,_ast           /* check/clear user resched ast */
	jeq     1f
	movw    sp@(ESF+ESF_SW),d0      /* must be user ast */
	andw    #PSL_CURMOD,d0          /* leave pending */
	jne	1f			/* no leave it pending */
	bclr    #AST_USR,_ast           /* clear ast and go service in trap */
	movw    #T_ASTFLT,sp@(TTYPE)
	jra     traps0

    1:	POPR				/* restore [da][01] */
	movw	sp@(6),sp@(12)
	movl	sp@(8),sp@(14)
	addl	#EEXT,sp		/* pop exception extention */

dorte:	bclr	#ESF_SOFT_BIT,sp@(ESF_VEC)
	jne	5f			/* branch if frame must be collapsed */

	/* check for excessive stack growth, clobbering u area */
    2:	cmpl	#U_REDZONE_MAGIC,_u+U_STACK
	jne	3f

	/* chech for stack pointer getting near uarea */
	cmpl	#_u+U_STACK+512,sp
	jgt	4f
	cmpl	#SCRATCH_STACK,sp
	jlt	4f
    3:	tstl	_panicstr		/* disregaurd on panic */
	jne	4f
	pea	panic_stackovf		/* kernel stack overflow!! */
	jsr	_panic
    4:	
	rte				/**** return from trap/interrupt ****/

    5:	andw	#ESF_FMTMSK,sp@(ESF_VEC)/* isolate stack format */
	cmpw	#ESF_FMT0,sp@(ESF_VEC)	/* format 0 does not collapse */
	jeq	2b

	COLLAPSE(A)
	COLLAPSE(B)
	COLLAPSE(9)
	COLLAPSE(2)

    5:	pea	panic_iret		/* bad stack format */
	jsr	_panic

	/* Handle asynchronious soft trap */
SCBVEC(softtrap):
	IBEG
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	andw	#~SCR_SOFT_TRAP,d0	/* software ast */
	movsw	d0,SCR_ADDR
	movw	d0,_scr
	movw	d1,sr
	bclr	#AST_SOFT,_ast		/* check/clear software ast */
	jeq	1f
	movw	#PSL_IPLS,sr
	jsr	_softint
    1:
	bclr	#AST_TIC,_ast		/* check/clear softclock ast */
	jeq	1f
	movw	#PSL_IPLC,sr
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
    1:
	RTE	(V_INTR)

SCBVEC(nmi):
#ifndef	KPROF
	TRAP(T_NMI)
#else	KPROF
	/*
	 * To prepare QBUS 68010 CPU board for kprof profiling at level 7:
	 *	- Inject profile clock into 8A (8640) pin 7, BHALTL.
	 * To prepare VBUS 68010 CPU board for kprof profiling at level 7:
	 *	-  Bend up 9M (S113) pin 1 (AC fail), and inject profile clock 
	 *	   into chip pin.
	 * To prepare VBUS 68020 CPU board for kprof profiling at level 7:
	 *	-  Bend up U58 (LS32) pin 5, and ground that chip pin. This 
	 *	   disables latching of BSR on NMI interrupts, so that status 
	 *	   for bus errors is not lost.
	 *	-  Remove R5, which connects to AC fail on the bus. 
	 *	-  Inject profile clock into U82(LS113) pin 13.
	 */
	.data
	.globl	_kprof_magic
_kprof_magic:	.long	0x12345678
	.comm	_kprof_enable,4
	.comm	_kprof_su,2*4
	.comm	_kprof_spsl,8*4
	.comm	_kprof_upsl,8*4
	.comm	_kprof,KPROF*4
	.comm	_kprof_swtch,4
	.comm	_kprof_buse,4
	.comm	_kprof_sysc,4
	.comm	_kprof_pid,(20+32)*4	/* first 20 plus last 32 pid's */
	.comm	_kprof_pid_cnt,(20+32)*4
	.comm	_kprof_pid_nam,(20+32)*8
	.text

	IBEG
	tstb	_kprof_enable+3		/* skip if not enabled */
	jeq	3f
	cmpl	#SCRATCH_STACK+SYSV_BASE,sp	/* dont look at pid if swtching */
	jlt	2f
	clrl	d0
	movl	_u+U_PROCP,a0		
	movw	a0@(P_PID),d0
	movl	d0,d1
	cmpw	#20,d0
	jle	1f
	andw	#0x1F,d0
	addl	#20,d0
    1:	lsll	#2,d0
	lea	_kprof_pid,a0
	addl	d0,a0
	movl	d1,a0@
	lea	_kprof_pid_cnt,a0
	addl	d0,a0
	addl	#1,a0@
	lea	_kprof_pid_nam,a0
	lsll	#1,d0
	addl	d0,a0
	lea	_u+U_COMM,a1		
	movl	a1@+,a0@+
	movl	a1@,a0@
    2:	clrl	d0
	movw	sp@(ESF+ESF_SW),d0	/* get psl */
	movw	d0,d1
	andl	#PSL_HIGH,d0
	lsrw	#PSL_IPL_SHIFT-2,d0	/* define kprof_[su]psl index */
	andl	#PSL_CURMOD,d1		/* test system mode */
	jeq	1f			/* jump if user mode */
	addl	#1,_kprof_su+4		/* accumulate system mode stats */
	jmi	4f;			/* jump if auto-shutoff */
	movl	sp@(ESF+ESF_PC),d1	/* get pc */
	andl	#NONT_MASK,d1
	lsrl	#2,d1			/* >>4, &(KPROF-1), <<2 */
	andl	#((KPROF-1)<<2),d1
	lea	_kprof,a0
	addl	d1,a0
	addl	#1,a0@
	lea	_kprof_spsl,a0
	jra	2f
    1:	addl	#1,_kprof_su		/* user mode */
	jmi	4f;			/* jump if auto-shutoff */
	lea	_kprof_upsl,a0
    2:	addl	d0,a0
	addl	#1,a0@
    3:	RTE	(V_INTR)
    4:	clrl	_kprof_enable		/* disable */
	RTE	(V_INTR)
#endif	KPROF

SCBVEC(clock):
	IBEG
#ifndef	is68k_kobj
#if	NVB > 0
	jsr	_vbcheck		/* 010's and standalone dont use IPI */
#endif	NVB > 0
#endif	is68k_kobj
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_hardclock		/* hardclock(pc,psl) */
	addl	#8,sp
	addl	#1,_intrcnt+I_CLOCK
    1:	
	RTE	(V_INTR)		/* temp so not to break vmstat -= HZ */


SCBVEC(buserr):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_buse		/* kprof: count bus errors */
    1:
#endif	KPROF
	PEEXT(T_BUSERR)			/* hopeful trap type */
	jra	traps

/*
 * System call service: Trap #1 is typical user system call. Signal and 
 * longjmp cleanup use traps #2 - #8, and go to Sigcleanup() via a 
 * negative-number syscall.  The traps are 4-word stack format 0, but may need 
 * to return with a larger stack format obtained from the user. Here we allocate
 * larger exception stack frame, slide the 4-word format up to the top of the 
 * allocated area, and change its format so that if it is actually used, it will
 * collapse back to 4 words.
 */
#define	SIG_CLEAN_SYSCALL(x,n)	\
	subl	#(ESF_ISIZE/**/x-ESF_ISIZE0),sp;/* allocate for format x */ \
	movw	sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_SW);	\
	movl	sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_PC);	\
	movw	#(ESF_SOFT|ESF_FMT/**/x),sp@(ESF_VEC);			\
	PEEXT(T_SYSCALL + (-(n) << 16)); jra 2b	/* syscall -n */

#ifdef	SYSV
SCBVEC(trap0):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_sysc		/* kprof: count system calls */
    1:
#endif	KPROF
	movl	sp@(2),sp@-
	movw	sp@(4),sp@-
	clrw	sp@-			/* align psl, part of EEXT */
	movw	#T_SYSCALL,sp@-		/* push type, part of EEXT */
	movw	d0,sp@-			/* push code, part of EEXT */
	PUSHR				/* save temp regs */
	movl	usp,d0			/* save user sp */
	movl	d0,sp@-
	cmpw	#NCRMAGIC,_u+U_FILEMAG	/* for NCR compatibility */
	beq	1f
	movl	#32,sp@-		/* no of args (passed on the stack) */
	movl	#_u+U_ARG,sp@-		/* start of u arg area */
	addl	#4,d0			/* user sp + 4 */
	movl	d0,sp@-
	jsr	_copyin
	addl	#12,sp
	bra	2f
    1:
#define	ARG1OFF	_u+U_ARG
#define	ARG2OFF	_u+U_ARG+4
#define	ARG3OFF	_u+U_ARG+8
#define	ARG4OFF	_u+U_ARG+12
#define	ARG5OFF	_u+U_ARG+16
#define	ARG6OFF	_u+U_ARG+20
#define	ARG7OFF	_u+U_ARG+24
#define	ARG8OFF	_u+U_ARG+28
	movl	a0,ARG1OFF		/* args passed in registers */
	movl	d1,ARG2OFF
	movl	a1,ARG3OFF
	movl	d2,ARG4OFF
	movl	a2,ARG5OFF
	movl	d3,ARG6OFF
	movl	a3,ARG7OFF
	movl	d4,ARG8OFF
    2:
	movml	#<d2-d7,a2-a6>,sp@-
	jsr	_sysv_syscall		/* call system call handler */
	movml	sp@+,#<d2-d7,a2-a6>
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_SYSCALL)
	jra	iret
#endif	SYSV

SCBVEC(trap1):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_sysc		/* kprof: count system calls */
    1:
#endif	KPROF
	movl	sp@(2),sp@-
	movw	sp@(4),sp@-
	clrw	sp@-			/* align psl, part of EEXT */
	movw	#T_SYSCALL,sp@-		/* push type, part of EEXT */
	movw	d0,sp@-			/* push code, part of EEXT */
	jne	1f
	movw	d1,sp@
	movml	#<a0-a6>,_u+U_ARG
	jra	2f
    1:	movml	#<d1,a0-a6>,_u+U_ARG
    2:	PUSHR				/* save temp regs */
	movl	usp,a0			/* save user sp */
	pea	a0@
	movml	#<d2-d7,a2-a6>,sp@-
	jsr	_syscall		/* call system call handler */
	movml	sp@+,#<d2-d7,a2-a6>
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_SYSCALL)
	jra	iret

SCBVEC(trap2):	SIG_CLEAN_SYSCALL(B,7)	/* trampoline format B, syscall -7 */
SCBVEC(trap3):	SIG_CLEAN_SYSCALL(A,6)	/* trampoline format A, syscall -6 */
SCBVEC(trap4):	SIG_CLEAN_SYSCALL(9,5)	/* trampoline format 9, syscall -5 */
SCBVEC(trap5):	SIG_CLEAN_SYSCALL(8,4)	/* trampoline format 8, syscall -4 */
SCBVEC(trap6):	SIG_CLEAN_SYSCALL(2,3)	/* trampoline format 2, syscall -3 */
SCBVEC(trap8):				/* trampoline format 0, syscall -2 */
	PEEXT(T_SYSCALL + (-2 << 16)); jra	2b
SCBVEC(trap7):				/* longjmp cleanup, syscall -1 */
	PEEXT(T_SYSCALL + (-1 << 16)); jra	2b

/************************************************************************/

	.globl	_badaddr
/*
 * badaddr(addr, len)
 *	See if access addr with a len type instruction causes a bus or address 
 *	error. Len is length of access (1=byte, 2=short, 4=long).
 */
_badaddr:
	movl	sp@(4),a0		/* address to be tested */
	movl	sp@(8),d1		/* size of operand (1, 2, or 4) */
	movl	vb,a1			/* get vbr */
	movl	a1@(SCB_BUSERR),sp@-	/* save old bus error vector */
	movl	a1@(SCB_ADRERR),sp@-	/* save old address error vector */
	movl	#8f,a1@(SCB_BUSERR)	/* set new bus error vector */
	movl	#9f,a1@(SCB_ADRERR)	/* set new address error vector */
	movw	sr,d0
	movl	d0,a1			/* save old sr in a1 */
	movl	#0,d0			/* hopeful return value: 0 */
	orw	#PSL_HIGH,sr		/* disable interrupts */
	tstl	d1
	jle	3f			/* READ operation */
	lsrw	#1,d1			/* byte operation? */
	jcc	1f			/*   no */
	tstb	a0@			/*   yes -- try to access byte */
    1:	lsrw	#1,d1			/* short operation? */
	jcc	2f			/*   no */
	tstw	a0@			/*   yes -- try to access short */
    2:	lsrw	#1,d1			/* long operation? */
	jcc	4f			/*   no */
	tstl	a0@			/*   yes -- try to access long */
	jra	4f
    3:	negl	d1			/* WRITE operation */
	lsrw	#1,d1			/* byte operation? */
	jcc	1f			/*   no */
	movb	d0,a0@			/*   yes -- try to access byte */
    1:	lsrw	#1,d1			/* short operation? */
	jcc	2f			/*   no */
	movw	d0,a0@			/*   yes -- try to access short */
    2:	lsrw	#1,d1			/* long operation? */
	jcc	4f			/*   no */
	movl	d0,a0@			/*   yes -- try to access long */
    4: 	movl	a1,d1
	movw	d1,sr			/* restore old interrupt priority */
	movl	vb,a1			/* get vbr */
	movl	sp@+,a1@(SCB_ADRERR)	/* restore old address error vector */
	movl	sp@+,a1@(SCB_BUSERR)	/* restore old bus error vector */
	rts				/* return value in d0 */

    8:	addw	#1,d0			/* BUS ERROR modify return value */
	andw	#ESF_SSW_20_SOFTMSK,sp@(ESF_SSW)
	jra	dorte			/* return from bus error exception */

    9:	addw	#8,d0			/* ADDRESS ERROR modify return value */
	andw	#ESF_SSW_20_SOFTMSK,sp@(ESF_SSW)
	jra	dorte			/* return from address error exceptn */

/* addupc(pc, &u.u_prof, nticks)
/*	struct uprof {			/* profile arguments */
/*		short	*pr_base;	/* buffer base */
/*		unsigned pr_size;	/* buffer size */
/*		unsigned pr_off;	/* pc offset */
/*		unsigned pr_scale;	/* pc scaling */
/*	} u_prof;
/* */
	.globl	_addupc
_addupc:movl	sp@(8),a1		/* &u.u_prof */
	movl	sp@(4),d0
	subl	a1@(8),d0		/* corrected pc */
	jlt	9f
	lsrl	#1,d0			/* logical right shift */
	movl	a1@(12),d1
	lsrl	#1,d1			/* ditto for scale */
	mulul	d1, d1:d0		/* [d1:d0]=(pc-pr_off)/2*pr_scale/2 */
	lsll	#1,d0			/* quad right shift 14 */
	roxll	#1,d1
	jcs	9f
	lsll	#1,d0
	roxll	#1,d1
	jcs	9f
	movw	d1,d0
	clrw	d1
	swap	d0
	swap	d1
	jne	9f
	andw	#0xFFFE,d0
	cmpl	a1@(4),d0		/* length */
	jhs	9f
	addl	a1@,d0			/* base */
	movl	d0,a0
	movl	_nofault,sp@-
	movl	#8f,_nofault
	movw	a0@,d1
	addl	sp@(16),d1
	movw	d1,a0@
    7:	movl	sp@+,_nofault
    9:	rts
    8:	clrl	a1@(12)
	jra	7b

	.globl	_useracc
	.globl	_kernacc
_useracc:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tuseracc
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) ruseracc() */
	jne	_ruseracc
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),d0		/* user virtual address */
	cmpl	#MAXU_ADDR,d0
	jlt	1f	
    	movl	#0,d0
	rts
    1: 	movl	d0,a0
	jra	1f

_kernacc:
	movl	sp@(4),a0		/* system virtual address */
    1:	movl	#NBPG,d1
	movl	a0,a1
	addl	sp@(8),a1
	subl	#1,a1			/* address of last byte */
	movl	_nofault,sp@-
	movl	#4f,_nofault
	tstl	sp@(16)			/* 1 => READ */
	jeq	2f

    1:	movb	a0@,d0			/* check for read access */
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b
	movb	a1@,d0
	jra	3f

    2:	movb	a0@,d0			/* check for write access */
	movb	d0,a0@
	addl	d1,a0
	cmpl	a0,a1
	jgt	2b
	movb	a1@,d0
	movb	d0,a1@

    3:	movl	#1,d0
    1:	movl	sp@+,_nofault
	rts
    4:	movl	#0,d0
	jra	1b

	.globl	_noproc
	.comm	_noproc,4
	.globl	_runrun
	.comm	_runrun,4
	.globl	_setrq
	.globl	_remrq
	.globl	__insque
	.globl	__remque
/*
 * setrq(p): 	Called at spl6().  p->p_stat should be SRUN.
 */
_setrq:	movl	sp@(4),a0
	tstl	a0@(P_RLINK)
	jeq	1f
	pea	panic_setrq
	jsr	_panic

    1:	movl	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1			/* put on queue which is p->p_pri / 4 */
	movl	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1
	movl	a1,a0@			/* insert at end of queue */
	movl	a1@(4),d0
	movl	d0,a0@(4)
	movl	a0,a1@(4)
	movl	d0,a1
	movl	a0,a1@
	lea	_whichqs,a1		/* mark queue non-empty */
	movl	a1@,d0
	bset	d1,d0
	movl	d0,a1@
	rts

/*
 * remrq(p): 	Called at spl6().
 */
_remrq:	movl	sp@(4),a0
	movl	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1
	movl	_whichqs,d0
	bclr	d1,d0
	jne	1f
	movl	d0,_whichqs
	pea	panic_remrq
	jsr	_panic

    1:	movl	a0@,a1
	movl	a0@(4),d1
	cmpl	d1,a1
	jne	1f
	movl	d0,_whichqs
    1:	movl	d1,a1@(4)
	exg	d1,a1
	movl	d1,a1@
	clrl	a0@(P_RLINK)
	rts

__insque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0		/* new */
	movl	sp@(8),a1		/* pred */
	movl	a1@,d0			/* succ */
	movl	d0,a0@
	movl	a1,a0@(4)
	movl	a0,a1@
	movl	d0,a1
	movl	a0,a1@(4)
	movw	d1,sr
	rts

__remque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0
	movl	a0@,a1
	movl	a0@(4),d0
	movl	d0,a1@(4)
	exg	d0,a0
	movl	a1,a0@
	movw	d1,sr
	rts

	.globl	_swtch
	.globl	_waitloc
/*
 * swtch: switch to another process.
 */
_swtch:	movw	sr,_u+PCB_PSL+2
	movl	#1,_noproc
	clrl	_runrun

	/* determine highst priority nonempty queue */
    1:	orw	#PSL_HIGH,sr		/* disable interrupts */
	movl	_whichqs,d0
	movl	#0,d1
	jra	3f
    2:	addw	#1,d1
    3:	lsrl	#1,d0			/* find an active queue */
	jcs	4f			/* jump if active */
	jne	2b

	stop	#PSL_IPL0		/* go idle */

_waitloc:
	jra	1b			/* try again */

	/* found nonempty run queue, remove first entry */
    4:	movw	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1		/* a1 -> queue header */
	movl	a1@,a0			/* a0 -> first entry in queue */
	cmpl	a1,a0			/* make sure queue not empty */
	jne	1f
    2:	pea	panic_swtch
	jsr	_panic

    1:	movl	a0@,d0			/* unlink item from queue */
	movl	d0,a1@			/* unlink from queue header */
	exg	d0,a1
	movl	d0,a1@(4)		/* unlink from successor */
	cmpl	d0,a1			/* if queue is now empty, */
	jne	1f
	movl	_whichqs,d0		/* mark queue empty */
	bclr	d1,d0
	movl	d0,_whichqs

    1:	clrl	_noproc
	tstl	a0@(P_WCHAN)
	jne	2b
	cmpb	#SRUN,a0@(P_STAT)
	jne	2b
	clrl	a0@(P_RLINK)
	movl	a0@(P_ADDR),a1
	movl	a1@,_masterpaddr
	INC	(V_SWTCH)

	movml	#<d2-d7,a2-a7>,_u	/* save 68020 registers */
	movl	_CMAP2,_u+PCB_CMAP2

#ifdef	FP_68881
	.globl	_save_68881
	.globl	_restore_68881
_save_68881:
	tstb	_u+U_68881_INUSE	/* is 68881/2 being used */
	jeq	1f
	lea	_u+U_68881_STATE,a2
	fsave	a2@			/* save state frame */
	tstb	a2@			/* if null, dont save registers */
	beq	1f
	lea	_u+U_68881_REGS,a2
	fmovemx	#<f0-f7>,a2@		/* save programmers model */
	addl	#8*12,a2
	fmoveml	#<fpcr,fpsr,fpiar>,a2@
    1:
#endif	FP_68881
    2:	movl	_cacr,d2
	movl	d2,cac			/* Invalidate 020 cache */
	movw	_scr,d1
	movsw	d1,SCR_ADDR
	movl	#SCRATCH_STACK+SYSV_BASE,sp	/* run on temporary stack */
	lea	_Umap,a2
	movw	#UPAGES-1,d1
     1: movl	a1@+,d0			/* get u pte */
	andl	#~PG_PROT,d0
	orl	#PG_V|PG_KW,d0
	movl	d0,a2@+
	dbra	d1,1b
	
	pflusha
	jsr	_setctx			/* setctx() */
	
   	movml	_u,#<d2-d7,a2-a7>	/* restore 68020 registers */
	movl	_u+PCB_CMAP2,_CMAP2
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_swtch		/* kprof: count context switches */
    1:
#endif	KPROF

#ifdef	FP_68881
_restore_68881:
	tstb	_u+U_68881_INUSE	/* is 68881/2 being used */
	jne	1f
	movw	_scr,d0
	andw	#~SCR_FPU_USE,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	jra	2f
    1:
	movw	_scr,d0
	orw	#SCR_FPU_USE,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	lea	_u+U_68881_STATE,a0
	tstb	a0@			/* skip if no saved model */
	jeq	1f
	lea	_u+U_68881_REGS,a1
	fmovemx	a1@,#<f0-f7>
	addl	#8*12,a1
	fmoveml	a1@,#<fpcr,fpsr,fpiar>	/* restore programers model */
    1:	frestore	a0@		/* restore state frame */
    2:
#endif	FP_68881

    3:	movl	_u+PCB_SSWAP,d0
	jeq	1f
	clrl	_u+PCB_SSWAP
	movl	d0,sp@
	movw	_u+PCB_PSL+2,sr
	jsr	_longjmp

    1:	movl	#0,d1
	movw	_u+PCB_PSL+2,d1
	jra	splx

	.globl	_setjmp
	.globl	_longjmp
	.globl	_resume
/*
 * Non-local goto's
 */
_setjmp:movl	sp@+,a1			/* return address */
	movl	sp@,a0			/* jmpbuf */
	movml	#<d2-d7,a2-a7>,a0@
	movl	a1,a0@(12*4)		/* return pc */
	movl	#0,d0			/* zero return value */
	jmp	a1@			/* return */

_longjmp:
	movl	sp@(4),a0		/* jmpbuf */
	movl	a6,d0			/* save fp in case we panic */
	movml	a0@+,#<d2-d7,a2-a6>
	movl	a0@+,a1			/* to be new sp */
	cmpl	sp,a1			/* must be a pop */
	jge	1f
	movl	d0,a6			/* put frame pointer back */
	link	a6,#0			/* for stack backtrace */
	pea	panic_ljmp
	jsr	_panic			/* no return */

    1:	movl	a1,sp
	movl	a0@,a1			/* return pc */
	movl	a0,d0			/* nonzero return value */
	jmp	a1@			/* return */

_resume:movw	sr,_u+PCB_PSL+2
	movml	#<d2-d7,a2-a7>,_u
	rts

	.globl	_setsoftclock
_setsoftclock:
	bset	#AST_TIC,_ast		/*   no -- set ast pending & return */
	jsr	_setsofttrap
	rts

/* set software ast interrupt pending, must be called at splhigh! */
	.globl	_siron
_siron:	bset	#AST_SOFT,_ast
	jsr	_setsofttrap
	rts

/* set software trap */
_setsofttrap:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movw	_scr,d0
	orw	#SCR_SOFT_TRAP,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	movw	d1,sr
	rts

	.globl	_splx
	.globl	_spl
	.globl	_spl0
	.globl	_spl1
	.globl	_splsoftclock
	.globl	_splsoft
	.globl	_splnet			/* dont go lower than current ??? */
	.globl	_spl4
	.globl	_spl5
	.globl	_spltty
	.globl	_splimp			/* dont go lower than current ??? */
	.globl	_spl6
	.globl	_spl7
	.globl	_splhigh
	.globl	_splclock
	.globl	_splbio

_splx:	movl	sp@(4),d1
splx:	movw	d1,d0
	clrl	d0
	movw	sr,d0
	movw	d1,sr
	rts

_spl:	clrl	d0
	movw	sr,d0
	rts

_spl0:	clrl	d0
	movw	sr,d0
    	andw	#PSL_LOW,sr		/* drop to low priority */
	rts

_splnet:clrl	d0
	movw	sr,d0
	movw	#PSL_IPLN,sr
	rts

_splsoft:
	clrl	d0
	movw	sr,d0
	movw	#PSL_IPLS,sr
	rts

_splsoftclock:
	clrl	d0
	movw	sr,d0
	movw	#PSL_IPLC,sr
	rts

_spl1:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL1,sr
	rts

_spl4:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL4,sr
	rts

_spl5:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL5,sr
	rts

_splclock:
_spl6:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL6,sr
	rts

_splhigh:
_spl7:	clrl	d0
	movw	sr,d0
	orw	#PSL_HIGH,sr
	rts

_spltty: clrl	d0
	movw	sr,d0
	movl	_clev_tty,d1
	bne	1f
	movl	_clev_ttymax,d1
1:
	andw	#7,d1
	lslw	#PSL_IPL_SHIFT,d1
	addw	#PSL_CURMOD,d1
	movw	d1,sr
	rts

_splimp: clrl	d0
	movw	sr,d0
	movl	_clev_imp,d1
	bne	1f
	movl	_clev_impmax,d1
1:
	andw	#7,d1
	lslw	#PSL_IPL_SHIFT,d1
	addw	#PSL_CURMOD,d1
	movw	d1,sr
	rts

_splbio: clrl	d0
	movw	sr,d0
	movl	_clev_bio,d1
	bne	1f
	movl	_clev_biomax,d1
1:
	andw	#7,d1
	lslw	#PSL_IPL_SHIFT,d1
	addw	#PSL_CURMOD,d1
	movw	d1,sr
	rts

	.globl	_utokaddr
	.globl	_copyin
	.globl	_copyout
	.globl	_copyinstr
	.globl	_copyoutstr
	.globl	_copystr
	.globl	_fubyte
	.globl	_fuibyte
	.globl	_fuword
	.globl	_fuiword
	.globl	_subyte
	.globl	_suibyte
	.globl	_suword
	.globl	_suiword

_utokaddr:				/* user to kernel adress */
	movl	sp@(4),d0
	rts

_copyin:				/* copyin(us, kd, bcount) */
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyin
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rcopyin() */
	jne	_rcopyin
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0		/* user virtual */
	movl	sp@(8),a1		/* kernel destination */
	movw	a1,d1
	movw	a0,d0
	jra	1f

_copyout:				/* copyout(ks, ud, bcount) */
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyout
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rcopyout() */
	jne	_rcopyout
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(8),a1		/* user virtual */
	movl	sp@(4),a0		/* kernel source */
	movw	a0,d0			/* fall through ... */
	movw	a1,d1

    1:	eorw	d1,d0			/* common copyin/copyout code */
	movl	sp@(12),d1		/* byte count */
	jle	4f
	movl	_nofault,sp@-
	movl	#5f,_nofault
	lsrw	#1,d0
	jcs	3f
	movw	a0,d0			/* check for both addrs odd */
	lsrw	#1,d0
	jcc	1f
	movb	a0@+,a1@+
	subl	#1,d1
    1:	movl	d1,d0
	lsrl	#5,d0
	andl	#0x1F,d1
	jra	2f
    1:	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
    2:	dbra	d0,1b
	addw	#1,d0
	subl	#1,d0
	jge	1b
	movw	d1,d0
	lsrw	#1,d0
	andw	#1,d1
	jra	2f
    1:	movw	a0@+,a1@+
    2:	dbra	d0,1b
	jra	3f
    1:	movb	a0@+,a1@+
    3:	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	movl	sp@+,_nofault
    4:	movl	#0,d0
	rts
    5:	movl	sp@+,_nofault
    6:	movl	#EFAULT,d0
	rts

/* bzero user address space */
	.globl	_u_bzero
_u_bzero:				/* u_bzero(us, bcount) */
	movl	sp@(4),a0		/* user virtual */
	movl	sp@(8),d1		/* byte count */
	jle	4f
	movl	_nofault,sp@-
	movl	#5f,_nofault
    	movl	d1,d0
	lsrw	#1,d0
	jcc	1f
	clrb	a0@+
	subl	#1,d1
    1:	movl	d1,d0
	lsrl	#5,d0
	andl	#0x1F,d1
	jra	2f
    1:	clrl	a0@+; clrl a0@+; clrl a0@+; clrl a0@+;
	clrl	a0@+; clrl a0@+; clrl a0@+; clrl a0@+;
    2:	dbra	d0,1b
	addw	#1,d0
	subl	#1,d0
	jge	1b
	movl	d1,d0
	lsrw	#1,d0
	jra	2f
    1:	clrw	a0@+
    2:	dbra	d0,1b
	andw	#1,d1
	jeq	3f
	clrb	a0@+
    3:	movl	sp@+,_nofault
    4:	movl	#0,d0
	rts
    5:	movl	sp@+,_nofault
    6:	movl	#EFAULT,d0
	rts

#if	defined(SYSV) && defined(RFS)
/* upath is called from RFS routines to copyin a string from user space */
/* It is similar to copyinstr. But having this is convenient for RFS	*/
	.globl	_upath
_upath:					/* upath(us, kd, maxlen) */
	/* Note that the original System V upath does not do any */
	/* copy when the length is unacceptable. But this one does */
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) spath() */
	jne	_spath
	movl	sp@(4),a0		/* user virtual */
	jra	1f
_spath:
	movl	sp@(4),a0		/* kernel source */
    1:	movl	sp@(8),a1		/* kernel destination */
    	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f			/* return 0 */
    	movl	_nofault,sp@-
	movl	#5f,_nofault
    1:	movb	a0@+,a1@+
	jeq	4f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
    2:	movl	#-2,d0			/* no null return code*/
    1:  movl	sp@+,_nofault
    3:	rts

    4:	subl	sp@(12+4),d1
	negl	d1			/* set lencopied */
	movl	d1,d0			/* a null path name returns 1 */
	jra	1b
    5:	movl	#-1,d0			/* illegal address return code*/
	jra	1b

/* rcopyfault: catches faults in remote moves */
	.globl	_rcopyfault
_rcopyfault:
	movl	#EFAULT,d0
	rts

#endif	defined(SYSV) && defined(RFS)

_copyinstr:				/* copyinstr(us, kd, maxlen, &len) */
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyinstr
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) copystr() */
	jne	_copystr
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0		/* user virtual */
	movl	sp@(8),a1		/* kernel destination */
	jra	1f

_copyoutstr:				/* copyoutstr(ks, ud, maxlen, &len) */
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyoutstr
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rcopyoutstr() */
	jne	_rcopyoutstr
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0		/* kernel source */
	movl	sp@(8),a1		/* user virtual */
	jra	1f

_copystr:				/* copystr(ks, kd, maxlen, &len) */
	movl	sp@(4),a0		/* kernel source */
	movl	sp@(8),a1		/* kernel destination */

    1:	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f
    	movl	_nofault,sp@-
	movl	#4f,_nofault
    1:	movb	a0@+,a1@+
	jeq	2f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	addl	#1,d1
	movl	#ENOENT,d0		/* no null return code*/
    2:	movl	sp@+,_nofault
    3:	movl	sp@(16),a0		/* &lencopied */
	cmpl	#0,a0
	jeq	1f			/* skip if NULL */
	subl	sp@(12),d1
	negl	d1
	movl	d1,a0@			/* set lencopied */
    1:	rts
    4:	movl	#EFAULT,d0		/* illegal address return code*/
	jra	2b
    5:	movl	#EFAULT,d0
	rts

_fubyte:
_fuibyte:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tfubyte
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rfubyte() */
	jne	_rfubyte
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	clrl	d0
	movb	a0@,d0
	movl	sp@+,_nofault
	rts

_fuword:
_fuiword:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tfuword
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rfuword() */
	jne	_rfuword
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	movl	a0@,d0
	movl	sp@+,_nofault
	rts

_subyte:
_suibyte:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tsubyte
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rsubyte() */
	jne	_rsubyte
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	movb	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts

_suword:
_suiword:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tsuword
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rsuword() */
	jne	_rsuword
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	movl	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts
    1:	movl	#-1,d0
	movl	sp@+,_nofault
	rts

	.globl	_copyseg
	.globl	_clearseg
_copyseg:
	movl	sp@(8),d0		/* page frame number */
	movl	#PGSHIFT,d1
	lsll	d1,d0
	addl	#VEQR_ADDR,d0		/* use v eq phy mapping */
	movl	d0,a1
	movl	sp@(4),a0		/* user virtual */
	movw	#(NBPG>>5)-1,d0		/* 8 longs (32 bytes) per loop */
    1:	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
	dbra	d0,1b
	movl	#0,d0
	rts

_clearseg:
	movl	sp@(4),d0		/* page frame number */
	movl	#PGSHIFT,d1
	lsll	d1,d0
	addl	#VEQR_ADDR,d0		/* use v eq phy mapping */
	movl	d0,a0
	movl	#0,d0			/* return value too */
	movw	#(NBPG>>5)-1,d1		/* 8 longs (32 bytes) per loop */
    1:	movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+;
	movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+;
	dbra	d1,1b
	rts

	.globl	_blkclr
	.globl	_ovbcopy
_blkclr: jmp	_bzero
_ovbcopy:jmp	_bcopy

	.globl	_doadump
_doadump:
	link	a6,#0
	movml	#<d2-d7,a2-a7>,_u	/* update pcb for running process */
	jsr	_dumpsys
	unlk	a6
	rts

	.globl	__reboot
__reboot:
	movl	_vbnum,d0
	movl	_howto,d7
	movl	_devtype,d6
	lea	_tcoff,a1			/* turn off tc */
	pmove	a1@,mmutc
	lea	_ttoff,a1			/* turn off tt0 and tt1 */
	pmove	a1@,mmutt0
	pmove	a1@,mmutt1
	lea	pc@(1f),a0
	addl	#MEM_DUP_MAP,a0			/* run in dup space */
	jmp	a0@
    1:	
	reset
#ifdef notdef
	tstl	d0
	bne	1f
	movw	#SCR_VME_RESET,d1		/* reset VME */
	movsw	d1,SCR_ADDR
    1:
#endif notdef
	movw	#0,d1
	movsw	d1,SCR_ADDR
	jmp	PROM_RESET_REBOOT


	/*
	 * Test-and-set primative. Sets the high-order bit of the 
	 * pointed-to byte. Returns zero (failure) if the byte had 
	 * been nonzero, else 1 (success). Routine is indivisible even 
	 * in multi-processor environment IF the byte is in VME memory.
	 */
	.globl	_tas
_tas:	movl	#0,d0
	movl	sp@(4),a0
	tas	a0@
	jne	1f
	addw	#1,d0
   1:	rts


	.globl	_have68881
/* 
 * Determine if 68881 coprocessor present.
 */
_have68881:
	movml	#<d2,a2>,sp@-
	movw	_scr,d0
	movw	d0,d2
	orw	#SCR_FPU_USE,d0
	movw	d0,_scr
	movsw	d0,SCR_ADDR
	clrl	d0
	movl	vb,a2
	movl	a2@(SCB_EM1111),a0		/* reprogram vectors */
	movl	a2@(SCB_COPROC),a1
	movl	sp,d1
	movl	#1f,a2@(SCB_EM1111)
	movl	#1f,a2@(SCB_COPROC)
	fnop
	movl	#-1,d0
    1:	movl	a0,a2@(SCB_EM1111)
	movl	a1,a2@(SCB_COPROC)
	movl	d1,sp
	movb	d0,_have_68881
	movl	d2,d1
	movml	sp@+,#<d2,a2>
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	rts

	.globl	_byterev
_byterev:
	movl	sp@(4),a0		/* address of byte string */
	movl	a0,a1
	movl	sp@(8),d1		/* length of string */
	addl	#1,d1
	lsrl	#1,d1
	jra	2f
    1:	movw	a1@,d0
	rolw	#8,d0
	movw	d0,a1@+
    2:	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	movl	a1,d0
	rts

/*
 * cksum(sum, string, len, sumlen)
 *  	return 16bit one's complement sum of 'sum' and the 16bit one's 
 *	complement sum of the string 'string' of byte length 'len'.
 *	Complicated by 'len' or 'sumlen' not being even.
 */ 
	.globl	_cksum
_cksum:	movl	d2,sp@-			/* save d2 */
	movl	sp@(8),d0		/* sum */
	movl	sp@(12),a0		/* address of byte string */
	movl	a0,d2
	tstl	sp@(16)			/* length of string */
	jeq	9f			/* zero length string, return */
	andb	#0xF,cc			/* X clerar x bit */
	btst	#0,sp@(20+3)		/* swap bytes ?? */
	jne	4f

	/* sum is word alligned, dont swap bytes */
	btst	#0,d2
	jeq	1f

	/* odd start address, do first byte, and then swap bytes */
	subl	#1,sp@(16)	
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addw	d2,d0			/* X */
	jra	5f

	/* even address, sum alligned */
    1:	movl	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	jra	3f
    2:	movw	a0@+,d2
	addxw	d2,d0			/* X */
    3:	dbra	d1,2b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
	jra	8f

	/* sum is not word alligned, swap bytes */
    4:	btst	#0,d2
	jeq	5f

	/* odd start address, do first byte, and then dont swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	movb	a0@+,d2
	addw	d2,d0			/* X */
	jra	1b

	/* even address, sum misalligned, swap bytes */
    5:	movl	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	jra	7f
    6:	movw	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
    7:	dbra	d1,6b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	addxw	d2,d0			/* X */

	/* fold in last carry bit */
    8:	clrl	d2
	addxw	d2,d0			/* X */
    9:	movl	sp@+,d2			/* restore d2 */
	rts

/*
 * Do a 16 bit one's complement sum of a given number of words
 * The word pointer may not be odd
 */
	.globl	_ocsum
_ocsum:
	movl	sp@(4),a0	/* get ptr */
	movl	sp@(8),d0	/* get word count */
	tstl	d0
	jeq	4f
	movl	d2,sp@-		/* save a reg */
	movl	d0,d2		/* save the count */
	lsrl	#1,d0		/* make d0 longs */
	movl	#0,d1		/* zero accumulator */
	jra	1f		/* into loop */
				/* run in 68010 loop mode til we get a carry */
    2:	addl	a0@+,d1		/* add in long */
    1:	dbcs	d0,2b		/* continue until carry or done */
	jcc	3f		/* if no carry, we're done */
	addl	#1,d1		/* add in carry */
	jra	1b		/* and go back to test for carry again */
    3:	btst	#0,d2		/* another short? */
	jeq	1f		/* no, go away */
	movl	#0,d0		/* must do unsigned add */
	movw	a0@,d0		/* get the short */
	addl	d0,d1		/* add it in */
	jcc	1f
	addl	#1,d1
				/* Now add in high word to low word as above */
    1:	movl	d1,d0
	lsrl	#8,d0		/* get high word in d0 */
	lsrl	#8,d0		/* and clear high do as well */
	andl	#0xFFFF,d1	/* clear high d1 */
	addw	d1,d0		/* add in just the low word */
	movl	#0,d1		/* doesn't clear x bit */
	addxw	d1,d0		/* add in final carry */
	movl	sp@+,d2		/* restore reg */
    4:	rts			/* all done */


/************************************************************************/

#define	SIOCONT(cont)	cont*10

SCBVEC(sio):
	IBEG
	addl	#1,_intrcnt+I_SIO
	clrl sp@-;  jsr _sioint;  addl #4,sp
	RTE	(V_INTR)

#ifdef	SIOPDMA
/*
 * SIO pseudo dma routine:
 *	d0 - port number * sizeof(struct pdma)
 */
	.align	1
	.globl	siodma
siodma:	addl	#_sio_pdma,d0
	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register base address */
	movb	#SIOW0_TXPEND,a0@(SIO_CTRL)	/* reset transmit int pending */
	jra	2f
    1:	movl	a1@+,d1			/* p_mem */
	cmpl	a1@+,d1			/* p_end > p_mem ? */
	bhs	4f			/* no, go call sioxint */
	exg	d1,a1
	movb	a1@+,a0@		/* adata = *p_mem++ */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register base address */
	movb	a0@(SIO_CTRL),d1
	andb	#SIOR0_TXRDY,d1
	jne	1b			/* if not TXRDY, all done */
    3:	movl	#SIO0_ADR+SIO_CTRL,a0	/* force to PORTA */
	movb	#SIOW0_RETINT,a0@
	RTE	(V_PDMA)
    4:	movl	d0,sp@-			/* save d0 */
	movl	a1@+,sp@-		/* push tty address as arg */
	movl	a1@,a1			/* get address of interrupt routine */
	jsr	a1@			/* call interrupt routine */
	addl	#4,sp			/* pop arg (tty address) */
	movl	sp@+,d0			/* restore d0 */
	jra	3b
#endif	SIOPDMA

/************************************************************************/
#ifdef	DEBUGGER
	.globl	dbg_excpt
/* debugger exception handler */
dbg_excpt:
	tstl	_enable_debugger	/* Ignore if debugger is disabled */
	jeq	2f
#ifdef	notdef
	movl	NMIVEC,_dbg_nmi_sav	/* redirect nmi because of */
	movl	#2f,NMIVEC		/* halt button bounce      */
#endif	notdef
	movw	#PSL_IPL7,sr		/* mask all interrupts */
	movl	sp,_dbg_ex_frame	/* save frame addr */
	movml	#<d0-d7,a0-a6>,_dbg_reg_sav
	movl	usp,a0			/* save usp */
	movl	a0,_dbg_usp_sav
	movl	sp,_dbg_ssp_sav		/* save ssp */
	movl	#CACHE_OFF,d0
	movl	d0,cac			/* disable cache */
        clrl    d1                      /* adjust stack frame size */
        movb    sp@(ESF_VEC),d1
        lsrw    #4,d1
	lea	3f,a1			/* test for valid format */
	tstb	a1@(0,d1:w)
	jne	1f
	pea	panic_badfmt
	jsr	_panic
    1:	lea	4f,a1			/* pick frame size, given format */
	clrl	d0
	movb	a1@(0,d1:w),d0
	addl	d0,_dbg_ssp_sav		/* save a7 as usp or ssp */
	movl	_dbg_ssp_sav,_dbg_reg_sav+(15*4)
	btst	#5,sp@
	bne	1f
	movl	_dbg_usp_sav,_dbg_reg_sav+(15*4)
    1:	jsr	_dbg			/* go to debugger */
	movl	_dbg_usp_sav,a0		/* back from debugger */
	movl	a0,usp			/* restore usp */
	movl	_cacr,d0
	movl	d0,cac			/* clear and enable cache */
	movml  _dbg_reg_sav,#<d0-d7,a0-a6>
#ifdef	notdef
        movl    _dbg_nmi_sav,NMIVEC	/* restore nmi vector */
#endif	notdef
    2:	rte

/* STACK FORMAT:0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
#ifdef	M68010
    3:	.byte	1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0
#else	M68010
    3:	.byte	1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
#endif	M68010
esf_len:
    4:	.byte	ESF_ISIZE0, ESF_ISIZE1, ESF_ISIZE2, 0, 0, 0, 0, 0
	.byte	ESF_ISIZE8, ESF_ISIZE9, ESF_ISIZEA, ESF_ISIZEB, 0, 0, 0, 0
	.align	1

	.globl _trap15
_trap15:trap	#15
	rts
#endif	DEBUGGER

/******* D A T A ***********************************************************/
	.data
	.align	1

/* icode */
	.globl	_icode
	.globl	_szicode
	.globl	_initflg
	.globl	_initi
icode:	movml	pc@(2f),#<d0-d1,a0-a1>	/* load syscall args into regs */
	trap	#1			/* do execve syscall */
	movl	#1,d1
	movl	#SYS_exit,d0
	trap	#1			/* do exit syscall */
    1:	jra	1b			/* loop here if cannot execute init */

    2:	.long	SYS_execve		/* d0: syscall: SYS_execve */
	.long	5f-icode		/* d1: file: "/etc/init" */
	.long	3f-icode		/* a0: argv: ("init", "-?", NULL) */
	.long	4f-icode		/* a1: envp: (NULL) */
    3:	.long	initi-icode		/* "init" */
	.long	6f-icode		/* "?" -> to m|s|M|S in startup */
    4:	.long	0			/* NULL */
    5:	.ascii	"/etc/"
initi:	.asciz	"init"
	.space	40			/* leave space for longer inits */
    6:	.byte	0x2D			/* '-' */
initflg:.byte	0x3F			/* '?' multi/single/GWS flag */
	.byte	0x00			/* '\0' */
	.align	1
_icode:		.long	icode		/* pointer to icode */
_szicode:	.long	_icode-icode	/* length of icode */
_initflg:	.long	initflg		/* pointer to init flag */
_initi:		.long	initi		/* pointer to first letter of "init" */

/* signal trampoline code */
	.globl	_sigcode
	.globl	_szsigcode
	.align	1
sigcode:
	bras	1f			/* +0:  stack format 0 entry */
	bras	2f			/* +2:  stack format 2 entry */
	bras	3f			/* +4:  stack format 8 entry */
	bras	4f			/* +6:  stack format 9 entry */
	bras	5f			/* +8:  stack format A entry */
	bras	6f			/* +10: stack format B entry */
		/* stack format 0 */
    1:	bsrs	8f			/* save regs and call handler */
    1:	trap	#8			/* restore sig mask and return */
	bras	1b
		/* stack format 2 */
    2:	bsrs	8f			/* save regs and call handler */
    1:	trap	#6			/* restore sig mask and return */
	bras	1b
		/* stack format 8 */
    3:	bsrs	8f			/* save regs and call handler */
    1:	trap	#5			/* restore sig mask and return */
	bras	1b
		/* stack format 9 */
    4:	bsrs	8f			/* save regs and call handler */
    1:	trap	#4			/* restore sig mask and return */
	bras	1b
		/* stack format A */
    5:	bsrs	8f			/* save regs and call handler */
    1:	trap	#3			/* restore sig mask and return */
	bras	1b
		/* stack format B */
    6:	bsrs	8f			/* save regs and call handler */
    1:	trap	#2			/* restore sig mask and return */
	bras	1b
    8:	link	a6,#-16			/* just like a real stack frame */
	movml	#<d0-d1,a0-a1>,a6@(-16)	/* save regs d0-d1, a0-a1 */
	movml	a6@(8),#<d0-d1,a0-a1>	/* get our args and handler ptr */
	movml	#<d0-d1,a0-a1>,sp@-	/* push our args as args to handler */
	jsr	a1@			/* handler(sig, code, psigctx) */
	movml	a6@(-16),#<d0-d1,a0-a1>	/* restore regs */
	unlk	a6			/* just like a real stack frame */
	rtd	#16			/* pop the args we were called with */
	.align	1
_sigcode:	.long	sigcode
_szsigcode:	.long	_sigcode-sigcode

#ifdef	SYSV
/* sigcode for System V */
	.globl	_sysv_sigcode
	.globl	_sysv_szsigcode
	.align	1
sysv_sigcode:
	bras	1f			/* +0:  stack format 0 entry */
	bras	2f			/* +2:  stack format 2 entry */
	bras	3f			/* +4:  stack format 8 entry */
	bras	4f			/* +6:  stack format 9 entry */
	bras	5f			/* +8:  stack format A entry */
	bras	6f			/* +10: stack format B entry */
		/* stack format 0 */
    1:	bsrs	8f			/* save regs and call handler */
    1:	trap	#8			/* restore sig mask and return */
	bras	1b
		/* stack format 2 */
    2:	bsrs	8f			/* save regs and call handler */
    1:	trap	#6			/* restore sig mask and return */
	bras	1b
		/* stack format 8 */
    3:	bsrs	8f			/* save regs and call handler */
    1:	trap	#5			/* restore sig mask and return */
	bras	1b
		/* stack format 9 */
    4:	bsrs	8f			/* save regs and call handler */
    1:	trap	#4			/* restore sig mask and return */
	bras	1b
		/* stack format A */
    5:	bsrs	8f			/* save regs and call handler */
    1:	trap	#3			/* restore sig mask and return */
	bras	1b
		/* stack format B */
    6:	bsrs	8f			/* save regs and call handler */
    1:	trap	#2			/* restore sig mask and return */
	bras	1b
    8:	link	a6,#-20			/* just like a real stack frame */
	movml	#<d0-d2,a0-a1>,a6@(-20)	/* save regs d0-d2, a0-a1 */
	movml	a6@(8),#<d0-d2,a0-a1>	/* get our args and handler ptr */
	bsrs	9f			/* push return pc !! */
	movml	a6@(-20),#<d0-d2,a0-a1>	/* restore regs */
	unlk	a6			/* just like a real stack frame */
	rtd	#20			/* pop the args we were called with */

    9:	movw	cc,sp@-			/* CC over PC, to make it look as if
					   trap occured here */
	cmpl	#NCRMAGIC,d2		/* check filemagic */
	beq	1f
	movw	#0,sp@-			/* pad word */
	movl	#0,sp@-			/* code: always 0 */
	movl	d0,sp@-			/* signo */
    1:
	jmp	a1@
	.align	1
_sysv_sigcode:	.long	sysv_sigcode
_sysv_szsigcode:	.long	_sysv_sigcode-sysv_sigcode
#endif	SYSV


/************************************************************************/
	.globl	_ast
	.globl	_bus
	.globl	_cache_enable
	.globl	_clev_bio
	.globl	_clev_biomax
	.globl	_clev_clock
	.globl	_clev_clockmax
	.globl	_clev_imp
	.globl	_clev_impmax
	.globl	_clev_tty
	.globl	_clev_ttymax
	.globl	_cpu
	.globl	_devtype
	.globl	_have_68881
	.globl	_howto
	.globl	_int_svc
	.globl	_masterpaddr
	.globl	_nofault
	.globl	_upages
	.globl	is68030
	.globl	is68020
	.globl	_scr
	.globl	_cacr
	.align	1
_int_svc:	.long	0
_scr:		.word	INITSCR
_ast:		.byte	0
	.align	1

_cacr:	.long	CACHE_ON
_cache_enable:	.long	1 /* BSR_W_CACHE */
_cpu:		.long	68030
is68030:	.long	0xFFFFFFFF
is68020:	.long	0xFFFFFFFF
_have_68881:	.long	0
_nofault:	.long	0
_howto:		.long	0
_devtype:	.long	0
_masterpaddr:	.long	0
_upages:	.long	UPAGES
_clev_ttymax:	.long	6
_clev_biomax:	.long	6
_clev_impmax:	.long	6
_clev_clockmax:	.long	6
_clev_tty:	.long	2
_clev_bio:	.long	2
_clev_imp:	.long	2
_clev_clock:	.long	6
_bus:		.asciz	"VME"
		.align	1
vsbmembase:	.space	VSB_MAX_SLOTS*2

	.align	1
N2C:		.asciz	"0123456789ABCDEF"
panic_ljmp:	.asciz	"longjmp"
panic_setrq:	.asciz	"setrq"
panic_remrq:	.asciz	"remrq"
panic_swtch:	.asciz	"swtch"
panic_iret:	.asciz	"iret"
panic_badfmt:	.asciz	"exception format"
panic_stackovf:	.asciz	"kernel stack overflow"
panic_trap:	.asciz	"trap/syscall patch failed"
panic_copyseg:	.asciz	"copyseg illegal user address"
	.text
