/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)in_cksum.c	6.4 (Berkeley) 6/8/85
 */

#include "types.h"
#include "param.h"
#include "mbuf.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"

/*
 * Checksum routine for Internet Protocol family headers (IS68K Version).
 * The work is done in locore.s.
 *
 * This routine is very heavily used in the network code and should be modified
 * for each CPU to be as fast as possible.
 */
#ifdef	OLD_CKSUM
in_cksum(m, len)
	register struct mbuf *m;
	register int len;
{
	register u_short sum = 0;
	register int mlen = 0, slen = 0;

	while (m && len) {
		if ((mlen = m->m_len) > 0) {
			if (len < mlen)
				mlen = len;
			sum = cksum(sum, mtod(m, u_short *), mlen, slen);
			slen += mlen;
			len -= mlen;
		}
		m = m->m_next;
	}
	if (len)
		printf("cksum: out of data\n");
	sum = (~sum) & 0xFFFF;
	return (sum);
}
#else	OLD_CKSUM
/* 
 * following is based on code is from 4.3 timed, it may be more efficient 
 * than what we are currently using above CTH 12/26/68 
 */

in_cksum(m, len)
	register struct mbuf *m;
	register int len;
{
	register int sum = 0;
	register int mlen = 0;
	register u_short *w;
	register int swsum;

	for (;;) {
		w = mtod(m, u_short *);
		if (mlen == -1) {
			sum += *(u_char *)w;
			w = (u_short *)((int)w + 1);
			len--;
			mlen = m->m_len - 1;
		} else
			mlen = m->m_len;
		m = m->m_next;
		if (len < mlen)
			mlen = len;
		if (mlen) {
		    len -= mlen;
		    if (((int)w & 1) == 0) {
			if (((int)w & 2) && mlen >= 2) {
				sum += *w++;
				mlen -= 2;
			} 
			sum += ocsum(w, mlen>>1);
			if (mlen & 1) {
				w += mlen>>1;
				sum += *(u_char *)w << 8;
				mlen = -1;
			}
		    } else {
			swsum = *(u_char *)w;
			w = (u_short *)((int)w + 1);
			mlen--;
			if (((int)w & 2) && mlen >= 2) {
				swsum += *w++;
				mlen -= 2;
			}
			swsum += ocsum(w, mlen>>1);
			if (mlen & 1) {
				w += mlen>>1;
				swsum += *(u_char *)w << 8;
			} else
				mlen = -1;
			swsum = (swsum & 0xFFFF) + (swsum >> 16);
			swsum = (swsum & 0xFFFF) + (swsum >> 16);
			swsum = ((swsum&0x00FF)<<8)|((swsum&0xFF00)>>8);
			sum += swsum;
		    }
		    sum = (sum & 0xFFFF) + (sum >> 16);
		    sum = (sum & 0xFFFF) + (sum >> 16);
		}
		if (len == 0)
			break;
		for (;;) {
			if (m == 0) {
				printf("cksum: out of data\n");
				goto done;
			}
			if (m->m_len)
				break;
			m = m->m_next;
		}
	}
done:	sum = (~sum) & 0xFFFF;
	return (sum);
}
#endif	OLD_CKSUM
