/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)conf.c	6.14 (Berkeley) 2/19/86
 */

#include "param.h"
#include "systm.h"
#include "buf.h"
#include "ioctl.h"
#include "tty.h"
#include "conf.h"

int	nulldev(), nodev(), ttselect(), seltrue();
#define	NU	nulldev		/* noop */
#define	NO	nodev		/* error */

#define	UNUSED_BDEV	{NO, NO, NO, NO, NO, 0 }
#define	UNUSED_CDEV	{NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, 0}

#ifdef	SYSV
#define	UNUSED_FMOD	{"XXXXXXX", 0 }			/* KLUDGE */
#endif	SYSV

/* -------  BUS INDEPENDENT DEVICES --------- */
int	swstrategy(), swread(), swwrite();
#define	SWAP_BDEV	{NO,NO,swstrategy,NO,0,0}
#define	SWAP_CDEV	{NU,NU,swread,swwrite,NO,NO,NU,0,NO,NO,0}

int	sioopen(),sioclose(),sioread(),siowrite(),sioioctl(),siostop();
struct tty sio_tty[];
#define	SIO_CDEV {sioopen,sioclose,sioread,siowrite,sioioctl,siostop,NU, \
		 sio_tty,ttselect,NO,0}


#ifdef	VQX
int     kbopen(),kbclose(),kbread(),kbwrite(),kbioctl();
struct tty con_tty[];
#define KB_CDEV {kbopen,kbclose,kbread,kbwrite,kbioctl,NU,NU, \
                 con_tty,ttselect,NO,0}
#else	VQX
#define	KB_CDEV	UNUSED_CDEV
#endif	VQX


int	syopen(), syread(), sywrite(), syioctl(), syselect();
#define	SY_CDEV	{syopen,NU,syread,sywrite,syioctl,NU,NU,0,syselect,NO,0}

int     mmread(), mmwrite(), mmmap(), mmioctl();
#define MEM_CDEV {NU,NU,mmread,mmwrite,mmioctl,NU,NU,0,seltrue,mmmap,0}

int	logopen(),logclose(),logread(),logioctl(),logselect();
#define	LOG_CDEV {logopen,logclose,logread,NO,logioctl,NO,NU,0,logselect,NO,0}

#include "rd.h"
#if NRD > 0 || Nrd > 0
int	rdopen(),rdstrategy(),rdread(),rdwrite(),rdreset(),rddump(),rdsize();
#define	RD_BDEV	{rdopen,NU,rdstrategy,rddump,rdsize,0}
#define	RD_CDEV {rdopen,NU,rdread,rdwrite,NO,NO,rdreset,0,seltrue,NO,0}
#else
#define	RD_BDEV	UNUSED_BDEV
#define	RD_CDEV	UNUSED_CDEV
#endif

#include "ts.h"
#if NTS > 0 || Nts > 0
int	tsopen(),tsclose(),tsstrategy(),tsread(),tswrite(),
	tsioctl(),tsdump(),tsreset();
#define	TS_BDEV	{tsopen,tsclose,tsstrategy,tsdump,0,B_TAPE}
#define	TS_CDEV	{tsopen,tsclose,tsread,tswrite,tsioctl,NO,tsreset,0,seltrue,\
		NO,0}
#else
#define	TS_BDEV	UNUSED_BDEV
#define	TS_CDEV	UNUSED_CDEV
#endif
 
#include "pty.h"
#if NPTY > 0 || Npty > 0
int	ptsopen(),ptsclose(),ptsread(),ptswrite(),ptsstop();
int	ptcopen(),ptcclose(),ptcread(),ptcwrite(),ptcselect();
int	ptyioctl();
struct	tty pt_tty[];
#define	PTS_CDEV {ptsopen,ptsclose,ptsread,ptswrite,ptyioctl,ptsstop,NU,pt_tty,\
		ttselect,NO,0}
#define	PTC_CDEV {ptcopen,ptcclose,ptcread,ptcwrite,ptyioctl,NU,NU,pt_tty,\
		ptcselect,NO,0}
#else
#define	PTS_CDEV	{NO, NO, NO, NO, NO, NU, NU, 0, NO, NO,0}
#define	PTC_CDEV	UNUSED_CDEV
#endif

#ifdef	 ENETFILTER
int	enetopen(),enetclose(),enetread(),enetwrite(),enetioctl(),enetselect();
#define	ENET_CDEV {enetopen,enetclose,enetread,enetwrite,enetioctl,NU,NU,0,\
		enetselect,NO,0}
#else
#define	ENET_CDEV	UNUSED_CDEV
#endif

#include "sp.h"
#if NSP > 0 || Nsp > 0
int	spopen(),spstrategy(),spread(),spwrite(),spioctl(),spsize();
#define	SP_BDEV	{spopen,NU,spstrategy,NU,spsize,0}
#define	SP_CDEV	{spopen,NU,spread,spwrite,spioctl,NO,NU,0,seltrue,NO,0}
#else
#define	SP_BDEV	UNUSED_BDEV
#define	SP_CDEV	UNUSED_CDEV
#endif

#ifdef	SYSV
#include "stp.h"
#if NSTP > 0
int	stpinfo;
#define	STP_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &stpinfo}
#else
#define	STP_CDEV UNUSED_CDEV
#endif

int	clninfo, loginfo;
#define	CLN_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &clninfo}
#define	STRLOG_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &loginfo}

#ifdef	RFS
extern int	timinfo,trwinfo, loopinfo, RfsNetinfo;
#define	TIMOD_FMOD	{"timod", &timinfo}
#define	TIRDWR_FMOD	{"tirdwr", &trwinfo}
#define	LOOP_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &loopinfo}
#define	RFSNET_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &RfsNetinfo}
#else	RFS
#define	LOOP_CDEV UNUSED_CDEV
#define RFSNET_CDEV UNUSED_CDEV
#endif	RFS

#ifdef	SVVS_NS
extern int	loinfo, lmrinfo, lmeinfo, lmtinfo, lmbinfo, tidinfo, tivinfo, tmxinfo;
#define	LRMOD_FMOD	{"lmodr", &lmrinfo}
#define	LEMOD_FMOD	{"lmode", &lmeinfo}
#define	LTMOD_FMOD	{"lmodt", &lmtinfo}
#define	LBMOD_FMOD	{"lmodb", &lmbinfo}
#define	LO_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &loinfo}
#define	TIDG_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &tidinfo}
#define	TIVC_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &tivinfo}
#define	TMUX_CDEV {NO, NO, NO, NO, NO, NO, NU, 0, NO, NO, &tmxinfo}
#else	SVVS_NS
#define	LO_CDEV UNUSED_CDEV
#define	TIDG_CDEV UNUSED_CDEV
#define	TIVC_CDEV UNUSED_CDEV
#define	TMUX_CDEV UNUSED_CDEV
#endif	SVVS_NS

#include "sxt.h"
#if NSXT > 0
extern int sxtopen(), sxtclose(), sxtread(), sxtwrite(), sxtioctl(); 
#define	SXT_CDEV {sxtopen, sxtclose, sxtread, sxtwrite, sxtioctl, NO, NU, 0, \
		NO, NO, 0}
#else
#define	SXT_CDEV	UNUSED_CDEV
#endif
#endif	SYSV

/* ----------- VME BUS BUS DEVICES ----------- */

#include "sd.h"
#if NSD > 0 || Nsd > 0
int	sdopen(),sdstrategy(),sdread(),sdwrite(),sdioctl(),sdreset(),sddump(),sdsize();
#define	SD_BDEV	{sdopen,NU,sdstrategy,sddump,sdsize,0}
#define	SD_CDEV	{sdopen,NU,sdread,sdwrite,sdioctl,NO,sdreset,0,seltrue,NO,0}
#else
#define	SD_BDEV	UNUSED_BDEV
#define	SD_CDEV	UNUSED_CDEV
#endif

#include "sm.h"
#if NSM > 0 || Nsm > 0
int	smopen(),smstrategy(),smread(),smwrite(),smioctl(),smreset(),smdump(),smsize();
#define	SM_BDEV	{smopen,NU,smstrategy,smdump,smsize,0}
#define	SM_CDEV	{smopen,NU,smread,smwrite,smioctl,NO,smreset,0,seltrue,NO,0}
#else
#define	SM_BDEV	UNUSED_BDEV
#define	SM_CDEV	UNUSED_CDEV
#endif

#include "gt.h"
#if NGT > 0 || Ngt > 0
int	gtblkopen(),gtchropen(),gtclose(),gtstrategy(),gtread(),gtwrite(),
	gtioctl(),gtdump(),gtreset();
#define	GT_BDEV	{gtblkopen,gtclose,gtstrategy,NU,0,B_TAPE}
#define	GT_CDEV	{gtchropen,gtclose,gtread,gtwrite,gtioctl,NO,gtreset,0,seltrue,\
		NO,0}
#else
#define	GT_BDEV	UNUSED_BDEV
#define	GT_CDEV	UNUSED_CDEV
#endif

#define NQT 0
#define Nqt 0
#if NQT > 0 || Nqt > 0
int	qtopen(),qtclose(),qtstrategy(),qtread(),qtwrite(),qtioctl();
int	qtreset();
#define	QT_BDEV	{qtopen,qtclose,qtstrategy,NU,NU,0}
#define	QT_CDEV	{qtopen,qtclose,qtread,qtwrite,qtioctl,NO,qtreset,0,seltrue,\
		NO,0}
#else
#define	QT_BDEV	UNUSED_BDEV
#define	QT_CDEV	UNUSED_CDEV
#endif

#ifdef GZ_RELEASED
#include "gz.h"
#else GZ_RELEASED
#define NGZ 0
#define Ngz 0
#endif GZ_RELEASED
#if NGZ > 0 || Ngz > 0
int	gzopen(),gzclose(),gzstrategy(),gzread(),gzwrite(),gzioctl();
int	gzreset(),gzsize();
#define	GZ_BDEV	{gzopen,gzclose,gzstrategy,NU,gzsize,0}
#define	GZ_CDEV	{gzopen,gzclose,gzread,gzwrite,gzioctl,NO,gzreset,0,seltrue,\
		NO,0}
#else
#define	GZ_BDEV	UNUSED_BDEV
#define	GZ_CDEV	UNUSED_CDEV
#endif

#include "gd.h"
#if NGD > 0 || Ngd > 0
int	gdopen(),gdstrategy(),gdread(),gdwrite(),gdioctl();
int	gdreset(),gddump(),gdsize();
#define	GD_BDEV	{gdopen,NU,gdstrategy,gddump,gdsize,0}
#define	GD_CDEV	{gdopen,NU,gdread,gdwrite,gdioctl,NO,gdreset,0,seltrue,NO,0}
#else
#define	GD_BDEV	UNUSED_BDEV
#define	GD_CDEV	UNUSED_CDEV
#endif

/*
#include "rf.h"
#if NRF > 0 || Nrf > 0
int	rfopen(),rfstrategy(),rfread(),rfwrite(),rfreset(),rfdump(),rfsizeof();
#define	RF_BDEV	{rfopen,NU,rfstrategy,rfdump,rfsizeof,0}
#define	RF_CDEV	{rfopen,NU,rfread,rfwrite,NO,NO,rfreset,0,seltrue,NO,0}
#else
#define	RF_BDEV	UNUSED_BDEV
#define	RF_CDEV	UNUSED_CDEV
#endif
*/
#define	RF_BDEV	UNUSED_BDEV
#define	RF_CDEV	UNUSED_CDEV

#include "cp.h"
#if NCP > 0 || Ncp > 0
int	cpopen(),cpclose(),cpread(),cpwrite(),cpioctl(),cpstop(),cpreset();
struct	tty cp_tty[];
#define	CP_CDEV	{cpopen,cpclose,cpread,cpwrite,cpioctl,cpstop,cpreset,cp_tty,\
		ttselect,NO,0}
int	lpopen(),lpclose(),lpwrite(),lpreset();
#define	LP_CDEV	{lpopen,lpclose,NO,lpwrite,NO,NO,NU,0,seltrue,NO,0}
#else
#define	CP_CDEV	UNUSED_CDEV
#define	LP_CDEV	UNUSED_CDEV
#endif

#ifdef	GWS
int	vtopen(),vtclose(),vtread(),vtwrite(),vtioctl();
struct	tty vt_tty[];
int	fntopen(),fntclose(),fntread(),fntwrite(),fntioctl();
#define	VT_CDEV	{vtopen,vtclose,vtread,vtwrite,vtioctl,NU,NU,vt_tty,ttselect,\
		NO,0}
#define	FNT_CDEV {fntopen,fntclose,fntread,fntwrite,fntioctl,NU,NU,0,seltrue,\
		NO,0}
#else
#define	RP_CDEV	UNUSED_CDEV
#endif

/*#include "enp.h" /**/
#if NENP > 0
int	enpioctl(), enpreconfig(), enpr_read(), enpr_write(), enpr_ioctl();
#define	ENP_CDEV {NU,NU,NO,NO,enpioctl,NO,NU,0,NO,NO}
#define	ENPR_CDEV {NU,NU,enpr_read,enpr_write,enpr_ioctl,NO,NU,0,NO,NO,0}
#else
#define	ENP_CDEV	UNUSED_CDEV
#define	ENPR_CDEV	UNUSED_CDEV
#endif

#include "nw.h"
#if NNW > 0
int	nwioctl(), nwreconfig(), nwr_read(), nwr_write(), nwr_ioctl();
#define	NWR_CDEV {NU,NU,nwr_read,nwr_write,nwr_ioctl,NO,NU,0,NO,NO,0}
#else
#define	NW_CDEV	UNUSED_CDEV
#define	NWR_CDEV UNUSED_CDEV
#endif

#include "gg.h"
#if NGG > 0 || Ngg > 0
int	ggopen(), ggclose(), ggread(), ggwrite(), ggioctl();
#define	GG_CDEV	{ggopen,ggclose,ggread,ggwrite,ggioctl,NO,NU,0,seltrue,NO,0}
#else
#define	GG_CDEV	UNUSED_CDEV
#endif

/*
#include "px.h"
#if NPX > 0 || Npx > 0
int	pxopen(),pxclose(),pxread(),pxwrite(),pxioctl();
#define	PX_CDEV	{pxopen,pxclose,pxread,pxwrite,pxioctl,NO,NU,0,seltrue,NO,0}
#else
#define	PX_CDEV	UNUSED_CDEV
#endif
*/
#define	PX_CDEV	UNUSED_CDEV

/*
#include "sc.h"
#if NSC > 0 || Nsc > 0
int	scopen(), scclose(), scread(), scwrite(), scioctl();
#define SC_CDEV {scopen,scclose,scread,scwrite,scioctl,NO,NU,0,NO,NO,0}
#else
#define SC_CDEV UNUSED_CDEV
#endif
*/
#define SC_CDEV UNUSED_CDEV

/* #include "mst.h"	/**/
#if NMST>0 || Nmst > 0
extern mstopen(),mstclose(),mstread(),mstwrite(),mstioctl(),mstselect();
#define MST_CDEV {mstopen,mstclose,mstread,mstwrite,mstioctl,NU,NU,\
0,mstselect,NO,0}
#else
#define MST_CDEV UNUSED_CDEV
#endif

struct bdevsw	bdevsw[] = {
	SWAP_BDEV,						/*0*/
	SD_BDEV, SM_BDEV, GD_BDEV, RF_BDEV, UNUSED_BDEV,	/*1-5*/
	RD_BDEV,						/*6*/
	QT_BDEV, GT_BDEV,					/*7-8*/
	TS_BDEV,						/*9*/
	SP_BDEV,						/* KLUDGE 10 */

};
int	nblkdev = sizeof (bdevsw) / sizeof (bdevsw[0]);

#define	CONS_MAJ	10
#define	MEM_MAJ		12

struct cdevsw	cdevsw[] = {
	SWAP_CDEV,						/*0*/
#define	SWAP_MAJ	0
	SD_CDEV, SM_CDEV, GD_CDEV, RF_CDEV, UNUSED_CDEV,	/*1-5*/
    	RD_CDEV, 						/*6*/
#define	TRFS_MAJ	6
	QT_CDEV, GT_CDEV,					/*7-8*/
	TS_CDEV, SIO_CDEV, SY_CDEV, MEM_CDEV,			/*9-12*/
	UNUSED_CDEV, CP_CDEV, LP_CDEV,				/*13-15*/
	PTS_CDEV, PTC_CDEV,					/*16-17*/
	UNUSED_CDEV, UNUSED_CDEV,				/*18-19*/
	ENET_CDEV,						/*20*/
#ifdef	GWS
	VT_CDEV, FNT_CDEV,					/*21-22*/
#else	GWS
	PX_CDEV, UNUSED_CDEV, 					/*21-22*/
#endif	GWS
    	ENP_CDEV, ENPR_CDEV, 					/*23-24*/
    	SP_CDEV, 						/*25*/
    	NWR_CDEV, GG_CDEV,					/*26-27*/
    	LOG_CDEV, 						/*28*/
#ifdef	SYSV
    	STP_CDEV, CLN_CDEV, SXT_CDEV, LOOP_CDEV, STRLOG_CDEV,	/*29-33*/
	LO_CDEV, TIVC_CDEV, TIDG_CDEV, TMUX_CDEV, RFSNET_CDEV,	/*34-38*/
#else	SYSV
    	UNUSED_CDEV, UNUSED_CDEV, UNUSED_CDEV, UNUSED_CDEV,	/*29-32*/
    	UNUSED_CDEV, UNUSED_CDEV, UNUSED_CDEV, UNUSED_CDEV,	/*33-36*/
    	UNUSED_CDEV, UNUSED_CDEV,				/*37-38*/
#endif	SYSV
	SC_CDEV,						/*39*/
	MST_CDEV,						/*40*/
        KB_CDEV,                                                /*41*/
};
int	nchrdev = sizeof (cdevsw) / sizeof (cdevsw[0]);

/*
 * Swapdev is a fake device implemented in sw.c used only internally to get to 
 * swstrategy. It cannot be provided to the users, because the swstrategy 
 * routine munches the b_dev and b_blkno entries before calling the appropriate
 * driver.  This would horribly confuse, e.g. the hashing routines. Instead, 
 * /dev/drum is provided as a character (raw) device.
 */
dev_t	swapdev= makedev(SWAP_MAJ, 0);
int	console_no = CONS_MAJ;	/* major device number of console */
int	mem_no = MEM_MAJ; 	/* major device number of memory special file */
#ifdef	TRFS
int	trfs_no = TRFS_MAJ;	/* major device number of network swap device */
#endif	TRFS

#ifdef	SYSV
struct fmodsw	fmodsw[] = {
#ifdef	RFS
	TIMOD_FMOD,
	TIRDWR_FMOD,
#endif	RFS
#ifdef	SVVS_NS
	LRMOD_FMOD,
	LEMOD_FMOD,
	LTMOD_FMOD,
	LBMOD_FMOD,
#endif	SVVS_NS
	UNUSED_FMOD,
};
int fmodcnt = sizeof (fmodsw) / sizeof (fmodsw[0]);
#endif	SYSV
