/*
 * IS-68K20 VQX CPU board constants
 */

#define	SYSV_BASE	0x40000000	/* system virtual base */
#define	VMESPACE	((unsigned)(1<<31))
#define	MAXU_ADDR	0x40000000	/* size of user virtual space */
#define	VEQR_ADDR	0x60000000	/* kernel virtual eq phy mapping */
#define	OBIO_BASE	0x70000000	/* virt addr of on board io-space */
#define OBIO_SIZE	0x4000000	/* map in zero to start of phys mem */

#define	PROM		0x00000000	/* prom */
#define	PROM_BASE	PROM
#define MAXPHYSMEM	0x1000000	/* max physical memory */
#define PHYSMEMBASE	0x4000000	/* physical starting addr of main mem */

#define VME_BASE	VME_EX_BASE	/* virt start of all VME space */
   /* virt start of extended VME space */
#define VME_EX_BASE	((unsigned)0x80000000)
    /* phys start of extended vme for a 4MB main memory system */
#define VME_P_EX4	((unsigned)0x4400000)
    /* phys start of extended vme for a 16MB main memory system */
#define VME_P_EX16	((unsigned)0x5000000)
    /* A32 (extended) vme space starts at VME_EX_BASE regardless of the	*/
    /* amount of memory configured in the system, basically we have	*/
    /* chosen to ignore that protion of extended vme space from		*/
    /* VME_P_EX4 to VME_EX_BASE, except that it will be mapped correctly*/
    /* if it is populated with memory adjacent to the on-board memory,	*/
    /* but it will be mapped in with memory, not into vme space		*/
    /* length of virtual extended vme space */
#define VME_EX_LEN	((unsigned)(VME_P_SHRT - VME_EX_BASE))
    /* phys start of short vme */
#define VME_P_SHRT	((unsigned)0xFEC00000)
    /* length of virtual short vme space */
#define VME_SHRT_LEN	((unsigned)(VME_P_STD - VME_P_SHRT))
    /* phys start of standard vme */
#define VME_P_STD	((unsigned)0xFF000000)
#define VME_STD_LEN	((unsigned)(0 - VME_P_STD))
#define VME_LEN		((unsigned)(0x80000000))


#define	VME_SHORTIO	0xFEC00000  	/* virtual adress of VME short */
#define	VME_STANDARD	0xFF000000	/* virtual adress of VME standard */
#define	VME_EXTENDED	0x80000000  	/* virtual adress of VME extended */

/* 68020 ON CHIP CACHE */
#define	CCACHE_CLEAR	0x08
#define	CCACHE_CE	0x04
#define	CCACHE_FREEZE	0x02
#define	CCACHE_ENABLE	0x01


#define SVTOP(addr)	((u_long)(addr) - SYSV_BASE + PHYSMEMBASE)

#define VDMA_STD(x, cl)	((x) - PHYSMEMBASE)

/* memory offset to page frame number - ONLY WORKS WITH ON-BOARD RAM! */
#define motopf(x)	(btop(((x) + PHYSMEMBASE)))
/* memory page offset to page frame number - ONLY WORKS WITH ON-BOARD RAM! */
#define mpotopf(x)	((x) + btop(PHYSMEMBASE))
/* page frame to map index, used when indexing through Sysmap with pf's */
#define pftondx(x)	((x) - btop(PHYSMEMBASE))

/*
 * The following macros nullify machine dependent functions
 * which are not applicable to the VQX architecture.
 */
#define CACHE_INHIBIT(x)	(x)
#define pte_flush_cache(x, y, z)
#define CTX_SYS		0
