/*
 * LIBERATOR CPU board constants
 */

#define	LOCAL_RAM	0x04000000	/* on board RAM */
#define	VME_STANDARD	0xFF000000	/* VME nontranslated standard address */
#define	VME_SHORTIO	0xFEC00000  	/* VME nontranslated shortio address */
#define	VME_EXTENDED	0x05000000  	/* VME nontranslated extended address */

/* ONBOARD IO SPACE REGISTERS */
#ifdef	LOCORE
#define	PROM		0x00000000	/* prom */
#else	LOCORE
#define	PROM		((unsigned char *)0x00000000)
#endif	LOCORE

#define	PROM_BASE	PROM
#define PROM_REBOOT	(PROM+8)

#define	CCACHE_CLEAR	0x08
#define	CCACHE_CE	0x04
#define	CCACHE_FREEZE	0x02
#define	CCACHE_ENABLE	0x01

/*
 * The following macros nullify machine dependent functions
 * which are not applicable to the IS68K20 architecture.
 */
#define	CACHE_INHIBIT(x) (x)
#define cache_inhibit(x, y)
#define	flush_cache_entry(x, y)
#define pte_flush_cache(x, y, z)
#define refbits()
#define	VDMA_EXT(x,cl)	(x)
#define	VDMA_STD(x,cl)	(x)

