/*
 * IS-68K30 VME CPU board constants
 */

#define	SYSV_BASE	0x40000000	/* system virtual base */
#define	VME_BASE	((unsigned)0x80000000)	/* VME space base */
#define	VMESPACE	((unsigned)(1<<31))
#define	MAXU_ADDR	0x40000000	/* size of user virtual space */
#define	VEQR_ADDR	0x60000000	/* kernel virtual eq phy mapping */
#define	VEQR_CI_ADDR	0x70000000	/* kernel virtual eq phy mapping */
#define	CACHE_INHIBIT(x) (((int)(x)&0x0fffffff)|0x70000000)

#define VSB_IACK_BASE	0x80000000	/* VSB interrupt ack base */
#define VSB_IOAS_BASE	0xA0000000	/* VSB IOAS base */
#define OCTART_ADDR	0xC0000000	/* Octart address */
#define	NVRAM_ADDR	0xC8000000	/* NonVolatile Ram address*/
#define	NVRAM_RESET_ADDR 0x08000000	/* NonVolatile Ram RESET address*/
#define SCR_ADDR      	0xD0000000 	/* system control register */
#define VBMATM_REG	0xE0000000	/* VBMATM map registers */
#define	PROM_RESET_ADDR 0x00000000	/* PROM RESET address */
#define PROM_RESET_REBOOT (PROM_RESET_ADDR+0x0C)
#define	PROM		0xF0000000	/* prom */
#define	PROM_BASE	PROM
#define PROM_REBOOT	(PROM+0xC)
#define MAXPHYSMEM	0x10000000	/* max physical memory */

#define NO_WA(x)	(((unsigned)(x)&0x0FFFFFFF)|0x10000000)	
#define MEM_DUP_MAP	0x20000000
#define MEM_DUP_FUNC(x)	(((unsigned)(x)&0x0FFFFFFF)+MEM_DUP_MAP)	

/* Mostek MK48T02 Non Volatile Ram */
#define	NVRAM_YEAR	(NVRAM_ADDR+0x7FF)	/* year counter */
#define	NVRAM_MONTH	(NVRAM_ADDR+0x7FE)	/* month counter */ 
#define	NVRAM_DATE	(NVRAM_ADDR+0x7FD)	/* date counter */ 
#define	NVRAM_DAY	(NVRAM_ADDR+0x7FC)	/* day counter */ 
#define	NVRAM_HOUR	(NVRAM_ADDR+0x7FB)	/* hour counter */ 
#define	NVRAM_MINUTE	(NVRAM_ADDR+0x7FA)	/* minute counter */ 
#define	NVRAM_SECOND	(NVRAM_ADDR+0x7F9)	/* second counter */ 
#define	NVRAM_CONTROL	(NVRAM_ADDR+0x7F8)	/* control register */ 
#define	NVRAM_RESET_COUNTER	(NVRAM_ADDR+0x7F4) /* reset counter */ 
#define	NVRAM_BOOT_ARGSIZE	80 		/* size of boot arg */ 
#define	NVRAM_BOOT_ARG	(NVRAM_RESET_COUNTER-NVRAM_BOOT_ARGSIZE)
#define	NVRAM_READ	0x40			/* read command */
#define NVRAM_WRITE	0x80			/* write command */

#define	BD_HW_VER	(NVRAM_BOOT_ARG - 2) /* board version ie board lable */
	/* board ver 1.0 = 0x10, board ver 1.2 = 0x12, board ver 2.3 - 0x23 */
#define	BD_FUNC_LEV	(NVRAM_BOOT_ARG - 1) /* board functional level */
#define	BD_FUNC_CACHE_BURST	0x01	/* capable of cache burst  */
#define BD_FUNC_VSB			0x02	/* works with VSB memory, not PVSB */
#define BD_FUNC_16MHZ		0x04	/* runs at 16 Mh, not 25 Mh */
/* bits 3-7 not defined */

/* VBMATM slot assignment */
#define VBM_SHORT_SLOT	0
#define	VBM_STD_SLOT	1
#define	VBM_EXT_SLOT	2
#define	VBM_SLOTS	16		/* number of VBMATM slots */
#define VBM_AM_SHORT	0x2D		/* short io address modifier */
#define VBM_AM_STD	0x3D		/* standard address modifier */
#define VBM_AM_EXT	0x0D		/* extended address modifier */
#define	VBM_PORT_16	1		/* 16 bit port size */
#define	VBM_PORT_32	0		/* 32 bit port size */
#define	VME_SHORTIO	0x80000000  	/* VBMATM(0) VME shortio address */
#define	VME_STANDARD	0x88000000	/* VBMATM(1) VME standard address */
#define	VME_EXTENDED	0x90000000  	/* VBMATM(2) VME extended address */
#define	VBM_BASE(x)	((unsigned)(((x)<<27)|(0x80000000)))


/* VSB constants */
#define VSB_MAX_SLOTS	8		/* maximum VSB slots 1 - 6 */
#define	VSB_IOAS_ID_INCR 0x10000	/* VSB board id increment */
#define	VSB_ID_MASK	0xFC00		/* VSB board id mask */
#define	VSB_ID_SHFT	10		/* VSB board id shift */
#define	VSB_ID_MEM	0x00		/* VSB memory board id */
#define	VSB_MEM_SIZE_MASK 0x0300	/* VSB memory size mask */
#define	VSB_MEM_SIZE_SHFT 8		/* size in 4 meg */
#define	VSB_MEM_SIZE_4MEG 0		/* 4 meg board */
#define	VSB_MEM_SIZE_8MEG 1		/* 8 meg board */
#define	VSB_MEM_SIZE_16MEG 3		/* 16 meg board */
#define	VSB_PAR_ERROR	0x0080		/* VSB memory parity enable */
#define	VSB_MEM_PE_BLK	0x0040		/* parity error on block xfer */
#define	VSB_MEM_PE_GROUP 0x0020		/* parity error memory group */
#define	VSB_MEM_PE_BANK	0x0010		/* parity error memory bank */
#define	VSB_MEM_PE_3	0x0008		/* parity error byte 3 */
#define	VSB_MEM_PE_2	0x0004		/* parity error byte 2 */
#define	VSB_MEM_PE_1	0x0002		/* parity error byte 1 */
#define	VSB_MEM_PE_0	0x0001		/* parity error byte 0 */
#define	VSB_PAR_ENAB	0x8000		/* VSB memory parity enable */
#define	VSB_MEM_BASE_MASK 0x03FF	/* VSB memory base mask */

/* System Control Register defines */
#define	SCR_SOFT_TRAP	0x0001		/* enable software trap */
#define	SCR_INTR_ENAB	0x0002		/* enable interrupt */
#define SCR_VME_INT_ENAB 0x0004		/* enable VME interrupt */
#define	SCR_VME_RESET	0x0008		/* generate VME reset */
#define	SCR_CACHE_CLEAR	0x0010		/* flush cache */
#define	SCR_PROM_DISAB	0x0020		/* disable phantom prom */
#define	SCR_FPU_USE	0x0040		/* enable fpu */
#define	SCR_VME_SYSFAIL	0x0080		/* assert VME sysfail */
#define	SCR_CACHE_ENAB	0x0100		/* external cache enable */
#define	SCR_LED_1	0x0800		/* led 1 */
#define	SCR_LED_2	0x1000		/* led 2 */
#define	SCR_LED_3	0x2000		/* led 3 */
#define	SCR_LEDS	0x3800		/* turn off all leds */
#define	SCR_LED_OFF	0x3800		/* turn off all leds */
#define	SCR_LED_0x1	(SCR_LEDS & ~(SCR_LED_1))		/* code 1 */
#define	SCR_LED_0x2	(SCR_LEDS & ~(SCR_LED_2))		/* code 2 */
#define	SCR_LED_0x3	(SCR_LEDS & ~(SCR_LED_1 | SCR_LED_2)) 	/* code 3 */
#define	SCR_LED_0x4	(SCR_LEDS & ~(SCR_LED_1))		/* code 4 */ 
#define	SCR_LED_0x5	(SCR_LEDS & ~(SCR_LED_1 | SCR_LED_3))	/* code 5 */
#define	SCR_LED_0x6	(SCR_LEDS & ~(SCR_LED_2 | SCR_LED_3))	/* code 6 */
#define	SCR_LED_0x7	(SCR_LEDS & ~(SCR_LEDS))		/* code 7 */

#define	SEQ_OCTART_RST	SCR_LED_0x1
#define	SEQ_READ_BSR	SCR_LED_0x2
#define	SEQ_INIT_SIO	SCR_LED_0x3
#define	SEQ_PROBE_VSB	SCR_LED_0x4
#define	SEQ_INIT_MEM	SCR_LED_0x5
#define	SEQ_RELOCATE	SCR_LED_0x6
#define	SEQ_GO_DEBUG	SCR_LED_0x7
#define	SEQ_RUN_LINK	SCR_LED_0x1			/* VME_SYSFAIL is also off */
#define	SEQ_BOOT_DONE	SCR_LED_OFF

#define CTX_SYS		0	
#define CTX_INVALID	7		/* unallocated context */

#define	VSTD_BASE(cl)	(0x00000000|((cl)<<20)) /* base of VDMA in std space */
#define	VEXT_BASE(cl)	(0x0ff00000|((cl)<<28)) /* base of VDMA in ext space */
#define VDMA_SPACE	0x100000	/* VDMA SPACE */
#define VDMA_INDX_SHFT	6 
#define	VDMA_MAP_ADDR(mapindex,cl) \
 	   ((0xc000)|(((unsigned)mapindex&0x00ff)<<(VDMA_INDX_SHFT))|((cl)<<1))
	
#define	VDMA_STD(x,cl)	((((int)(x)&(VDMA_SPACE-1))) | (VSTD_BASE(cl)))
#define	VDMA_EXT(x,cl)	((((int)(x)&(VDMA_SPACE-1))) | (VEXT_BASE(cl)))

/* System Status registers */
#define	BSR_SWTCH0	0x00000002	/* DIP switch 0 */
#define	BSR_SWTCH5	0x00000008	/* DIP switch 5 */
#define BSR_CLA0	0x00000010	/* Cluster bit 0 */
#define BSR_CLA1	0x00000020	/* Cluster bit 1 */
#define BSR_CLA2	0x00000040	/* Cluster bit 2 */
#define BSR_CLA_MASK	0x00000070
#define BSR_CLA_SHIFT	4

#define	BSR_SWTCH4	0x00000800	/* DIP switch 4 */
#define	BSR_SWTCH3	0x00001000	/* DIP switch 3 */
#define	BSR_VMEINTENAB	0x00002000	/* vme interrupt enable */
#define BSR_VMESYSFAIL	0x00004000	/* vme sys fail */
#define BSR_VMEACFAIL	0x00008000	/* vme ac fail */

#define	BSR_SWTCH2	0x00080000	/* DIP switch 2 */
#define	BSR_SWTCH1	0x00100000	/* DIP switch 1 */
#define	BSR_GA0		0x00200000	/* Geographic address bit 1 */
#define	BSR_GA1		0x00400000	/* Geographic address bit 0 */
#define	BSR_GA2		0x00800000	/* Geographic address bit 2 */

#define BSR_SWTRAP	0x10000000	/* software trap */
#define	BSR_INTERENAB	0x20000000	/* interrupt enable */
#define	BSR_FPUUSED	0x40000000	/* fpu used */
#define	BSR_PARITY	0x80000000	/* parity error */
#define	BSR_VSB_IRQ	0x80000000	/* VSB interrupt ack request */


#define	BSR_SWITCH_MSK	(BSR_SWTCH5 | BSR_SWTCH4 | BSR_SWTCH3 | \
			BSR_SWTCH2 | BSR_SWTCH1 | BSR_SWTCH0)
#define	BSR_DIAG_MODE	(BSR_SWTCH5 | BSR_SWTCH4)  /* sw5 & sw4 =diag mode */
#define	BSR_DIAG_DEBUG 	BSR_SWTCH5  	/* sw5 resident diagnostics */

#define	BSR_KEY_SW3 	BSR_SWTCH3	/* switch 3 - un-used type */
#define	BSR_BAUD	(BSR_SWTCH0 | BSR_SWTCH1 | BSR_SWTCH2)
#define	BSR_BAUD_2400	(BSR_SWTCH0 | BSR_SWTCH1 | BSR_SWTCH2)
					/* all baud switches on */
#define	BSR_BAUD_1200	BSR_SWTCH0	/* sw0 off, sw1 on,  sw2 on */
#define	BSR_BAUD_9600	BSR_SWTCH1	/* sw0 on, sw1 off, sw2 on */
#define	BSR_BAUD_19200	BSR_SWTCH2	/* sw0 on, sw1 on, sw2 off */

/* interrupt vector number assignment */
#define	NMI_VECT	31		/* autovector 7 */
#define	TIMER_VECT	30		/* autovector 6, system timer*/
#define	SIO_VECT	28		/* autovector 4, octart */
#define	PROC_VECT	27		/* autovector 3, interprocessor */
#define	SOFT_VECT	25		/* autovector 1, software */


/*
 * The following macros nullify machine dependent functions
 * which are not applicable to the IS68K30 architecture.
 */
#define ctx_free(x)
#define refbits()
