/*	mmu.h	*/

/* segment protections */

#define	SEG_VALID	0x0000
#define	SEG_INVALID	0x8000

/* page protections */

#define	PAGE_INVALID	0x0000
#define	READ_ONLY	0x4000
#define	EXEC_ONLY	0x8000
#define	READ_WRITE	0xc000

/* page status */

#define	FRESH_PAGE	0
#define DIRTY		1
#define REFERENCE	2


struct vm_context {
	struct proc	*vc_occupant;
	u_short		vc_lastaccess;
};

struct vm_segment {
	u_short		vs_lastalloc;
	u_short		vs_pcontext;
	u_short		vs_psegslot;
};

#define NCNTX		16
#define NSEG		32
#define NUSERSEG	(NSEG-8)
#define NSEGSLOT	64
#define NUSERSEGSLOT	(NSEGSLOT-8)
#define NPAGESLOT	64
