/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)text.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Text structure.
 * One allocated per pure
 * procedure on swap device.
 * Manipulated by text.c
 */
#define	NXDAD	64		/* ISI: TUNE: param.h:MAXTSIZ / dmap.h:DMTEXT */

struct text
{
	struct	text *x_forw;	/* forward link in free list */
	struct	text **x_back;	/* backward link in free list */
	swblk_t	x_daddr[NXDAD];	/* disk addresses of DMTEXT-page segments */
	swblk_t	x_ptdaddr;	/* disk address of page table */
	size_t	x_size;		/* size (clicks) */
	union {
		struct proc *xu_caddr;
		struct pregion *xu_preg;
	} x_un;			/* ISI: SYSV: union for shared mem regions */
#define	x_caddr x_un.xu_caddr	/* ISI: SYSV: ptr to linked proc, if loaded */
#define	x_preg  x_un.xu_preg	/* ISI: SYSV: */
	short	x_noswapcnt;	/* ISI: SYSV: no swap count for shared memory */
	struct vnode *x_vptr;	/* vnode of prototype */
	short	x_rssize;
	short	x_swrss;
	short	x_count;	/* reference count */
	short	x_ccount;	/* number of loaded references */
	short	x_flag;		/* traced, written flags */
	short	x_poip;		/* page out in progress count */
	char	x_slptime;
};

#ifdef	KERNEL
struct	text *text, *textNTEXT;
int	ntext;
#endif

#define	XTRC	0x0001		/* Text may be written, exclusive use */
#define	XNOFREE	0x0001		/* ISI: SYSV: Dont free the shared memory on */
				/* detach. The bit assignment conflicts */
				/* with that of XTRC.  But it is fine */
				/* They are mutually exclusive.       */
#define	XWRIT	0x0002		/* Text written into, must swap out */
#define	XLOAD	0x0004		/* Currently being read from file */
#define	XLOCK	0x0008		/* Being swapped in or out */
#define	XWANT	0x0010		/* Wanted for swapping */
#define	XPAGV	0x0020		/* Page in on demand from inode */
#define	XUNUSED	0x0040		/* unused since swapped out for cache */
#define	XREGION	0x0080		/* ISI: SYSV: text struct associated with region */
#define	XPLOCK	0x0100		/* ISI: SYSV: text structure is locked from swap */
#define	XTRFS	0x0200		/* ISI: TRFS: text associated with TRFS exec */

/*
 * Text table statistics
 */
struct xstats {
	u_long	alloc;			/* calls to xalloc */
	u_long	alloc_inuse;		/*	found in use/sticky */
	u_long	alloc_cachehit;		/*	found in cache */
	u_long	alloc_cacheflush;	/*	flushed cached text */
	u_long	alloc_unused;		/*	flushed unused cached text */
	u_long	free;			/* calls to xfree */
	u_long	free_inuse;		/*	still in use/sticky */
	u_long	free_cache;		/*	placed in cache */
	u_long	free_cacheswap;		/*	swapped out to place in cache */
};

#define X_LOCK(xp) { \
	while ((xp)->x_flag & XLOCK) { \
		(xp)->x_flag |= XWANT; \
		sleep((caddr_t)(xp), PSWP); \
	} \
	(xp)->x_flag |= XLOCK; \
}
#define	XUNLOCK(xp) { \
	if ((xp)->x_flag & XWANT) \
		wakeup((caddr_t)(xp)); \
	(xp)->x_flag &= ~(XLOCK|XWANT); \
}
#define FREE_AT_HEAD(xp) { \
	(xp)->x_forw = xhead; \
	xhead = (xp); \
	(xp)->x_back = &xhead; \
	if (xtail == &xhead) \
		xtail = &(xp)->x_forw; \
	else \
		(xp)->x_forw->x_back = &(xp)->x_forw; \
}
#define FREE_AT_TAIL(xp) { \
	(xp)->x_back = xtail; \
	*xtail = (xp); \
	xtail = &(xp)->x_forw; \
	/* x_forw is NULL */ \
}
#define	ALLOC(xp) { \
	*((xp)->x_back) = (xp)->x_forw; \
	if ((xp)->x_forw) \
		(xp)->x_forw->x_back = (xp)->x_back; \
	else \
		xtail = (xp)->x_back; \
	(xp)->x_forw = NULL; \
	(xp)->x_back = NULL; \
}

extern struct	text *xhead, **xtail;	/* text table free list */
extern int	xcache;			/* number of "sticky" texts retained */
extern int	maxtextcache;		/* maximum number of "sticky" texts */
extern struct	xstats xstats;		/* cache statistics */

