/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)proc.h	7.1 (Berkeley) 6/4/86
 */

/*
 * One structure allocated per active
 * process. It contains all data needed
 * about the process while the
 * process may be swapped out.
 * Other per process data (user.h)
 * is swapped with the process.
 */
struct	proc {
	struct	proc *p_link;	/* linked list of running processes */
	struct	proc *p_rlink;
	struct	proc *p_nxt;	/* linked list of allocated proc slots */
	struct	proc **p_prev;	/*   also zombies, and free proc's */
	struct	pte *p_addr;	/* u-area kernel map address */
	char	p_usrpri;	/* user-priority based on p_cpu and p_nice */
	char	p_pri;		/* priority, negative is high */
	char	p_cpu;		/* cpu usage for scheduling */
	char	p_stat;
	char	p_time;		/* resident time for scheduling */
	char	p_nice;		/* nice for cpu usage */
	char	p_slptime;	/* time since last block */
	char	p_cursig;
	char	p_context;	/* ISI: context number */
	u_char	p_systemcall;	/* ISI: current/last system call */
	int	p_sig;		/* signals pending to this process */
	int	p_sigmask;	/* current signal mask */
	int	p_sigignore;	/* signals being ignored */
	int	p_sigcatch;	/* signals being caught by user */
	int	p_flag;
	u_short	p_xflag;	/* ISI: more flag bits ... */
#ifndef is68k_kobj
#ifdef NPC
	/* p_xflag defines for SMBexit problem */
#define	    PX_NPCUSE	 0x8000 /* process needs to SMBexit when done */
#define	    PX_EXCLO     0x7fff /* mask for exclo count */
#endif NPC
#endif	is68k_kobj
	uid_t	p_uid;		/* user id, used to direct tty signals */
	short	p_pgrp;		/* name of process group leader */
	short	p_pid;		/* unique process id */
	short	p_ppid;		/* process id of parent */
	u_short	p_xstat;	/* Exit status for wait */
	struct	rusage *p_ru;	/* mbuf holding exit information */
	short	p_poip;		/* page outs in progress */
	short	p_szpt;		/* copy of page table size */
	u_int	p_tstart;	/* ISI: SYSV: starting page number of text */
	size_t	p_tsize;	/* size of text (clicks) */
	size_t	p_dsize;	/* size of data space (clicks) */
	size_t	p_ssize;	/* copy of stack size (clicks) */
	size_t 	p_rssize; 	/* current resident set size in clicks */
	size_t	p_maxrss;	/* copy of u.u_limit[MAXRSS] */
	size_t	p_swrss;	/* resident set size before last swap */
	swblk_t	p_swaddr;	/* disk address of u area when swapped */
	caddr_t p_wchan;	/* event process is awaiting */
	struct	text *p_textp;	/* pointer to text structure */
	struct	pte *p_p0br;	/* page table base P0BR */
	struct	pte *p_p1br;	/* page table base P1BR */
	struct	proc *p_xlink;	/* linked list of procs sharing same text */
	short	p_cpticks;	/* ticks of cpu time */
#ifdef vax
	float	p_pctcpu;	/* %cpu for this process during p_time */
#endif
#ifdef is68k
	long	p_pctcpu;	/* %cpu for this process during p_time */
#endif
	short	p_ndx;		/* proc index for memall (because of vfork) */
	short	p_idhash;	/* hashed based on p_pid for kill+exit+... */
	struct	proc *p_pptr;	/* pointer to process structure of parent */
	struct	proc *p_cptr;	/* pointer to youngest living child */
	struct	proc *p_osptr;	/* pointer to older sibling processes */
	struct	proc *p_ysptr;	/* pointer to younger siblings */
	struct	proc *p_dptr;	/* ISI: CDB: process structure of debugger */
#define	p_tptr	p_dptr		/* compatibility */
	struct	itimerval p_realtimer;
	struct	quota *p_quota;	/* quotas for this process */
				/* ISI: record locking */
	short	p_epid;		/* effective pid - normally same as p_pid */
	sysid_t	p_sysid;	/* normally - same as sysid */
				/* if server - system that sent message */
	char	p_universe;	/* ISI: SYSV: universe */
#define	UNIVERSE_BSD	0
#define	UNIVERSE_SYSV	1
	uid_t	p_suid;		/* ISI: NFS: saved (effective) exec user id */
	struct	pklink *p_trecq;/* ISI: TRFS: wipc/trfs receive queue */
	struct	pklink *p_trepq;/* ISI: TRFS: wipc/trfs reply queue */
	gid_t	p_sgid;		/* ISI: SYSV: saved (effective) gid from exec */
	int	p_clktim;	/* ISI: SYSV: time to alarm clock signal */
	time_t	p_utime;	/* ISI: SYSV: user time, this proc */
	time_t	p_stime;	/* ISI: SYSV: system time, this proc */
	struct	proc *p_mlink;	/* ISI: SYSV: link list of processes sleeping 
						on memwant or swapwant */
	struct  pregion	*p_region;/* ISI: SYSV: process regions */
	u_short	mpgneed;	/* ISI: SYSV: memory pages needed in memwant */
	struct	rcvd *p_minwd;	/* ISI: SYSV: server message arrived queue */
	struct	proc *p_rrlink;	/* ISI: SYSV: linked list for server */
	int	p_trlock;	/* ISI: SYSV: */
	struct	vnode *p_trace;	/* ISI: SYSV: pointer to /proc vnode */
	int	p_chold;	/* ISI: SYSV: defer signal bitmask */
				/* sigset turns on this bit */
				/* signal does not turn on this bit */
};

#define	PIDHSZ		64
#define	PIDHASH(pid)	((pid) & (PIDHSZ - 1))

#ifdef KERNEL
short	pidhash[PIDHSZ];
struct	proc *pfind();
struct	proc *proc, *procNPROC;	/* the proc table itself */
struct	proc *freeproc, *zombproc, *allproc;
			/* lists of procs in various states */
int	nproc;

#define	NQS	32		/* 32 run queues */
struct	prochd {
	struct	proc *ph_link;	/* linked list of running processes */
	struct	proc *ph_rlink;
} qs[NQS];
int	whichqs;		/* bit mask summarizing non-empty qs's */
#endif

/* stat codes */
#define	SSLEEP	1		/* awaiting an event */
#define	SWAIT	2		/* (abandoned state) */
#define	SRUN	3		/* running */
#define	SIDL	4		/* intermediate state in process creation */
#define	SZOMB	5		/* intermediate state in process termination */
#define	SSTOP	6		/* process being traced */
#define	SONPRO	7		/* ISI: SYSV: Process being run on processor */
#define	SXBRK	8		/* ISI: SYSV: process being xswapped */

/* flag codes */
#define	SLOAD	0x00000001	/* in core */
#define	SSYS	0x00000002	/* swapper or pager process */
#define	SLOCK	0x00000004	/* process being swapped out */
#define	SSWAP	0x00000008	/* save area flag */
#define	STRC	0x00000010	/* process is being traced */
#define	SWTED	0x00000020	/* another tracing flag */
#define	SULOCK	0x00000040	/* user settable lock in core */
#define	SPAGE	0x00000080	/* process in page wait state */
#define	SKEEP	0x00000100	/* another flag to prevent swap out */
#define	SOMASK	0x00000200	/* restore old mask after taking signal */
#define	SWEXIT	0x00000400	/* working on exiting */
#define	SPHYSIO	0x00000800	/* doing physical i/o (bio.c) */
#define	SVFORK	0x00001000	/* process resulted from vfork() */
#define	SVFDONE	0x00002000	/* another vfork flag */
#define	SNOVM	0x00004000	/* no vm, parent in a vfork() */
#define	SPAGV	0x00008000	/* init data space on demand, from vnode */
#define	SSEQL	0x00010000	/* user warned of sequential vm behavior */
#define	SUANOM	0x00020000	/* user warned of random vm behavior */
#define	STIMO	0x00040000	/* timing out during sleep */
#define	SXLOCK	0x00080000	/* ISI: text segment locked */
#define	SOUSIG	0x00100000	/* using old signal mechanism */
#define	SOWEUPC	0x00200000	/* owe process an addupc() call at next ast */
#define	SSEL	0x00400000	/* selecting; wakeup/waiting danger */
#define	SLOGIN	0x00800000	/* a login process (legit child of init) */
#define	SPTECHG	0x01000000	/* pte's for process have changed */
			    /* ISI: local flag codes */
#define	SPOLL	0x02000000	/* ISI: SYSV: process in stream poll */
#define	SRSIG	0x04000000	/* ISI: SYSV: Set when signal goes remote */
#define	SOWNGIP	0x08000000	/* ISI: GWS: process owns graphics processor */
#define SPHIGH	0x10000000	/* ISI: REALTIME: process is high priority */
#define	SPLOCK	0x20000000	/* ISI: REALTIME: process is locked in core */
#define SLKDONE 0x40000000	/* ISI: NFS: record-locking has been done */
#define SSKY	0x80000000	/* ISI: SKY: using sky ffp board */
