/* ISI: $Header: param.h,v 1.3 88/03/11 11:53:28 mcneal Exp $ */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)param.h	7.1 (Berkeley) 6/4/86
 */

#define	BSD	43		/* 4.3 * 10, as cpp doesn't do floats */
#define BSD4_3	1

/*
 * Machine type dependent parameters.
 */
#ifdef KERNEL
#include "../machine/machparam.h"
#else
#include <machine/machparam.h>
#endif

#define	NPTEPG		(NBPG/(sizeof (struct pte)))

/*
 * Machine-independent constants
 */
#define	NMOUNT	20		/* number of mountable file systems */
/* NMOUNT must be <= 255 unless c_mdev (cmap.h) is expanded */
#define	MSWAPX	NMOUNT		/* pseudo mount table index for swapdev */
#define	MAXUPRC	40		/* max processes per user */
#define	NOFILE	64		/* max open files per process */
#define	MAXPID	30000		/* ISI: SYSV: max process id */
#define	MAXUID	60000		/* ISI: SYSV: max user id */
#define	CDLIMIT	(1L << 17)	/* ISI: SYSV: default max file size
				   Default was 11 which is a 1Meg file limit.
				   That's a little unreasonable so I bumped it up
				   to 64Mb. */
#ifdef	is68k
#define	MAXLINK	1000		/* ISI: SYSV: max links */
#else	is68k
#define	MAXLINK	32767		/* ISI: SYSV: max links */
#endif	is68k
#define	CANBSIZ	256		/* max size of typewriter line */
#define	NCARGS	20480		/* # characters in exec arglist */
#define	NGROUPS	16		/* max number groups */

#define	NOGROUP	65535		/* marker for empty group set member */

/*
 * Priorities
 */
#define	PMASK	0177
#define	PCATCH	0400		/* return if sleep interrupted, don't longjmp */
#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PRIUBA	24
#define	PZERO	25
#define	PPIPE	26
#define	PVFS	27
#define	PWAIT	30
#define	PLOCK	35
#define	PSLEP	40
#define	PUSER	50

#define	NZERO	0

/*
 * Signals
 */
#ifdef KERNEL
#ifndef LOCORE
#include "signal.h"
#ifdef	SYSV
#include "../sysv/sys/signal.h"
#endif	SYSV
#endif	LOCORE
#else	KERNEL
#ifndef	SYSV
#include <signal.h>
#endif	SYSV
#endif

#ifdef	SYSV
#define	ISSIG(p) \
	((p)->p_sig && ((p)->p_flag&STRC || \
	 ((p)->p_sig &~ ((((p)->p_universe == UNIVERSE_BSD) ? \
	 (p)->p_sigignore : ((p)->p_sigignore & ~sigmask(SIGCLD_SV))) \
	 | (p)->p_sigmask))) && issig())
#else	SYSV
#define	ISSIG(p) \
	((p)->p_sig && ((p)->p_flag&STRC || \
	 ((p)->p_sig &~ ((p)->p_sigignore | (p)->p_sigmask))) && issig())
#endif	SYSV

#define	NBPW	sizeof(int)	/* number of bytes in an integer */

#ifndef	NULL
#define	NULL	0
#endif	NULL
#define	CMASK	022		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)

/*
 * Clustering of hardware pages on machines with ridiculously small
 * page sizes is done here.  The paging subsystem deals with units of
 * CLSIZE pte's describing NBPG (from vm.h) pages each.
 *
 * NOTE: SSIZE, SINCR and UPAGES must be multiples of CLSIZE
 */
#define	CLBYTES		(CLSIZE*NBPG)
#define	CLOFSET		(CLSIZE*NBPG-1)	/* for clusters, like PGOFSET */
#define	claligned(x)	((((int)(x))&CLOFSET)==0)
#define	CLOFF		CLOFSET
#define	CLSHIFT		(PGSHIFT+CLSIZELOG2)

#if CLSIZE==1
#define	for_CLSIZE(Z)	(Z) = 0;
#define	clbase(i)	(i)
#define	clrnd(i)	(i)
#else
/* loop for all pages in CLUSTER size */
#define	for_CLSIZE(Z)	for ((Z) = 0; (Z) < CLSIZE; (Z)++)
/* give the base virtual address (first of CLSIZE) */
#define	clbase(i)	((i) &~ (CLSIZE-1))
/* round a number of clicks up to a whole cluster */
#define	clrnd(i)	(((i) + (CLSIZE-1)) &~ (CLSIZE-1))
#endif

/* CBLOCK is the size of a clist block, must be power of 2 */
#define	CBLOCK	128
#define	CBSIZE	(CBLOCK - 4/*sizeof(struct cblock *)*/)	/* data chars/clist */
#define	CROUND	(CBLOCK - 1)				/* clist rounding */

#ifndef KERNEL
#include	<sys/types.h>
#else
#ifndef LOCORE
#include	"types.h"
#endif
#endif

/*
 * File system parameters and macros.
 *
 * The file system is made out of blocks of at most MAXBSIZE units,
 * with smaller units (fragments) only in the last direct block.
 * MAXBSIZE primarily determines the size of buffers in the buffer
 * pool. It may be made larger without any effect on existing
 * file systems; however making it smaller make make some file
 * systems unmountable.
 *
 * Note that the blocked devices are assumed to have DEV_BSIZE
 * "sectors" and that fragments must be some multiple of this size.
 * Block devices are read in BLKDEV_IOSIZE units. This number must
 * be a power of two and in the range of
 *	DEV_BSIZE <= BLKDEV_IOSIZE <= MAXBSIZE
 * This size has no effect upon the file system, but is usually set
 * to the block size of the root file system, so as to maximize the
 * speed of ``fsck''.
 */
#define	MAXBSIZE	8192
#define	DEV_BSIZE	512
#define	DEV_BSHIFT	9		/* log2(DEV_BSIZE) */
#define BLKDEV_IOSIZE	2048
#define MAXFRAG 	8

#define	btodb(bytes)	 		/* calculates (bytes / DEV_BSIZE) */ \
	((unsigned)(bytes) >> DEV_BSHIFT)
#define	dbtob(db)			/* calculates (db * DEV_BSIZE) */ \
	((unsigned)(db) << DEV_BSHIFT)

/*
 * Map a ``block device block'' to a file system block.
 * This should be device dependent, and will be after we
 * add an entry to cdevsw for that purpose.  For now though
 * just use DEV_BSIZE.
 */
#define	bdbtofsb(bn)	((bn) / (BLKDEV_IOSIZE/DEV_BSIZE))

/*
 * MAXPATHLEN defines the longest permissable path length
 * after expanding symbolic links. It is used to allocate
 * a temporary buffer from the buffer pool in which to do the
 * name expansion, hence should be a power of two, and must
 * be less than or equal to MAXBSIZE.
 * MAXSYMLINKS defines the maximum number of symbolic links
 * that may be expanded in a path name. It should be set high
 * enough to allow all legitimate uses, but halt infinite loops
 * reasonably quickly.
 */
#define MAXPATHLEN	1024
#define MAXSYMLINKS	20

/*
 * bit map related macros
 */
#define	setbit(a,i)	((a)[(i)/NBBY] |= 1<<((i)%NBBY))
#define	clrbit(a,i)	((a)[(i)/NBBY] &= ~(1<<((i)%NBBY)))
#define	isset(a,i)	((a)[(i)/NBBY] & (1<<((i)%NBBY)))
#define	isclr(a,i)	(((a)[(i)/NBBY] & (1<<((i)%NBBY))) == 0)

/*
 * Macros for fast min/max.
 */
#define	MIN(a,b)	(((a)<(b))?(a):(b))
#define	UMIN(a,b)	(((u_int)(a)<(u_int)(b))?(u_int)(a):(u_int)(b))
#define	IMIN(a,b)	(((int)(a)<(int)(b))?(int)(a):(int)(b))
#define	MAX(a,b)	(((a)>(b))?(a):(b))
#define	UMAX(a,b)	(((u_int)(a)>(u_int)(b))?(u_int)(a):(u_int)(b))
#define	IMAX(a,b)	(((int)(a)>(int)(b))?(int)(a):(int)(b))

/*
 * Macros for counting and rounding.
 */
#ifndef howmany
#define	howmany(x, y)	((unsigned int)(((x)+((y)-1)))/(unsigned int)(y))
#endif
#define	roundup(x, y)	(((unsigned int)(((x)+((y)-1)))/(unsigned int)(y))*(y))

/*
 * Maximum size of hostname recognized and stored in the kernel.
 */
#define MAXHOSTNAMELEN	64

/*
 * ISI: factor for scaled integers used to count %cpu time and load averages.
 *	aviod floating point in kernel!
 */
#define	FSHIFT	8		/* bits to right of fixed binary point */
#define	FSCALE	(1<<FSHIFT)

/*	To avoid prefetch errors at the end of a region, it must
**	be padded with the following number of bytes.
*/
#define	PREFETCH	12	/* ISI: SYSV */


/*
 *	RFS-related information	
 */

#define	NBPC	4096		/* Number of bytes per click */
/* REMOTE -- whether machine is primary, secondary, or regular */
#define SYSNAME 9		/* ISI: SYSV # chars in system name */
#define PREMOTE 39		/* ISI: SYSV */
