/* ISI: $Header: exec.h,v 1.2 88/04/07 16:31:25 root Exp $ */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)exec.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Header prepended to each a.out file.
 */
struct exec {
#ifdef vax
	unsigned long	a_magic;	/* magic number */
#endif vax
#ifdef is68k
	unsigned short	a_machtype;	/* ISI: machine type */
#define M_68010		0x0000		/* 	ISI: 68010 image */
#define M_68020		0x0001		/* 	ISI: 68020 image */
#define M_68881		0x0002		/* 	ISI: 68881 image */
#define M_SYSV_MASK	0xF800		/* 	ISI: SYSV: */
#define M_SYSV_VAL	0x0800		/* 	ISI: SYSV: */
#define	M_ISSYSV(a)	((a->a_machtype & M_SYSV_MASK) == M_SYSV_VAL) /* ISI: SYSV: */
#define M_IS68020(a)	((a).a_machtype & M_68020)
#define M_IS68881(a)	((a).a_machtype & M_68881)
	unsigned short	a_magic;	/* ISI: magic number */
#endif is68k
	unsigned long	a_text;		/* size of text segment */
	unsigned long	a_data;		/* size of initialized data */
	unsigned long	a_bss;		/* size of uninitialized data */
	unsigned long	a_syms;		/* size of symbol table */
	unsigned long	a_entry;	/* entry point */
	unsigned long	a_trsize;	/* size of text relocation */
	unsigned long	a_drsize;	/* size of data relocation */
};

#define	OMAGIC	0407			/* old impure format */
#define	NMAGIC	0410			/* read-only text */
#define	ZMAGIC	0413			/* demand load format */

struct sysv_exdata {			/* ISI: SYSV: coff exec info */
	struct vnode	*vp;
	long      	a_tsize;	/* text size    */
	long      	a_dsize;	/* data size    */
	long      	a_bsize;	/* bss size     */
	long      	a_lsize;  	/* lib size     */
	long      	a_nshlibs; 	/* no of shared libs needed  */
	short     	a_mag;   	/* magic number MUST be here */
	long      	a_toffset;	/* file offset to raw text   */
	long      	a_doffset;	/* file offset to raw data   */
	long      	a_loffset;	/* file offset to lib sctn   */
	long      	a_txtorg;	/* text start addr. in mem   */
	long      	a_datorg;	/* data start addr. in mem   */
	long      	a_bssorg;	/* bss start addr. in mem    */
	long      	a_entloc;	/* entry location            */
};
