/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)cmap.h	7.1 (Berkeley) 6/4/86
 */

/*
 * core map entry
 *
 * Limits imposed by this structure:
 *
 *		limit		     cur. size		fields
 *	Physical memory+		256 Mb	c_next, c_prev, c_hlink
 *	Mounted filesystems		unlimited c_vnode
 *	size of a process segment	256 Mb	c_page
 *	filesystem size			8 Gb	c_blkno
 *	proc, text table size		64K	c_ndx
 *
 *	+ memory can be expanded by converting first three entries
 *	to bit fields, shrinking c_ndx, and increasing MAXMEM below.
 */
#ifndef	LOCORE
struct cmap
{
unsigned short 	c_next,		/* index of next free list entry */
		c_prev,		/* index of previous free list entry */
		c_hlink,	/* hash link for <vp,blkno> */
		c_ndx,		/* index of owner proc or text */
		c_page;		/* virtual page number in segment */
unsigned int	c_type:3,	/* type CSYS or CTEXT or CSTACK or CDATA */
				/* ISI: SYSV: or CLIBTXT or CLIBDAT or CSHMEM */
		c_lock:1,	/* locked for raw i/o or pagein */
		c_want:1,	/* wanted */
		c_free:1,	/* on the free list */
		c_gone:1,	/* associated page has been released */
		c_intrans:1,	/* intransit bit */
		c_blkno:24;	/* disk block this is a copy of */
struct vnode	*c_vp;		/* vnode to which c_blkno refers */
};
#endif	LOCORE

#define	MAXMEM	256*1024		/* maximum memory, in Kbytes */

#define	CMHEAD	0

/*
 * Shared text pages are not totally abandoned when a process
 * exits, but are remembered while in the free list hashed by <mdev,blkno>
 * off the cmhash structure so that they can be reattached
 * if another instance of the program runs again soon.
 */
#define	CMHSIZ	2048		/* SHOULD BE DYNAMIC */
#define	CMHASH(bn)	((bn)&(CMHSIZ-1))

#ifndef	LOCORE
#ifdef	is68k
#define	CM_SETSIZE	(((MAXMEM)*1024)/NBPG)
typedef	struct cm_set {
	fd_mask	cms_bits[howmany(CM_SETSIZE, NFDBITS)];
} cm_set;
#define	CM_SET(n, p)	((p)->cms_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	CM_CLR(n, p)	((p)->cms_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	CM_ISSET(n, p)	((p)->cms_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define CM_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif	is68k
#ifdef	KERNEL
struct	cmap *cmap;
struct	cmap *ecmap;
int	ncmap;
struct	cmap *mfind();
int	firstfree, maxfree;
int	ecmx;			/* cmap index of ecmap */
u_short	cmhash[CMHSIZ];
#ifdef	is68k
cm_set	freememmap;
#endif	is68k
#endif

/* bits defined in c_type */

#define	CSYS		0		/* none of below */
#define	CTEXT		1		/* belongs to shared text segment */
#define	CDATA		2		/* belongs to data segment */
#define	CSTACK		3		/* belongs to stack segment */
#define	CLIBTXT		4		/* ISI: SYSV: belongs to shared lib text */
#define	CLIBDAT		5		/* ISI: SYSV: belongs to shared lib data */
#define	CSHMEM		6		/* ISI: SYSV: belongs to shared memory */

#define	pgtocm(p)	(((int) ((p)-firstfree) / CLSIZE) + 1)
#define	cmtopg(x)	((((x)-1) * CLSIZE) + firstfree)
#define	cmtocmp(x)	(&cmap[x])
#define	cmptocm(c)	((int)((c)-cmap))
#define	pgtocmp(p)	(cmtocmp(gptocm(p)))
#define	cmptopg(c)	(cmtopg(cmptocm(c)))
#endif	LOCORE
