/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)clist.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Raw structures for the character list routines.
 */
struct cblock {
	struct cblock	*c_next;
	char		c_info[CBSIZE];
};
#ifdef KERNEL
struct	cblock *cfree;
#ifndef	VQX
int     cfree_vdma;                     /* VDMA resource for all cblocks */
#endif	VQX
int	nclist;
struct	cblock *cfreelist;
int	cfreecount;

#ifndef	VQX
/* compute io address from pointer within clist memory */
#define CDMA_ADR(x)     (cfree_vdma + ((int)x - (int)cfree))
#endif	VQX
#endif	KERNEL
