/*
 * Patch prologue and epilogue of trap() and syscall() (both in trap.o) to save
 * all registers at a known offset on the stack. This is very compiler 
 * dependent. The current implementation assumes that locals and temps are 
 * referenced relative to the frame pointer (NOT the sp) and that there are 
 * no more than LOCAL_TEMPS local variables and temps to save.
 */
/*#define DEBUG /**/

#include <nlist.h>
#include <machine/reg.h>

#define	N_SYMBOLS	6
struct nlist nl[N_SYMBOLS+1] = {
	{ "_trap" },			/* prologue/epilogue pairs */
	{ "_trap_end" },

	{ "_syscall" },
	{ "_syscall_end" },

	{ "_sysv_syscall" },
	{ "_sysv_syscall_end" },

	{ "" },
};

unsigned short p[5], e[5];

main()
{
	register char *file_name = "trap.o";
	register int i, file, j;

	nlist(file_name, nl);
	if (nl[0].n_type == 0) {
		printf("patch_trap: %s not found in %s's namelist\n", 
			nl[0].n_name, file_name);
		exit(1);
	}
	for (i = 0 ; i < N_SYMBOLS; i++)	/* adjust for a.out header */
		nl[i].n_value += 0x20;		/* KLUDGE */
	file = open(file_name, 2);
	if (file < 0) {
		printf("patch_trap: cannot open %s\n", file_name);
		exit(1);
	}

	for (i = 0; i < N_SYMBOLS; i += 2) {
		if (nl[i].n_value <= 0x20)
			continue;
		if (lseek(file, nl[i].n_value, 0) < 0) {
			perror("patch_trap: prologue seek");
			exit(1);
		}
		if (read(file, p, sizeof(p)) != sizeof(p)) {
			perror("patch_trap: prologue read");
			exit(1);
		}
		if (lseek(file, nl[i+1].n_value, 0) < 0) {
			perror("patch_trap: epilogue seek");
			exit(1);
		}
		if (read(file, e, sizeof(e)) != sizeof(e)) {
			perror("patch_trap: epilogue read");
			exit(1);
		}

#ifdef	DEBUG
		printf("old prologue: ");
		for (j = 0 ; j < sizeof(p)/sizeof(p[0]) ; j++)
			printf("%4x ", p[j]);
		printf("\n");
		printf("old epilogue: ");
		for (j = 0 ; j < sizeof(e)/sizeof(e[0]) ; j++)
			printf("%4x ", e[j]);
		printf("\n");
#endif	DEBUG
		if (p[0] == 0x4e56 && p[2] == 0x48e7 &&
		    e[0] == 0x4cee && e[3] == 0x4e5e &&
		    (-((int)(*(short *)&(p[1]))) < (10 + LOCAL_TEMPS)*4)) {
			p[1] = -(LOCAL_TEMPS*4);
			p[3] = 0x3F3C;	/* save d[2-7],a[2-5] */
			e[1] = 0x3CFC;	/* restore d[2-7],a[2-5] */
			e[2] = -((10 + LOCAL_TEMPS)*4);
		} else {
			printf("patch_trap: %s at %x: prologue/epilogue mismatch\n",
				nl[i].n_name, nl[i].n_value);
			exit(1);
		}
#ifdef	DEBUG
		printf("new prologue: ");
		for (j = 0 ; j < sizeof(p)/sizeof(p[0]) ; j++)
			printf("%4x ", p[j]);
		printf("\n");
		printf("new epilogue: ");
		for (j = 0 ; j < sizeof(e)/sizeof(e[0]) ; j++)
			printf("%4x ", e[j]);
		printf("\n");
#endif	DEBUG

		if (lseek(file, nl[i].n_value, 0) < 0) {
			perror("patch_trap: prologue seek");
			exit(1);
		}
		if (write(file, p, sizeof(p)) != sizeof(p)) {
			perror("patch_trap: prologue write");
			exit(1);
		}
		if (lseek(file, nl[i+1].n_value, 0) < 0) {
			perror("patch_trap: epilogue seek");
			exit(1);
		}
		if (write(file, e, sizeof(e)) != sizeof(e)) {
			perror("patch_trap: epilogue write");
			exit(1);
		}
	}
	printf("patch_trap: successful patch\n");
	exit(0);
}
