#include<stdio.h>
#include<sys/types.h>
#include<ctype.h>

#define MAXLINELEN 256
#define MAXADDRS 30
#define DEVNAMELEN 10
#define SPACENAMELEN 30
#define ADDRLEN 10
#define NOTUSED -1
#define NOTADDRS 3
char daddrfile[] = "../conf/devaddrtab";
char csrcfile[] = "stddev.c";
char linebuf[MAXLINELEN];

char *spacetypes[] = {
		"vme_short",
		"vme_std",
		"vme_ext",
		"qbus",
		"res_vme_short",
		"res_vme_std",
		"res_vme_ext",
		"res_qbus",
		"on_board",
		"\0" };


		
		
/* -----------------------------------------------------------*/

struct item{
	char devname[DEVNAMELEN];
	char devspace[SPACENAMELEN];
	int csrlen;
	int doflag;
	int devaddrs[MAXADDRS];
};

struct node{
	struct item *item;
	struct node *next;
	struct node *prev;
};
typedef struct node node_t;
	
struct header{
	int len;
	node_t	*first;
	node_t  *last;
};
typedef struct header head_t;

head_t	*ini_header();
node_t	*ini_node();
struct item *ini_item();
/* -----------------------------------------------------------*/	

int debug = 0;
int ignore = 0;
int warnonly = 0;	
main(argc,argv)
	int argc;
	char *argv[];
{
	
		
		
	extern int optind;
	extern char *optarg;
	char daddr[MAXADDRS][ADDRLEN];
	char devname[DEVNAMELEN];
	char spacename[SPACENAMELEN];
	char csrlenstr[ADDRLEN];
	char *tptr;
	int ret,i,j,c;
	FILE *infile, *outfile, *fopen();
	head_t *list;
	node_t *newnode;
	struct item *newitem;
	char *nameptr;



	while((c= getopt(argc,argv,"diw")) != EOF){
		switch(c){
		case 'd':
			debug = 1;
			break;
		case 'i':
			ignore = 1;		
			break;
		case 'w':
			warnonly = 1;
			break;
		case '?':
		default:
			printf("Usage: addrconf [-d] [-a]\n");
			printf("-d = print debug messages\n");
			printf("-i = ignore address conflicts\n");
			printf("-w = warn of address conflicts\n");
			printf("-w overrides -i\n");
			exit(0);
			break;
		}
	}
	if ( warnonly && ignore )
		ignore = 0;

	if ((infile = fopen(daddrfile,"r")) == NULL ){
		fprintf(stderr,"addrconf: can't open %s\n",daddrfile);
		perror("failed on fopen of inputfile");
		exit(1);
	}


	outfile = stdout;
	
	if((list = ini_header()) == NULL){
		perror("malloc failed\n");
		exit(1);
	}	

	for(;;){
		if (fgets(linebuf,MAXLINELEN,infile) == NULL )
                       break;
                if ( linebuf[0] == '#' || linebuf[0] == '\n') 
                        continue;

		/* if (blank_line())
			continue; */
		ret=sscanf(linebuf, 
			"%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
			devname, spacename, csrlenstr, daddr[0],
			daddr[1],daddr[2],daddr[3],	
			daddr[4],daddr[5],daddr[6],	
			daddr[7],daddr[8],daddr[9],	
			daddr[10],daddr[11],daddr[12],	
			daddr[13],daddr[14]);
	
		if(ret < 0){
			perror("addrconf: sscanf failed\n");
			exit(1);
		}
		if(debug){	
			printf("%s\n",linebuf);
			printf("ret = %d\n",ret);
			printf("devname = %s spacename = %s csrlen = %s\n",
				devname,spacename,csrlenstr);
			for(i = 0; i < ret - NOTADDRS; i++){
				printf("address %d = %s\n",i,daddr[i]);
			}          
		}


		if(check_space(spacename)){
			fprintf(stderr,
				"invalid address space %s for device %s\n",
				spacename,devname);
			exit(1);
		}
		
		if((newitem = ini_item()) == NULL){
			perror("malloc for new item failed\n");
			exit(1);
		}	
		
		strcpy(newitem->devname,devname); 
		if (!strncmp(spacename,"res_",4)){
			tptr = &spacename[4];
			strcpy(newitem->devspace,tptr);	         
			newitem->doflag = 0;
		}else{
			strcpy(newitem->devspace,spacename);   
			newitem->doflag = 1;
		}
		ini_devaddrs(newitem);	
		
		if((newitem->csrlen = strtoint(csrlenstr)) < 0){
				fprintf(stderr,"addrconf:");
				fprintf(stderr,"len for %s: %s not a number\n",
					devname,csrlenstr);
				exit(1);
		}		

		for(i = j = 0; i < ret - NOTADDRS; i++, j++){
			/* convert string to a int */
			newitem->devaddrs[j] = strtoint(daddr[i]);

			/* Check for duplicate address on device's *
			 * address list				   */

			if(check_dup_addr(newitem->devaddrs,
				newitem->devaddrs[j],j)){
				fprintf(stderr,"duplicate address %s at %x\n",
					newitem->devname,newitem->devaddrs[j]);
				exit(1);	
			}
			
			if(newitem->devaddrs[j] < 0 ){ 
				fprintf(stderr,
					"%s is not a number for device %s\n",
					daddr[i],devname);
				exit(1);
			}
		
			if(!ignore){		
				if(check_in_use(list,newitem,
				   newitem->devaddrs[j])){
					if(!warnonly){
					   fprintf(stderr,
						"addr 0x%x not added for %s\n",
						newitem->devaddrs[j],
						newitem->devname);
					   newitem->devaddrs[j] = NOTUSED;
					   j--;
					}
				}	
			}
		}          
	
		
	
		
	/*	if((nameptr = (char *)malloc(DEVNAMELEN)) == NULL){
			perror("malloc failed\n");
			exit(1);
		}

		strcpy(nameptr,devname); */

		if((newnode = ini_node(newitem)) == NULL){
			perror("malloc in ini_node failed\n");
			exit(1);
		}
	
		newnode->item = newitem;
		
		add_to_list(list,newnode);
		
		bzero(linebuf,MAXLINELEN);
	}
	if(debug){
		print_list(list);
	}
	delete_reserved(list);
	makecfile(list,outfile);
	fclose(infile);
	fclose(outfile);
}

	         		
		



node_t *
ini_node(val)
        struct item *val;
{
        node_t *new_item;
        if( new_item = (node_t *)malloc(sizeof(node_t))){
                new_item->item = val;
        }
        return(new_item);
}

head_t *
ini_header(){
        head_t *head;

        if(head = (head_t *)malloc(sizeof(head_t))){
                head->len = 0;
                head->first = NULL;
                head->last = NULL;
        }
        return(head);
}

struct item *
ini_item(){
	struct item *item;
	return((struct item *)malloc(sizeof(struct item)));
}
add_to_list(header, node)
	head_t	*header;
	node_t	*node;
{
	node_t *nodeptr;
	if(header->len == 0){
		header->first = node;
		header->last = node;
		header->len++;
	}else{
		nodeptr = header->last;
		nodeptr->next = node;
		node->prev = nodeptr;
		node->next = NULL;
		header->last = node;
		header->len++;
	}
}	
	
check_dup(header, name)
	head_t *header;
	char *name;
{
	node_t *nodeptr;
	nodeptr = header->first;
	while(nodeptr != NULL){
		if((strcmp(nodeptr->item->devname,name)) == 0){
			return(1);
		}else{
			nodeptr = nodeptr->next;
		}
	}
	return(0);
}

delete_reserved(header)
	head_t *header;
{
	int i, first;
	node_t *nodeptr;

	nodeptr = header->first;
	first = 1;
	while(nodeptr != NULL){
		if(nodeptr->item->doflag){
			nodeptr = nodeptr->next;
			first = 0;
			continue;
		}else{
			if(first)
				header->first = nodeptr->next;
			else
				nodeptr->prev->next = nodeptr->next;
			if (nodeptr->next == NULL )
				header->last = nodeptr->prev;
			else
				nodeptr->next->prev = nodeptr->prev;
			nodeptr = nodeptr->next;
		}
				
				
	}
}
	
print_list(header)
	head_t *header;
{
	int i;
	node_t *nodeptr;

	nodeptr = header->first;
	while(nodeptr != NULL){
		printf("item = %s, space = %s, csrlen = %d\n",
			nodeptr->item->devname,nodeptr->item->devspace,
			nodeptr->item->csrlen);
		for(i = 0; i < MAXADDRS; i++){
			printf("\t addr %d = %x\n",
				i, nodeptr->item->devaddrs[i]);	
		}
		nodeptr = nodeptr->next;
	}
}	

check_space(spacename)
	char *spacename;
{
	int i;
	for(i = 0; spacetypes[i][0] != NULL; i++){
		if (debug){
			printf("spacenme %s cmp to spacetyp %s\n",
				spacename,spacetypes[i]);
		}
		if((strcmp(spacetypes[i],spacename)) == 0){
			return(0);
		}
	}
	return(1);
}
	

strtoint(str)
	char *str;
{
	char *temp;		
	int x;

	if ( *str == '0' && (*(str + 1) == 'x' || *(str + 1) == 'X')){
		temp = str + 2;
		if((sscanf(temp,"%x",&x)) <= 0)
			return(-1);
		return(x);
	}
	if ( *str == '0'){
		if((sscanf(str,"%o",&x)) <= 0)
			return(-1);
		return(x);
	}else{
		if((sscanf(str,"%d",&x)) <= 0)
                        return(-1);
                return(x);
	}
	return(-1);
}
	
		
makecfile(list,fptr)
	head_t *list;
	FILE *fptr;
{
	int first,i,j;
	int addrcount = 0;
	int spacecount = 0;
	node_t *nptr, *nxptr;
	char spacename[SPACENAMELEN + 1];
	char nxspacename[SPACENAMELEN + 1];
	first = 1;
	fprintf(fptr,"#include<sys/types.h>\n");
	fprintf(fptr,"extern char vme_short[];\n");
	fprintf(fptr,"extern char vme_std[];\n");
	fprintf(fptr,"extern char vme_stdio[];\n");
	fprintf(fptr,"extern char vme_ext[];\n");
	
	nptr = list->first;
	while(nptr != NULL){
		spacecount = getspcount(nptr);
		makelower(nptr->item->devname);
		fprintf(fptr,"#include \"%s.h\"\n",nptr->item->devname);
		makeupper(nptr->item->devname);
		fprintf(fptr,"#if N%s > %d\n",
			nptr->item->devname,addrcount);
		
		fprintf(fptr,"u_short *%sstd[] = {\n",
			nptr->item->devname);
		
		addrcount++;
		if(!strcmp(nptr->item->devspace,"qbus")){
			strcpy(spacename,"");
		}else{
			strcpy(spacename,"&");
			strcat(spacename,nptr->item->devspace);
		}
		if ( nptr->item->devaddrs[0] == NOTUSED )
			nxptr = nptr;
			
		for(i = 0;nptr->item->devaddrs[i] >= 0;i++){
			nxptr = nptr;	
			if(!strcmp(nptr->item->devspace,"on_board")){
				fprintf(fptr,"\t\t(u_short *)0x%x,\n",
					nptr->item->devaddrs[i]);
			} else {
				fprintf(fptr,"\t\t(u_short *)%s[0x%x],\n",
					spacename, nptr->item->devaddrs[i]);
			}
			for(j = spacecount;j;j--){
				if( nxptr->next == NULL)
						break;	
				nxptr = nxptr->next; 
				if(nxptr->item->devaddrs[i] < 0)
					continue;
				if(!strcmp(nxptr->item->devspace,"qbus")){
					strcpy(nxspacename,"");
				}else{
					strcpy(nxspacename,"&");
					strcat(nxspacename,
						nxptr->item->devspace);
				}    
				if(!strcmp(nxptr->item->devspace,"on_board")){
					fprintf(fptr,"\t\t(u_short *)0x%x,\n",
						nptr->item->devaddrs[i]);
				} else {
					fprintf(fptr,
						"\t\t(u_short *)%s[0x%x],\n",
						nxspacename,
						nxptr->item->devaddrs[i]);
				}
			} 
					
				
			addrcount++;
		}
	/*	for(i = addrcount - 1;i;--i){
	 *		fprintf(fptr,"#endif\n");
	 *	} 				 */
		addrcount = 0;
		fprintf(fptr,"\t\t 0 };\n");
		fprintf(fptr,"#endif\n\n\n");
		nptr = nxptr->next;
		
	}
}	
			
				
	
		


makeupper(str)
	char *str;
{
	int c;
	while(*str){
             	if ( isalpha(*str) && islower(*str)){
                     c = toupper(*str);
                     *str = c;
		
        	}
		++str;	
       	}
}

makelower(str)
	char *str;
{
	int c;
	while(*str){
             	if ( isalpha(*str) && isupper(*str)){
                     c = tolower(*str);
                     *str = c;
		
        	}
		++str;	
       	}
}

check_dup_addr(addrlist, addr,i)
	int *addrlist;
	int addr;
	int i;
{
	int j;
	for(j = 0; j < i; j++){
		if(addr == *addrlist)
			return(1);
		++addrlist;
	}
	return(0);
}	

/* See if address is in use by another device within the same address space */
check_in_use(header,item,addr)
	head_t *header;
	struct item *item;
	int addr;
{
	int i, curlen, itemlen,curaddr;
	node_t *nptr;
	nptr = header->first;
	itemlen = item->csrlen;
	while(nptr != NULL){
	
		curlen = nptr->item->csrlen;
		
		for(i = 0; i < MAXADDRS;i++ ){
			if(nptr->item->devaddrs[i] == NOTUSED)
				continue;
			curaddr = nptr->item->devaddrs[i];
			if(curaddr == addr && (strcmp(item->devspace, 
				nptr->item->devspace) == 0)){ 

				fprintf(stderr,"Warning, \"%s\" addr 0x%x is in",
					item->devname,addr); 
				fprintf(stderr," use for device \"%s\" in ",
					nptr->item->devname);
				fprintf(stderr,"address space \"%s\"\n",
					nptr->item->devspace);
				return(1);
			}
			if(((curaddr < addr && curaddr + curlen > addr) ||
				(curaddr > addr && addr + itemlen > curaddr))   
				&& (strcmp(item->devspace, 
				nptr->item->devspace) == 0)){ 

				fprintf(stderr,"Warning, \"%s\" addr 0x%x overlaps",
					item->devname,addr); 
				fprintf(stderr," address for device \"%s\" in ",
					nptr->item->devname);
				fprintf(stderr,"address space \"%s\"\n",
					nptr->item->devspace);
				return(1);
			} 
		}

		nptr = nptr->next;
	}
	return(0);
}

getspcount(node)
	node_t *node;
{
	int count = 0;

	while(node != NULL){
		if ( node->next != NULL){
			makelower(node->item->devname);
			makelower(node->next->item->devname);
			if(strcmp(node->item->devname,
				node->next->item->devname) == 0){
				count++;
			}else{
				return(count);	
			}
		}
		if(count)
			node = node->next;
		else
			return(0);
	}
	return(count);
}


ini_devaddrs(item)
	struct item *item;
{
	int i;
	for(i = 0; i < MAXADDRS; i++)
		item->devaddrs[i] = NOTUSED;
}

blank_line(){
	int i;

	for(i = 0; i < MAXLINELEN && linebuf[i] != '\n'; i++){
		if(isalpha(linebuf[i] ))
			return(0);
	}
	return(1);
}
			
			 
