#include <a.out.h>

struct exec header;
char zero[4096];
char buff[4096];
char sysbuf[40];

main(argc, argv)
	int	argc;
	char	*argv[];
{
	int 	i;
	int	old, new, old_pos;
	int	old_a_text, new_a_text;
	int	old_a_data, new_a_data;

	if (argc != 2) {
		printf("usage: 428k file\n");
		exit(1);
	}

	if ((old = open(argv[1],2,0)) < 0 ) {
		printf("428k: cannot open '%s'\n",argv[1]);
		exit (1);
	}
	if (read(old, &header, sizeof(header)) != sizeof(header)) {
/*		printf("428k: '%s' cannot read header\n", argv[1]); /**/
		exit (1);
	}
	if (N_BADMAG(header)) {
/*		printf("428k: '%s' not in a.out format\n", argv[1]); /**/
		exit (1);
	}
	if (header.a_magic == OMAGIC)
		exit(0);

	new_a_text = old_a_text = header.a_text;
	new_a_data = old_a_data = header.a_data;
	if ((old_a_text % 8192) == 0 && (old_a_data % 8192) == 0) {
/*		printf("428k: '%s' already rounded to 8k\n", argv[1]); /**/
		exit(0);
	}
	sprintf(sysbuf,"cp %s xxx", argv[1]);
	system(sysbuf);
	if ((old_a_text % 8192) != 0)
		new_a_text += 4096;
	if ((old_a_data % 8192) != 0) {
		new_a_data += 4096;
		if (header.a_bss)
			header.a_bss -= 4096;
	}
	header.a_text = new_a_text;
	header.a_data = new_a_data;

	if ((new = open("xxx",2,0)) < 0 ) {
		printf("428k: cannot open '%s'\n",argv[1]);
		exit (1);
	}
	if (lseek(new, 0, 0) < 0) {
		printf("428k: cannot seek back to begining of file\n");
		exit (1);
	}
	if (write(new, &header, sizeof(header)) != sizeof(header)) {
		printf("428k: cannot write header\n");
		exit (1);
	}
	if (lseek(old, old_a_text, 0) < 0) {
		printf("428k: cannot seek back to begining of file\n");
		exit (1);
	}
	old_pos = old_a_text;
	if (lseek(new, old_a_text, 0) < 0) {
		printf("428k: cannot seek back to begining of file\n");
		exit (1);
	}
	if ((old_a_text % 8192) != 0) {
		if (write(new, zero, 4096) != 4096) {
			printf("428k: cannot write zero\n");
			exit (1);
		}
	}
	while (1) {
		if ((i = read(old, buff, 4096)) != 4096)
			break;
		if (write(new, buff, 4096) != 4096) {
			printf("428k: cannot write buff\n");
			exit (1);
		}
		old_pos += 4096;
		if ((old_a_data % 8192) != 0 && 
		    (old_pos == old_a_text + old_a_data)) {
			if (write(new, zero, 4096) != 4096) {
				printf("428k: cannot write zero\n");
				exit (1);
			}
		}
	}
	if (i < 0) {
		printf("428k: cannot read buff\n");
		exit (1);
	}
	if (write(new, buff, i) != i) {
		printf("428k: cannot write buff\n");
		exit (1);
	}
	sprintf(sysbuf,"mv xxx %s", argv[1]);
	system(sysbuf);
	printf("428k: %s\n",argv[1]);
}
