static	char *sccsid = "@(#)mon.c	4.9 (Berkeley) 11/28/83";

#define ARCDENSITY	5	/* density of routines */
#define MINARCS		50	/* minimum number of counters */
#define	HISTFRACTION	2	/* fraction of text space for histograms */


struct phdr {
	int *lpc;
	int *hpc;
	int ncnt;
};

struct cnt {
	int *pc;
	long ncall;
} *countbase;

static int cntrs = 0;
static short profiling = 3;
static char *s_sbuf;
static int s_bufsiz;
static int s_scale;
static char *s_lowpc;

int numctrs;

#define	MSG "No space for monitor buffer(s)\n"

monstartup(lowpc, highpc)
	char *lowpc;
	char *highpc;
{
	int monsize;
	char *buffer;
	int cntsiz;
	extern char *sbrk();
	extern char *minbrk;


	cntsiz = (highpc - lowpc) * ARCDENSITY / 100;
	if (cntsiz < MINARCS)
		cntsiz = MINARCS;
	monsize = (highpc - lowpc + HISTFRACTION - 1) / HISTFRACTION
		+ sizeof(struct phdr) + cntsiz * sizeof(struct cnt);
	monsize = (monsize + 1) & ~1;
	buffer = sbrk(monsize);
	if (buffer == (char *)-1) {
		write(2, MSG, sizeof(MSG));
		return;
	}
	minbrk = sbrk(0);
	monitor(lowpc, highpc, buffer, monsize, cntsiz);
}

#ifdef is68k
mcount()
{
	asm("	movl	sp,sp@-		/* push adder of ret adder*/");
	asm("	movl	a1,sp@- 	/* push counter index */");
	asm("	jsr	_xyzzy		/* call the real mcount */");
	asm("   addql	#8,sp		/* restore stack */");
}
#endif is68k

#ifdef is68k
static
xyzzy(cntp,selfpc)
	register long **cntp;
	register int selfpc;
#else
static
xyzzy()
#endif is68k
{
#ifndef is68k
	register int selfpc;			/* d7 */
	register long **cntp;			/* a5 */
	asm("/* the beginning of mcount() */");
#endif is68k

#ifdef lint
	selfpc = (int *) 0;
#else not lint
#ifndef is68k
	asm("	.globl	mcount");
	asm("mcount:");
#endif is68k
#endif not lint
	/*
	 * check that we aren't recursively invoked.
	 */
	if (profiling == 0) {
		profiling++;
		/*
		 * check that counter is allocated
		 */
		if (*cntp == 0) {
			/*
			 * check that a counter is available
			 */
			if (cntrs++ == numctrs) {
				write (2, "mcount: counter overflow\n", 25);
				return;
			}
			countbase->pc = (int *)selfpc;
			*cntp = &countbase->ncall;
			countbase++;
		}
		(**cntp)++;
		profiling--;
	}
#ifndef is68k
	asm("/* the end of mcount() */");
#endif is68k
}


monitor(lowpc, highpc, buf, bufsiz, cntsiz)
	char *lowpc, *highpc;
	char *buf;
	int bufsiz, cntsiz;
{
	register int o;
	struct phdr *php;
	static int ssiz;
	static char *sbuf;

	if (lowpc == 0) {
		moncontrol(0);
		o = creat("mon.out", 0666);
		write(o, sbuf, ssiz);
		close(o);
		return;
	}
	sbuf = buf;
	ssiz = bufsiz;
	php = (struct phdr *)&buf[0];
	php->lpc = (int *)lowpc;
	php->hpc = (int *)highpc;
	php->ncnt = cntsiz;
	numctrs = cntsiz;
	countbase = (struct cnt *)(buf + sizeof(struct phdr));
	o = sizeof(struct phdr) + cntsiz * sizeof(struct cnt);
	buf += o;
	bufsiz -= o;
	if (bufsiz <= 0)
		return;
	o = (highpc - lowpc);
	if(bufsiz < o)

# ifdef BOOTSTRAP
		o = ((bufsiz*65536) / o);
# else BOOTSTRAP
		o = ((float) bufsiz / o) * 65536;
# endif BOOTSTRAP

	else
		o = 65536;
	s_scale = o;
	s_sbuf = buf;
	s_bufsiz = bufsiz;
	s_lowpc = lowpc;
	moncontrol(1);
}

/*
 * Control profiling
 *	profiling is what mcount checks to see if
 *	all the data structures are ready.
 */
moncontrol(mode)
    int mode;
{
    if (mode) {
	/* start */
	profil(s_sbuf, s_bufsiz, s_lowpc, s_scale);
	profiling = 0;
    } else {
	/* stop */
	profil((char *)0, 0, 0, 0);
	profiling = 3;
    }
}
