/*	strncat.s	4.2	83/11/21	*/

/* strncat(s0, s1, n)
 * Concatenate s1 on end of s0.  s0's space must be large enough.
 * At most n characters are moved.
 * Returns s0.
 */

/*
 * char *
 * strncat(s0, s1, n)
 * register char *s0, *s1;
 * register n;
 * {
 *         register char *os0;
 * 
 *         os0 = s0;
 *         while (*s0++)
 *                 ;
 *         --s0;
 *         while (*s0++ = *s1++)
 *                 if (--n < 0) {
 *                         *--s0 = '\0';
 *                         break;
 *                 }
 *         return(os0);
 * }
 */

#include "DEFS.h"

ENTRY(strncat)
	movl	sp@(4),a0	/* s0: dest */
	movl	sp@(8),a1	/* s1: source */
	movl	a0,d0		/* set return value before we lose it */
	movq	#-1,d1		/* dummy counter for dbcc */

    1:	tstb	a0@+		/* scan to terminating null */
	dbeq	d1,1b
	jne	1b		/* wow, still more */

	subql	#1,a0		/* back up to point at terminating null */
	movl	sp@(12),d1	/* count */

	movb	a1@+,a0@+	/* special case: first time (strict compat) */
	jeq	4f
	subql	#1,d1
	jlt	3f		/* initial check for 32-bit negative count */

    2:	movb	a1@+,a0@+	/* copy the string */
	dbeq	d1,2b
	jeq	4f		/* if end of string, we're all done */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	2b
    3:	movb	#0,a0@-		/* count exhausted -- force null terminator */
    4:	rts
