/*	setjmp.s	4.5	83/11/26	*/

/*
 * C library -- setjmp, longjmp
 *
 *	longjmp(a,v)
 * will generate a "return(v)" from
 * the last call to
 *	setjmp(a)
 * by restoring registers from the stack,
 * previous signal mask, and doing a return.
 *
 * BUG: always restores onsigstack state to 0.
 * ANOTHER BUG: registers should be restored as stack is unwound,
 *  instead of from jmpbuf.
 */

#include "DEFS.h"

ENTRY(setjmp)
	movq	#0,d0
	movl	d0,sp@-
	jsr	_sigblock
	addql	#4,sp
	movl	sp@(4),a0
	movl	a6,a0@			/* save frame pointer of caller */
	movl	sp@+,a1			/* pop return address */
	movl	a1,a0@(4)		/* save pc of caller */
	movl	d0,a0@(8)		/* save signal mask */
	movq	#0,d0
	movl	d0,a0@(12)		/* XXX (should be onsigstack) XXX */
	movml	#0xBCFC,a0@(40)		/* XXX (shouldn't need this) XXX */
	jmp	a1@			/* zero return value */

ENTRY(longjmp)
	movl	sp@(8),d0		/* return value */
	movl	sp@(4),a0		/* fetch buffer */
	tstl	a0@
	jeq	botch

	movml	a0@(40),#0xBCFC		/* XXX (shouldn't need this) XXX */
	movl	a0@,a6			/* restore frame pointer */
	clrl	sp@-			/* psl */
	movl	a0@(4),sp@-		/* pc */
	pea	sp@			/* sp */
	movl	a0@(8),sp@-		/* sigmask */
	movl	a0@(12),sp@-		/* onstack */
	pea	sp@
	trap	#7			/* no return */


botch:
	pea	msgend-msg
	pea	msg
	pea	2
	jsr	_write
	stop	#0

	.data
msg:	.ascii	"longjmp botch\n"
msgend:
