/* unsigned long multiply: c = a * b */

#include "DEFS.h"

RENTRY(rulmul)
	tstb	is68020		/* test for 68020 */
	jeq	2f
    	mulul	d1,d0		/* 68020 instruction */
	rts

    2:	moveml	#0x3000,sp@-	/* save d2,d3 */
	movl	d0,d2		/* d2 = a */
	movl	d1,d3		/* d3 = b */
	movw	d2,d0		/* d0 = alo, unsigned */
	mulu	d3,d0		/* d0 = blo*alo, unsigned */
	movw	d2,d1		/* d1 = alo */
	swap	d2		/* swap alo-ahi */
	movw	d2,d2		/* for following test */
	jne	4f		/* skip multiply if possible */
	swap	d3
	movw	d3,d3
	jne	6f
	moveml	sp@+,#0x000C	/* restore d2,d3 */
	rts
    6:	mulu	d3,d1
	jmp	7f
    4:	mulu	d3,d2		/* d2 = blo*ahi, unsigned */
	swap	d3		/* swap blo-bhi */
	movw	d3,d3		/* for following test */
	jne	5f		/* skip multiply if possible */
	movl	d2,d1
	jmp	7f
    5:	mulu	d3,d1		/* d1 = bhi*alo, unsigned */
	addl	d2,d1		/* d1 = (ahi*blo + alo*bhi) */
    7:	swap	d1		/* d1 = */
	clrw	d1		/*    (ahi*blo + alo*bhi)*(2**16) */
	addl	d1,d0		/* d0 = alo*blo + (ahi*blo + alo*bhi)*(2**16) */
	moveml	sp@+,#0x000C	/* restore d2,d3 */
	rts
