/* @(#)bzero.s	4.2 11/22/83 */
/* bzero(base, length) */

#include "DEFS.h"

ENTRY(bzero)
	tstb	is68020		/* test for 68020 */
	jeq	9f		/* jump if not 68020 */
	movl	sp@(4),a0	/* base */
	movl	sp@(8),d1	/* length */
	jle	7f		/* ought to be positive */
	cmpl	#8,d1		/* if less than 8 bytes just zero bytes */
	jlt	8f		/* short copy */
	movw	a0,d0		/* check for odd address */
	lsrw	#1,d0
	jcc	1f
	clrb	a0@+
	subql	#1,d1
	jle	7f
    1:	lsrw	#1,d0		/* check for long aligned address */
	jcc	1f
	clrw	a0@+
	subql	#2,d1
	jle	7f
    1:	movq	#0,d0 		/* we now have long address, positive count */
	movl	d1,a1		/* save byte count */
	lsrl	#5,d1		/* convert to 32 byte block count (truncated) */
	jra	2f

    1:	movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+
	movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+
    2:	dbf	d1,1b		/* entry point of block copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	1b
	movw	a1,d1		/* restore byte count */
	andw	#0x1F,d1	/* only interested in bottom 5 bits */
	jra	2f
    1:	movb	d0,a0@+		/* copy last 0-3 bytes */
    2:	dbf	d1,1b
    7:	rts
    1:	clrb	a0@+
    8:	dbf	d1,1b		/* short length zero ... */
	rts

    9:	movl	sp@(4),a0	/* base */
	movl	sp@(8),d1	/* length */
	jle	7f		/* ought to be positive */
	movw	a0,d0		/* check for odd address */
	lsrw	#1,d0
	jcc	1f
	clrb	a0@+
	subql	#1,d1
	jle	7f
    1:	movq	#0,d0		/* we now have even address, positive count */
	movl	d1,a1		/* save byte count */
	lsrl	#2,d1		/* convert to long count (truncated) */
	jra	2f
    1:	movl	d0,a0@+		/* long copy loop */
    2:	dbf	d1,1b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	1b
    	movw	a1,d1		/* restore byte count */
	andw	#3,d1		/* only interested in bottom 2 bits */
	jra	2f
    1:	movb	d0,a0@+		/* copy last 0-3 bytes */
    2:	dbf	d1,1b
    7:	rts
