/* ISI	phys.c	4.2	85/02/14 JRN */

/*
 * phys.c  emulates phys(2) system call from unisoft system 3
 */
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/mman.h>

#define	NPHYSMAP	4

static struct physmap {	
	caddr_t	pm_addr;	/* virtual address */
	u_int	pm_len;		/* region length in bytes */
} physmap[NPHYSMAP];

/*
 * Map a region of virtual address space to a physical address.
 * Implemented using 4.2 mmap call applied to /dev/mem.
 */
phys(physnum, addr, len, physaddr)
u_int		physnum;	/* region number */
caddr_t	addr;		/* virtual address */
int		len;		/* region length in bytes */
caddr_t	physaddr;	/* physical address */
{
	register int		error = 0;	/* return value */
	register struct physmap	*pmap;		/* ptr to region map */
	static int		memfd = -1;	/* fd for /dev/mem */
	caddr_t			curbrk;		/* current brk */
	extern caddr_t		sbrk();
	extern int		errno;

	if (physnum >= NPHYSMAP) {
		errno = EINVAL;
		return(-1);
	}
	pmap = &physmap[physnum];

	if (memfd == -1 && (memfd = open("/dev/mem", 2)) == -1)
		return(-1);		/* no permission */

	if (pmap->pm_len)		/* remove old mapping */
		error = munmap(pmap->pm_addr, pmap->pm_len);
	pmap->pm_len = 0;

	if (len == 0)			/* just unmapping a region */
		return(error);

	if ((int)physaddr & PGOFSET) {	/* physical addr must be page boundary */
		errno = EINVAL;
		return(-1);
	}
	len = (len + CLOFSET) & ~CLOFSET;	/* round up to cluster size */

	curbrk = sbrk(0);		/* get addr within data segment */
	if (addr + len > curbrk && brk(addr + len) == -1)
		return(-1);

	error = mmap(addr, len, (PROT_READ|PROT_WRITE), MAP_SHARED, memfd, physaddr);
	if (error == 0) {
		pmap->pm_addr = addr;
		pmap->pm_len = len;
	}
	return(error);
}
