(*$w-*)
(************************)
(* BUTTON Definitions	*)
(************************)
function  CreateButtonField(
		fd : integer;		(* file descriptor		*)
		n : short;		(* number of buttons		*)
		var plabel : char;	(* button labels		*)
		var pbs : pbutton;	(* button information		*)
		dir : short;		(* direction (vert/hor)		*)
		spacing : short;	(* space between buttons	*)
		style : short;		(* button style			*)
		t : short;		(* border thickness		*)
		fc : short;		(* field color			*)
		font : short;		(* font style			*)
		x, y, w, h : short	(* button region		*)
	  ):BFD;external;

procedure DeleteButtonField(
		bfd : BFD 		(* button descriptor		*)
	  );external;

function  ButtonInput(
		bfd : BFD;		(* button descriptor		*)
		x, y : short		(* location			*)
	  ):short;external;

procedure RefreshButtonField(
		bfd : BFD 		(* button descriptor		*)
	  );external;

procedure HighlightButton(
		bfd : BFD;		(* button descriptor		*)
		b : short		(* button to be highlighted	*)
	  );external;

procedure UnHighlightButton(
		bfd : BFD;		(* button descriptor		*)
		b : short		(* button to be unhighlighted	*)
	  );external;

function  GetButtonFieldWidth(
		n : short;		(* number of buttons		*)
		var plabel : char;	(* button labels		*)
		var pbs : pbutton;	(* button information		*)
		dir : short;		(* direction (vert/hor)		*)
		spacing : short;	(* space between buttons	*)
		style : short;		(* button style			*)
		t : short;		(* border thickness		*)
		font : short		(* font style			*)
	  ):BFD;external;

function  GetButtonFieldHeight(
		n : short;		(* number of buttons		*)
		var plabel : char;	(* button labels		*)
		var pbs : pbutton;	(* button information		*)
		dir : short;		(* direction (vert/hor)		*)
		spacing : short;	(* space between buttons	*)
		style : short;		(* button style			*)
		t : short;		(* border thickness		*)
		font : short		(* font style			*)
	  ):BFD;external;
(************************)
(* GAUGE Definitions	*)
(************************)
function  CreateGauge(
		fd : integer;		(* file descriptor		*)
		x, y, w, h : short;	(* gauge location		*)
		bcolor : short;		(* background color		*)
		tcolor : short;		(* tick color			*)
		lcolor : short;		(* *)
		ncolor : short;		(* *)
		font : short;		(* font for labels		*)
		position : short;	(* current pointer position	*)
		var glabel : char;	(* null separated labels	*)
		var size : short;	(* relative tick sizes		*)
		nticks : short		(* number of ticks		*)
	  ):GAUGE;external;

procedure MoveGauge(
		gauge : GAUGE;		(* gauge descriptor		*)
		position : short	(* new location			*)
	  );external;

procedure RefreshGauge(
		gauge : GAUGE 		(* gauge descriptor		*)
	  );external;

procedure DeleteGauge(
		gauge : GAUGE 		(* gauge descriptor		*)
	  );external;

(************************)
(* MENU MANAGEMENT	*)
(* Definitions		*)
(************************)
function  PresentMenu(
		desc : MENU		(* menu descriptor		*)
	  ):integer;external;

function  CreateMenu(
		var title :char		(* menu title			*)
	  ):MENU;external;

function MenuQuestion(
		desc : MENU;		(* menu descriptor		*)
		qtype : integer;	(* question type: TOGGLE, 	*)
					(*      SELECT or STRING	*)
		var qchoice : char	(* question label		*)
	  ):integer;external;

function MenuChoice(
		desc : MENU;		(* menu descriptor		*)
		ctype : integer;	(* choice type = LABEL		*)
		initial : integer;	(* if (TOGGLE) 0 = false 1=true *)
					(* if (SELECT) 1 = default	*)
					(* if (STRING) n =maximum length*)
		var mchoice : char	(* if (TOGGLE) choice label     *)
					(* if (SELECT) choice label	*)
					(* if (STRING) default label	*)
	  ):integer;external;

function ToggleResult(
		desc : MENU;		(* menu descriptor		*)
		qnum : short;		(* question number		*)
		var toggle : MENUTOGGLE	(* answer to TOGGLE question	*)
	  ):integer;external;

function SelectResult(
		desc : MENU; 		(* menu descriptor		*)
		qnum : short;		(* question number		*)
		var select:integer	(* answer to SELECT question	*)
	  ):integer;external;

function StringResult(
		desc : MENU; 		(* menu descriptor		*)
		qnum : short;		(* question number		*)
		var string : char	(* answer to STRING question	*)
	  ):integer;external;
(************************)
(* LOAD CURSORS		*)
(* Definitions		*)
(************************)
function GetCursor(
		ctype : short;
		var mask : integer;
		var face : integer;
		var xhot : short;
		var yhot : short;
		var blink : short
	  ):integer;external;
(************************)
(* WINDOW MANAGEMENT	*)
(* Definitions		*)
(************************)
procedure CloseWindow(fd:integer);external;

function  OpenWindow(
		wx,wy,			(* upper left position of window*)
		ww,wh : short;		(* width and height of window	*)
		var title : char	(* window title			*)
	  ):integer;external;

(************************)
(* LINEAR ELEVATOR	*)
(* Definitions		*)
(************************)
function  CreateElevatorBar(
		fd:integer;		(* window file descriptor	*)
		x,y,			(* location of elevator bar	*)
		w,h,			(* width and height of bar	*)
		bcolor,			(* background color		*)
		t,			(* border thickness		*)
		loc,			(* location of elevator in bar	*)
		size,			(* size of elevator in bar	*)
		ecolor:short;		(* elevator color		*)
		dir,			(* vertical or horizontal	*)
		arrows:short 		(* arrows or no arrows		*)
	  ):EBAR;external;

procedure DeleteElevatorBar(
		eba : EBAR 		(* elevator bar descriptor	*)
	  );external;

function  DoElevatorBar(
		eba : EBAR; 		(* elevator bar descriptor	*)
		x,y : short		(* position being pointed at	*)
	  ):integer;external;

procedure MoveElevator(
		eba : EBAR; 		(* elevator bar descriptor	*)
		loc : short		(* new location			*)
	  );external;

procedure RefreshElevatorBar(
		eba : EBAR  		(* elevator bar descriptor	*)
	  );external;

procedure SizeElevator(
		eba : EBAR; 		(* elevator bar descriptor	*)
		size : short		(* new size of elevator in bar	*)
	  );external;

(****************)
(* 2D ELEVATORS	*)
(* Definitions	*)
(****************)

function  CreateElevatorBar2D(
		window:integer;		(* window file descriptor	*)
		x,y,			(* location of elevator bar	*)
		w,h,			(* width and height of bar	*)
		bcolor,			(* background color		*)
		brdrsiz: short;		(* border thickness		*)
		arrows:short; 		(* arrows or no arrows		*)
		lx,ly:short;		(* location of elevator in bar	*)
		sx,sy:short;		(* size of elevator in bar	*)
		ecolor:short		(* elevator color		*)
	  ):EBAR;external;

procedure DeleteElevatorBar2D(
		eba : EBAR 		(* elevator bar descriptor	*)
	  );external;

function  DoElevatorBar2D(
		eba : EBAR; 		(* elevator bar descriptor	*)
		var x,y : short		(* position being pointed at	*)
	  ):short;external;

procedure MoveElevator2D(
		eba : EBAR; 		(* elevator bar descriptor	*)
		lx, ly : short		(* new location			*)
	  );external;

procedure RefreshElevatorBar2D(
		eba : EBAR  		(* elevator bar descriptor	*)
	  );external;

procedure SizeElevator2D(
		eba : EBAR; 		(* elevator bar descriptor	*)
		sx, sy : short		(* new size of elevator in bar	*)
	  );external;
(*$w+*)
