(*$w-*)
function  bmAllocate(
		width:short;		(* rectangle width  		*)
		height:short		(* rectangle height		*)
	  ):BMD;external;

procedure bmBumpPosition(
		bmd:BMD;		(* bitmap descriptor		*)
		dx:short;		(* change in x coordinate	*)
		dy:short		(* change in y coordinate	*)
	  );external;

procedure bmBumpXPosition(
		bmd:BMD;		(* bitmap descriptor		*)
		dx:short		(* change in x coordinate	*)
	  );external;

procedure bmBumpYPosition(
		bmd:BMD;		(* bitmap descriptor		*)
		dy:short		(* change in y coordinate	*)
	  );external;

function  bmCharacterBaseline(
		bmd:BMD			(* bitmap descriptor		*)
	  ):integer;external;

function  bmCharacterHeight(
		bmd:BMD			(* bitmap descriptor		*)
	  ):integer;external;

function  bmCharacterWidth(
		bmd:BMD;		(* bitmap descriptor		*)
		c:char			(* character in the font	*)
	  ):integer;external;

procedure bmClearRegion(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coord of src	*)
		y:short;		(* upper left y coord of src	*)
		w:short;		(* width of region		*)
		h:short;		(* height of region		*)
		color:short		(* clear bitmap to this color   *)
	  );external;

procedure bmCopyPattern(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coord of src	*)
		y:short;		(* upper left y coord of src	*)
		w:short;		(* width of region		*)
		h:short;		(* height of region		*)
		var pattern:short;	(* pattern			*)
		px:short;		(* pattern x coordinate         *)
		py:short;		(* pattern y coordinate         *)
		pw:short		(* pattern width in bits        *)
	  );external;

procedure bmCopyRegion(
		sbmd:BMD;		(* source bitmap descriptor	*)
		sx:short;		(* upper left x coord of src	*)
		sy:short;		(* upper left y coord of src	*)
		dbmd:BMD;		(* destination bitmap descriptor*)
		dx:short;		(* upper left x coord of dest	*)
		dy:short;		(* upper left y coord of dest	*)
		w:short;		(* width of region		*)
		h:short			(* height of region		*)
	  );external;

procedure bmDeallocate(
		bmd:BMD			(* bitmap descriptor		*)
	  );external;

function  bmDisplayBitmap(
		fd:integer;		(* window file descriptor	*)
		operation:short;	(* toggle,copy or paint		*)
		bmd:BMD;		(* bitmap descriptor		*)
		sx,sy:short;		(* upper left src coordinate	*)
		dx,dy:short;		(* upper left dest coordinate	*)
		w,h:short;		(* region width and height	*)
		color:short		(* color of bits in bitmap	*)
	  ):integer;external;

procedure bmGetPermanentClipping(
		bmd:BMD;		(* bitmap descriptor		*)
		var x:short;		(* upper left x coordinate      *)
		var y:short;		(* upper left y coordinate      *)
		var w:short;		(* width			*)
		var h:short		(* height			*)
	  );external;

procedure bmGetTemporaryClipping(
		bmd:BMD;		(* bitmap descriptor		*)
		var x:short;		(* upper left x coordinate      *)
		var y:short;		(* upper left y coordinate      *)
		var w:short;		(* width			*)
		var h:short		(* height			*)
	  );external;

procedure bmInvertRegion(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coord of src	*)
		y:short;		(* upper left y coord of src	*)
		w:short;		(* width of region		*)
		h:short			(* height of region		*)
	  );external;

procedure bmPaintArcBorder(
		bmd:BMD;		(* bitmap descriptor		*)
		r:short;		(* arc radius			*)
		xs,ys:short;		(* source radius coordinate     *)
		xe,ye:short		(* destination radius coordinate*)
	  );external;

procedure bmPaintArcInterior(
		bmd:BMD;		(* bitmap descriptor		*)
		r:short;		(* arc radius			*)
		xs,ys:short;		(* source radius coordinate     *)
		xe,ye:short		(* destination radius coordinate*)
	  );external;

procedure bmPaintCharacter(
		bmd:BMD;		(* bitmap descriptor		*)
		c:char			(* character to be painted	*)
	  );external;

procedure bmPaintCircleBorder(
		bmd:BMD;		(* bitmap descriptor		*)
		r:short			(* radius of circle		*)
	  );external;

procedure bmPaintCircleInterior(
		bmd:BMD;		(* bitmap descriptor		*)
		r:short 		(* radius of circle		*)
	  );external;

procedure bmPaintLine(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* x coordinate of line endpoint*)
		y:short 		(* y coordinate of line endpoint*)
	  );external;

procedure bmPaintPolygonBorder(
		bmd:BMD;		(* bitmap descriptor		*)
		nsets:short;		(* number of points on polygon  *)
		var px:short;		(* x coordinates of poly points *)
		var py:short 		(* y coordinates of poly points *)
	  );external;

procedure bmPaintPolygonInterior(
		bmd:BMD;		(* bitmap descriptor		*)
		nsets:short;		(* number of points on polygon  *)
		var px:short;		(* x coordinates of poly points *)
		var py:short 		(* y coordinates of poly points *)
	  );external;

procedure bmPaintRectangleBorder(
		bmd:BMD;		(* bitmap descriptor		*)
		width:short;		(* rec w or lower right x coord *)
		height:short 		(* rec h or lower right y coord *)
	  );external;

procedure bmPaintRectangleInterior(
		bmd:BMD;		(* bitmap descriptor		*)
		width:short;		(* rec w or lower right x coord *)
		height:short 		(* rec h or lower right y coord *)
	  );external;

procedure bmPaintRegion(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coord of src	*)
		y:short;		(* upper left y coord of src	*)
		w:short;		(* width of region		*)
		h:short;		(* height of region		*)
		color:short;		(* VTWhite or VTBlack		*)
		var mask:short;		(* mask				*)
		mx:short;		(* mask x coordinate		*)
		my:short;		(* mask y coordinate		*)
		mw:short		(* mask width in bits		*)
	  );external;

procedure bmPaintString(
		bmd:BMD;		(* bitmap descriptor		*)
		size:short;		(* length of string		*)
		var string:char		(* string to be painted		*)
	  );external;

function  bmRead(
		var sfile:char		(* source file			*)
	  ):BMD;external;

function bmReadBit(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* x position to check		*)
		y:short 		(* y position to check		*)
	  ):integer;external;

procedure bmRestrictPermanentClipping(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coordinate      *)
		y:short;		(* upper left y coordinate      *)
		w:short;		(* width			*)
		h:short 		(* height			*)
	  );external;

procedure bmRestrictTemporaryClipping(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coordinate      *)
		y:short;		(* upper left y coordinate      *)
		w:short;		(* width			*)
		h:short 		(* height			*)
	  );external;

function  bmRotate(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coordinate      *)
		y:short;		(* upper left y coordinate      *)
		w:short;		(* width			*)
		h:short;		(* height			*)
		angle:short 		(* angle specified in degrees	*)
	  ):BMD;external;

function  bmScale(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coordinate      *)
		y:short;		(* upper left y coordinate      *)
		w:short;		(* width			*)
		h:short;		(* height			*)
		sx:short;		(* scale in x direction		*)
		sy:short		(* scale in y direction		*)
	  ):BMD;external;
		
procedure bmSetAddressing(
		bmd:BMD;		(* bitmap descriptor		*)
		addressing:short 	(* new addressing mode 		*)
	  );external;

procedure bmSetBColor(
		bmd:BMD;		(* bitmap descriptor		*)
		bcolor:short 		(* new clear back color  	*)
	  );external;

procedure bmSetBit(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* x position to check		*)
		y:short;		(* y position to check		*)
		color:short 		(* color to set bit		*)
	  );external;

procedure bmSetBPattern(
		bmd:BMD;		(* bitmap descriptor		*)
		var bpattern:short 	(* new backgrnd pattern		*)
	  );external;

procedure bmSetColor(
		bmd:BMD;		(* bitmap descriptor		*)
		color:short 		(* new foreground color  	*)
	  );external;

procedure bmSetCharAttributes(
		bmd:BMD;		(* bitmap descriptor		*)
		attributes:short 	(* new character attributes  	*)
	  );external;

procedure bmSetDirection(
		bmd:BMD;		(* bitmap descriptor		*)
		direction:short 	(* new direction   		*)
	  );external;

function  bmSetFont(
		bmd:BMD;		(* bitmap descriptor		*)
		var font:char 		(* new font   			*)
	  ):integer;external;

procedure bmSetJustification(
		bmd:BMD;		(* bitmap descriptor		*)
		justification:short 	(* new justification   		*)
	  );external;

procedure bmSetOrientation(
		bmd:BMD;		(* bitmap descriptor		*)
		orientation:short 	(* new orientation   		*)
	  );external;

procedure bmSetPattern(
		bmd:BMD;		(* bitmap descriptor		*)
		var pattern:short 	(* new fill pattern		*)
	  );external;

procedure bmSetPermanentClipping(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coordinate      *)
		y:short;		(* upper left y coordinate      *)
		w:short;		(* width			*)
		h:short 		(* height			*)
	  );external;

procedure bmSetPhase(
		bmd:BMD;		(* bitmap descriptor		*)
		xphase:short;		(* new x coordinate of phase	*)
		yphase:short 		(* new y coordinate of phase	*)
	  );external;

procedure bmSetPosition(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* new x coordinate		*)
		y:short 		(* new y coordinate		*)
	  );external;

procedure bmSetStyle(
		bmd:BMD;		(* bitmap descriptor		*)
		mask:short;		(* new line style mask		*)
		count:short 		(* new line style count		*)
	  );external;

procedure bmSetTemporaryClipping(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coordinate      *)
		y:short;		(* upper left y coordinate      *)
		w:short;		(* width			*)
		h:short 		(* height			*)
	  );external;

procedure bmSetThickness(
		bmd:BMD;		(* bitmap descriptor		*)
		thickness:short 	(* new line and border thickness*)
	  );external;

procedure bmSetXPosition(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short 		(* new x coordinate		*)
	  );external;

procedure bmSetYPosition(
		bmd:BMD;		(* bitmap descriptor		*)
		y:short 		(* new y coordinate		*)
	  );external;

procedure bmToggleRegion(
		bmd:BMD;		(* bitmap descriptor		*)
		x:short;		(* upper left x coord of src	*)
		y:short;		(* upper left y coord of src	*)
		w:short;		(* width of region		*)
		h:short;		(* height of region		*)
		var mask:short;		(* mask				*)
		mx:short;		(* mask x coordinate            *)
		my:short;		(* mask y coordinate            *)
		mw:short		(* mask width in bits           *)
	  );external;

function  bmWrite(
		bmd:BMD;		(* bitmap descriptor		*)
		var dfile:char  	(* destination file		*)
	  ):integer;external;
(*$w+*)
