#include <vt/vt_fonts.h>
#include <vt.h>

#define BMAGIC  0x10200		/* magic number for bitmap files */
#define BMAGIC_C 0x10400	/* magic number for compressed bitmap files */
#define SMMLEN	255
extern short BMP00[], BMP01[], BMP02[], BMP03[], BMP04[], BMP05[],
                      BMP06[], BMP07[], BMP08[], BMP09[], BMP10[],
                      BMP11[], BMP12[], BMP13[], BMP14[], BMP15[],
                      BMP16[], BMP17[], BMP18[], BMP19[], BMP20[],
                      BMP21[], BMP22[], BMP23[], BMP24[], BMP25[],
		      BMP26[], BMP27[], BMP28[], BMP29[], BMP30[],
                      BMP31[], BMP32[], BMP33[], BMP34[], BMP35[],
                      BMP36[], BMP37[], BMP38[], BMP39[], BMP40[],
                      BMP41[], BMP42[], BMP43[], BMP44[], BMP45[],
                      BMP46[], BMP47[], BMP48[], BMP49[], BMP50[],
                      BMP51[], BMP52[], BMP53[], BMP54[], BMP55[],
                      BMP56[], BMP57[], BMP58[], BMP59[];

struct bitmap {
	long	b_magic;        /* magic number */
	int	b_width;        /* width in bits */
	int	b_height;       /* height in bits */
	int	b_hres;         /* horizontal resolution in bits/inch */
	int	b_vres;         /* vertical resolution in bits/inch */
	int	b_comp;		/* (byte) size of compressed bitmap */
	char	unused[16];     /* for future expansion */
};

struct BMD {
   short    addressing;       /* bitmap addressing mode  */
   short    attributes;       /* text attributes         */
   short    bcolor;           /* clearback color index   */
   short    *bpattern;        /* clearback color index   */
   short    count,mask;       /* line style mask, count  */
   short    direction;        /* string direction        */
   short    fcolor;           /* text/line color index   */
   char     font[SMMLEN];     /* current font id         */
   short    justification;    /* string justification    */
   short    orientation;      /* string orientation      */
   short    *pattern;         /* current pattern         */
   short    pxc,pyc,pwc,phc;  /* perm clipping bounds    */
   short    thickness;        /* line thickness          */
   short    txc,tyc,twc,thc;  /* temp clipping bounds    */
   short    width,height;     /* bitmap size             */
   short    xphase,yphase;    /* phase of patterns       */
   short    xpos,ypos;        /* current position        */
   RASTER   bitmap;           /* actual bitmap           */
   struct   font_plane *font_planes[NUM_PLANES];
			      /* current font info       */
};

extern short	     BM_ReadBit();
extern unsigned char BM_ReadChar();
extern int           BM_CharacterBaseline();
extern int           BM_CharacterHeight();
extern int           BM_CharacterWidth();
extern int           BM_CharacterOffset();
extern int           BM_Write();
extern struct BMD   *BM_Allocate();
extern struct BMD   *BM_Read();
extern short	     BM_SETFONT();
extern short	     BM_SetFont();

#define BM_BumpPosition(p0,p1,p2) \
      (p0)->xpos += (p1),(p0)->ypos += (p2)

#define BM_BumpXPosition(p0,p1)\
      (p0)->xpos += (p1)

#define BM_BumpYPosition(p0,p1)\
      (p0)->ypos += (p1)

#define BM_SetPosition(p0,p1,p2)\
      (p0)->xpos = (p1),(p0)->ypos = (p2)

#define BM_SetXPosition(p0,p1)\
      (p0)->xpos = (p1)

#define BM_SetYPosition(p0,p1)\
      (p0)->ypos = (p1)

#define BM_SetDirection(p0,p1) \
      (p0)->direction = (p1)

#define BM_SetPattern(p0,p1) \
      (p0)->pattern = (p1)

#define BM_SetBPattern(p0,p1) \
      (p0)->bpattern = (p1)

#define BM_SetThickness(p0,p1) \
      (p0)->thickness = (p1)

#define BM_SetStyle(p0,p1,p2)\
      (p0)->count = (p2),(p0)->mask = (p1)

#define BM_SetJustification(p0,p1)\
      (p0)->justification = (p1)

#define BM_SetOrientation(p0,p1)\
      (p0)->orientation = (p1)

#define BM_SetAddressing(p0,p1)\
      (p0)->addressing = (p1)

#define BM_SetCharAttributes(p0,p1)\
      (p0)->attributes = (p1)

#define BM_SetPhase(p0,p1,p2)\
      (p0)->xphase = (p1),(p0)->yphase = (p2)

#define BM_SetFont(p0,p1)\
      BM_SETFONT(&(p0),p1)

#define BM_CharacterBaseline(p0)\
      ((p0)->font_planes[16]->baseline)

#define BM_CharacterHeight(p0)\
      ((p0)->font_planes[16]->height)

#define BM_CharacterWidth(p0,p1)\
      ((p0)->font_planes[16]->ch_desc[(p1)-32].char_width)

#define BM_CharacterOffset(p0,p1)\
      ((p0)->font_planes[16]->ch_desc[(p1)-32].char_xoff)

#define BM_DisplayBitmap(p0,p1,p2,p3,p4,p5,p6,p7,p8,p9)\
        DisplayBitmap(p0,p1,(&((p2)->bitmap)),p3,p4,p5,p6,p7,p8,p9)
