/*
    ANSI C Runtime library

    Copyright 1983,1984,1985,1986,1987,1988 by Green Hills Software Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

#ifndef _STDDEF_H
#  include <stddef.h>
#endif  /* _STDDEF_H */

#ifndef _TIME_H
#define _TIME_H

#define CLK_TCK     60

#define _TZ_UNKNOWN (-1)

typedef long clock_t;       /* said to be an arithmetic type, so can't be too accurate */
/*typedef unsigned int time_t;/* said to be an arithmetic type, so can't be too accurate */
typedef long time_t;        /* PLUM HALL wants us to go back into the 40s, so we must be signed */
struct tm {
    int tm_sec;             /* seconds of the minute, [0,60] */ /* leap sec */
				/* we never return 60 */
    int tm_min;             /* minutes of the hour, [0,59] */
    int tm_hour;            /* hour of the day, [0,23] */
    int tm_mday;            /* day of the month, [1,31] */
    int tm_mon;             /* months since Jan, [0,11] */
    int tm_year;            /* years since 1900 */
    int tm_wday;            /* days since Sun, [0,6] */
    int tm_yday;            /* days since Jan 1, [0,365] */
    int tm_isdst;           /* daylight savings time */
};

clock_t clock(void);
double difftime(time_t time1, time_t time0);
#define difftime(t1,t0) ((double) ((t1)-(t0)))
time_t mktime(struct tm *timeptr);
time_t time(time_t *timer);

char *asctime(const struct tm *timeptr);
char *ctime(const time_t *timer);
struct tm *gmtime(const time_t *timer);
struct tm *localtime(const time_t *timer);
size_t strftime(char *s, size_t maxsize, const char *format,
	const struct tm *timeptr);
#endif
