/*
    ANSI C Runtime library

    Copyright 1983,1984,1985,1986,1987,1988 by Green Hills Software Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

#ifndef _STDDEF_H
#  include <stddef.h>
#endif  /* _STDDEF_H */
#ifndef _STRING_H
#define _STRING_H
void *memcpy(void *s1, const void *s2, size_t n);
void *memmove(void *s1, const void *s2, size_t n);  /* same as above, but handles overlap */
char *strcpy(char *s1, const char *s2);
char *strncpy(char *s1, const char *s2, size_t n);

char *strcat(char *s1, const char *s2);
char *strncat(char *s1, const char *s2, size_t n);

int memcmp(const void *s1, const void *s2, size_t n);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t n);
int strcoll(const char *s1, const char *s2);
size_t strxfrm(char *s1, const char *s2, size_t n);

void *memchr(const void *s, int c, size_t n);
char *strchr(const char *s, int c);
size_t strcspn(const char *s1, const char *s2);
char *strpbrk(const char *s1, const char *s2);
char *strrchr(const char *s, int c);
size_t strspn(const char *s1, const char *s2);
char *strstr(const char *s1, const char *s2);
char *strtok(char *s1, const char *s2);

void *memset(void *s, int c, size_t n);
char *strerror(int errnum);
size_t strlen(const char *s);
#endif      /* _STRING_H */
