/*
    ANSI C Runtime library

    Copyright 1983,1984,1985,1986,1987,1988 by Green Hills Software Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

#ifndef _STDDEF_H
#  include <stddef.h>
#endif  /* _STDDEF_H */
#ifndef _STDLIB_H
#define _STDLIB_H
typedef struct {
    int quot;           /* quotient */
    int rem;            /* remainder */
} div_t;
typedef div_t ldiv_t;

#include <math.h>       /* define ERANGE and HUGE_VAL */
#define EXIT_FAILURE        1
#define EXIT_SUCCESS        0
#define RAND_MAX            (2029052025-1)
#define mb_max              sizeof(wchar_t)

#define BLOCKSIZE       2048    /* block size to allocate with sbrk in malloc */

double atof(const char *nptr);
int atoi(const char *nptr);
long int atol(const char *nptr);
double strtod(const char *nptr, char **endptr);
long int strtol(const char *nptr, char **endptr, int base);
unsigned long int strtoul(const char *nptr, char **endptr, int base);

int rand(void);
void srand(unsigned int seed);

void *calloc(size_t nmemb, size_t size);
void free(void *ptr);
void *malloc(size_t size);
void *realloc(void *ptr, size_t size);

void abort(void);
int atexit(void (*func)(void));
void exit(int status);
char *getenv(const char *name);
int system(const char *string);

void *bsearch(const void *key, const void *base, size_t nmemb, size_t size,
	int (*compar)(const void *, const void *));
void qsort(void *base, size_t nmemb, size_t size,
	int (*compar)(const void *, const void *));

int abs(int j);
#define abs(j)  ((j)<0?-(j):(j))
/* the compiler can recognize the above construct and will produce better code */
div_t div(int number, int denom);
long int labs(long int j);
#define labs(j)  ((j)<0?-(j):(j))
ldiv_t ldiv(long int number, long int denom);

int mblen(const char *s, size_t n);
int mbtowc(wchar_t *pwc, const char *s, size_t n);
int wctomb(char *s, wchar_t wchar);
#endif      /* _STDLIB_H */
